#!/bin/sh

echo "Init Idrive program"
#remove all old files 
rm -R /root/*.old
rm -R /root/modules/*.old

chmod +x /root/extractor.sh 
chmod +x /root/Firmware.X2.HF
chmod +x /root/Iupdate.HF

if ! grep -E "^SYSLOGD_ARGS" /etc/init.d/S01logging | grep -q /dev/shm/idr_syslog;then 
    echo "correcting log location to /dev/shm/idr_syslog";
    sed -i 's~^SYSLOGD_ARGS=.*~SYSLOGD_ARGS="-n -O /dev/shm/idr_syslog"~g' /etc/init.d/S01logging;
    sync;
    /etc/init.d/S01logging restart
else 
    echo "system log location is in param [$(grep -E ^SYSLOGD_ARGS /etc/init.d/S01logging)]";
fi;

#extract any updates 
/root/extractor.sh

#kill any existing programs 
killall Iupdate.HF Firmware.X2.HF

cd /root/

#Maintenance
./Maintenance.HF

#run the update program 
./Iupdate.HF &

#run firmware
./Firmware.X2.HF &

echo "Done Idrive init"

exit 0;






