#!/bin/sh
#
/ezdvr/usrbin/samba.sh stop

DEV=$1
MountPoint=$2

operate=;
if [ $# -gt 2 ];  then
   operate=$3
   echo ${operate}
fi

FrcFDisk=0;
fdiskOnly=0;

if [ "X${operate}" == "Xfdisk" ]; then
   fdiskOnly=1
elif [ "X${operate}" == "Xfdisk_frcF" ]; then
   FrcFDisk=1
   fdiskOnly=1
elif [ "X${operate}" == "Xfmt_frcF" ]; then
   FrcFDisk=1
fi
echo Force Fdisk ${FrcFDisk}
echo fdiskOnly ${fdiskOnly}

if [ ! -d ${MountPoint} ]; then
   mkdir -p ${MountPoint};
   if [ "X$?" != "X0" ]; then
       echo  "error: failed to create mountpoint ${MountPoint}"> /dev/console;
       exit 1
   fi
else
    mount | grep ${MountPoint}
    if [ $? -eq 0 ];    then  
       umount -lf ${MountPoint};
       if [ "X$?" != "X0" ]; then
          echo  "error: failed to umount  ${MountPoint}"> /dev/console;
          exit 2
       fi
    fi
fi   
   
echo "off" > /tmp/mountDev

wrap_exit()
{
   	ret=$1;
   	echo "1" > /tmp/mountDev
   	/ezdvr/usrbin/samba.sh
   	exit ${ret}  	
}

if [ "X${DEV}" == "X/dev/sda" ] || [ "X${DEV}" == "X/dev/sdb" ]; then
   echo "WARNING:fdisk ${DEV} first !!"  > /dev/console

	 if [ "X${FrcFDisk}" == "X1" ]; then
	    /ezdvr/usrbin/fdisk  -o 63   -f  ${DEV}
	 else
	    /ezdvr/usrbin/fdisk  -o 63       ${DEV}
	 fi
	 
	 #./usrbin/fdisk  ${DEV}
   RET=$?	
   if [ ${RET} -le 2 ]; then
   
   	  if [ ${RET} == 1 ]; then
   	      #/ezdvr/usrbin/usb.sh
   	      echo  "error: failed to reread partition table "> /dev/console;
          wrap_exit 3
   	  fi   
   
      count=0
		  while [ $count -le 30 ]
		  do
			   if [ -e  "${DEV}1"  ]
			   then
				    break
			   else
				    sleep 1
			   fi
			   count=$((count+1))
		  done
		
		  if [ -e "${DEV}1" ]
		  then
			   echo "fdisk ok"> /dev/console;
			   DEV="${DEV}1"
			else
			   echo "fdisk failed"> /dev/console;
			   wrap_exit 4
		  fi
   fi     	
fi
 
if [ "X${fdiskOnly}" == "X1" ]; then
   echo  "Only fdisk"> /dev/console;
   wrap_exit  0
fi   
 
echo ""         > /dev/console 
echo "${DEV} "  > /dev/console

/ezdvr/usrbin/mkdosfs  -I  -v  ${DEV}
if [ "X$?" != "X0" ]; then
   echo  "error: failed to mkdosfs"> /dev/console;
   wrap_exit 5
fi

mount  -t  vfat  ${DEV}  ${MountPoint}
if [ "X$?" != "X0" ]; then
   echo  "error: failed to mount ${DEV} on ${MountPoint}"> /dev/console;
   wrap_exit 6
fi

echo  "Format OK"> /dev/console;
wrap_exit 0