jQuery(document).ready(function () {
    jQuery(document).on('click', '.SM_Image_Field .repeat-field', function (e) {
		e.preventDefault();
		make_it_sortable();
		var PARENT = jQuery(this).parents('.SM_Image_Field');
		var IMAGES = PARENT.find('.field-item').length - 1;
		var NAME = PARENT.find('.field-item:eq(0) input').attr('name').split("[sm-field-")[0];
        var link = jQuery(this);
        var container = jQuery(this).parent();
        var frameArgs = {
            multiple: true,
            title: 'Select File'
        };
        var SM_Frame = wp.media(frameArgs);
        SM_Frame.on('select', function () {
            var selection = SM_Frame.state().get('selection').toJSON();
			for(var i=IMAGES;i<selection.length+IMAGES;i++){
				var model = selection[i-IMAGES].id;
				PARENT.find('.field-item.hidden:eq(0)').before(
				'<div class="field-item item-no-'+i+'" data-class="SM_Image_Field" style="position: relative">'+
					'<button class="sm-delete-field" title="Remove field"><span class="sm-delete-field-icon">×</span>Remove Group</button>'+
					'<div class="sm-file-wrap" data-type="image" data-original-width="150" data-original-height="150" style="width: 150px; height: 150px;">'+
						'<div class="sm-file-wrap-placeholder"></div>'+
						'<div class="sm-file-holder type-img hidden" data-crop="1"></div>'+
						'<button class="sm-remove-file button hidden">Remove</button>'+
						'<input type="hidden" class="sm-file-upload-input" name="'+NAME+'[sm-field-'+i+']" value="">'+
					'</div>'+
				'</div>');
				recalculateFileFieldSize();
				var fileHolder = PARENT.find('.item-no-'+i+' .sm-file-holder');
                var data = {
                    action: 'sm_request_image',
                    id: model,
                    width: '150px',
                    height: '150px',
                    crop: 1,
                    nonce: link.attr('data-nonce'),
					holderId: i
                };
				fileHolder.html('');
				fileHolder.show();				
                fileHolder.addClass('loading');
                jQuery.post(ajaxurl, data, function (result) {
					result = JSON.parse(result);
					var fileHolder = PARENT.find('.item-no-'+result.holderId+' .sm-file-holder');
					PARENT.find('.item-no-'+result.holderId+' input').val(result.id);
                    jQuery('<img />', {
                        src: result.src
                    }).prependTo(fileHolder);
                    fileHolder.removeClass('loading');
                });
			}
			IMAGES = i;
        });
        SM_Frame.open();
    });
	
	/* start for single image */
	
	jQuery( document ).on( 'click', '.sm-file-upload', function(e) {

		e.preventDefault();

		var link = jQuery( this );
		var container = jQuery( this ).parent();

		var frameArgs = {
			multiple: false,
			title: 'Select File'
		};

		library = container.attr( 'data-type' ).split(',');
		if ( library.length > 0 ){
			frameArgs.library = { type: library };
		}

		var SM_Frame = wp.media( frameArgs );

		SM_Frame.on( 'select', function() {

			var selection = SM_Frame.state().get('selection'),
				model = selection.first(),
				fileHolder = container.find( '.sm-file-holder' );

			jQuery( container ).find( '.sm-file-upload-input' ).val( model.id );

			link.hide();

			SM_Frame.close();

			fileHolder.html( '' );
			fileHolder.show();
			fileHolder.siblings( '.sm-remove-file' ).show();

			var fieldType = container.closest( '.field-item' ).attr( 'data-class' );

			if ( 'SM_Image_Field' === fieldType ) {

				var data = {
					action: 'sm_request_image',
					id:     model.attributes.id,
					width:  container.width(),
					height: container.height(),
					crop:   fileHolder.attr('data-crop'),
					nonce:  link.attr( 'data-nonce' ),
					holderId: 0
				};

				fileHolder.addClass( 'loading' );

				jQuery.post( ajaxurl, data, function( result ) {
					result = JSON.parse(result);
					jQuery( '<img />', { src: result.src } ).prependTo( fileHolder );
					fileHolder.removeClass( 'loading' );
				}).fail( function() {
					jQuery( '<img />', { src: model.attributes.url } ).prependTo( fileHolder );
					fileHolder.removeClass( 'loading' );
				});

			} else {

				jQuery( '<img />', { src: model.attributes.icon } ).prependTo( fileHolder );
				fileHolder.append( jQuery('<div class="sm-file-name" />').html( '<strong>' + model.attributes.filename + '</strong>' ) );

			}

		});

		SM_Frame.open();

	} );	

	jQuery( document ).on( 'click', '.sm-remove-file', function(e) {

		e.preventDefault();

		var container = jQuery( this ).parent().parent();

		container.find( '.sm-file-holder' ).html( '' ).hide();
		container.find( '.sm-file-upload-input' ).val( '' );
		container.find( '.sm-file-upload' ).show().css( 'display', 'inline-block' );
		container.find( '.sm-remove-file' ).hide();

	} );
	/* end for single image */
	
    jQuery(document).on('click', '.sm-delete-field', function (e) {
        e.preventDefault();
		var container;
		if(jQuery(this).hasClass('delete-group')){
			container = jQuery(this).parent().parent();
		}
		else{
			container = jQuery(this).parent();
		}
		container.hide();
		container.remove();
    });
    var recalculateFileFieldSize = function () {
        jQuery('.sm-file-wrap').each(function () {
            var el = jQuery(this),
                container = el.closest('.postbox'),
                width = container.width() - 12 - 10 - 10,
                ratio = el.height() / el.width();
            if(el.attr('data-original-width')){
                el.width(el.attr('data-original-width'));
			}
            else{
                el.attr('data-original-width', el.width());
			}
            if(el.attr('data-original-height')){
                el.height(el.attr('data-original-height'));
			}
            else{
                el.attr('data-original-height', el.height());
			}
            if(el.width() > width) {
                el.width(width);
                el.find('.sm-file-wrap-placeholder').width(width - 8);
                el.height(width * ratio);
                el.css('line-height', (width * ratio) + 'px');
                el.find('.sm-file-wrap-placeholder').height((width * ratio) - 8);
            }
        });
    };
    recalculateFileFieldSize();
    jQuery(window).resize(recalculateFileFieldSize);

	function make_it_sortable(){
		jQuery( ".SM_Image_Field" ).each(function(){
			var object = jQuery(this);
			object.sortable({
				revert: false,
				update: function(event, ui) {
					var NAME = object.find('.field-item:eq(0) input').attr('name').split("[sm-field-")[0];
					var image = 0;
					object.find('.field-item').each(function(){
						if(!jQuery(this).hasClass('hidden')){
							jQuery(this).find('input').attr('name',NAME+'[sm-field-'+image+']');
							image++;
						}						
					});	
				}
			});	
		});		
	}
	make_it_sortable();
	
});