<?php

/**

 * This file loads the CSS and JS necessary for your shortcodes display

 *

 * @package Symple Shortcodes Plugin

 * @since 1.0

 * @author AJ Clarke : http://wpexplorer.com

 * @copyright Copyright (c) 2012, AJ Clarke

 * @link http://wpexplorer.com

 */



if( !function_exists ('symple_shortcodes_scripts') ) :

	function symple_shortcodes_scripts() {



		$scripts_dir =  get_template_directory_uri();



		// Make sure jquery is loaded

		wp_enqueue_script( 'jquery' );



		// Register scripts

		wp_register_script( 'fusion_tabs', $scripts_dir . '/functions/symple-shortcodes/includes/js/fusion_tabs.js', array ( 'jquery', 'jquery-ui-tabs'), '1.0', true );

		wp_register_script( 'fusion_toggle', $scripts_dir . '/functions/symple-shortcodes/includes/js/fusion_toggle.js', 'jquery', '1.0', true );

		wp_register_script( 'fusion_accordion', $scripts_dir . '/functions/symple-shortcodes/includes/js/fusion_accordion.js', array ( 'jquery', 'jquery-ui-accordion'), '1.0', true );

		wp_register_script( 'symple_googlemap',  $scripts_dir . '/functions/symple-shortcodes/includes/js/symple_googlemap.js', array('jquery'), '1.0', true );

		wp_register_script( 'symple_googlemap_api', 'https://maps.googleapis.com/maps/api/js?sensor=false', array('jquery'), '1.0', true );

		wp_register_script( 'fusion_skillbar', $scripts_dir . '/functions/symple-shortcodes/includes/js/fusion_skillbar.js', array ( 'jquery' ), '1.0', true );

		wp_register_script( 'symple_scroll_fade', $scripts_dir . '/functions/symple-shortcodes/includes/js/symple_scroll_fade.js', array ( 'jquery' ), '1.0', true );

		wp_register_script( 'myjs', $scripts_dir . '/functions/symple-shortcodes/includes/js/myjs.js', array ( 'jquery' ), '1.0', true );

		// Enqueue CSS

		wp_enqueue_style( 'symple_shortcode_styles', $scripts_dir . '/functions/symple-shortcodes/includes/css/fusion_shortcodes_styles.css' );
		wp_enqueue_style( 'animate', $scripts_dir . '/functions/symple-shortcodes/includes/css/animate.css' );
		

		

	}

	add_action('wp_enqueue_scripts', 'symple_shortcodes_scripts');

endif;