<?php

add_action('init','of_options');

if (!function_exists('of_options'))
{
	function of_options()
	{
		//Access the WordPress Categories via an Array
		$of_categories 		= array();  
		$of_categories_obj 	= get_categories('hide_empty=0');
		foreach ($of_categories_obj as $of_cat) {
		    $of_categories[$of_cat->cat_ID] = $of_cat->cat_name;}
		$categories_tmp 	= array_unshift($of_categories, "Select a category:");    
	       
		//Access the WordPress Pages via an Array
		$of_pages 			= array();
		$of_pages_obj 		= get_pages('sort_column=post_parent,menu_order');    
		foreach ($of_pages_obj as $of_page) {
		    $of_pages[$of_page->ID] = $of_page->post_name; }
		$of_pages_tmp 		= array_unshift($of_pages, "Select a page:");       
	
		//Testing 
		$of_options_select 	= array("one","two","three","four","five"); 
		$of_options_radio 	= array("one" => "One","two" => "Two","three" => "Three","four" => "Four","five" => "Five");
		
		//Sample Homepage blocks for the layout manager (sorter)
		$of_options_homepage_blocks = array
		( 
			"disabled" => array (
				"placebo" 		=> "placebo", //REQUIRED!
				"block_one"		=> "Block One",
				"block_two"		=> "Block Two",
				"block_three"	=> "Block Three",
			), 
			"enabled" => array (
				"placebo" 		=> "placebo", //REQUIRED!
				"block_four"	=> "Block Four",
			),
		);
		
		$of_options_mobile_blocks = array( 
			"disabled" 			=> array(
			"placebo"   		=> "placebo", //REQUIRED!
			"call_button"		=> "Call Button",
			"social_profiles"	=> "Social Profiles",
			"leadform"			=> "Lead Form",
			"video"				=> "Video",
			"search_form"		=> "Search Form",
			"aweber_optinform"  => "aweber optinform"
			), 
			"enabled" 		=> array(
			"placebo"   		=> "placebo", //REQUIRED!
			"menus" 			=> "Menus"
			),
);
		
		//Stylesheets Reader
		$alt_stylesheet_path = LAYOUT_PATH;
		$alt_stylesheets = array();
		
		if ( is_dir($alt_stylesheet_path) ) 
		{
		    if ($alt_stylesheet_dir = opendir($alt_stylesheet_path) ) 
		    { 
		        while ( ($alt_stylesheet_file = readdir($alt_stylesheet_dir)) !== false ) 
		        {
		            if(stristr($alt_stylesheet_file, ".css") !== false)
		            {
		                $alt_stylesheets[] = $alt_stylesheet_file;
		            }
		        }    
		    }
		}


		//Background Images Reader
		$bg_images_path = get_stylesheet_directory(). '/images/bg/'; // change this to where you store your bg images
		$bg_images_url = get_template_directory_uri().'/images/bg/'; // change this to where you store your bg images
		$bg_images = array();
		
		if ( is_dir($bg_images_path) ) {
		    if ($bg_images_dir = opendir($bg_images_path) ) { 
		        while ( ($bg_images_file = readdir($bg_images_dir)) !== false ) {
		            if(stristr($bg_images_file, ".png") !== false || stristr($bg_images_file, ".jpg") !== false) {
		                $bg_images[] = $bg_images_url . $bg_images_file;
		            }
		        }    
		    }
		}
		

		/*-----------------------------------------------------------------------------------*/
		/* TO DO: Add options/functions that use these */
		/*-----------------------------------------------------------------------------------*/
		
		//More Options
		$uploads_arr 		= wp_upload_dir();
		$all_uploads_path 	= $uploads_arr['path'];
		$all_uploads 		= get_option('of_uploads');
		$other_entries 		= array("Select a number:","1","2","3","4","5","6","7","8","9","10","11","12","13","14","15","16","17","18","19");
		$body_repeat 		= array("no-repeat","repeat-x","repeat-y","repeat");
		$body_pos 			= array("top left","top center","top right","center left","center center","center right","bottom left","bottom center","bottom right");
		
		// Image Alignment radio box
		$of_options_thumb_align = array("alignleft" => "Left","alignright" => "Right","aligncenter" => "Center"); 
		
		// Image Links to Options
		$of_options_image_link_to = array("image" => "The Image","post" => "The Post"); 
		
		$font_sizes = array(
			'10' => '10',
			'11' => '11',
			'12' => '12',
			'13' => '13',
			'14' => '14',
			'15' => '15',
			'16' => '16',
			'17' => '17',
			'18' => '18',
			'19' => '19',
			'20' => '20',
			'21' => '21',
			'22' => '22',
			'23' => '23',
			'24' => '24',
			'25' => '25',
			'26' => '26',
			'27' => '27',
			'28' => '28',
			'29' => '29',
			'30' => '30',
			'31' => '31',
			'32' => '32',
			'33' => '33',
			'34' => '34',
			'35' => '35',
			'36' => '36',
			'37' => '37',
			'38' => '38',
			'39' => '39',
			'40' => '40',
			'41' => '41',
			'42' => '42',
		);
       
	  $font_weight = array(	   
	   '100'=>'100',
	   '200'=>'200',
	   '300'=>'300',
	   '400'=>'400',
	   '500'=>'500',
	   '600'=>'600',
	   '700'=>'700',
	   '800'=>'800',
	   '900'=>'900',
	   'normal'=>'normal',
	   'bold'=>'bold',
	   'bolder'=>'bolder',
	   'lighter'=>'lighter',
	   'inherit'=>'inherit',
	  );

	      $google_fonts = array(
            "0" => "Select Font",
            "ABeeZee" => "ABeeZee",
            "Abel" => "Abel",
            "Abril Fatface" => "Abril Fatface",
            "Aclonica" => "Aclonica",
            "Acme" => "Acme",
            "Actor" => "Actor",
            "Adamina" => "Adamina",
            "Advent Pro" => "Advent Pro",
            "Aguafina Script" => "Aguafina Script",
            "Akronim" => "Akronim",
            "Aladin" => "Aladin",
            "Aldrich" => "Aldrich",
            "Alef" => "Alef",
            "Alegreya" => "Alegreya",
            "Alegreya SC" => "Alegreya SC",
            "Alex Brush" => "Alex Brush",
            "Alfa Slab One" => "Alfa Slab One",
            "Alice" => "Alice",
            "Alike" => "Alike",
            "Alike Angular" => "Alike Angular",
            "Allan" => "Allan",
            "Allerta" => "Allerta",
            "Allerta Stencil" => "Allerta Stencil",
            "Allura" => "Allura",
            "Almendra" => "Almendra",
            "Almendra Display" => "Almendra Display",
            "Almendra SC" => "Almendra SC",
            "Amarante" => "Amarante",
            "Amaranth" => "Amaranth",
            "Amatic SC" => "Amatic SC",
            "Amethysta" => "Amethysta",
            "Anaheim" => "Anaheim",
            "Andada" => "Andada",
            "Andika" => "Andika",
            "Angkor" => "Angkor",
            "Annie Use Your Telescope" => "Annie Use Your Telescope",
            "Anonymous Pro" => "Anonymous Pro",
            "Antic" => "Antic",
            "Antic Didone" => "Antic Didone",
            "Antic Slab" => "Antic Slab",
            "Anton" => "Anton",
            "Arapey" => "Arapey",
            "Arbutus" => "Arbutus",
            "Arbutus Slab" => "Arbutus Slab",
            "Architects Daughter" => "Architects Daughter",
            "Archivo Black" => "Archivo Black",
            "Archivo Narrow" => "Archivo Narrow",
            "Arimo" => "Arimo",
            "Arizonia" => "Arizonia",
            "Armata" => "Armata",
            "Artifika" => "Artifika",
            "Arvo" => "Arvo",
            "Asap" => "Asap",
            "Asset" => "Asset",
            "Astloch" => "Astloch",
            "Asul" => "Asul",
            "Atomic Age" => "Atomic Age",
            "Aubrey" => "Aubrey",
            "Audiowide" => "Audiowide",
            "Autour One" => "Autour One",
            "Average" => "Average",
            "Average Sans" => "Average Sans",
            "Averia Gruesa Libre" => "Averia Gruesa Libre",
            "Averia Libre" => "Averia Libre",
            "Averia Sans Libre" => "Averia Sans Libre",
            "Averia Serif Libre" => "Averia Serif Libre",
            "Bad Script" => "Bad Script",
            "Balthazar" => "Balthazar",
            "Bangers" => "Bangers",
            "Basic" => "Basic",
            "Battambang" => "Battambang",
            "Baumans" => "Baumans",
            "Bayon" => "Bayon",
            "Belgrano" => "Belgrano",
            "Belleza" => "Belleza",
            "BenchNine" => "BenchNine",
            "Bentham" => "Bentham",
            "Berkshire Swash" => "Berkshire Swash",
            "Bevan" => "Bevan",
            "Bigelow Rules" => "Bigelow Rules",
            "Bigshot One" => "Bigshot One",
            "Bilbo" => "Bilbo",
            "Bilbo Swash Caps" => "Bilbo Swash Caps",
            "Bitter" => "Bitter",
            "Black Ops One" => "Black Ops One",
            "Bokor" => "Bokor",
            "Bonbon" => "Bonbon",
            "Boogaloo" => "Boogaloo",
            "Bowlby One" => "Bowlby One",
            "Bowlby One SC" => "Bowlby One SC",
            "Brawler" => "Brawler",
            "Bree Serif" => "Bree Serif",
            "Bubblegum Sans" => "Bubblegum Sans",
            "Bubbler One" => "Bubbler One",
            "Buda" => "Buda",
            "Buenard" => "Buenard",
            "Butcherman" => "Butcherman",
            "Butterfly Kids" => "Butterfly Kids",
            "Cabin" => "Cabin",
            "Cabin Condensed" => "Cabin Condensed",
            "Cabin Sketch" => "Cabin Sketch",
            "Caesar Dressing" => "Caesar Dressing",
            "Cagliostro" => "Cagliostro",
            "Calligraffitti" => "Calligraffitti",
            "Cambo" => "Cambo",
            "Candal" => "Candal",
            "Cantarell" => "Cantarell",
            "Cantata One" => "Cantata One",
            "Cantora One" => "Cantora One",
            "Capriola" => "Capriola",
            "Cardo" => "Cardo",
            "Carme" => "Carme",
            "Carrois Gothic" => "Carrois Gothic",
            "Carrois Gothic SC" => "Carrois Gothic SC",
            "Carter One" => "Carter One",
            "Caudex" => "Caudex",
            "Cedarville Cursive" => "Cedarville Cursive",
            "Ceviche One" => "Ceviche One",
            "Changa One" => "Changa One",
            "Chango" => "Chango",
            "Chau Philomene One" => "Chau Philomene One",
            "Chela One" => "Chela One",
            "Chelsea Market" => "Chelsea Market",
            "Chenla" => "Chenla",
            "Cherry Cream Soda" => "Cherry Cream Soda",
            "Cherry Swash" => "Cherry Swash",
            "Chewy" => "Chewy",
            "Chicle" => "Chicle",
            "Chivo" => "Chivo",
            "Cinzel" => "Cinzel",
            "Cinzel Decorative" => "Cinzel Decorative",
            "Clicker Script" => "Clicker Script",
            "Coda" => "Coda",
            "Coda Caption" => "Coda Caption",
            "Codystar" => "Codystar",
            "Combo" => "Combo",
            "Comfortaa" => "Comfortaa",
            "Coming Soon" => "Coming Soon",
            "Concert One" => "Concert One",
            "Condiment" => "Condiment",
            "Content" => "Content",
            "Contrail One" => "Contrail One",
            "Convergence" => "Convergence",
            "Cookie" => "Cookie",
            "Copse" => "Copse",
            "Corben" => "Corben",
            "Courgette" => "Courgette",
            "Cousine" => "Cousine",
            "Coustard" => "Coustard",
            "Covered By Your Grace" => "Covered By Your Grace",
            "Crafty Girls" => "Crafty Girls",
            "Creepster" => "Creepster",
            "Crete Round" => "Crete Round",
            "Crimson Text" => "Crimson Text",
            "Croissant One" => "Croissant One",
            "Crushed" => "Crushed",
            "Cuprum" => "Cuprum",
            "Cutive" => "Cutive",
            "Cutive Mono" => "Cutive Mono",
            "Damion" => "Damion",
            "Dancing Script" => "Dancing Script",
            "Dangrek" => "Dangrek",
            "Dawning of a New Day" => "Dawning of a New Day",
            "Days One" => "Days One",
            "Delius" => "Delius",
            "Delius Swash Caps" => "Delius Swash Caps",
            "Delius Unicase" => "Delius Unicase",
            "Della Respira" => "Della Respira",
            "Denk One" => "Denk One",
            "Devonshire" => "Devonshire",
            "Didact Gothic" => "Didact Gothic",
            "Diplomata" => "Diplomata",
            "Diplomata SC" => "Diplomata SC",
            "Domine" => "Domine",
            "Donegal One" => "Donegal One",
            "Doppio One" => "Doppio One",
            "Dorsa" => "Dorsa",
            "Dosis" => "Dosis",
            "Dr Sugiyama" => "Dr Sugiyama",
            "Droid Sans" => "Droid Sans",
            "Droid Sans Mono" => "Droid Sans Mono",
            "Droid Serif" => "Droid Serif",
            "Duru Sans" => "Duru Sans",
            "Dynalight" => "Dynalight",
            "EB Garamond" => "EB Garamond",
            "Eagle Lake" => "Eagle Lake",
            "Eater" => "Eater",
            "Economica" => "Economica",
            "Electrolize" => "Electrolize",
            "Elsie" => "Elsie",
            "Elsie Swash Caps" => "Elsie Swash Caps",
            "Emblema One" => "Emblema One",
            "Emilys Candy" => "Emilys Candy",
            "Engagement" => "Engagement",
            "Englebert" => "Englebert",
            "Enriqueta" => "Enriqueta",
            "Erica One" => "Erica One",
            "Esteban" => "Esteban",
            "Euphoria Script" => "Euphoria Script",
            "Ewert" => "Ewert",
            "Exo" => "Exo",
            "Expletus Sans" => "Expletus Sans",
            "Fanwood Text" => "Fanwood Text",
            "Fascinate" => "Fascinate",
            "Fascinate Inline" => "Fascinate Inline",
            "Faster One" => "Faster One",
            "Fasthand" => "Fasthand",
            "Fauna One" => "Fauna One",
            "Federant" => "Federant",
            "Federo" => "Federo",
            "Felipa" => "Felipa",
            "Fenix" => "Fenix",
            "Finger Paint" => "Finger Paint",
            "Fjalla One" => "Fjalla One",
            "Fjord One" => "Fjord One",
            "Flamenco" => "Flamenco",
            "Flavors" => "Flavors",
            "Fondamento" => "Fondamento",
            "Fontdiner Swanky" => "Fontdiner Swanky",
            "Forum" => "Forum",
            "Francois One" => "Francois One",
            "Freckle Face" => "Freckle Face",
            "Fredericka the Great" => "Fredericka the Great",
            "Fredoka One" => "Fredoka One",
            "Freehand" => "Freehand",
            "Fresca" => "Fresca",
            "Frijole" => "Frijole",
            "Fruktur" => "Fruktur",
            "Fugaz One" => "Fugaz One",
            "GFS Didot" => "GFS Didot",
            "GFS Neohellenic" => "GFS Neohellenic",
            "Gabriela" => "Gabriela",
            "Gafata" => "Gafata",
            "Galdeano" => "Galdeano",
            "Galindo" => "Galindo",
            "Gentium Basic" => "Gentium Basic",
            "Gentium Book Basic" => "Gentium Book Basic",
            "Geo" => "Geo",
            "Geostar" => "Geostar",
            "Geostar Fill" => "Geostar Fill",
            "Germania One" => "Germania One",
            "Gilda Display" => "Gilda Display",
            "Give You Glory" => "Give You Glory",
            "Glass Antiqua" => "Glass Antiqua",
            "Glegoo" => "Glegoo",
            "Gloria Hallelujah" => "Gloria Hallelujah",
            "Goblin One" => "Goblin One",
            "Gochi Hand" => "Gochi Hand",
            "Gorditas" => "Gorditas",
            "Goudy Bookletter 1911" => "Goudy Bookletter 1911",
            "Graduate" => "Graduate",
            "Grand Hotel" => "Grand Hotel",
            "Gravitas One" => "Gravitas One",
            "Great Vibes" => "Great Vibes",
            "Griffy" => "Griffy",
            "Gruppo" => "Gruppo",
            "Gudea" => "Gudea",
            "Habibi" => "Habibi",
            "Hammersmith One" => "Hammersmith One",
            "Hanalei" => "Hanalei",
            "Hanalei Fill" => "Hanalei Fill",
            "Handlee" => "Handlee",
            "Hanuman" => "Hanuman",
            "Happy Monkey" => "Happy Monkey",
            "Headland One" => "Headland One",
            "Henny Penny" => "Henny Penny",
            "Herr Von Muellerhoff" => "Herr Von Muellerhoff",
            "Holtwood One SC" => "Holtwood One SC",
            "Homemade Apple" => "Homemade Apple",
            "Homenaje" => "Homenaje",
            "Holtwood One SC" => "Holtwood One SC",
            "IM Fell DW Pica" => "IM Fell DW Pica",
            "IM Fell DW Pica SC" => "IM Fell DW Pica SC",
            "IM Fell Double Pica" => "IM Fell Double Pica",
            "IM Fell Double Pica SC" => "IM Fell Double Pica SC",
            "IM Fell English" => "IM Fell English",
            "IM Fell English SC" => "IM Fell English SC",
            "IM Fell French Canon" => "IM Fell French Canon",
            "IM Fell French Canon SC" => "IM Fell French Canon SC",
            "IM Fell Great Primer" => "IM Fell Great Primer",
            "IM Fell Great Primer SC" => "IM Fell Great Primer SC",
            "Iceberg" => "Iceberg",
            "Iceland" => "Iceland",
            "Imprima" => "Imprima",
            "Inconsolata" => "Inconsolata",
            "Inder" => "Inder",
            "Indie Flower" => "Indie Flower",
            "Inika" => "Inika",
            "Irish Grover" => "Irish Grover",
            "Istok Web" => "Istok Web",
            "Italiana" => "Italiana",
            "Italianno" => "Italianno",
            "Jacques Francois" => "Jacques Francois",
            "Jacques Francois Shadow" => "Jacques Francois Shadow",
            "Jim Nightshade" => "Jim Nightshade",
            "Jockey One" => "Jockey One",
            "Jolly Lodger" => "Jolly Lodger",
            "Josefin Sans" => "Josefin Sans",
            "Josefin Slab" => "Josefin Slab",
            "Joti One" => "Joti One",
            "Judson" => "Judson",
            "Julee" => "Julee",
            "Julius Sans One" => "Julius Sans One",
            "Junge" => "Junge",
            "Jura" => "Jura",
            "Just Another Hand" => "Just Another Hand",
            "Just Me Again Down Here" => "Just Me Again Down Here",
            "Kameron" => "Kameron",
            "Karla" => "Karla",
            "Kaushan Script" => "Kaushan Script",
            "Kavoon" => "Kavoon",
            "Keania One" => "Keania One",
            "Kelly Slab" => "Kelly Slab",
            "Kenia" => "Kenia",
            "Khmer" => "Khmer",
            "Kite One" => "Kite One",
            "Knewave" => "Knewave",
            "Kotta One" => "Kotta One",
            "Koulen" => "Koulen",
            "Kranky" => "Kranky",
            "Kreon" => "Kreon",
            "Kristi" => "Kristi",
            "Krona One" => "Krona One",
            "La Belle Aurore" => "La Belle Aurore",
            "Lancelot" => "Lancelot",
            "Lato" => "Lato",
            "latoregular" => "LatoRegular",
            "League Script" => "League Script",
            "Leckerli One" => "Leckerli One",
            "Ledger" => "Ledger",
            "Lekton" => "Lekton",
            "Lemon" => "Lemon",
            "Libre Baskerville" => "Libre Baskerville",
            "Life Savers" => "Life Savers",
            "Lilita One" => "Lilita One",
            "Lily Script One" => "Lily Script One",
            "Limelight" => "Limelight",
            "Linden Hill" => "Linden Hill",
            "Lobster" => "Lobster",
            "Lobster Two" => "Lobster Two",
            "Londrina Outline" => "Londrina Outline",
            "Londrina Shadow" => "Londrina Shadow",
            "Londrina Sketch" => "Londrina Sketch",
            "Londrina Solid" => "Londrina Solid",
            "Lora" => "Lora",
            "Love Ya Like A Sister" => "Love Ya Like A Sister",
            "Loved by the King" => "Loved by the King",
            "Lovers Quarrel" => "Lovers Quarrel",
            "Luckiest Guy" => "Luckiest Guy",
            "Lusitana" => "Lusitana",
            "Lustria" => "Lustria",
            "Macondo" => "Macondo",
            "Macondo Swash Caps" => "Macondo Swash Caps",
            "Magra" => "Magra",
            "Maiden Orange" => "Maiden Orange",
            "Mako" => "Mako",
            "Marcellus" => "Marcellus",
            "Marcellus SC" => "Marcellus SC",
            "Marck Script" => "Marck Script",
            "Margarine" => "Margarine",
            "Marko One" => "Marko One",
            "Marmelad" => "Marmelad",
            "Marvel" => "Marvel",
            "Mate" => "Mate",
            "Mate SC" => "Mate SC",
            "Maven Pro" => "Maven Pro",
            "McLaren" => "McLaren",
            "Meddon" => "Meddon",
            "MedievalSharp" => "MedievalSharp",
            "Medula One" => "Medula One",
            "Megrim" => "Megrim",
            "Meie Script" => "Meie Script",
            "Merienda" => "Merienda",
            "Merienda One" => "Merienda One",
            "Merriweather" => "Merriweather",
            "Merriweather Sans" => "Merriweather Sans",
            "Metal" => "Metal",
            "Metal Mania" => "Metal Mania",
            "Metamorphous" => "Metamorphous",
            "Metrophobic" => "Metrophobic",
            "Michroma" => "Michroma",
            "Milonga" => "Milonga",
            "Miltonian" => "Miltonian",
            "Miltonian Tattoo" => "Miltonian Tattoo",
            "Miniver" => "Miniver",
            "Miss Fajardose" => "Miss Fajardose",
            "Modern Antiqua" => "Modern Antiqua",
            "Molengo" => "Molengo",
            "Molle" => "Molle",
            "Monda" => "Monda",
            "Monofett" => "Monofett",
            "Monoton" => "Monoton",
            "Monsieur La Doulaise" => "Monsieur La Doulaise",
            "Montaga" => "Montaga",
            "Montez" => "Montez",
            "Montserrat" => "Montserrat",
            "Montserrat Alternates" => "Montserrat Alternates",
            "Montserrat Subrayada" => "Montserrat Subrayada",
            "Moul" => "Moul",
            "Moulpali" => "Moulpali",
            "Mountains of Christmas" => "Mountains of Christmas",
            "Mouse Memoirs" => "Mouse Memoirs",
            "Mr Bedfort" => "Mr Bedfort",
            "Mr Dafoe" => "Mr Dafoe",
            "Mr De Haviland" => "Mr De Haviland",
            "Mrs Saint Delafield" => "Mrs Saint Delafield",
            "Mrs Sheppards" => "Mrs Sheppards",
            "Muli" => "Muli",
            "Mystery Quest" => "Mystery Quest",
			"museo_sans500"=>"museo_sans500",
            "Neucha" => "Neucha",
            "Neuton" => "Neuton",
            "New Rocker" => "New Rocker",
            "News Cycle" => "News Cycle",
            "Niconne" => "Niconne",
            "Nixie One" => "Nixie One",
            "Nobile" => "Nobile",
            "Nokora" => "Nokora",
            "Norican" => "Norican",
            "Nosifer" => "Nosifer",
            "Nothing You Could Do" => "Nothing You Could Do",
            "Noticia Text" => "Noticia Text",
            "Noto Sans" => "Noto Sans",
            "Noto Serif" => "Noto Serif",
            "Nova Cut" => "Nova Cut",
            "Nova Flat" => "Nova Flat",
            "Nova Mono" => "Nova Mono",
            "Nova Oval" => "Nova Oval",
            "Nova Round" => "Nova Round",
            "Nova Script" => "Nova Script",
            "Nova Slim" => "Nova Slim",
            "Nova Square" => "Nova Square",
            "Numans" => "Numans",
            "Nunito" => "Nunito",
            "Odor Mean Chey" => "Odor Mean Chey",
            "Offside" => "Offside",
            "Old Standard TT" => "Old Standard TT",
            "Oldenburg" => "Oldenburg",
            "Oleo Script" => "Oleo Script",
            "Oleo Script Swash Caps" => "Oleo Script Swash Caps",
            "Open Sans" => "Open Sans",
            "Open Sans Bold" => "Open Sans Bold",
            "Open Sans Condensed" => "Open Sans Condensed",
            "TwCenMTRegular" => "TwCenMTRegular",
            "Oranienbaum" => "Oranienbaum",
            "Orbitron" => "Orbitron",
            "Oregano" => "Oregano",
            "Orienta" => "Orienta",
            "Original Surfer" => "Original Surfer",
            "Oswald" => "Oswald",
            "Over the Rainbow" => "Over the Rainbow",
            "Overlock" => "Overlock",
            "Overlock SC" => "Overlock SC",
            "Ovo" => "Ovo",
            "Oxygen" => "Oxygen",
            "Oxygen Mono" => "Oxygen Mono",
            "PT Mono" => "PT Mono",
            "PT Sans" => "PT Sans",
            "PT Sans Caption" => "PT Sans Caption",
            "PT Sans Narrow" => "PT Sans Narrow",
            "PT Serif" => "PT Serif",
            "PT Serif Caption" => "PT Serif Caption",
            "Pacifico" => "Pacifico",
            "Paprika" => "Paprika",
            "Parisienne" => "Parisienne",
            "Passero One" => "Passero One",
            "Passion One" => "Passion One",
            "Pathway Gothic One" => "Pathway Gothic One",
            "Patrick Hand" => "Patrick Hand",
            "Patrick Hand SC" => "Patrick Hand SC",
            "Patua One" => "Patua One",
            "Paytone One" => "Paytone One",
            "Peralta" => "Peralta",
            "Permanent Marker" => "Permanent Marker",
            "Petit Formal Script" => "Petit Formal Script",
            "Petrona" => "Petrona",
            "Philosopher" => "Philosopher",
            "Piedra" => "Piedra",
            "Pinyon Script" => "Pinyon Script",
            "Pirata One" => "Pirata One",
            "Plaster" => "Plaster",
            "Play" => "Play",
            "Playball" => "Playball",
            "Playfair Display" => "Playfair Display",
            "Playfair Display SC" => "Playfair Display SC",
            "Podkova" => "Podkova",
            "Poiret One" => "Poiret One",
            "Poller One" => "Poller One",
            "Poly" => "Poly",
            "Poppins" => "Poppins",
            "Pompiere" => "Pompiere",
            "Pontano Sans" => "Pontano Sans",
            "Port Lligat Sans" => "Port Lligat Sans",
            "Port Lligat Slab" => "Port Lligat Slab",
            "Prata" => "Prata",
            "Preahvihear" => "Preahvihear",
            "Press Start 2P" => "Press Start 2P",
            "Princess Sofia" => "Princess Sofia",
            "Prociono" => "Prociono",
            "Prosto One" => "Prosto One",
            "Puritan" => "Puritan",
            "Purple Purse" => "Purple Purse",
            "Quando" => "Quando",
            "Quantico" => "Quantico",
            "Quattrocento" => "Quattrocento",
            "Quattrocento Sans" => "Quattrocento Sans",
            "Questrial" => "Questrial",
            "Quicksand" => "Quicksand",
            "Quintessential" => "Quintessential",
            "Qwigley" => "Qwigley",
            "Racing Sans One" => "Racing Sans One",
            "Radley" => "Radley",
            "Raleway" => "Raleway",
            "Raleway Dots" => "Raleway Dots",
            "Rambla" => "Rambla",
            "Rammetto One" => "Rammetto One",
            "Ranchers" => "Ranchers",
            "Rancho" => "Rancho",
            "Rationale" => "Rationale",
            "Redressed" => "Redressed",
            "Reenie Beanie" => "Reenie Beanie",
            "Revalia" => "Revalia",
            "Ribeye" => "Ribeye",
            "Ribeye Marrow" => "Ribeye Marrow",
            "Righteous" => "Righteous",
            "Risque" => "Risque",
            "Roboto" => "Roboto",
            "Roboto Condensed" => "Roboto Condensed",
            "Roboto Slab" => "Roboto Slab",
            "Rochester" => "Rochester",
            "Rock Salt" => "Rock Salt",
            "Rokkitt" => "Rokkitt",
            "Romanesco" => "Romanesco",
            "Ropa Sans" => "Ropa Sans",
            "Rosario" => "Rosario",
            "Rosarivo" => "Rosarivo",
            "Rouge Script" => "Rouge Script",
            "Ruda" => "Ruda",
            "Rufina" => "Rufina",
            "Ruge Boogie" => "Ruge Boogie",
            "Ruluko" => "Ruluko",
            "Rum Raisin" => "Rum Raisin",
            "Ruslan Display" => "Ruslan Display",
            "Russo One" => "Russo One",
            "Ruthie" => "Ruthie",
            "Rye" => "Rye",
            "Sacramento" => "Sacramento",
            "Sail" => "Sail",
            "Salsa" => "Salsa",
            "Sanchez" => "Sanchez",
            "Sancreek" => "Sancreek",
            "Sansita One" => "Sansita One",
            "Sarina" => "Sarina",
            "Satisfy" => "Satisfy",
            "Scada" => "Scada",
            "Schoolbell" => "Schoolbell",
            "Seaweed Script" => "Seaweed Script",
            "Sevillana" => "Sevillana",
            "Seymour One" => "Seymour One",
            "Shadows Into Light" => "Shadows Into Light",
            "Shadows Into Light Two" => "Shadows Into Light Two",
            "Shanti" => "Shanti",
            "Share" => "Share",
            "Share Tech" => "Share Tech",
            "Share Tech Mono" => "Share Tech Mono",
            "Shojumaru" => "Shojumaru",
            "Short Stack" => "Short Stack",
            "Siemreap" => "Siemreap",
            "Sigmar One" => "Sigmar One",
            "Signika" => "Signika",
            "Signika Negative" => "Signika Negative",
            "Simonetta" => "Simonetta",
            "Sintony" => "Sintony",
            "Sirin Stencil" => "Sirin Stencil",
            "Six Caps" => "Six Caps",
            "Skranji" => "Skranji",
            "Slackey" => "Slackey",
            "Smokum" => "Smokum",
            "Smythe" => "Smythe",
            "Sniglet" => "Sniglet",
            "Snippet" => "Snippet",
            "Snowburst One" => "Snowburst One",
            "Sofadi One" => "Sofadi One",
            "Sofia" => "Sofia",
            "Sonsie One" => "Sonsie One",
            "Sorts Mill Goudy" => "Sorts Mill Goudy",
            "Source Code Pro" => "Source Code Pro",
            "Source Sans Pro" => "Source Sans Pro",
            "Special Elite" => "Special Elite",
            "Spicy Rice" => "Spicy Rice",
            "Spinnaker" => "Spinnaker",
            "Spirax" => "Spirax",
            "Squada One" => "Squada One",
            "Stalemate" => "Stalemate",
            "Stalinist One" => "Stalinist One",
            "Stardos Stencil" => "Stardos Stencil",
            "Stint Ultra Condensed" => "Stint Ultra Condensed",
            "Stint Ultra Expanded" => "Stint Ultra Expanded",
            "Stoke" => "Stoke",
            "Strait" => "Strait",
            "Sue Ellen Francisco" => "Sue Ellen Francisco",
            "Sunshiney" => "Sunshiney",
            "Supermercado One" => "Supermercado One",
            "Suwannaphum" => "Suwannaphum",
            "Swanky and Moo Moo" => "Swanky and Moo Moo",
            "Syncopate" => "Syncopate",
            "Tangerine" => "Tangerine",
            "Taprom" => "Taprom",
            "Tauri" => "Tauri",
            "Telex" => "Telex",
            "Tenor Sans" => "Tenor Sans",
            "Text Me One" => "Text Me One",
            "The Girl Next Door" => "The Girl Next Door",
            "Tienne" => "Tienne",
            "Tinos" => "Tinos",
            "Titan One" => "Titan One",
            "Titillium Web" => "Titillium Web",
            "Trade Winds" => "Trade Winds",
            "Trocchi" => "Trocchi",
            "Trochut" => "Trochut",
            "Trykker" => "Trykker",
            "Tulpen One" => "Tulpen One",
            "Ubuntu" => "Ubuntu",
            "Ubuntu Condensed" => "Ubuntu Condensed",
            "Ubuntu Mono" => "Ubuntu Mono",
            "Ultra" => "Ultra",
            "Uncial Antiqua" => "Uncial Antiqua",
            "Underdog" => "Underdog",
            "Unica One" => "Unica One",
            "UnifrakturCook" => "UnifrakturCook",
            "UnifrakturMaguntia" => "UnifrakturMaguntia",
            "Unkempt" => "Unkempt",
            "Unlock" => "Unlock",
            "Unna" => "Unna",
            "VT323" => "VT323",
            "Vampiro One" => "Vampiro One",
            "Varela" => "Varela",
            "Varela Round" => "Varela Round",
            "Vast Shadow" => "Vast Shadow",
            "Vibur" => "Vibur",
            "Vidaloka" => "Vidaloka",
            "Viga" => "Viga",
            "Voces" => "Voces",
            "Volkhov" => "Volkhov",
            "Vollkorn" => "Vollkorn",
            "Voltaire" => "Voltaire",
            "Waiting for the Sunrise" => "Waiting for the Sunrise",
            "Wallpoet" => "Wallpoet",
            "Walter Turncoat" => "Walter Turncoat",
            "Warnes" => "Warnes",
            "Wellfleet" => "Wellfleet",
            "Wendy One" => "Wendy One",
            "Wire One" => "Wire One",
            "Yanone Kaffeesatz" => "Yanone Kaffeesatz",
            "Yellowtail" => "Yellowtail",
            "Yeseva One" => "Yeseva One",
            "Yesteryear" => "Yesteryear",
            "Zeyada" => "Zeyada"
        );

$fontawesomeicons=array("glass" => 'glass', "music" => "music", "search" => "search", "envelope-o" => "envelope-o", "heart" => "heart", "star" => "star", "star-o" => "star-0", "user" => "user", "film" => "film", "th-large" => "th-large", "th" => "th", "th-list" => "th-list", "check" => "check", "times" => "times", "search-plus" => "search-plus", "search-minus" => "search-minus", "power-off" => "power-off", "signal" => "signal", "cog" => "cog", "trash-o" => "trash-o", "home" => "home", "file-o" => "file-o", "clock-o" => "clock-o", "road" => "road", "download" => "download", "arrow-circle-o-down" => "arrow-circle-o-down", "arrow-circle-o-up" => "01b", 
"inbox" => "inbox",
 "play-circle-o" => "play-circle-o",
 "repeat" => "repeat", 
 "refresh" => "refresh",
 "list-alt" => "list-alt", 
 "lock" => "lock", "flag" => "flag", "headphones" => "headphones", 
 "volume-off" => "volume-off", "volume-down" => "volume-down", "volume-up" => "volume-up", 
 "qrcode" => "qrcode", "barcode" => "barcode", "tag" => "tag", "tags" => "tags", "book" => "book",
 "bookmark" => "bookmark", "print" => "print", "camera" => "camera", "font" => "font", "bold" => "bold", 
 "italic" => "italic", "text-height" => "text-height", "text-width" => "text-width", "align-left" => "align-left", "align-center" => "align-center", 
 "align-right" => "align-right", "align-justify" => "align-justify", "list" => "list", "outdent" => "outdent", "indent" => "indent", "video-camera" => "video-camera",
 "picture-o" => "picture-o", "pencil" => "pencil", "map-marker" => "map-marker", "adjust" => "adjust", "tint" => "tint", "pencil-square-o" => "pencil-square-o",
 "share-square-o" => "share-square-o", "check-square-o" => "check-square-o", "arrows" => "arrows", "step-backward" => "step-backward", "fast-backward" => "fast-backward", "backward" => "backward", "play" => "play", 
 "pause" => "pause", "stop" => "stop", "forward" => "forward", "fast-forward" => "fast-forward", "step-forward" => "step-forward", "eject" => "eject", 
 "chevron-left" => "chevron-left", 
 "chevron-right" => "chevron-right", "plus-circle" => "plus-circle", "minus-circle" => "minus-circle", "times-circle" => "times-circle", "check-circle" => "check-circle",
 "question-circle" => "question-circle",
 "info-circle" => "info-circle", "crosshairs" => "crosshairs", "times-circle-o" => "times-circle-o", "check-circle-o" => "check-circle-o", 
 "ban" => "ban", "arrow-left" => "arrow-left", "arrow-right" => "arrow-right",
 "arrow-up" => "arrow-up", "arrow-down" => "arrow-down", "share" => "share", "expand" => "expand", "compress" => "compress", "plus" => "plus", 
 "minus" => "minus", "asterisk" => "asterisk",
 "exclamation-circle" => "exclamation-circle", "gift" => "gift", "leaf" => "leaf", "fire" => "fire", "eye" => "eye", "eye-slash" => "eye-slash", 
 "exclamation-triangle" => "exclamation-triangle", 
 "plane" => "plane", "calendar" => "calendar", "random" => "random", "comment" => "comment", "magnet" => "magnet", 
 "chevron-up" => "chevron-up", "chevron-down" => "chevron-down", 
 "retweet" => "retweet", "shopping-cart" => "shopping-cart", "folder" => "folder", "folder-open" => "folder-open", "arrows-v" => "arrows-v", 
 "arrows-h" => "arrows-h", "bar-chart-o" => "bar-chart-o",
 "twitter-square" => "twitter-square", "facebook-square" => "facebook-square", "camera-retro" => "camera-retro", "key" => "key", "cogs" => "cogs",
 "comments" => "comments", "thumbs-o-up" => "thumbs-o-up", 
 "thumbs-o-down" => "thumbs-o-down", "star-half" => "star-half", "heart-o" => "heart-o", "sign-out" => "sign-out", "linkedin-square" => "linkedin-square",
 "thumb-tack" => "thumb-tack", 
 "external-link" => "external-link", "sign-in" => "sign-in", "trophy" => "trophy", "github-square" => "github-square", "upload" => "upload", "lemon-o" => "lemon-o", 
 "phone" => "phone", 
 "square-o" => "square-o", "bookmark-o" => "bookmark-o", "phone-square" => "phone-square", "twitter" => "twitter", "facebook" => "facebook", "github" => "github",
 "unlock" => "unlock", 
 "credit-card" => "credit-card", "rss" => "rss", "hdd-o" => "hdd-o", "bullhorn" => "bullhorn", "bell" => "bell", "certificate" => "certificate", "hand-o-right" => "hand-o-right", 
 "hand-o-left" => "hand-o-left", "hand-o-up" => "hand-o-up", "hand-o-down" => "hand-o-down", "arrow-circle-left" => "arrow-circle-left", "arrow-circle-right" => "arrow-circle-right", 
 "arrow-circle-up" => "arrow-circle-up", "arrow-circle-down" => "arrow-circle-down", "globe" => "globe", "wrench" => "wrench", "tasks" => "tasks", 
 "filter" => "filter", 
 "briefcase" => "briefcase", "arrows-alt" => "arrows-alt", "users" => "users", "link" => "link", "cloud" => "cloud", "flask" => "flask", "scissors" => "scissors", 
 "files-o" => "files-o", "paperclip" => "paperclip", "floppy-o" => "floppy-o", "square" => "square", "bars" => "bars", "list-ul" => "list-ul", "list-ol" => "list-ol", 
 "strikethrough" => "strikethrough", "underline" => "underline", "table" => "table", "magic" => "magic", "truck" => "truck", "pinterest" => "pinterest", 
 "pinterest-square" => "pinterest-square", 
 "google-plus-square" => "google-plus-square", "google-plus" => "google-plus", "money" => "money", "caret-down" => "caret-down", "caret-up" => "caret-up", 
 "caret-left" => "caret-left", 
 "caret-right" => "caret-right", "columns" => "columns", "sort" => "sort", "sort-desc" => "sort-desc", "sort-asc" => "sort-asc", "envelope" => "envelope", 
 "linkedin" => "linkedin", 
 "undo" => "undo", "gavel" => "gavel", "tachometer" => "tachometer", "comment-o" => "comment-o", "comments-o" => "comments-o", "bolt" => "bolt", "sitemap" => "sitemap", 
 "umbrella" => "umbrella", "clipboard" => "clipboard", "lightbulb-o" => "lightbulb-o", "exchange" => "exchange", "cloud-download" => "cloud-download", 
 "cloud-upload" => "cloud-upload", 
 "user-md" => "user-md", "stethoscope" => "stethoscope", "suitcase" => "suitcase", "bell-o" => "bell-o", "coffee" => "coffee", "cutlery" => "cutlery",
 "file-text-o" => "file-text-o", 
 "building-o" => "building-o", "hospital-o" => "hospital-o", "ambulance" => "ambulance", "medkit" => "medkit", "fighter-jet" => "fighter-jet",
 "beer" => "beer", "h-square" => "h-square",
 "plus-square" => "plus-square", "angle-double-left" => "angle-double-left", "angle-double-right" => "angle-double-right", "angle-double-up" => "angle-double-up",
 "angle-double-down" => "angle-double-down", 
 "angle-left" => "angle-left", "angle-right" => "angle-right", "angle-up" => "angle-up", "angle-down" => "angle-down", "desktop" => "desktop",
 "laptop" => "laptop", "tablet" => "tablet", 
 "mobile" => "mobile", "circle-o" => "circle-o", "quote-left" => "quote-left", "quote-right" => "quote-right", "spinner" => "spinner", "circle" => "circle", 
 "reply" => "reply", 
 "github-alt" => "github-alt", "folder-o" => "folder-o", "folder-open-o" => "folder-open-o", "smile-o" => "mile-o", "frown-o" => "frown-o", "meh-o" => "meh", 
 "gamepad" => "gamepad",
 "keyboard-o" => "keyboard", "flag-o" => "flag", "flag-checkered" => "flag", "terminal" => "terminal", "code" => "code", "reply-all" => "reply", "star-half-o" => "star", 
 "location-arrow" => "location", "crop" => "crop", "code-fork" => "code", "chain-broken" => "chain", "question" => "question", "info" => "info", 
 "exclamation" => "exclamation", 
 "superscript" => "superscript", "subscript" => "subscript", "eraser" => "eraser", "puzzle-piece" => "puzzle", "microphone" => "microphone",
 "microphone-slash" => "microphone", 
 "shield" => "shield", "calendar-o" => "calendar", "fire-extinguisher" => "extinguisher", "rocket" => "rocket", "maxcdn" => "maxcdn", "chevron-circle-left" => "chevron",
 
 "chevron-circle-right" => "chevron", "chevron-circle-up" => "chevron", "chevron-circle-down" => "chevron", "html5" => "html5", "css3" => "css3", "anchor" => "anchor",
 "unlock-alt" => "unlock", "bullseye" => "bullseye", "ellipsis-h" => "ellipsis", "ellipsis-v" => "ellipsis", "rss-square" => "rss", "play-circle" => "play",
 "ticket" => "ticket", 
 "minus-square" => "minus", "minus-square-o" => "minus", "level-up" => "level", "level-down" => "level", "check-square" => "check", "pencil-square" => "pencil", 
 "external-link-square" => "external", "share-square" => "share", "compass" => "compass", "caret-square-o-down" => "caret", "caret-square-o-up" => "caret",
 "caret-square-o-right" => "caret", "eur" => "eur", "gbp" => "gbp", "usd" => "usd", "inr" => "inr", "jpy" => "jpy", "rub" => "rub", "krw" => "krw", 
 "btc" => "btc", "file" => "file", "file-text" => "file", "sort-alpha-asc" => "sort", "sort-alpha-desc" => "sort", "sort-amount-asc" => "sort", 
 "sort-amount-desc" => "sort", "sort-numeric-asc" => "sort", "sort-numeric-desc" => "sort", "thumbs-up" => "thumbsup", "thumbs-down" => "thumbsdown",
 "youtube-square" => "youtube", "youtube" => "youtube", "xing" => "xing", "xing-square" => "xing", "youtube-play" => "youtube", "dropbox" => "dropbox", 
 "stack-overflow" => "stack", "instagram" => "instagram", "flickr" => "flickr", "adn" => "adn", "bitbucket" => "bitbucket", "bitbucket-square" => "bitbucket", 
 "tumblr" => "tumblr", "tumblr-square" => "tumblr", "long-arrow-down" => "long-arrow", "long-arrow-up" => "long-arrow", "long-arrow-left" => "long-arrow", 
 "long-arrow-right" => "long-arrow", 
 "apple" => "apple", "windows" => "windows", "android" => "android", "linux" => "linux", "dribbble" => "dribbble", "skype" => "skype", "foursquare" => "foursquare",
 "trello" => "trello",
 "female" => "female", "male" => "male", "gittip" => "gittip", "sun-o" => "sun", "moon-o" => "moon", "archive" => "archive", "bug" => "bug", "vk" => "vk",
 "weibo" => "weibo",
 "renren" => "renren", "pagelines" => "pagelines", "stack-exchange" => "exchange", "arrow-circle-o-right" => "circle", "arrow-circle-o-left" => "circle",
 "caret-square-o-left" => "caret",
 "dot-circle-o" => "circle", "wheelchair" => "wheelchair", "vimeo-square" => "vimeo", "try" => "try", "plus-square-o" => "square", "space-shuttle" => "space",
 "slack" => "slack",
 "envelope-square" => "envelope", "wordpress" => "wordpress", "openid" => "openid", "university" => "university", "graduation-cap" => "graduation",
 "yahoo" => "yahoo", "google" => "google", 
 "reddit" => "reddit", "reddit-square" => "reddit", "stumbleupon-circle" => "stumbleupon", "stumbleupon" => "stumbleupon", "delicious" => "delicious",
 "digg" => "digg",
 "pied-piper" => "pied", "pied-piper-alt" => "piper", "drupal" => "drupal", "joomla" => "joomla", "language" => "language", "fax" => "fax", "building" => "building", 
 "child" => "child", "paw" => "paw", "spoon" => "spoon", "cube" => "cube", "cubes" => "cubes", "behance" => "behance", "behance-square" => "behance", 
 "steam" => "steam",
 "steam-square" => "steam", "recycle" => "recycle", "car" => "car", "taxi" => "taxi", "tree" => "tree", "spotify" => "spotify", "deviantart" => "deviantart", 
 "soundcloud" => "soundcloud", "database" => "database", "file-pdf-o" => "file", "file-word-o" => "file", "file-excel-o" => "file", "file-powerpoint-o" => "powerpoint", 
 "file-image-o" => "image", "file-archive-o" => "archive", "file-audio-o" => "audio", "file-video-o" => "video", "file-code-o" => "code", "vine" => "vine", 
 "codepen" => "codepen", "jsfiddle" => "jsfiddle", "life-ring" => "life-ring", "circle-o-notch" => "circle", "rebel" => "rebel", "empire" => "empire",
 "git-square" => "square",
 "git" => "git", "hacker-news" => "hacker", "tencent-weibo" => "tencent", "qq" => "qq", "weixin" => "weixin", "paper-plane" => "paper", "paper-plane-o" => "paper", 
 "history" => "history", "circle-thin" => "circle", "header" => "header", "paragraph" => "paragraph", "sliders" => "sliders", "share-alt" => "share",
 "share-alt-square" => "share", 
 "bomb" => "bomb" );

 $autoresponder_list = array(       
       '0'=>'- Choose Your Mailer -',
       '3'=>'GetResponse',
       /* '1'=>'Aweber', */
       '2'=>'MailChimp',
      

      ); 
$sortBy = array(       
       '0'=>'- Choose Your Option -',
       'featured'=>'Featured Posts',
       ''=>'Newly Added',
       'hot' => 'Hot Posts',
       'trending' => 'Trending Posts',
	   '_likes'   => 'Likes'
      

      );
	  
	  $masonaryEffects = array(       
		"effect-1" => "Effect-1",
		"effect-2" => "Effect-2",
		"effect-3" => "Effect-3",
		"effect-4" => "Effect-4",
		"effect-5" => "Effect-5",
		"effect-7" => "Effect-6",
		"effect-8" => "Effect-7"
      

      );

$args = array(
    'number'     => $number,
    'orderby'    => 'name',
    'order'      => 'ASC',
    'hide_empty' => false,
    'include'    => $ids
);
$post_categories = get_terms( 'category', $args );
$count = count($post_categories);
$allcategories = array();
if ( $count > 0 ){
    foreach ( $post_categories as $post_category ) {

		$allcategories[$post_category->name] = $post_category->name;
	}
}

/*-----------------------------------------------------------------------------------*/
/* The Options Array */
/*-----------------------------------------------------------------------------------*/

// Set the Options Array
global $of_options;
$of_options = array();

$of_options[] = array( 	"name" 		=> "Home Page Settings",
						"type" 		=> "heading",
						"icon"		=> "fa fa-home"
				);

$of_options[] = array( "name" => "Header Section",
						"desc" => "",
						"id" => "headersetting",
						"std" => "<h3 style='margin: 0;''>Header Setting</h3>",
						"icon" => true,
						"type" => "info"
						
					);						
				
$of_options[] = array( 	"name" 		=> "Your Logo",
						"desc" 		=> "Recommended dimension for this image is 178*48 px.",
						"id" 		=> "logo",
						"std" 		=> "",
						"type" 		=> "upload"
					);	
					
$of_options[] = array(    "name" 	=> "Custom Favicon",
						 "desc" 	=> "Upload a 16px x 16px Png/Gif image that will represent your website's favicon.",
						 "id" 		=> "favi_image",
						 "std" 		=> "",
						 "type" 	=> "upload"
						 
					);
					

$of_options[] = array( "name" => "Slider switch selector",
					"id" => "show_slider",
					"desc" => "if This is on then display slider section. ",
					"std" => 1,
					"folds" => 1,
					"type" => "switch");
								
$of_options[] = array( "name" => "Choose your Sort by Option",
						"desc" => "",
						"id" => "favourite_sort_by",
						"std" => "featured",
						"type" => "select",
						"options" => $sortBy);	
						
$of_options[] = array( 	"name" 		=> "Number of features posts to be display",
						"desc" 		=> "",
						"id" 		=> "favourite_num",
						"std" 		=> "-1",
						"type" 		=> "text"
						
				);	
	
			
/* Slider switcher */

$of_options[] = array( "name" => "Featured Posts section",
						"desc" => "",
						"id" => "Imageslider",
						"std" => "<h3 style='margin: 0;''>Featured Slider Section</h3>",
						"icon" => true,
						"type" => "info"
						
					);	
					
$of_options[] = array( "name" => "Featured switch selector",
					"id" => "featured_section",
					"desc" => "if This is on then display slider section. ",
					"std" => 1,
					"folds" => 1,
					"type" => "switch");	
					
$of_options[] = array( 	"name" 		=> "Heading",
						"desc" 		=> "",
						"id" 		=> "featured_head",
						"std" 		=> "",
						"type" 		=> "text"
						
				);	
$of_options[] = array( "name" => "Choose your Sort by Option",
						"desc" => "",
						"id" => "featured_sort_by",
						"std" => "featured",
						"type" => "select",
						"options" => $sortBy);	
						
$of_options[] = array( 	"name" 		=> "Number of posts to be display",
						"desc" 		=> "",
						"id" 		=> "featured_num",
						"std" 		=> "2",
						"type" 		=> "text"
						
				);						


				
				
$of_options[] = array( "name" => "Most Shared Section",
						"desc" => "",
						"id" => "Imageslider",
						"std" => "<h3 style='margin: 0;''>Most Shared Section</h3>",
						"icon" => true,
						"type" => "info"
						
					);	
$of_options[] = array( "name" => "Slider switch selector",
					"id" => "shared_section",
					"desc" => "if This is on then display Most Shared Section. ",
					"std" => 1,
					"folds" => 1,
					"type" => "switch");
					
$of_options[] = array( 	"name" 		=> "Heading",
						"desc" 		=> "",
						"id" 		=> "shared_blog_head",
						"std" 		=> "most shared",
						"type" 		=> "text"
						
				);	
				
$of_options[] = array( "name" => "Choose your Sort by Option",
						"desc" => "",
						"id" => "shared_sort_by",
						"std" => "_likes",
						"type" => "select",
						"options" => $sortBy);
						
$of_options[] = array( 	"name" 		=> "Number of Posts",
						"desc" 		=> "",
						"id" 		=> "most_shared_sort_by_num",
						"std" 		=> "4",
						"type" 		=> "text"
						
				);	
				

$of_options[] = array( "name" => "Trending Page Section",
						"desc" => "",
						"id" => "Imageslider",
						"std" => "<h3 style='margin: 0;''>Trending Page Section</h3>",
						"icon" => true,
						"type" => "info"
						
					);	
					
$of_options[] = array( 	"name" 		=> "Heading",
						"desc" 		=> "",
						"id" 		=> "Trending_head",
						"std" 		=> "Cool Blogs",
						"type" 		=> "text"
						
				);	
				
$of_options[] = array( "name" => "Choose your Sort by Option",
						"desc" => "",
						"id" => "Trending_sort_by",
						"std" => "trending",
						"type" => "select",
						"options" => $sortBy);	
						
$of_options[] = array( 	"name" 		=> "Number of Posts",
						"desc" 		=> "",
						"id" 		=> "Trending_sort_by_num",
						"std" 		=> "3",
						"type" 		=> "text"
						
				);

				
$of_options[] = array( "name" => "Trending Hot Section",
						"desc" => "",
						"id" => "Imageslider",
						"std" => "<h3 style='margin: 0;''>Trending Hot Section</h3>",
						"icon" => true,
						"type" => "info"
						
					);	

					
$of_options[] = array( 	"name" 		=> "Heading",
						"desc" 		=> "",
						"id" 		=> "Hot_head",
						"std" 		=> "Trending Hot Niches",
						"type" 		=> "text"
						
				);	
				
$of_options[] = array( "name" => "Choose your Sort by Option",
						"desc" => "",
						"id" => "Hot_sort_by",
						"std" => "hot",
						"type" => "select",
						"options" => $sortBy);	
						
$of_options[] = array( 	"name" 		=> "Number of Posts",
						"desc" 		=> "",
						"id" 		=> "Hot_sort_by_num",
						"std" 		=> "-1",
						"type" 		=> "text"
						
				);
/* Shop Page Settings */				
$of_options[] = array( 	"name" 		=> "Shop Page Settings",
						"type" 		=> "heading",
						"icon"		=> "fa fa-shopping-basket"
				);
$of_options[] = array( "name" => "Masonry Effect on Shop Page",
					"id" => "show_masonary",
					"desc" => "Show Image on Blog Listing Page.",
					"std" => 1,
					"folds" => 1,
					"type" => "switch");				
$of_options[] = array( 	"name" 		=> "Enter Number of products per page for Shop Page",
						"desc" 		=> "",
						"id" 		=> "show_items_per_page",
						"std" 		=> "32",
						"type" 		=> "text"
						
						
				);	

$of_options[] = array( "name" => "Select Shop Page Visual Effect Style",
						"desc" => "Choose Any effect from dropdown",
						"id" => "shop_masonary_style",
						"std" => "effect-1",
						"type" => "select",
						"options" => $masonaryEffects);				
				
	
/**********************--------Footer Heading---------********************/

$of_options[] = array( 	"name" 		=> "Banner Settings",
						"type" 		=> "heading",
						"icon"		=> "fa fa-star"
				);	

				
$of_options[] = array( "name" => "Ad Banner switch selector below Optin Form ",
					"id" => "show_ad_banner_above_popular",
					"desc" => "if This is on then display Ad banner section below Optin Form",
					"std" => 1,
					"folds" => 1,
					"type" => "switch");				

$of_options[] = array( 	"name" 		=> "Upload Banner Image",
						"desc" 		=> "",
						"id" 		=> "home_page_banner_above_popular",
						"std" 		=> "",
						"type" 		=> "upload"
						
						
				);	
$of_options[] = array( 	"name" 		=> "Banner Link",
						"desc" 		=> "",
						"id" 		=> "home_page_banner_url_above_popular",
						"std" 		=> "",
						"type" 		=> "textarea"
				);
				
$of_options[] = array( "name" => "Ad Banner switch selector for trending page",
					"id" => "show_ad_banner_trending",
					"desc" => "",
					"std" => 1,
					"folds" => 1,
					"type" => "switch");				

$of_options[] = array( 	"name" 		=> "Upload Banner Image",
						"desc" 		=> "",
						"id" 		=> "home_page_banner_trending",
						"std" 		=> "",
						"type" 		=> "upload"
						
						
				);	
$of_options[] = array( 	"name" 		=> "Banner Link",
						"desc" 		=> "",
						"id" 		=> "home_page_banner_url_trending",
						"std" 		=> "",
						"type" 		=> "textarea"
				);
$of_options[] = array( "name" => "Ad Banner switch selector for inner blog page",
					"id" => "show_ad_banner_inner",
					"desc" => "",
					"std" => 1,
					"folds" => 1,
					"type" => "switch");				

$of_options[] = array( 	"name" 		=> "Upload Banner Image",
						"desc" 		=> "",
						"id" 		=> "home_page_banner_inner",
						"std" 		=> "",
						"type" 		=> "upload"
						
						
				);	
$of_options[] = array( 	"name" 		=> "Banner Link",
						"desc" 		=> "",
						"id" 		=> "home_page_banner_url_inner",
						"std" 		=> "",
						"type" 		=> "textarea"
				);
				
				
				

/**********************--------Footer Heading---------********************/

$of_options[] = array( 	"name" 		=> "Footer Settings",
						"type" 		=> "heading",
						"icon"		=> "fa fa-file"
				);



$of_options[] = array( 	"name" 		=> "Footer Description",
						"desc" 		=> "",
						"id" 		=> "footer_desc",
						"std" 		=> "",
						"type" 		=> "textarea"
				);

$of_options[] = array( 	"name" 		=> "Heading for Latest Posts",
						"desc" 		=> "",
						"id" 		=> "footer_heading",
						"std" 		=> "",
						"type" 		=> "text"
				);
				
$of_options[] = array( 	"name" 		=> "Connect Us Heading",
						"desc" 		=> "",
						"id" 		=> "connect_us_heading",
						"std" 		=> "",
						"type" 		=> "text"
				);
			
					


/******************************************************/
/* $of_options[] = array( 	"name" 		=> "Youtube page Settings",
						"type" 		=> "heading",
						"icon"		=> "fa fa-youtube"
				);


$of_options[] = array( "name" => "Trending video section",
						"desc" => "",
						"id" => "trend_sect",
						"std" => "<h3 style='margin: 0;''>Trending Video Section</h3>",
						"icon" => true,
						"type" => "info"
						
					);
$of_options[] = array( "name" => "Trending video switch selector",
					"id" => "show_trend_video",
					"desc" => "if This is on then display Trending Video section. ",
					"std" => 1,
					"folds" => 1,
					"type" => "switch");				
					
$of_options[] = array( 	"name" 		=> "Trending Video main heading",
						"desc" 		=> "main header on Video goes here",
						"id" 		=> "trend_heading",
						"std" 		=> "",
						"type" 		=> "text"
				);
				

				

$of_options[] = array( 	"name" 		=> "Number Of Videos to display",
						"desc" 		=> "Insert any Numeric value here.Put '-1' to display all products",
						"id" 		=> "trend_feature_num",
						"std" 		=> "-1",
						"type" 		=> "text"
				);
				
$of_options[] = array( "name" => "Choose your Sort by Option",
						"desc" => "",
						"id" => "trend_sort_by",
						"std" => "",
						"type" => "select",
						"options" => $sortBy);		
				
$of_options[] = array( "name" => "Related video section",
						"desc" => "",
						"id" => "related_sect",
						"std" => "<h3 style='margin: 0;''>Related youtube Section</h3>",
						"icon" => true,
						"type" => "info"
						
					);
				
$of_options[] = array( "name" => "Related video switch selector",
					"id" => "show_related_video",
					"desc" => "if This is on then display Related Video section. ",
					"std" => 1,
					"folds" => 1,
					"type" => "switch");
					
$of_options[] = array( 	"name" 		=> "Related Video main heading",
						"desc" 		=> "main header on Video goes here",
						"id" 		=> "related_yt_vid_heading",
						"std" 		=> "",
						"type" 		=> "text"
				);
				
$of_options[] = array( 	"name" 		=> "Number Of Videos to display",
						"desc" 		=> "Insert any Numeric value here.Put '-1' to display all products",
						"id" 		=> "related_feature_num",
						"std" 		=> "-1",
						"type" 		=> "text"
				);
				
/* $of_options[] = array( "name" => "Choose your Sort by Option",
						"desc" => "",
						"id" => "related_sort_by",
						"std" => "",
						"type" => "select",
						"options" => $sortBy);	
 */				
/******************************************************/
/* $of_options[] = array( 	"name" 		=> "Vimeo page Settings",
						"type" 		=> "heading",
						"icon"		=> "fa fa-vimeo"
				);


$of_options[] = array( "name" => "Vimeo staff picks section",
						"desc" => "",
						"id" => "staff_sect",
						"std" => "<h3 style='margin: 0;''>Vimeo staff picks Section</h3>",
						"icon" => true,
						"type" => "info"
						
					);
				
$of_options[] = array( "name" => "Vimeo staff picks switch selector",
					"id" => "show_vimeo_staff",
					"desc" => "if This is on then display Vimeo staff picks section. ",
					"std" => 1,
					"folds" => 1,
					"type" => "switch");
					
$of_options[] = array( 	"name" 		=> "Vimeo staff picks main heading",
						"desc" 		=> "main header on Video goes here",
						"id" 		=> "staff_heading",
						"std" 		=> "",
						"type" 		=> "text"
				);
				

$of_options[] = array( 	"name" 		=> "Number Of Videos to display",
						"desc" 		=> "Insert any Numeric value here.Put '-1' to display all products",
						"id" 		=> "staff_feature_num",
						"std" 		=> "-1",
						"type" 		=> "text"
				);
				
$of_options[] = array( "name" => "Choose your Sort by Option",
						"desc" => "",
						"id" => "staff_sort_by",
						"std" => "",
						"type" => "select",
						"options" => $sortBy);		
				
$of_options[] = array( "name" => "Related video section",
						"desc" => "",
						"id" => "related_sect",
						"std" => "<h3 style='margin: 0;''>Related Vimeo Section</h3>",
						"icon" => true,
						"type" => "info"
						
					);
					
$of_options[] = array( "name" => "Vimeo Related video switch selector",
					"id" => "show_vimeo_related_section",
					"desc" => "if This is on then display Vimeo Related video section. ",
					"std" => 1,
					"folds" => 1,
					"type" => "switch");				
					
$of_options[] = array( 	"name" 		=> "Related Video main heading",
						"desc" 		=> "main header on Video goes here",
						"id" 		=> "related_vm_vid_heading",
						"std" 		=> "",
						"type" 		=> "text"
				);
				
$of_options[] = array( 	"name" 		=> "Number Of Videos to display",
						"desc" 		=> "Insert any Numeric value here.Put '-1' to display all products",
						"id" 		=> "related_vm_feature_num",
						"std" 		=> "-1",
						"type" 		=> "text"
				);
				
$of_options[] = array( "name" => "Choose your Sort by Option",
						"desc" => "",
						"id" => "related_vm_sort_by",
						"std" => "",
						"type" => "select",
						"options" => $sortBy);
						
/******************************************************/
/*						
$of_options[] = array( 	"name" 		=> "Dailymotion page Settings",
						"type" 		=> "heading",
						"icon"		=> "fa fa-dashcube"
				);


$of_options[] = array( "name" => "Dailymotion staff picks section",
						"desc" => "",
						"id" => "dmstaff_sect",
						"std" => "<h3 style='margin: 0;''>Dailymotion staff picks Section</h3>",
						"icon" => true,
						"type" => "info"
						
					);
				
$of_options[] = array( "name" => "Dailymotion staff picks switch selector",
					"id" => "show_dailymotion_staff",
					"desc" => "if This is on then display Dailymotion staff picks section. ",
					"std" => 1,
					"folds" => 1,
					"type" => "switch");
					
$of_options[] = array( 	"name" 		=> "Dailymotion staff picks main heading",
						"desc" 		=> "main header on Video goes here",
						"id" 		=> "dmstaff_heading",
						"std" 		=> "",
						"type" 		=> "text"
				);
				

$of_options[] = array( 	"name" 		=> "Number Of Videos to display",
						"desc" 		=> "Insert any Numeric value here.Put '-1' to display all videos",
						"id" 		=> "dmstaff_feature_num",
						"std" 		=> "-1",
						"type" 		=> "text"
				);
				
$of_options[] = array( "name" => "Choose your Sort by Option",
						"desc" => "",
						"id" => "dmstaff_sort_by",
						"std" => "",
						"type" => "select",
						"options" => $sortBy);		
				
$of_options[] = array( "name" => "Related video section",
						"desc" => "",
						"id" => "related_sect",
						"std" => "<h3 style='margin: 0;''>Related Dailymotion Section</h3>",
						"icon" => true,
						"type" => "info"
						
					);
					
$of_options[] = array( "name" => "Dailymotion Related video switch selector",
					"id" => "show_dailymotion_related_section",
					"desc" => "if This is on then display Dailymotion Related video section. ",
					"std" => 1,
					"folds" => 1,
					"type" => "switch");				
					
$of_options[] = array( 	"name" 		=> "Related Video main heading",
						"desc" 		=> "main header on Video goes here",
						"id" 		=> "related_dm_vid_heading",
						"std" 		=> "",
						"type" 		=> "text"
				);
				
$of_options[] = array( 	"name" 		=> "Number Of Videos to display",
						"desc" 		=> "Insert any Numeric value here.Put '-1' to display all videos",
						"id" 		=> "related_dm_feature_num",
						"std" 		=> "-1",
						"type" 		=> "text"
				);
				
/* $of_options[] = array( "name" => "Choose your Sort by Option",
						"desc" => "",
						"id" => "related_dm_sort_by",
						"std" => "",
						"type" => "select",
						"options" => $sortBy); */	
				

/***********************************************************/
	$of_options[] = array( 
						"name" => "Subscribe Form Setting", 

                        "type" => "heading", 

                       "icon"		=> "fa fa-envelope" 

                ); 
/*.........................................................*/
$of_options[] = array( "name" => "Subscribe Form Section",
						"desc" => "",
						"id" => "whatwedo_sect",
						"std" => "<h3 style='margin: 0;''>Subscribe Form Section</h3>",
						"icon" => true,
						"type" => "info"
						
					);
					
$of_options[] = array( 
					"name" => "Subscribe Form switch selector",

					"id" => "show_subscribe_form",

					"desc" => "if This is on then display Subscribe Form Section. ",

					"std" => 1,

					"folds" => 1,

					"type" => "switch"
					);		
					
$of_options[] = array( 	"name" 		=> "Subscribe Form Main Heading",
						"desc" 		=> "",
						"id" 		=> "newsletter_heading",

						"std" 		=> "",

						"type" 		=> "text"

				);



$of_options[] = array( 	"name" 		=> "Subscribe Form Button Text",

						"desc" 		=> "",

						"id" 		=> "sub_btn",

						"std" 		=> "",

						"type" 		=> "text"

				);
				

$of_options[] = array( 	"name" 		=> "Subscribe Form Email field Text",

						"desc" 		=> "",

						"id" 		=> "email_place",

						"std" 		=> "",

						"type" 		=> "text"

				);


  /*  
$of_options[] = array( 	"name" 		=> "Subscribe Form Background Color",

						"desc" 		=> "Recommended dimension for this image is 1349*347 px.",

						"id" 		=> "form_background_color",
 
						"std" 		=> "#363636",

						"type" 		=> "color"

					);
	
$of_options[] = array( "name" => "Enable Optin Form on Home Page", 

                    "id" => "enable_optin_home", 

                    "desc" => "", 

                    "std" => 1, 

                    "folds" => 1, 

                    "type" => "switch");     

                     

            
*/


$of_options[] = array( "name" => "Select your Autoresponder", 

                    "desc" => "", 

                    "id" => "autoresponder_type", 

                    "std" => "", 

                    "type" => "select", 

                    "options" => $autoresponder_list); 

                     

$of_options[] = array( "name" => "Or Use Copy Paste Autoresponder Code", 

                    "desc" => "", 

                    "id" => "copypaste", 

                    "std" => "<h3 style='margin: 0;''>Or Use Copy Paste Autoresponder Code</h3>", 

                    "icon" => true, 

                    "type" => "info");         

                     

$of_options[] = array( "name" => "Enable Copy Paste Settings", 

                    "id" => "enable_copyresponder", 

                    "desc" => "", 

                    "std" => 0, 

                    "folds" => 1, 

                    "type" => "switch"); 

                     

$of_options[] = array(     "name"         => "Paste Your Copy-Paste Code here", 

                        "desc"         => "", 

                        "id"         => "copypaste_autoresponder", 

                        "std"         => "", 

                        "type"         => "textarea" 

                         

                         

);   

				
					
/*.........................................................*/				
$of_options[] = array( 	"name" 		=> "Social and Copyrights",
						"type" 		=> "heading",
						"icon"		=> "fa fa-copyright"
				);

$of_options[] = array( 	"name" 		=> "Copyrights Information",
						"desc" 		=> "Enter your copyrights information",
						"id" 		=> "copyright",
						"std" 		=> "",
						"type" 		=> "text"
						
						
				);					
				

$of_options[] = array( 	"name" 		=> "Twitter link",
						"desc" 		=> "Entered link will redirect to your twitter account",
						"id" 		=> "twitter_link",
						"std" 		=> "",
						"type" 		=> "text"
						
						
				);					

$of_options[] = array( 	"name" 		=> "Facebook link",
						"desc" 		=> "Entered link will redirect to your Facebook account",
						"id" 		=> "facebook_link",
						"std" 		=> "",
						"type" 		=> "text"
						
						
				);		
				


				
$of_options[] = array( 	"name" 		=> "Pinterest",
						"desc" 		=> "Entered link will redirect to your Pinterest account",
						"id" 		=> "Pinterest",
						"std" 		=> "",
						"type" 		=> "text"
						
						
				);	

			

				
//Blog Options Starts Here				
$of_options[] = array( 	"name" 		=> "Blog Page Setting",
						"type" 		=> "heading",
						"icon"		=> "fa fa-rss"
				);	

			
$of_options[] = array( "name" => "Blog Listing Page",
					"desc" => "",
					"id" => "Bloglist",
					"std" => "<h3 style='margin: 0;''>Option For Blog Listing Page</h3>",
					"icon" => true,
					"type" => "info");
					

$of_options[] = array( 	"name" 		=> "Page Title",
						"desc" 		=> "",
						"id" 		=> "blog_head",
						"std" 		=> "All Articles",
						"type" 		=> "text"
						
						
				);
$of_options[] = array( 	"name" 		=> "Number of Blogs Per Page",
						"desc" 		=> "Insert any Numeric value here.Put '-1' to display all products",
						"id" 		=> "blog_count",
						"std" 		=> "12",
						"type" 		=> "text"
						
						
				);
$of_options[] = array( 	"name" 		=> "Number of Related Blogs post",
						//"desc" 		=> "Insert any Numeric value here.Put '-1' to display all products",
						"id" 		=> "blogpost_count",
						"std" 		=> "5",
						"type" 		=> "text"						
						
				);

$of_options[] = array( 	"name" 		=> "Match Keyword According to Post Title(%)",
						"desc" 		=> "Enter numeric valur in in between 1-100",
						"id" 		=> "product_count",
						"std" 		=> "20",
						"type" 		=> "text"
						
						
				);	
$of_options[] = array( "name" => "Enable Products Block on inner block page", 

                    "id" => "enable_products", 

                    "desc" => "", 

                    "std" => 1, 

                    "folds" => 1, 

                    "type" => "switch"); 				
$of_options[] = array( 	"name" 		=> "Heading for Products",
						"desc" 		=> "",
						"id" 		=> "head_products_inner",
						"std" 		=> "Products you may like",
						"type" 		=> "text"
						
						
				);		

						


				
$of_options[] = array( "name" => "Blog inner Page",
					"desc" => "",
					"id" => "Bloginner",
					"std" => "<h3 style='margin: 0;''>Option For Inner Blog Page</h3>",
					"icon" => true,
					"type" => "info");						
					
					
$of_options[] = array(    "name" 	=> "Default Blog Image",
						 "desc" 	=> "",
						 "id" 		=> "default_blog",
						 "std" 		=> "",
						 "type" 	=> "upload"
						 
					);
				

				
							
				
				
$of_options[] = array( 	"name" 		=> "Retargeting  Options",
						"type" 		=> "heading",
						"icon"		=> "fa fa-code"
				);					
$of_options[] = array( 	"name" 		=> "Tracking Code",
						"desc" 		=> "Put your Google Analytics (or FB) tracking code here. This will be added into the header template of your theme.",
						"id" 		=> "google_analytics",
						"std" 		=> "",
						"type" 		=> "textarea"
				);	
				
$of_options[] = array( 	"name" 		=> "Adsense Code",
						"desc" 		=> "Put your Adsense code here. This will be added into the header template of your theme.",
						"id" 		=> "google_addsense",
						"std" 		=> "",
						"type" 		=> "textarea"
				);	


$of_options[] = array( 	"name" 		=> "SEO  Options",
						"type" 		=> "heading",
						"icon"		=> "fa fa-user-plus"
				);				

				

				
$of_options[] = array( 	"name" 		=> "SEO For Meta Keyword",
						"desc" 		=> "SEO Meta Keywords",
						"id" 		=> "keyword_seo",
						"std" 		=> "",
						"type" 		=> "textarea"
				);
				
$of_options[] = array( 	"name" 		=> "SEO For Meta Description",
						"desc" 		=> "SEO Meta Description",
						"id" 		=> "description_seo",
						"std" 		=> "",
						"type" 		=> "textarea"
				);
				
$of_options[] = array( 	"name" 		=> "SEO Option HEAD Tag",
						"desc" 		=> "Usually Used To Enter Varification Code In Heading Tag",
						"id" 		=> "act_key",
						"std" 		=> "",
						"type" 		=> "textarea"
				);	
																									

//Styling Options
				
$of_options[] = array( 	"name" 		=> "Styling Options",
						"type" 		=> "heading",
						"icon"		=> "fa fa-paint-brush"
						
				);
		
/*				$of_options[] = array( 	"name" 		=> "Theme Second Background Color",
						"desc" 		=> "Pick a Second background color for the theme It includes Video/image top color and lead form submit button and top color, Read more button color and a Submit button color. (default: #f05135)",
						"id" 		=> "Second_Background",
						"std" 		=> "#f05135",
						"type" 		=> "color"
				);
							
*/
				
$of_options[] = array( 	"name" 		=> "Primary  Color",
						"desc" 		=> "Pick a background color for the theme ",
						"id" 		=> "primary_background",
						"std" 		=> "",
						"type" 		=> "color"
				);
				
$of_options[] = array( 	"name" 		=> "Theme Second Background Color",
						"desc" 		=> "Pick a Second background color for the theme ",
						"id" 		=> "Second_Background",
						"std" 		=> "",
						"type" 		=> "color"
				);
				
$of_options[] = array( 	"name" 		=> "Primary  Text Color",
						"desc" 		=> "Pick a Text color for the theme ",
						"id" 		=> "primary_text_color",
						"std" 		=> "",
						"type" 		=> "color"
				);				

$of_options[] = array( 	"name" 		=> "Secondary  Text Color",
						"desc" 		=> "Pick a Text color for the theme ",
						"id" 		=> "secondary_text_color",
						"std" 		=> "",
						"type" 		=> "color"
				);				

$of_options[] = array( 	"name" 		=> "Highlight  Text Color",
						"desc" 		=> "Pick a Text color for the theme ",
						"id" 		=> "highlight_text_color",
						"std" 		=> "#3b5998",
						"type" 		=> "color"
				);					

$of_options[] = array( 	"name" 		=> "Custom CSS",
						"desc" 		=> "You can put your custom CSS which will override existing one",
						"id" 		=> "custom_css",
						"std" 		=> "",
						"type" 		=> "textarea"
				);						


//Example Options For Typography 
			
$of_options[] = array( 	"name" 		=> "Typography Options",
						"type" 		=> "heading",
						"icon"		=> "fa fa-font"
				);

				
$of_options[] = array( "name" => "Google Fonts",
					"desc" => "",
					"id" => "google_fonts_intro",
					"std" => "<h3 style='margin: 0;''>Google Fonts</h3>",
					"icon" => true,
					"type" => "info");

					
$of_options[] = array( "name" => "Select H1 Font",
					"desc" => "Select a font family for H1",
					"id" => "hone",
					"std" => "latobold",
					"type" => "select",
					"options" => $google_fonts);	

$of_options[] = array( "name" => "Select H1 Font Size (px)",
					"desc" => "Select H1 Font Size (px) (Default is 13)",
					"id" => "honesize",
					"std" => "13",
					"type" => "select",
					"options" => $font_sizes);	
					
$of_options[] = array( "name" => "Select H1 Font weight",
					"desc" => "Default is 100",
					"id" => "honeweight",
					"std" => "100",
					"type" => "select",
					"options" => $font_weight);						

		
					

$of_options[] = array( "name" => "Select H2 Font",
					"desc" => "Select a font family for footer headings",
					"id" => "htwo",
					"std" => "latoregular",
					"type" => "select",
					"options" => $google_fonts);	

$of_options[] = array( "name" => "Select H2 Font Size (px)",
					"desc" => "Default is 13",
					"id" => "htwosize",
					"std" => "13",
					"type" => "select",
					"options" => $font_sizes);	

$of_options[] = array( "name" => "Select H2 Font weight",
					"desc" => "Default is 100",
					"id" => "htwoweight",
					"std" => "100",
					"type" => "select",
					"options" => $font_weight);		
					
	
				
				
$of_options[] = array( "name" => "Select H3 Font",
					"desc" => "Select a font family H3",
					"id" => "hthree",
					"std" => "latosemibold",
					"type" => "select",
					"options" => $google_fonts);	

$of_options[] = array( "name" => "Select H3 Font Size (px)",
					"desc" => "Default is 13",
					"id" => "hthreesize",
					"std" => "13",
					"type" => "select",
					"options" => $font_sizes);	

$of_options[] = array( "name" => "Select H3 Font weight",
					"desc" => "Default is 100",
					"id" => "hthreeweight",
					"std" => "100",
					"type" => "select",
					"options" => $font_weight);		

				
				
$of_options[] = array( "name" => "Select Paragraph Font",
					"desc" => "Select a font family for footer headings",
					"id" => "pfont",
					"std" => "lato",
					"type" => "select",
					"options" => $google_fonts);	

$of_options[] = array( "name" => "Select Paragraph Font Size (px)",
					"desc" => "Default is 13",
					"id" => "psize",
					"std" => "14",
					"type" => "select",
					"options" => $font_sizes);

$of_options[] = array( "name" => "Select Paragraph Font weight",
					"desc" => "Default is 100",
					"id" => "pweight",
					"std" => "100",
					"type" => "select",
					"options" => $font_weight);							
						

$of_options[] = array( "name" => "Select form Menu Font",
					"desc" => "Select a font family for form labels",
					"id" => "menufont",
					"std" => "Bitter",
					"type" => "select",
					"options" => $google_fonts);			
$of_options[] = array( "name" => "Select Form label Font Size (px)",
					"desc" => "Default is 12",
					"id" => "labelfontsize",
					"std" => "12",
					"type" => "select",
					"options" => $font_sizes);	
					
$of_options[] = array( "name" => "Select Form label Font weight",
					"desc" => "Default is initial",
					"id" => "labelweight",
					"std" => "initial",
					"type" => "select",
					"options" => $font_weight);							
					
								
				
// Backup Options
$of_options[] = array( 	"name" 		=> "Backup Options",
						"type" 		=> "heading",
						"icon"		=> ADMIN_IMAGES . "datarec.png"
				);
				
$of_options[] = array( 	"name" 		=> "Backup and Restore Options",
						"id" 		=> "of_backup",
						"std" 		=> "",
						"type" 		=> "backup",
						"desc" 		=> 'You can use the two buttons below to backup your current options, and then restore it back at a later time. This is useful if you want to experiment on the options but would like to keep the old settings in case you need it back.',
				);
				
$of_options[] = array( 	"name" 		=> "Transfer Theme Options Data",
						"id" 		=> "of_transfer",
						"std" 		=> "",
						"type" 		=> "transfer",
						"desc" 		=> 'You can tranfer the saved options data between different installs by copying the text inside the text box. To import data from another install, replace the data in the text box with the one from another install and click "Import Options".',
				);
				
	}//End function: of_options()
}//End chack if function exists: of_options()
?>
