<?php
/**
 * @package themify
 * @since 1.1.1.0
 * 
 * ----------------------------------------------------------------------
 * 					DO NOT EDIT THIS FILE
 * ----------------------------------------------------------------------
 * 				Class to interact with TinyMCE editor. 
 *  			http://themify.me
 *  			Copyright (C) Themify
 *
 ***************************************************************************/

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Themify_TinyMCE {
	
	function __construct(){
		if ( current_user_can( 'publish_posts' ) && get_user_option( 'rich_editing' ) == 'true' ) {
			add_filter( 'mce_external_plugins', array( $this, 'add_plugin' ) );
			add_filter( 'mce_buttons', array( $this, 'add_button' ) );
		}
	}

	/**
	 * Add button to WP Editor.
	 *
	 * @param array $mce_buttons
	 * @return mixed
	 */
	function add_button( $mce_buttons ) {
		array_push( $mce_buttons, 'separator', 'btnthemifyMenu' );
		return $mce_buttons;
	}

	/**
	 * Add plugin JS file to list of external plugins.
	 *
	 * @param array $mce_external_plugins
	 * @return mixed
	 */
	function add_plugin( $mce_external_plugins ) {
		global $wp_version;
		if ( false !== stripos( $wp_version, '3.9' ) ) {
			$mce_external_plugins['themifyMenu'] = THEMIFY_URI . '/tinymce/plugin.js';
		} else {
			$mce_external_plugins['themifyMenu'] = THEMIFY_URI . '/tinymce/tinymce.menu.js';
		}
		return $mce_external_plugins;
	}
}

/**
 * Initialize class to add button to WP Editor.
 */
function themify_init_tinymce() {
	new Themify_TinyMCE();
}
add_action( 'init', 'themify_init_tinymce' );