<?php
/***************************************************************************
 *
 * 	----------------------------------------------------------------------
 * 						DO NOT EDIT THIS FILE
 *	----------------------------------------------------------------------
 * 
 *  				     Copyright (C) Themify
 * 
 *	----------------------------------------------------------------------
 *
 ***************************************************************************/

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Theme and Themify Framework Path and URI
 * @since 1.2.2
 */
define( 'THEME_DIR', get_template_directory() );
define( 'THEME_URI', get_template_directory_uri() );
define( 'THEMIFY_DIR', THEME_DIR . '/themify' );
define( 'THEMIFY_URI', THEME_URI . '/themify' );
define( 'THEMIFYMIN', defined('SCRIPT_DEBUG') && SCRIPT_DEBUG ? '' : '.min' );
	
	///////////////////////////////////////////
	// Create Nav Options
	///////////////////////////////////////////
	function themify_admin_nav() {
		$theme = wp_get_theme();
		add_menu_page('themify', $theme->display('Name'), 'manage_options', 'themify', 'themify_page', get_template_directory_uri().'/themify/img/favicon.png', 50);
		add_submenu_page('themify', $theme->display('Name'), __('Settings', 'themify'), 'manage_options', 'themify', 'themify_page');
		add_submenu_page('themify', $theme->display('Name'), __('Documentation', 'themify'), 'manage_options', 'themify_docs', 'themify_docs');
	}

/*  Pages
/***************************************************************************/	
	
	///////////////////////////////////////////
	// Themify Documentation
	///////////////////////////////////////////
	function themify_docs(){
		echo "<script type='text/javascript'>window.location='http://themify.me/docs';</script>";
	}
	
	///////////////////////////////////////////
	// Themify Page
	///////////////////////////////////////////
	function themify_page() {
		
		if ( ! current_user_can( 'manage_options' ) )
			wp_die( __( 'You do not have sufficient permissions to update this site.', 'themify' ) );
		
		if (isset($_GET['action'])) {
			$action = 'upgrade';
			themify_updater();
		}
		
		global $themify_config;

		// check theme information
		$theme = wp_get_theme();
		$check_theme_name = ( is_child_theme() ) ? $theme->parent()->Name : $theme->display('Name');
		$check_theme_version = ( is_child_theme() ) ? $theme->parent()->Version : $theme->display('Version');

		?>
        <!-- alerts -->
        <div class="alert"></div> 
        <!-- /alerts -->
        
        <!-- prompts -->
        <div class="prompt-box">
            <div class="show-login">
            	<form id="themify_update_form" method="post" action="admin.php?page=themify&action=upgrade&type=theme&login=true">
            	<p class="prompt-msg"><?php _e('Enter your Themify login info to upgrade', 'themify'); ?></p>
	            <p><label><?php _e('Username', 'themify'); ?></label> <input type="text" name="username" class="username" value=""/></p>
	            <p><label><?php _e('Password', 'themify'); ?></label> <input type="password" name="password" class="password" value=""/></p>
	            <input type="hidden" value="theme" name="type" />
	            <input type="hidden" value="true" name="login" />
	            <p class="pushlabel"><input name="login" type="submit" value="Login" class="button upgrade-login" /></p>
	            </form>
            </div>
            <div class="show-error">
            	<p class="error-msg"><?php _e('There were some errors updating the theme', 'themify'); ?></p>
            </div>
        </div>
        <div class="overlay">&nbsp;</div>
        <!-- /prompts -->
        
        <!-- html -->
        <form id="themify" method="post" action="" enctype="multipart/form-data">
        <p id="theme-title"><?php echo $check_theme_name; ?> <em><?php echo $check_theme_version; ?> (<a href="http://themify.me/logs/<?php echo '' != $theme->display('Template')? $theme->display('Template') : strtolower($check_theme_name); ?>-changelogs" class="themify_changelogs" target="_blank"><?php _e('changelogs', 'themify'); ?></a>)</em></p>
		<p class="top-save-btn"><a href="#" id="save-button" class="save-button"><?php _e('Save All', 'themify'); ?></a></em></p>
		<div id="content">
        
            <!-- nav -->
            <ul id="maintabnav">
                <li class="setting"><a href="#setting"><?php _e( 'Settings', 'themify' ); ?></a></li>
                <li class="styling"><a href="#styling"><?php _e( 'Styling', 'themify' ); ?></a></li>
                <li class="skins"><a href="#skins"><?php _e( 'Skins', 'themify' ); ?></a></li>
                <li class="transfer"><a href="#transfer"><?php _e( 'Import', 'themify' ); ?></a></li>
            </ul>
            <!-- /nav -->
    		
            <!------------------------------------------------------------------------------------>
            
            <!--setting tab -->
            <div id="setting" class="maintab">
                
                <ul class="subtabnav">
                    <?php 
                    $x = 1;
                    foreach($themify_config['panel']['settings']['tab'] as $tab){
                        if($x){
                            echo '<li class="selected"><a href="#setting-'.themify_scrub_func($tab['id']).'">'.$tab['title'].'</a></li>';
                            $x = 0;
                        } else {
                        	if ( isset( $tab['id'] ) ) {
                        		echo '<li><a href="#setting-'.themify_scrub_func($tab['id']).'">'.$tab['title'].'</a></li>';
                        	}
                        }
                    } 
                    ?>
                </ul>
                
                 <?php foreach($themify_config['panel']['settings']['tab'] as $tab){ ?>
                    <!-- subtab: setting-<?php echo themify_scrub_func($tab['id']); ?> -->
                    <div id="setting-<?php echo themify_scrub_func($tab['id']); ?>" class="subtab">
                        <?php 
						if(is_array($tab['custom-module'])){
							if(isset($tab['custom-module']['title']) && isset($tab['custom-module']['function'])){
								echo themify_fieldset($tab['custom-module']['title'], themify_scrub_func($tab['custom-module']['function']), $tab['custom-module']); 
							} else {
								foreach($tab['custom-module'] as $module){
									echo themify_fieldset($module['title'], themify_scrub_func($module['function']),$module); 
								}
							}
						}
                        ?>
                    </div>
                    <!-- /subtab: setting-<?php echo themify_scrub_func($tab['id']); ?> -->
                <?php } ?>
            
            </div>
            <!--/setting tab -->
            
            <!------------------------------------------------------------------------------------>
            
            <!--styling tab -->
            <div id="styling" class="maintab">
            
                <ul class="subtabnav">
                    <?php 
                    $x = 1;
					if(isset($themify_config['panel']['styling']['tab']['title'])){
						echo '<li class="selected"><a href="#styling-'.themify_scrub_func($themify_config['panel']['styling']['tab']['title']).'">'.$themify_config['panel']['styling']['tab']['title'].'</a></li>';
					} else {
						foreach($themify_config['panel']['styling']['tab'] as $tab){
							if($x){
								echo '<li class="selected"><a href="#styling-'.themify_scrub_func($tab['id']).'">'.$tab['title'].'</a></li>';
								$x = 0;
							} else {
								echo '<li><a href="#styling-'.themify_scrub_func($tab['id']).'">'.$tab['title'].'</a></li>';
							}
						}
					}
					?>
                </ul>
                
                <?php 
				if(isset($themify_config['panel']['styling']['tab']['title'])){
				?>
					<!-- subtab: styling-<?php echo themify_scrub_func($themify_config['panel']['styling']['tab']['_a']['title']); ?> -->
						<div id="styling-<?php echo themify_scrub_func($themify_config['panel']['styling']['tab']['title']); ?>" class="subtab">
							<?php 
							if(is_array($themify_config['panel']['styling']['tab']['element'])){
								if(isset($themify_config['panel']['styling']['tab']['element']['title']) && isset($themify_config['panel']['styling']['tab']['element']['selector'])){
									echo themify_container(themify_scrub_func($tab['id']), $themify_config['panel']['styling']['tab']['element']);
								} else {
									foreach($themify_config['panel']['styling']['tab']['element'] as $element){
										echo themify_container(themify_scrub_func($themify_config['panel']['styling']['tab']['title']), $element);
									}
								}
							}
							?>
						</div>
						<!-- /subtab: styling-<?php echo themify_scrub_func($tab['_a']['title']); ?> -->
				<?php 
				} else {
					foreach($themify_config['panel']['styling']['tab'] as $tab){ ?>
						<!-- subtab: styling-<?php echo themify_scrub_func($tab['id']); ?> -->
						<div id="styling-<?php echo themify_scrub_func($tab['id']); ?>" class="subtab">
							<?php 
							if(is_array($tab['element'])){
								if(isset($tab['element']['title']) && isset($tab['element']['selector'])){
									echo themify_container(themify_scrub_func($tab['id']), $tab['element']); 
								} else {
									foreach($tab['element'] as $element){
										echo themify_container(themify_scrub_func($tab['id']), $element); 
									}
								}
							}
							?>
						</div>
						<!-- /subtab: styling-<?php echo themify_scrub_func($tab['id']); ?> -->
					<?php } 
				} 
				?>
                
            </div>
            <!--/styling tab -->
    
    		<!------------------------------------------------------------------------------------>
            
            <!--skins tab -->
            <div id="skins" class="maintab">
                <ul class="subtabnav">
                    <li class="selected"><a href="#setting-general"><?php _e('Skins', 'themify'); ?></a></li>
                </ul>
               
                <div id="load-load" class="subtab">
                    <?php echo themify_get_skins(); ?>
                </div>
                
            </div>
            <!--/skins tab -->
    		
            <!------------------------------------------------------------------------------------>
            
            <!--import tab -->
            <div id="transfer" class="maintab">
                <ul class="subtabnav">
                    <li><a href="#transfer-import"><?php _e( 'Theme Settings', 'themify' ); ?></a></li>
                    <li><a href="#demo-import"><?php _e( 'Demo Import', 'themify' ); ?></a></li>
                </ul>

                <div id="transfer-import" class="subtab">
                    <div class="biggest-transfer-btn">
                    <input type="hidden" id="import" />
                     <?php themify_uploader( 'import', array(
                     			'label' => __('Import', 'themify'),
                     			'confirm' => __('Import will overwrite all settings and configurations. Press OK to continue, Cancel to stop.', 'themify') )
							); ?> 
                     
                    <em><?php _e('or', 'themify'); ?></em>
                    <?php
	            	/**
					 * URL of Themify Settings Page properly nonced.
					 * @var String
					 */
	            	$baseurl = wp_nonce_url(admin_url('admin.php?page=themify'), 'themify_export_nonce');
	            	?>
                    <a href="<?php echo $baseurl ?>&amp;export=themify" class="export" id="download-export"><?php _e('Export', 'themify'); ?></a>
                	</div>
                </div>
                <div id="demo-import" class="subtab">
					<p>
					<a href="#" class="button import-sample-content" data-default="<?php _e( 'Import Demo', 'themify' ); ?>" data-success="<?php _e( 'Done', 'themify' ); ?>" data-importing="<?php _e( 'Importing', 'themify' ) ?>"> <i class="fa fa-arrow-down"></i> <span><?php _e( 'Import Demo', 'themify' ); ?></span> </a>
					</p>
					<p><?php _e( 'Import Demo will import the content (posts/pages), Themify panel settings, menus and widgets as our demo. Due to copyright reasons, demo images will be replaced with a placeholder image.', 'themify' ); ?></p>
					<p>&nbsp;  </p>
					<p>
					<a href="#" class="button erase-sample-content" data-default="<?php _e( 'Erase Demo', 'themify' ); ?>" data-erasing="<?php _e( 'Erasing', 'themify' ); ?>" data-success="<?php _e( 'Done', 'themify' ); ?>"> <i class="fa fa-times"></i> <span><?php _e( 'Erase Demo', 'themify' ); ?></span> </a>
					</p>
					<p><?php _e( 'Erase demo will delete the imported posts/pages. Existing and modified imported post/page will not be deleted. Themify panel settings and widgets will not be removed. You may import the content again later.', 'themify' ); ?></p>
				</div>

            </div>
            <!--/import tab -->
            
            <!------------------------------------------------------------------------------------>
    
        </div>
        <!--/content -->

		<?php if( get_option( get_template() . '_themify_import_notice', 1 ) ) : ?>
			<div id="demo-import-notice">
				<h3><?php _e( 'Import Demo', 'themify' ); ?></h3>
				<p><?php _e( 'Would you like to import the demo content to have the exact look as our demo?', 'themify' ); ?></p>
				<p><?php _e( 'You may import or erase demo content later at the Import tab of the Themify panel.', 'themify' ); ?></p>
				<a href="#" class="button import-sample-content" data-default="<?php _e( 'Import Demo', 'themify' ); ?>" data-success="<?php _e( 'Done', 'themify' ); ?>" data-importing="<?php _e( 'Importing', 'themify' ) ?>"> <i class="fa fa-arrow-down"></i> <span><?php _e( 'Yes, import', 'themify' ); ?></span> </a>
				<a href="#" class="thanks-button dismiss-import-notice"> <?php _e( 'No, thanks', 'themify' ); ?> </a>
				<a href="#" class="close dismiss-import-notice"><i class="fa fa-times"></i></a>
			</div>
		<?php endif; ?>

        <!-- footer -->
        <div id="bottomtab">
           <p id="logo"><span>Themify</span> <a href="http://themify.me/logs/framework-changelogs/" target="_blank" class="themify_changelogs">v<?php echo THEMIFY_VERSION; ?></a></p>
            <p class="reset">
                <strong><?php _e('Reset:', 'themify'); ?></strong> 
                <a href="#" id="reset-setting" class="reset-button"><?php _e('Settings', 'themify'); ?></a><a href="#" id="reset-styling" class="reset-button"><?php _e('Styling', 'themify'); ?></a>
            </p>
            <p class="btm-save-btn">
            	<a href="#" class="save-button"><?php _e('Save All', 'themify'); ?></a>
       		</p>
        </div>
        <!--/footer -->
        
   		</form>
    	<div class="clearBoth"></div>
        <!-- /html -->
        
		<?php
		do_action('themify_settings_panel_end'); 
	}
	
	
/*  Utilities
/***************************************************************************/

	///////////////////////////////////////////
	// Get Skins
	///////////////////////////////////////////
	function themify_get_skins(){
		global $db, $themify_config;
		$data = themify_get_data();
		$output = '<input type="hidden" name="skin" value="'.themify_get( 'skin' ).'">';
		if( ! isset( $data['skin'] ) || $data['skin'] == '' ) {
			$output .= '<div class="skin-preview"><a href="#"><img src="'.get_template_directory_uri().'/themify/img/non-skin.gif" alt="skin" id="" class="selected" /></a><br />' . __('No Skin', 'themify') . '</div>';
		} else {
			$output .= '<div class="skin-preview"><a href="#"><img src="'.get_template_directory_uri().'/themify/img/non-skin.gif" alt="skin" id="" /></a><br />' . __('No Skin', 'themify') . '</div>';
		}
		// Open Styles Folder
		$dir = dirname(__FILE__).'/../skins';
		if(is_dir($dir)){
			if($handle = opendir($dir)){
				// Grab Folders
				while (false !== ($dirTwo = readdir($handle))){
					if($dirTwo != '.' && $dirTwo != '..'){
						// Check For Folder
						if(is_dir(str_replace('//','/',dirname(__FILE__).'/').'../skins/'.$dirTwo)){
							// Open Folders
							if($handleTwo = opendir(str_replace('//','/',dirname(__FILE__).'/').'../skins/'.$dirTwo)){
								// Grab Files
								while(false !== ($file = readdir($handleTwo))){
									$ext = substr(strrchr($file, '.'), 1); // File Extension
									//echo $file;
									if($file == 'style.css'){
										$info = themify_get_skin_info(str_replace('//','/',dirname(__FILE__).'/').'../skins/'.$dirTwo.'/'.$file);
										$fullpath = get_template_directory_uri().'/skins/'.$dirTwo.'/'.$file;
										if(is_file(str_replace('//','/',dirname(__FILE__).'/').'../skins/'.$dirTwo.'/screenshot.png')){
											$image = get_template_directory_uri().'/skins/'.$dirTwo.'/screenshot.png';
										} else {
											$image = get_template_directory_uri().'/themify/img/screenshot-na.png';	
										}
										if ( $fullpath == themify_get( 'skin' ) ) {
											$output .= '<div class="skin-preview"><a href="#"><img src="'.$image.'" alt="skin" class="selected" id="'.get_template_directory_uri().'/skins/'.$dirTwo.'/style.css" /></a><br />'.$info['Skin Name'].'</div>';
										} else {
											$output .= '<div class="skin-preview"><a href="#"><img src="'.$image.'" alt="skin" id="'.get_template_directory_uri().'/skins/'.$dirTwo.'/style.css" /></a><br />'.$info['Skin Name'].'</div>';
										}
									}
								}
								closedir($handleTwo);
							}
						}
					}
				}		
				closedir($handle);
			} 
		}
		return $output;
	}
	
	///////////////////////////////////////////
	// Get CSS
	///////////////////////////////////////////
	function themify_get_css() {
		$data = themify_get_data();
		$output = '';
		/**
		 * Stores CSS rules
		 * @var string
		 */
		$module_styling = '';
		if( is_array( $data ) ) {
			foreach( $data as $name => $value ) {
				$array = explode( '-', $name );
				$path = '';
				foreach($array as $part){
					$path .= "['$part']";
				}
				eval("\$themify_config".$path." = \$value;");
			}
			if( isset( $themify_config['styling'] ) && is_array( $themify_config['styling'] ) ) {
				foreach( $themify_config['styling'] as $nav => $value ) {
					foreach( $value as $element => $val ) {
						$temp = '';
						foreach( $val as $attribute => $v ) {
							$attribute = str_replace("_", "-", $attribute);
							if( isset( $v['value'] ) && $v['value'] != '' ) {
								switch( $attribute ) {
									case "border":
										foreach( $v['value'] as $key => $val ) {
											if( '' == $val ) {
												if( strpos( $key, 'style' ) === false ) {
													if ( strpos( $key, 'color' ) === false ) {
														$v['value'][$key] = 0;
													} else {
														$v['value'][$key] = '000000';
													}	
												} else {
													$v['value'][$key] = 'solid';
												}
											}
										}
										if( isset( $v['value']['checkbox'] ) && $v['value']['checkbox'] ) {
											$temp .= "border: ".$v['value']['same']."px ".$v['value']['same_style']." #".$v['value']['same_color'].";\n";
										} else {
											if($v['value']['top'] != '' && $v['value']['top_style'] != '' && $v['value']['top_color'] != ''){
												$temp .= "border-top: ".$v['value']['top']."px ".$v['value']['top_style']." #".$v['value']['top_color'].";\n";
											}
											if($v['value']['right'] != '' && $v['value']['right_style'] != '' && $v['value']['right_color'] != ''){
												$temp .= "border-right: ".$v['value']['right']."px ".$v['value']['right_style']." #".$v['value']['right_color'].";\n";
											}
											if($v['value']['bottom'] != '' && $v['value']['bottom_style'] != '' && $v['value']['bottom_color'] != ''){
											
												$temp .= "border-bottom: ".$v['value']['bottom']."px ".$v['value']['bottom_style']." #".$v['value']['bottom_color'].";\n";
											}
											if($v['value']['left'] != '' && $v['value']['left_style'] != '' && $v['value']['left_color'] != ''){
												$temp .= "border-left: ".$v['value']['left']."px ".$v['value']['left_style']." #".$v['value']['left_color'].";\n";
											}
										}
									break;
									case "background-position":
										if($v['value']['x'] != '' && $v['value']['y']){
											foreach($v['value'] as $key => $val){
												if($val == ''){
													$v['value'][$key] = 0;
												}
											}
											$temp .= $attribute.": ";
											$temp .= $v['value']['x']." ".$v['value']['y'].";\n";
										}
									break;
									case "padding":
										if( isset( $v['value']['checkbox'] ) && $v['value']['checkbox'] ) {
											$temp .= $attribute.": ";
											$temp .= $v['value']['same']."px".";\n";		
										} else {
											if($v['value']['top'] != '' || $v['value']['right'] != '' || $v['value']['bottom'] != '' || $v['value']['left'] != ''){
												if($v['value']['top'] != ''){
													$temp .= "padding-top: ".$v['value']['top']."px;\n";
												}
												if($v['value']['right'] != ''){
													$temp .= "padding-right: ".$v['value']['right']."px;\n";
												}
												if($v['value']['bottom'] != ''){
													$temp .= "padding-bottom: ".$v['value']['bottom']."px;\n";
												}
												if($v['value']['left'] != ''){
													$temp .= "padding-left: ".$v['value']['left']."px;\n";
												}
											}
										}
									break;
									case "margin":
										if( isset( $v['value']['checkbox'] ) && $v['value']['checkbox'] ) {
											$temp .= $attribute.": ";
											$temp .= $v['value']['same']."px".";\n";		
										} else {
											if($v['value']['top'] != '' || $v['value']['right'] != '' || $v['value']['bottom'] != '' || $v['value']['left'] != ''){
												if($v['value']['top'] != ''){
													$temp .= "margin-top: ".$v['value']['top']."px;\n";
												}
												if($v['value']['right'] != ''){
													$temp .= "margin-right: ".$v['value']['right']."px;\n";
												}
												if($v['value']['bottom'] != ''){
													$temp .= "margin-bottom: ".$v['value']['bottom']."px;\n";
												}
												if($v['value']['left'] != ''){
													$temp .= "margin-left: ".$v['value']['left']."px;\n";
												}
											}
										}
									break;
									case "color":
										if($v['value']['value'] != '' && $v['value']['value'] != ' '){
											$temp .= $attribute.": ";
											$temp .= "#".$v['value']['value'].";\n";
										}
									break;
									case "background-color":
										if( isset( $v['value']['transparent'] ) && $v['value']['transparent'] ) {
											$temp .= $attribute.": transparent;\n";											
										} else {
											if($v['value']['value'] != '' && $v['value']['value'] != ' '){
												$temp .= $attribute.": ";
												$temp .= "#".$v['value']['value'].";\n";
											}
										}
									break;
									case "background-image":
										if($v['value']['value'] != '' && $v['value']['value'] != ' '){
											$temp .= $attribute.": ";
											$temp .= "url(".$v['value']['value'].")".";\n";
										} elseif( isset( $v['value']['none'] ) && 'on' == $v['value']['none'] ) {
											$temp .= $attribute.": ";
											$temp .= "none;\n";
										}
									break;
									case "background-repeat":
										if($v['value']['value'] != '' && $v['value']['value'] != ' '){
											$temp .= $attribute.": ";
											$temp .= $v['value']['value'].";\n";
										}
									break;
									case "font-family":
										if($v['value']['value'] != '' && $v['value']['value'] != ' '){
											$temp .= $attribute.": ";

											// check google fonts
											if ( themify_is_google_fonts( $v['value']['value'] ) ) {
												$temp .= '"' . $v['value']['value'] . '"' .";\n";
											} else {
												$temp .= $v['value']['value'] .";\n";
											}
										}
									break;
									case "line-height":
										if($v['value']['value'] != '' && $v['value']['value'] != ' '){
											$temp .= $attribute.": ";
											$temp .= $v['value']['value'].$v['value']['unit'].";\n";
										}
									break;
									case "position":
										if($v['value']['value'] != '' && $v['value']['value'] != ' '){
											$temp .= $attribute.": ";
											$temp .= $v['value']['value'].";\n";
											if($v['value']['value'] == 'absolute' || $v['value']['value'] == 'fixed'){
												if($v['value']['x_value'] != '' && $v['value']['x_value'] != ' '){
													$temp .= $v['value']['x'].": ".$v['value']['x_value']."px;\n";
												}
												if($v['value']['y_value'] != '' && $v['value']['y_value'] != ' '){
													$temp .= $v['value']['y'].": ".$v['value']['y_value']."px;\n";
												}
											}
										}
									break;
									default:
										if($v['value']['value'] != '' && $v['value']['value'] != ' '){
											$temp .= $attribute.": ";
											$temp .= $v['value']['value'];
											if(isset($v['value']['unit'])){
												$temp .= $v['value']['unit'];
											}
											$temp .= ";\n";
										}
									break;
								}
							}
						}	
						if($temp != '' && $temp != ' '){

							$style_selector = themify_get_styling_selector('id', $element, $nav, true);
							if ( $style_selector != '' ) {
								$module_styling .= $style_selector." {\n";
								$module_styling .= $temp;
								$module_styling .= "}\n\n";
							}
						}
					}
				}
			}
		} else {
			$output = '<style type="text/css">/* ' . __('No Values in the Database', 'themify') . ' */</style>';
		}
		$module_styling_before = "<!-- modules styling -->\n<style type='text/css'>\n";
		$module_styling_after = "</style>";
		if( '' != $module_styling ){
			$output .= $module_styling_before . $module_styling . $module_styling_after;
		}
		echo "\n\n".$output;
	}
	
	///////////////////////////////////////////
	// Get Skin Info
	///////////////////////////////////////////
	function themify_get_skin_info($file){
		$fh = fopen($file, 'r');
		$data = fread($fh, filesize($file));
		$tempArray = explode("\n",themify_strip("/*", "*/", $data, 0));
		$array = array();
		foreach($tempArray as $line){
			$tempLine = explode(":", $line);
			if ( isset( $tempLine[1] ) )
				$array[$tempLine[0]] = $tempLine[1];
		}
		fclose($fh);
		return $array;
	}
	
	///////////////////////////////////////////
	// Strip
	///////////////////////////////////////////
	function themify_strip($startTag, $endTag, $text, $pos){
		if(!is_integer($pos)){
			$pos = false;
			return false;
		}	
		$pos1 = strpos($text,$startTag,$pos);
		if(!is_integer($pos1)){
			$pos = false;
			return false;
		}
		$pos1 += strlen($startTag);
		$pos2 = strpos($text,$endTag,$pos1);
		if(!is_integer($pos2)){
			$pos = false;return false;
		}
		$res = substr($text,$pos1,$pos2-$pos1);
		$pos = $pos2 + strlen($endTag);
		return $res;
	} 
	
	///////////////////////////////////////////
	// Scrub Function
	///////////////////////////////////////////
	function themify_scrub_func($string=""){
		return str_replace(array(' ', '/', ','), array('_', '_', '-'), strtolower($string));
	}
	
	///////////////////////////////////////////
	// Scrub
	///////////////////////////////////////////
	function themify_scrub($string=""){
		return str_replace(array('#','-',' ','.',':',',','[',']','=','<','>'), array('_id_','_dash_','_space_','_class_','_colon_','_comma_','_opensquare_','_closesquare_','_equal_','_openbracket_','_closebracket_'), $string);
	}
	
	///////////////////////////////////////////
	// Scrub Decode
	///////////////////////////////////////////
	function themify_scrub_decode( $string = '' ) {
		return str_replace(array('_id_','_dash_','_space_','_class_','_colon_','_comma_','_opensquare_','_closesquare_','_equal_','_openbracket_','_closebracket_'), array('#','-',' ','.',':',',','[',']','=','<','>'), $string);
	}
	
	///////////////////////////////////////////
	// Create Settings Fieldset
	///////////////////////////////////////////
	function themify_fieldset( $title = '', $module = '', $attr = '' ) {
		$data = themify_get_data();
		$module = trim( $module );
		$data_param = isset( $data['setting'] ) && isset( $data['setting'][$title] )? $data['setting'][$title] : '';
		
		if ( function_exists( 'themify_' . $module ) ) {
			$function = 'themify_' . $module;
		} else if ( function_exists( $module ) ) {
			$function = $module;
		}
		
		$output = '<fieldset><legend>'.$title.'</legend>';
		$output .= call_user_func( $function, array(
			'data' => $data_param,
			'attr' => $attr )
		);
		$output .= '</fieldset>';
		return $output;
	}
	
	///////////////////////////////////////////
	// Create Styles Container
	///////////////////////////////////////////
	function themify_container( $category = '', $element = array() ) {
		$data = themify_get_data();
		$temp = array();
		if(is_array($data)){
			foreach($data as $name => $value){
				$array = explode('-',$name);
				$path = "";
				foreach($array as $part){
					$path .= "['$part']";
				}
				eval("\$temp".$path." = \$value;");
			}
		}
		if($element){
			$base_id = $element['id'];
			$output = '	<fieldset><legend>'.$element['title'].'</legend>';
			if(is_array($element['module'])){
				foreach($element['module'] as $module){
					if( themify_is_associative_array($module) ) {
						$module_name = $module['name'];
					} else {
						$module_name = $module;
					}

					$title = $element['id'];
					$attr = $module;
					$module = trim(str_replace(array(' ','-','|'),array('','_','hr'),$module_name));
					$value = isset( $temp['styling'][$category][$title][$module] )? $temp['styling'][$category][$title][$module] : '';
					if(function_exists("themify_".$module)){
						$output .=	call_user_func("themify_".$module, array('category' => $category, 'title' => $title, 'value' => $value, 'attr' => $attr, 'id' => $base_id));
					} else {
						if(function_exists($module)){
							$output .=	call_user_func($module, array('category' => $category, 'title' => $title, 'value' => $value, 'attr' => $attr, 'id' => $base_id));
						}
					}
				}
			}
			$output .= '</fieldset>';	
			return $output;
		}
	}

	/**
	 * Enqueues the chosen skin, if there was one selected and custom_style.css if it exists
	 * @since 1.7.4
	 */
	function themify_enqueue_framework_assets() {
		// Skin stylesheet
		if ( $skin = themify_get( 'skin' ) ) {
			wp_enqueue_style( 'themify-skin', themify_https_esc( $skin ), array( 'theme-style' ) );
		}

		// User stylesheet
		if ( is_file( get_template_directory() . '/custom_style.css' ) ) {
			wp_enqueue_style( 'custom-style', THEME_URI . '/custom_style.css', array( 'theme-style' ) );
		}

		// Enqueue font icon stylesheet
		wp_enqueue_style( 'themify-icon-font', THEMIFY_URI . '/fontawesome/css/font-awesome.min.css', array(), THEMIFY_VERSION );
	}

	/**
	 * Outputs the module styling and then the Custom CSS module content.
	 * @since 1.7.4
	 */
	function themify_output_framework_styling() {
		// Module Styling
		themify_get_css();

		// Custom CSS
		if ( $custom_css = themify_get( 'setting-custom_css' ) ) {
			echo "\n\n<!-- custom css -->\n\n<style type='text/css'>$custom_css</style>";
		}
	}

	
	/**
	 * XML 2 Array Function
	 * @param $string
	 */
	function themify_xml2array( &$string ) {
		$parser = xml_parser_create();
		xml_parser_set_option($parser, XML_OPTION_CASE_FOLDING, 0);
		xml_parse_into_struct($parser, $string, $vals, $index);
		xml_parser_free($parser);
		$mnary=array();
		$ary=&$mnary;
		foreach ($vals as $r) {
			$t=$r['tag'];
			if ($r['type']=='open') {
				if (isset($ary[$t])) {
					if (isset($ary[$t][0])) $ary[$t][]=array(); else $ary[$t]=array($ary[$t], array());
					$cv=&$ary[$t][count($ary[$t])-1];
				} else $cv=&$ary[$t];
				if (isset($r['attributes'])) {foreach ($r['attributes'] as $k=>$v) $cv['_a'][$k]=$v;}
				$cv['_c']=array();
				$cv['_c']['_p']=&$ary;
				$ary=&$cv['_c'];
			} elseif ($r['type']=='complete') {
				if (isset($ary[$t])) { // same as open
					if (isset($ary[$t][0])) $ary[$t][]=array(); else $ary[$t]=array($ary[$t], array());
					$cv=&$ary[$t][count($ary[$t])-1];
				} else $cv=&$ary[$t];
				if (isset($r['attributes'])) {foreach ($r['attributes'] as $k=>$v) $cv['_a'][$k]=$v;}
				$cv['_v']=(isset($r['value']) ? $r['value'] : '');
	
			} elseif ($r['type']=='close') {
				$ary=&$ary['_p'];
			}
		}    
		_themify_del_p($mnary);
		return $mnary;
	}
	
	///////////////////////////////////////////
	// _Internal: Remove recursion in result array
	///////////////////////////////////////////
	function _themify_del_p(&$ary) {
		foreach ($ary as $k=>$v) {
			if ($k==='_p') unset($ary[$k]);
			elseif (is_array($ary[$k])) _themify_del_p($ary[$k]);
		}
	}
	
	///////////////////////////////////////////
	// Array to XML
	///////////////////////////////////////////
	function themify_ary2xml($cary, $d=0, $forcetag='') {
		$res=array();
		foreach ($cary as $tag=>$r) {
			if (isset($r[0])) {
				$res[]=themify_ary2xml($r, $d, $tag);
			} else {
				if ($forcetag) $tag=$forcetag;
				$sp=str_repeat("\t", $d);
				$res[]="$sp<$tag";
				if (isset($r['_a'])) {foreach ($r['_a'] as $at=>$av) $res[]=" $at=\"$av\"";}
				$res[]=">".((isset($r['_c'])) ? "\n" : '');
				if (isset($r['_c'])) $res[]=themify_ary2xml($r['_c'], $d+1);
				elseif (isset($r['_v'])) $res[]=$r['_v'];
				$res[]=(isset($r['_c']) ? $sp : '')."</$tag>\n";
			}
			
		}
		return implode('', $res);
	}
	
	///////////////////////////////////////////
	// Insert element into array
	///////////////////////////////////////////
	function themify_ins2ary(&$ary, $element, $pos) {
		$ar1=array_slice($ary, 0, $pos); $ar1[]=$element;
		$ary=array_merge($ar1, array_slice($ary, $pos));
	}
	
	///////////////////////////////////////////
	// Upload and Resize Image Function
	///////////////////////////////////////////
	function themify_imageHandler($file, $new_file, $width, $height, $ext = null){
		$source_path = $file;
		list( $source_width, $source_height, $source_type ) = getimagesize( $source_path );
		if($ext != null){
			$ext = pathinfo($ext);	
			$ext = strtolower($ext['extension']);
			switch ( $ext ){
				case "gif":
				$source_gdim = imagecreatefromgif( $source_path );
				break;
				case "jpeg":
				$source_gdim = imagecreatefromjpeg( $source_path );
				break;
				case "jpg":
				$source_gdim = imagecreatefromjpeg( $source_path );
				break;
				case "png";
				$source_gdim = imagecreatefrompng( $source_path );
				break;
			}
		} else {
			switch ( $source_type ){
				case IMAGETYPE_GIF:
				$source_gdim = imagecreatefromgif( $source_path );
				break;
				case IMAGETYPE_JPEG:
				$source_gdim = imagecreatefromjpeg( $source_path );
				break;
				case IMAGETYPE_PNG:
				$source_gdim = imagecreatefrompng( $source_path );
				break;
			}
		}
		$source_aspect_ratio = $source_width / $source_height;
		$desired_aspect_ratio = $width / $height;
		if ( $source_aspect_ratio > $desired_aspect_ratio ){
			$temp_height = $height;
			$temp_width = ( int ) ( $height * $source_aspect_ratio );
		} else {
			$temp_width = $width;
			$temp_height = ( int ) ( $width / $source_aspect_ratio );
		}
		$temp_gdim = imagecreatetruecolor( $temp_width, $temp_height );
		imagecopyresampled(
			$temp_gdim,
			$source_gdim,
			0, 0,
			0, 0,
			$temp_width, $temp_height,
			$source_width, $source_height
		);
		$x0 = ( $temp_width - $width ) / 2;
		$y0 = ( $temp_height - $height ) / 2;
		$desired_gdim = imagecreatetruecolor( $width, $height );
			imagecopy(
			$desired_gdim,
			$temp_gdim,
			0, 0,
			$x0, $y0,
			$width, $height
		);
		imagejpeg( $desired_gdim, $new_file, 100 );
		imagedestroy( $source_gdim );
		imagedestroy( $temp_gdim );
	}
	
	///////////////////////////////////////////
	// Create ZIP Package
	///////////////////////////////////////////
	if(class_exists('ZipArchive')){
		function themify_create_zip($files = array(),$destination = "",$overwrite = false) {
			if(file_exists($destination) && !$overwrite) { return false; }
				$valid_files = array();
				if(is_array($files)) {
					foreach($files as $file) {
						if(file_exists($file)) {
							$valid_files[] = $file;
						}
					}
				}
				if(count($valid_files)) {
					$zip = new ZipArchive();
					if($zip->open($destination,$overwrite ? ZIPARCHIVE::OVERWRITE : ZIPARCHIVE::CREATE) !== true) {
					return false;
				}
				foreach($valid_files as $file) {
					$zip->addFile($file,pathinfo($file,PATHINFO_BASENAME));
				}
				$zip->close();
				return file_exists($destination);
			} else {
				return false;
			}
		}
	}
	
	///////////////////////////////////////////
	// Extract ZIP Package
	///////////////////////////////////////////
	if(class_exists('ZipArchive')){
		function themify_unzip($src_file, $dest_dir=false, $create_zip_name_dir=true, $overwrite=true){
					if(function_exists("zip_open")){   
						if(!is_resource(zip_open($src_file))){ 
							$src_file=dirname($_SERVER["SCRIPT_FILENAME"])."/".$src_file; 
						}
						if (is_resource($zip = zip_open($src_file))){          
							$splitter = ($create_zip_name_dir === true) ? "." : "/";
							if ($dest_dir === false) $dest_dir = substr($src_file, 0, strrpos($src_file, $splitter))."/";
							themify_create_dirs($dest_dir);
							while ($zip_entry = zip_read($zip)){
								$pos_last_slash = strrpos(zip_entry_name($zip_entry), "/");
								if ($pos_last_slash !== false){
									themify_create_dirs($dest_dir.substr(zip_entry_name($zip_entry), 0, $pos_last_slash+1));
								}
								if (zip_entry_open($zip,$zip_entry,"r")){
									$file_name = $dest_dir.zip_entry_name($zip_entry);
									if ($overwrite === true || $overwrite === false && !is_file($file_name)){
										$fstream = zip_entry_read($zip_entry, zip_entry_filesize($zip_entry));           
										if(!is_dir($file_name))            
										file_put_contents($file_name, $fstream );
										
										if(file_exists($file_name)){
											chmod($file_name, 0777);
											//echo "<span style=\"color:#1da319;\">file saved: </span>".$file_name."<br />";
										} else {
											//echo "<span style=\"color:red;\">file not found: </span>".$file_name."<br />";
										}
									}
									zip_entry_close($zip_entry);
								}      
							}
							zip_close($zip);
						} else {
							//echo "No Zip Archive Found.";
							return false;
						}
						themify_chmodr($dest_dir, 0755);
						return true;
					} else {
						return false;
					}
				}
				
			 	function themify_extract_zip($file){		
					$zip = zip_open($file);
					$dir = "temp/";
					if(is_resource($zip)){
						while($zip_entry = zip_read($zip)) {
							// echo $dir.basename(zip_entry_name($zip_entry));
							$fp = fopen($dir.basename(zip_entry_name($zip_entry)), "w");
							if(zip_entry_open($zip, $zip_entry, "r")) {
								$buf = zip_entry_read($zip_entry, zip_entry_filesize($zip_entry));
								fwrite($fp,"$buf");
								zip_entry_close($zip_entry);
								fclose($fp);
							}
						}
						zip_close($zip);
					} else {
						echo zipFileErrMsg($zip);		
					}
					if(file_exists($dir."custom-config.xml")){
						unlink("../custom-config.xml");
						rename($dir."custom-config.xml", "../custom-config.xml");
					}
					if(file_exists($dir."custom-modules.php")){
						unlink("../custom-modules.php");
						rename($dir."custom-modules.php","../custom-modules.php");
					}
					if(file_exists($dir."custom-functions.php")){
						unlink("../custom-functions.php");
						rename($dir."custom-functions.php","../custom-functions.php");
					}
					if(file_exists($dir."data_export.txt")){
						$handler = fopen($dir."data_export.txt", "r");
						$data = fread($handler, filesize($dir."data_export.txt"));
						themify_set_data(unserialize($data));
						fclose($handler);
					}
				}
	}

	///////////////////////////////////////////
	// Force Download
	///////////////////////////////////////////
	function themify_force_download($file){ 
		if((isset($file))&&(file_exists($file))){
		   header("Content-type: application/force-download"); 
		   header('Content-Disposition: inline; filename="' . $file . '"'); 
		   header("Content-Transfer-Encoding: Binary"); 
		   header("Content-length: ".filesize($file)); 
		   header('Content-Type: application/octet-stream'); 
		   header('Content-Disposition: attachment; filename="' . $file . '"'); 
		   readfile($file); 
		} else {
			return false;
		}	
	}
	
	///////////////////////////////////////////
	// Build Custom Write Panels
	///////////////////////////////////////////
	function themify_build_write_panels($args){
		global $themify_write_panels;
		if(is_array($args)){
			$themify_write_panels = $args;
			add_action('admin_menu', 'themify_create_meta_boxes');  
			add_action('save_post', 'themify_save_postdata');
		}
	}
	
	///////////////////////////////////////////
	// Call Custom Write Panel
	///////////////////////////////////////////
	function themify_create_meta_boxes() {
		global $themify_write_panels, $theme_name;
		$themify_write_panels = apply_filters('themify_do_metaboxes', $themify_write_panels);
		if(function_exists('add_meta_box') && is_array($themify_write_panels)){
			foreach($themify_write_panels as $args){
				if($args['pages'] != ''){
					$themify_meta_page = $args['pages'];
				} else {
					$themify_meta_page = 'post';	
				}
				if($args['name'] != ''){
					$themify_meta_name = $args['name'];	
				} else {
					$themify_meta_name = 'Themify Options';
				}
				$pages = explode(",", $themify_meta_page);
				foreach($pages as $page){
					add_meta_box( 'themify-meta-boxes', __('Themify Custom Panel', 'themify'), 'themify_meta_boxes', trim($page), 'normal', 'high' ); 
				}
			}
		}
	}  
	
///////////////////////////////////////////
// Build Custom Write Panel 
///////////////////////////////////////////
function themify_meta_boxes() {
		
	global $post, $themify_write_panels, $typenow;

echo '<div id="themify-meta-box-tabs">';		
		echo '<ul class="ilc-htabs themify-tabs-heading">';
		foreach( $themify_write_panels as $write_panel ) {
			if( trim( $write_panel['pages'] ) == $typenow ) {
				$panel_id = isset( $write_panel['id'] )? $write_panel['id']: sanitize_title( $write_panel['name'] );
				echo '<li><span><a id="'. $panel_id . 't" href="#'. $panel_id . '">' . $write_panel['name'] . '</a></span></li>';
			}
		}
		echo '</ul>';
		echo '<div class="ilc-btabs themify-tabs-body">';
		foreach( $themify_write_panels as $write_panel ) {
			
			$pages = explode(",", $write_panel['pages']);
			$check = false;
			
			foreach( $pages as $page ) {
				if( get_post_type($post) ) {
					if(get_post_type($post) == $page){
						$check = true;	
					}
				} else {
					if( (trim($page) == 'post' && $_GET['post_type'] == '') || $_GET['post_type'] == trim($page) ) {
						$check = true;	
					}
				}
			}
			
			if($check){
				$panel_id = isset( $write_panel['id'] )? $write_panel['id']: sanitize_title( $write_panel['name'] );
			?>
            <div id="<?php echo $panel_id; ?>" class="ilc-tab themify_write_panel">
            
            <div class="inside">
            	
				<input type="hidden" name="themify_proper_save" value="true" />

                <?php $themify_custom_panel_nonce = wp_create_nonce("themify-custom-panel"); ?>
                
                <!-- alerts -->
                <div class="alert"></div> 
                <!-- /alerts -->
                
                <?php
                
                foreach($write_panel['options'] as $meta_box):
                	if(isset($meta_box['name'])){
                    	$meta_value = get_post_meta($post->ID, $meta_box['name'], true);
                    }
	                $toggle_class = '';
	                $ext_attr = '';
	                $toggle_enable = false;
                   	if( isset($meta_box['toggle']) ){
	                	$toggle_class .= 'themify-toggle ';
	                	$toggle_class .= (is_array($meta_box['toggle'])) ? implode(' ', $meta_box['toggle']) : $meta_box['toggle'];
	                }
	                if( isset($meta_box['default_toggle']) && $meta_box['default_toggle'] == 'hidden' ){
	                	$ext_attr = 'style="display:none;"';
	                }
	                if( isset($meta_box['enable_toggle']) && $meta_box['enable_toggle'] == true ) {
	                	$toggle_class .= ' enable_toggle';
	                	$toggle_enable = true;
	                }
	                ?>

                    <?php
					///////////////////////////////////////////
					// Image Template 
					///////////////////////////////////////////
					if($meta_box['type'] == 'image'){ ?>
					<div class="featimgcontrol">
						<input type="hidden" name="<?php echo $meta_box['name']; ?>_noncename" id="<?php echo $meta_box['name']; ?>_noncename" value="<?php echo wp_create_nonce( plugin_basename(__FILE__) ); ?>" />
                        <div class="themify_field_row clearfix <?php echo $toggle_class; ?>" <?php echo $ext_attr; ?>>
                                                  
							<div class="themify_field_title"><?php echo $meta_box['title']; ?></div>
                                
                            	<div class="themify_field">
                                	
                            	<?php
                            	/** Parameters for the uploader @var Array */
								$featimg_uploader_args = array(
									'tomedia' => true,
									'topost' => $post->ID,
									'medialib' => true,
									'fields' => $meta_box['name']
								);

								$themify_featimg_field = themify_is_thumbnail_field($meta_box['name']);
								if( $themify_featimg_field ) {
									$featimg_uploader_args['featured'] = $meta_box['name'];
								}
								$this_attachment_id = '';
								if( has_post_thumbnail() && $themify_featimg_field ) {
									$this_attachment_id = get_post_thumbnail_id($post->ID);
									$thumb = wp_get_attachment_image_src( 
										$this_attachment_id, 'thumbnail');
									$thumb_src = $thumb[0];
								} elseif( !$themify_featimg_field && ($this_attachment_id = get_post_meta($post->ID, '_'.$meta_box['name'].'_attach_id', true)) ){
									$thumb = wp_get_attachment_image_src( 
										$this_attachment_id, 'thumbnail');
									$thumb_src = $thumb[0];
								} else {
									$thumb_src = $meta_value;
								}
								?>

									<div id="remove-<?php echo $meta_box['name']; ?>" class="themify_featimg_remove <?php if( $thumb_src == '' ) echo 'hide' ?>">
                		<a data-attachid="<?php echo get_post_meta($post->ID, '_'.$meta_box['name'].'_attach_id', true); ?>" href="#"><?php _e('Remove image', 'themify'); ?></a>
                	</div>

									<?php
									if( $thumb_src ) {
										$thumb = wp_get_attachment_image_src( $this_attachment_id, 'full');
										if( $thumb[0] ) $full_src = $thumb[0];
										else $full_src = $thumb_src;
										echo '<div class="themify_upload_preview" style="display:block;"><a href="'.$full_src.'" target="_blank"><img src="' . $thumb_src .'" width="40"  alt="'.__('Post Image', 'themify').'" /></a></div>';
									} else {
										echo '<div class="themify_upload_preview"></div>';
									}
									?>
									
                            	<!-- Field storing URL -->
                                <input type="hidden" id="<?php echo $meta_box['name']; ?>" name="<?php echo $meta_box['name']; ?>" value="<?php echo $meta_value; ?>" size="55" class="themify_input_field themify_upload_field" />

								<div class="themify_upload_buttons">
									<?php themify_uploader($meta_box['name'], $featimg_uploader_args) ?>
								</div>

								<?php if ( isset( $meta_box['description'] ) ) : ?>
									<span class="themify_field_description"><?php echo $meta_box['description']; ?></span>
								<?php endif; // meta_box description ?>
							</div>
                          
                          </div><!--/themify_field_row -->
                          
                          
						<script type="text/javascript">
						jQuery(function($){
                          	$('#remove-<?php echo $meta_box['name']; ?> a').on('click', function(e){
		                    	e.preventDefault();
		                    	
		                    	//Save value of this to use it on the response callback 
		                    	$this = $(this);

		                    	$.post(
									ajaxurl, {
										'action': 'themify_remove_post_image',
										'postid': <?php echo $post->ID; ?>,
										<?php if( !$themify_featimg_field )
												echo '\'attach_id\': $this.data(\'attachid\'),'; ?>
										'customfield' : '<?php echo $meta_box['name']; ?>',
										'nonce' : '<?php echo $themify_custom_panel_nonce; ?>'
									},
									function(data) {
										$this.parent().parent().find('.themify_upload_field').val('');
										$this.parent().parent().find('.themify_upload_preview').fadeOut();
										$('#remove-<?php echo $meta_box['name']; ?>').addClass('hide');
									}
								);
		                  	});
						});
						</script>
                          
                    </div><!-- Themify Image END -->
					<?php
					///////////////////////////////////////////
					// Video Template
					///////////////////////////////////////////
					} elseif ( 'video' == $meta_box['type'] ) { ?>
					<div class="featimgcontrol videocontrol">
						<input type="hidden" name="<?php echo $meta_box['name']; ?>_noncename" id="<?php echo $meta_box['name']; ?>_noncename" value="<?php echo wp_create_nonce( plugin_basename(__FILE__) ); ?>" />
                        <div class="themify_field_row clearfix <?php echo $toggle_class; ?>" <?php echo $ext_attr; ?>>

							<div class="themify_field_title"><?php echo $meta_box['title']; ?></div>

                            	<div class="themify_field">

                            	<?php
                            	/** Parameters for the uploader @var Array */
								$featimg_uploader_args = array(
									'tomedia'  => true,
									'topost'   => $post->ID,
									'medialib' => true,
									'fields'   => $meta_box['name'],
									'formats'  => 'mp4,m4v,webm,ogv,wmv,flv',
									'type'     => 'video',
								);

								$themify_featimg_field = themify_is_thumbnail_field($meta_box['name']);
								if( $themify_featimg_field ) {
									$featimg_uploader_args['featured'] = $meta_box['name'];
								}
								?>

								<div id="remove-<?php echo $meta_box['name']; ?>" class="themify_featimg_remove themify_video_remove <?php if( $meta_value == '' ) echo 'hide' ?>">
									<a href="#"><?php _e('Remove Video', 'themify'); ?></a>
								</div>

                            	<!-- Field storing URL -->
                                <input type="text" id="<?php echo $meta_box['name']; ?>" name="<?php echo
								$meta_box['name']; ?>" value="<?php echo $meta_value; ?>" size="55" class="themify_input_field themify_upload_field" />

								<div class="themify_upload_buttons">
									<?php themify_uploader($meta_box['name'], $featimg_uploader_args) ?>
								</div>

								<?php if ( isset( $meta_box['description'] ) ) : ?>
									<span class="themify_field_description"><?php echo $meta_box['description']; ?></span>
								<?php endif; // meta_box description ?>
							</div>
                        </div><!--/themify_field_row -->

						<script type="text/javascript">
						jQuery(function($){
                          	$('#remove-<?php echo $meta_box['name']; ?> a').on('click', function(e){
		                    	e.preventDefault();
								var $self = $(this).parent();
								$self.parent().find('.themify_upload_field').val('');
								$self.addClass('hide');

								$.post(
									ajaxurl, {
										'action': 'themify_remove_video',
										'postid': <?php echo $post->ID; ?>,
										'customfield' : '<?php echo $meta_box['name']; ?>',
										'nonce' : '<?php echo $themify_custom_panel_nonce; ?>'
									},
									function(data) {
										console.log(data);
										$self.parent().find('.themify_upload_field').val('');
										$self.addClass('hide');
									}
								);
		                  	});
						});
						</script>

                    </div><!-- Themify Image END -->
                   	<?php
					///////////////////////////////////////////
					// Image Size Dropdown Template 
					///////////////////////////////////////////
					?>
                    <?php } else if($meta_box['type'] == 'featimgdropdown'){
	                    /** Define WP Featured Image sizes + blank + Themify's img.php
		 				 * @var array */
						$themify_fi_sizes = themify_get_image_sizes_list();
                    	?>
                        <div <?php if(!themify_check('setting-img_settings_use') || ( isset( $meta_box['class'] ) && 'hidden' == $meta_box['class'] )) echo 'style="display:none"'; ?> class="<?php echo $meta_box['type']; ?>">
                            <input type="hidden" name="<?php echo $meta_box['name']; ?>_noncename" id="<?php echo $meta_box['name']; ?>_noncename" value="<?php echo wp_create_nonce( plugin_basename(__FILE__) ); ?>" />
                                <div class="themify_field_row clearfix <?php echo $toggle_class; ?>" <?php echo $ext_attr; ?>>
        
                                     <div class="themify_field_title"><?php echo $meta_box['title']; ?></div>
                                     
                                     <div class="themify_field">
                                        <select name="<?php echo $meta_box['name']; ?>">
                                    <?php foreach($themify_fi_sizes as $option): ?>
                                            <?php if($option['value'] == $meta_value){ $selected = "selected='selected'"; } else { $selected = ""; } ?>
                                             <option value="<?php echo $option['value']; ?>" <?php echo $selected; ?>><?php echo $option['name']; ?></option>
                                            <?php endforeach; ?>   
                                        </select>
										<?php if ( isset( $meta_box['description'] ) ) : ?>
											<span class="themify_field_description"><?php echo $meta_box['description']; ?></span>
										<?php endif; // meta_box description ?>
                                    </div>
                              </div><!--/themify_field_row -->
                        </div>
					<?php
					///////////////////////////////////////////
					// Post Meta Checkboxes Template 
					///////////////////////////////////////////
					?>
					<?php } else if($meta_box['type'] == 'postmeta'){ ?>

						<input type="hidden" name="<?php echo $meta_box['name']; ?>_noncename" id="<?php echo $meta_box['name']; ?>_noncename" value="<?php echo wp_create_nonce( plugin_basename(__FILE__) ); ?>" />
						<div class="custom-post-meta-group themify_field_row clearfix <?php echo $toggle_class; ?>" <?php echo $ext_attr; ?>>

							<div class="themify_field_title"><?php echo $meta_box['title']; ?></div>

							<div class="themify_field">
								<?php
								foreach($meta_box['meta'] as $meta => $name){
									$metakey = $meta_box['name'].'_'.$meta;
									$meta_class = 'all' != $meta? 'meta-sub meta-'.$meta : 'meta-all';
									echo '
									<label for="'.$metakey.'">
										<input type="checkbox" value="no" class="'.$meta_class.'" id="'.$metakey.'" name="'.$metakey.'" /> ' . $name . '
									</label>';
								}
								?>
								<br/>
								<input type="hidden" class="widefat" value="<?php echo $meta_value; ?>" id="<?php echo $meta_box['name']; ?>" name="<?php echo $meta_box['name']; ?>" />

								<?php if ( isset( $meta_box['description'] ) ) : ?>
									<span class="themify_field_description"><?php echo $meta_box['description']; ?></span>
								<?php endif; // meta_box description ?>
							</div>
						</div><!--/themify_field_row -->

					<?php
					///////////////////////////////////////////
					// Info Template 
					///////////////////////////////////////////
					} else if($meta_box['type'] == 'post_id_info'){ ?>
                    	
                            <div class="themify_field_row clearfix <?php echo $toggle_class; ?>" <?php echo $ext_attr; ?>>
    
                                <div class="themify_field_title"><?php echo $meta_box['title']; ?></div>
    
                                <div class="themify_field">
                                	<?php global $post_ID; ?>
                                    <span class="themify_field_description themify_field_info"><?php printf($meta_box['description'], $post_ID); ; ?></span>
                                </div>
    
                          </div><!--/themify_field_row -->
                    <?php
					///////////////////////////////////////////
					// Multi Template 
					///////////////////////////////////////////
					?>
                    <?php } else if($meta_box['type'] == 'multi'){
                    	echo themify_before_meta_field(array(
                    		'meta_box' => $meta_box,
                    		'toggle_class' => $toggle_class,
							'ext_attr' => $ext_attr,
						));
                    	foreach ($meta_box['meta']['fields'] as $field) {
							call_user_func('themify_meta_field_'.$field['type'], array(
								'meta_box' => $field,
								'meta_value' => get_post_meta($post->ID, $field['name'], true),
								'call_before_after' => false,
							));
							 if (!($field === end($meta_box['meta']['fields']))){
							 	echo $meta_box['meta']['separator'];
							 }
						}
						if(isset($meta_box['meta']['description']) && '' != $meta_box['meta']['description'])
							echo '<span class="themify_field_description">' . $meta_box['meta']['description'] . '</span>';
						echo themify_after_meta_field($meta_box['meta']['after']);
                    ?>
                    <?php
					///////////////////////////////////////////
					// Date Picker Template
					///////////////////////////////////////////
					?>
                    <?php } else if ( 'date' == $meta_box['type'] ) {
						themify_meta_field_date( array(
							'meta_box' => $meta_box,
							'meta_value' => $meta_value,
							'toggle_class' => $toggle_class,
							'ext_attr' => $ext_attr,
						));
					?>
					<?php
					///////////////////////////////////////////
					// Color Picker Template
					///////////////////////////////////////////
					?>
                    <?php } else if($meta_box['type'] == 'color'){
						themify_meta_field_color(array(
							'meta_box' => $meta_box,
							'meta_value' => $meta_value,
							'toggle_class' => $toggle_class,
							'ext_attr' => $ext_attr,
						));
					?>
                    <?php
					///////////////////////////////////////////
					// Dropdown Template 
					///////////////////////////////////////////
					?>
					<?php } else if($meta_box['type'] == 'dropdown'){
						themify_meta_field_dropdown(array(
							'meta_box' => $meta_box,
							'meta_value' => $meta_value,
							'toggle_class' => $toggle_class,
							'ext_attr' => $ext_attr,
						));
					?>
					<?php
					///////////////////////////////////////////
					// Dropdown Button Template 
					///////////////////////////////////////////
					?>
					<?php } else if($meta_box['type'] == 'dropdownbutton'){
						themify_meta_field_dropdownbutton(array(
							'meta_box' => $meta_box,
							'meta_value' => $meta_value,
							'toggle_class' => $toggle_class,
							'ext_attr' => $ext_attr,
						));
					?>
                    <?php
					///////////////////////////////////////////
					// Textbox Template 
					///////////////////////////////////////////
					?>
                    <?php } else if($meta_box['type'] == 'textbox'){
						themify_meta_field_textbox(array(
							'meta_box' => $meta_box,
							'meta_value' => $meta_value,
							'toggle_class' => $toggle_class,
							'ext_attr' => $ext_attr,
						));
					?>
                     <?php
					///////////////////////////////////////////
					// FontAwesome field template 
					///////////////////////////////////////////
					?>
                    <?php } else if($meta_box['type'] == 'fontawesome'){
						themify_meta_field_fontawesome(array(
							'meta_box' => $meta_box,
							'meta_value' => $meta_value,
							'toggle_class' => $toggle_class,
							'ext_attr' => $ext_attr,
						));
					?>
                   <?php
					///////////////////////////////////////////
					// Textarea Template 
					///////////////////////////////////////////
					?>
                    <?php } else if($meta_box['type'] == 'textarea'){
                    	themify_meta_field_textarea(array(
							'meta_box' => $meta_box,
							'meta_value' => $meta_value,
							'toggle_class' => $toggle_class,
							'ext_attr' => $ext_attr,
						));
					?>
					<?php
					///////////////////////////////////////////
					// Checkbox Template 
					///////////////////////////////////////////
					?>
					<?php } else if($meta_box['type'] == 'checkbox'){
						
						themify_meta_field_checkbox(array(
							'meta_box' => $meta_box,
							'meta_value' => $meta_value,
							'toggle_class' => $toggle_class,
							'ext_attr' => $ext_attr,
						));
					?>
					<?php
					///////////////////////////////////////////
					// Separator Template
					///////////////////////////////////////////
					?>
					<?php } else if($meta_box['type'] == 'separator'){
						
						themify_meta_field_separator(array(
							'meta_box' => $meta_box,
							'meta_value' => $meta_value,
							'toggle_class' => $toggle_class,
							'ext_attr' => $ext_attr,
						));
					?>
					<?php
					///////////////////////////////////////////
					// Layout Template 
					///////////////////////////////////////////
					?>
                    <?php } else if($meta_box['type'] == 'layout'){

						themify_meta_field_layout(array(
							'meta_box' => $meta_box,
							'meta_value' => $meta_value,
							'toggle_class' => $toggle_class,
							'ext_attr' => $ext_attr,
						));
					?>
					<?php
					///////////////////////////////////////////
					// Gallery Shortcode Template 
					///////////////////////////////////////////
					?>
                    <?php } else if($meta_box['type'] == 'gallery_shortcode'){
                    		wp_enqueue_script('gallery-shortcode');
                    		?>
                        
                            <input type="hidden" name="<?php echo $meta_box['name']; ?>_noncename" id="<?php echo $meta_box['name']; ?>_noncename" value="<?php echo wp_create_nonce( plugin_basename(__FILE__) ); ?>" />
                               
                               <div class="themify_field_row clearfix <?php echo $toggle_class; ?>" <?php echo $ext_attr; ?>>
        
                                    <div class="themify_field_title"><?php echo $meta_box['title']; ?></div>
        
                                    <div class="themify_field">
                                        <?php 
                                        if( isset($meta_box['meta']) && '' != $meta_box['meta']['size'] && 'small' == $meta_box['meta']['size'] ) {
                                            $class = 'small';	
                                        } else {
                                            $class = '';
                                        }
                                        ?>
                                        <textarea name="<?php echo $meta_box['name']; ?>" size="55" rows="4" class="themify_input_field themify-gallery-shortcode-input <?php echo $class; ?>"><?php echo $meta_value; ?></textarea>

										<div class="themify-gallery-shortcode-btn">
											<a href="#" class="themify-gallery-shortcode-btn"><?php _e('Insert Gallery', 'themify') ?></a>						
										</div>
                                        
										<?php if ( isset( $meta_box['description'] ) ) : ?>
											<span class="themify_field_description"><?php echo $meta_box['description']; ?></span>
										<?php endif; // meta_box description ?>
                                    </div>
        
                              </div><!--/themify_field_row -->
                    <?php
					///////////////////////////////////////////
					// Query Posts Template 
					///////////////////////////////////////////
					?>
                    <?php } else if($meta_box['type'] == 'query_category'){ ?>
                                
						<input type="hidden" name="<?php echo $meta_box['name']; ?>_noncename" id="<?php echo $meta_box['name']; ?>_noncename" value="<?php echo wp_create_nonce( plugin_basename(__FILE__) ); ?>" />
                              
						<div class="themify_field_row clearfix <?php echo $toggle_class; ?>" <?php echo $ext_attr; ?>>    
							<div class="themify_field_title"><?php echo $meta_box['title']; ?></div>
							<div class="themify_field">
                                <?php
                                $terms_tax = isset($meta_box['meta']['taxonomy'])? $meta_box['meta']['taxonomy']: 'category';
								
								$terms_options = '';
								$terms_by_tax = get_terms($terms_tax);
								$terms_list = array();
								$terms_list['0'] = array(
									'title' => __('All Categories', 'themify'),										
									'slug'	=> '0'
								);
								foreach ($terms_by_tax as $term) {
									$terms_list[$term->term_id] = array(
										'title' => $term->name,
										'slug'	=> $term->slug
									);
								}
								foreach ($terms_list as $term_id => $term) {
									$term_selected = '';
									if(!is_numeric($meta_value)) {
										if($meta_value == $term['slug']) $term_selected = 'selected="selected"';
									} else {
										if($meta_value == $term_id) $term_selected = 'selected="selected"';
									}
									$terms_options .= sprintf(
										'<option value="%s" data-termid="%s" %s>%s</option>',
										$term['slug'],
										$term_id,
										$term_selected,
										$term['title']
									);
								}//*/
                                /*$terms_dropdown = wp_dropdown_categories(
								array(
                                	'taxonomy' => $terms_tax, 
                                	'class' => 'query_category_single',
                                    'show_option_all' => __('All Categories', 'themify'),
                                    'hide_empty' => 0,
                                    'echo' => 0,
                                    'name' => $meta_box['name'],
                                    'selected' => $meta_value
								));
                                echo preg_replace('/>/', '><option></option>', $terms_dropdown, 1);//*/
                                ?>
                                <select id="<?php echo $meta_box['name']; ?>" class="query_category_single">
									<option></option>
									<?php echo $terms_options; ?>
                                </select>
                                <?php _e('or', 'themify'); ?> 
                                <input type="text" class="query_category" value="<?php echo $meta_value; ?>" />
                                <input type="hidden" value="<?php echo $meta_value; ?>" name="<?php echo $meta_box['name']; ?>" class="val" />
								<?php if ( isset( $meta_box['description'] ) ) : ?>
									<span class="themify_field_description"><?php echo $meta_box['description']; ?></span>
								<?php endif; // meta_box description ?>
							</div>
						</div>
                    
                    <?php
					///////////////////////////////////////////
					// Sidebar Visibility Template 
					///////////////////////////////////////////
					?>
                    <?php } else if($meta_box['type'] == 'sidebar_visibility'){ ?>
                    
                    		<input type="hidden" name="<?php echo $meta_box['name']; ?>_noncename" id="<?php echo $meta_box['name']; ?>_noncename" value="<?php echo wp_create_nonce( plugin_basename(__FILE__) ); ?>" />
                            
                                <div class="themify_field_row clearfix <?php echo $toggle_class; ?>" <?php echo $ext_attr; ?>>  
                                    <div class="themify_field_title"><?php echo $meta_box['title']; ?></div>
                                    <div class="themify_field">
                                    <?php 
                                    $sidebars = get_option('sidebars_widgets');
									global $wp_registered_sidebars;
                                    foreach($sidebars as $sidebar => $val){
                                        if($sidebar != 'wp_inactive_widgets' && $sidebar != 'array_version' && strpos(strtolower($wp_registered_sidebars[$sidebar]['name']),'sidebar') !== false){ 
										$checked = "";
										if(get_post_meta($post->ID, $meta_box['name'], true) == "" || !get_post_meta($post->ID, $meta_box['name'], true)){
											$checked = "checked='checked'";
										} else {
											foreach($meta_value as $key => $val){
												if(str_replace("'","",$key) == $wp_registered_sidebars[$sidebar]['name']){
													$checked = "checked='checked'";
												}
											}
										}
										?>
                                        <input type="checkbox" name="<?php echo $meta_box['name']; ?>[<?php echo $wp_registered_sidebars[$sidebar]['name']; ?>]" class="" <?php echo $checked; ?> /> <?php echo $wp_registered_sidebars[$sidebar]['name']; ?><br />
                                    <?php		
                                        }
                                    }
                                    ?>
									<?php if ( isset( $meta_box['description'] ) ) : ?>
                                    	<span class="themify_field_description"><?php echo $meta_box['description']; ?></span>
									<?php endif; // meta_box description ?>
                                    </div>	
                                </div>
                    
                    <?php
                    ///////////////////////////////////////////
					// Radio Template 
					///////////////////////////////////////////
                    ?>        
                    <?php } else if($meta_box['type'] == 'radio') { ?>

                    	<input type="hidden" name="<?php echo $meta_box['name']; ?>_noncename" id="<?php echo $meta_box['name']; ?>_noncename" value="<?php echo wp_create_nonce( plugin_basename(__FILE__) ); ?>" />

	<div class="themify_field_row clearfix <?php echo $toggle_class; ?>" <?php echo $ext_attr; ?>>

		<div class="themify_field_title"><?php echo $meta_box['title']; ?></div>

		<div class="themify_field">
                            	<?php foreach($meta_box['meta'] as $k => $option){
                            		//$k = ($k == '') ? 0 : $k;
									if(isset($option['selected']) && $option['selected'] && '' == $meta_value){
										$radio_selected = 'checked="checked"';
									} else {
										$radio_selected = checked( $meta_value, $option['value'], false );
									}

                            	?>
                            	<input type="radio" name="<?php echo $meta_box['name']; ?>" id="<?php echo $meta_box['name']; ?>-<?php echo esc_attr( $option['value'] ); ?>" value="<?php echo $option['value']; ?>" <?php echo $radio_selected; ?> /> <label for="<?php echo $meta_box['name']; ?>-<?php echo esc_attr( $option['value'] ); ?>" class="selectit"><?php echo $option['name']; ?></label>
                            	<?php } ?>
								<?php if ( isset( $meta_box['description'] ) ) : ?>
									<span class="themify_checkbox_description"><?php echo $meta_box['description']; ?></span>
								<?php endif; // meta_box description ?>
                            </div>

                      </div><!--/themify_field_row -->

			<?php
			///////////////////////////////////////////
			// Page builder template
			///////////////////////////////////////////
			?>

                    <?php } else if($meta_box['type'] == 'page_builder') {
                    	do_action('themify_builder_metabox');
                  	} ?>

                <?php endforeach; ?>
            </div>
            </div>
			<?php
			}
		}
	echo '</div>';//end .ilc-btabs
echo '</div>';//end #themify-meta-box-tabs

}

if(!function_exists('themify_framework_query_posts_page_args')){
	/**
	 * Allows to query by category slug or id
	 * @param array|string $qpargs Query parameters
	 * @return array
	 * @since 1.3.8
	 */
	function themify_framework_query_posts_page_args($qpargs) {
		global $themify;
		$cats = explode(',', str_replace(' ', '', $themify->query_category));
		if(is_array($qpargs)) {
			if(is_array($cats) && is_numeric($cats[0])) {
				return $qpargs;
			} else {
				$slugs = array();
				foreach ($cats as $cat) {
					$term = get_term_by('slug', $cat, $themify->query_taxonomy);
					$slugs[] = $term->term_id;
				}
				$qpargs['tax_query']['0']['terms'] = $slugs;
				return $qpargs;
			}
		} else {
			if(is_array($cats) && is_numeric($cats[0])) {
				return $qpargs;
			} else {
				$slugs = array();
				$taxo = isset($themify->query_taxonomy)? $themify->query_taxonomy: 'category';
				foreach ($cats as $cat) {
					$term = get_term_by('slug', $cat, $taxo);
					$slugs[] = $term->term_id;
				}
				parse_str($qpargs, $args);
				$qpargs = '';
				unset($args['cat']);
				$args['cat'] = implode(',', $slugs);
				foreach ($args as $key => $value) {
					$qpargs .= $key.'='.$value.'&';
				}
				$qpargs = substr($qpargs, 0, -1);
				return $qpargs;
			}
		}
	};
	add_filter('themify_query_posts_page_args', 'themify_framework_query_posts_page_args');
}

function themify_get_fontawesome_icons() {
	return apply_filters( 'themify_fontawesome_icons', array( 'fa-glass', 'fa-music', 'fa-search', 'fa-envelope-o', 'fa-heart', 'fa-star', 'fa-star-o', 'fa-user', 'fa-film', 'fa-th-large', 'fa-th', 'fa-th-list', 'fa-check', 'fa-times', 'fa-search-plus', 'fa-search-minus', 'fa-power-off', 'fa-signal', 'fa-gear', 'fa-cog', 'fa-trash-o', 'fa-home', 'fa-file-o', 'fa-clock-o', 'fa-road', 'fa-download', 'fa-arrow-circle-o-down', 'fa-arrow-circle-o-up', 'fa-inbox', 'fa-play-circle-o', 'fa-rotate-right', 'fa-repeat', 'fa-refresh', 'fa-list-alt', 'fa-lock', 'fa-flag', 'fa-headphones', 'fa-volume-off', 'fa-volume-down', 'fa-volume-up', 'fa-qrcode', 'fa-barcode', 'fa-tag', 'fa-tags', 'fa-book', 'fa-bookmark', 'fa-print', 'fa-camera', 'fa-font', 'fa-bold', 'fa-italic', 'fa-text-height', 'fa-text-width', 'fa-align-left', 'fa-align-center', 'fa-align-right', 'fa-align-justify', 'fa-list', 'fa-dedent', 'fa-outdent', 'fa-indent', 'fa-video-camera', 'fa-picture-o', 'fa-pencil', 'fa-map-marker', 'fa-adjust', 'fa-tint', 'fa-edit', 'fa-pencil-square-o', 'fa-share-square-o', 'fa-check-square-o', 'fa-arrows', 'fa-step-backward', 'fa-fast-backward', 'fa-backward', 'fa-play', 'fa-pause', 'fa-stop', 'fa-forward', 'fa-fast-forward', 'fa-step-forward', 'fa-eject', 'fa-chevron-left', 'fa-chevron-right', 'fa-plus-circle', 'fa-minus-circle', 'fa-times-circle', 'fa-check-circle', 'fa-question-circle', 'fa-info-circle', 'fa-crosshairs', 'fa-times-circle-o', 'fa-check-circle-o', 'fa-ban', 'fa-arrow-left', 'fa-arrow-right', 'fa-arrow-up', 'fa-arrow-down', 'fa-mail-forward', 'fa-share', 'fa-expand', 'fa-compress', 'fa-plus', 'fa-minus', 'fa-asterisk', 'fa-exclamation-circle', 'fa-gift', 'fa-leaf', 'fa-fire', 'fa-eye', 'fa-eye-slash', 'fa-warning', 'fa-exclamation-triangle', 'fa-plane', 'fa-calendar', 'fa-random', 'fa-comment', 'fa-magnet', 'fa-chevron-up', 'fa-chevron-down', 'fa-retweet', 'fa-shopping-cart', 'fa-folder', 'fa-folder-open', 'fa-arrows-v', 'fa-arrows-h', 'fa-bar-chart-o', 'fa-twitter-square', 'fa-facebook-square', 'fa-camera-retro', 'fa-key', 'fa-gears', 'fa-comments', 'fa-thumbs-o-up', 'fa-thumbs-o-down', 'fa-star-half', 'fa-heart-o', 'fa-sign-out', 'fa-linkedin-square', 'fa-thumb-tack', 'fa-external-link', 'fa-sign-in', 'fa-trophy', 'fa-github-square', 'fa-upload', 'fa-lemon-o', 'fa-phone', 'fa-square-o', 'fa-bookmark-o', 'fa-phone-square', 'fa-twitter', 'fa-facebook', 'fa-github', 'fa-unlock', 'fa-credit-card', 'fa-rss', 'fa-hdd-o', 'fa-bullhorn', 'fa-bell', 'fa-certificate', 'fa-hand-o-right', 'fa-hand-o-left', 'fa-hand-o-up', 'fa-hand-o-down', 'fa-arrow-circle-left', 'fa-arrow-circle-right', 'fa-arrow-circle-up', 'fa-arrow-circle-down', 'fa-globe', 'fa-wrench', 'fa-tasks', 'fa-filter', 'fa-briefcase', 'fa-arrows-alt', 'fa-group', 'fa-chain', 'fa-cloud', 'fa-flask', 'fa-cut', 'fa-copy', 'fa-paperclip', 'fa-save', 'fa-square', 'fa-bars', 'fa-list-ul', 'fa-list-ol', 'fa-strikethrough', 'fa-underline', 'fa-table', 'fa-magic', 'fa-truck', 'fa-pinterest', 'fa-google-plus-square', 'fa-google-plus', 'fa-money', 'fa-caret-down', 'fa-caret-up', 'fa-caret-left', 'fa-caret-right', 'fa-columns', 'fa-unsorted', 'fa-sort-down', 'fa-sort-up', 'fa-envelope', 'fa-linkedin', 'fa-rotate-left', 'fa-undo', 'fa-legal', 'fa-dashboard', 'fa-comment-o', 'fa-comments-o', 'fa-flash', 'fa-sitemap', 'fa-umbrella', 'fa-paste', 'fa-lightbulb-o', 'fa-exchange', 'fa-cloud-download', 'fa-cloud-upload', 'fa-user-md', 'fa-stethoscope', 'fa-suitcase', 'fa-bell-o', 'fa-coffee', 'fa-cutlery', 'fa-building-o', 'fa-hospital-o', 'fa-ambulance', 'fa-medkit', 'fa-fighter-jet', 'fa-beer', 'fa-h-square', 'fa-plus-square', 'fa-angle-double-left', 'fa-angle-double-right', 'fa-angle-double-up', 'fa-angle-double-down', 'fa-angle-left', 'fa-angle-right', 'fa-angle-up', 'fa-angle-down', 'fa-desktop', 'fa-laptop', 'fa-tablet', 'fa-mobile-phone', 'fa-circle-o', 'fa-quote-left', 'fa-quote-right', 'fa-spinner', 'fa-circle', 'fa-mail-reply', 'fa-github-alt', 'fa-folder-o', 'fa-folder-open-o', 'fa-smile-o', 'fa-frown-o', 'fa-meh-o', 'fa-gamepad', 'fa-keyboard-o', 'fa-flag-o', 'fa-flag-checkered', 'fa-terminal', 'fa-code', 'fa-reply-all', 'fa-mail-reply-all', 'fa-star-half-empty', 'fa-location-arrow', 'fa-crop', 'fa-code-fork', 'fa-unlink', 'fa-question', 'fa-info', 'fa-exclamation', 'fa-superscript', 'fa-subscript', 'fa-eraser', 'fa-puzzle-piece', 'fa-microphone', 'fa-microphone-slash', 'fa-shield', 'fa-calendar-o', 'fa-fire-extinguisher', 'fa-rocket', 'fa-maxcdn', 'fa-chevron-circle-left', 'fa-chevron-circle-right', 'fa-chevron-circle-up', 'fa-chevron-circle-down', 'fa-html5', 'fa-css3', 'fa-anchor', 'fa-unlock-alt', 'fa-bullseye', 'fa-ellipsis-h', 'fa-ellipsis-v', 'fa-rss-square', 'fa-play-circle', 'fa-ticket', 'fa-minus-square', 'fa-minus-square-o', 'fa-level-up', 'fa-level-down', 'fa-check-square', 'fa-pencil-square', 'fa-external-link-square', 'fa-share-square', 'fa-compass', 'fa-toggle-down', 'fa-caret-square-o-down', 'fa-toggle-up', 'fa-toggle-right', 'fa-euro', 'fa-gbp', 'fa-dollar', 'fa-rupee', 'fa-cny', 'fa-ruble', 'fa-won', 'fa-bitcoin', 'fa-file', 'fa-file-text', 'fa-sort-alpha-asc', 'fa-sort-alpha-desc', 'fa-sort-amount-asc', 'fa-sort-amount-desc', 'fa-sort-numeric-asc', 'fa-sort-numeric-desc', 'fa-thumbs-up', 'fa-thumbs-down', 'fa-youtube-square', 'fa-youtube', 'fa-xing', 'fa-xing-square', 'fa-youtube-play', 'fa-dropbox', 'fa-stack-overflow', 'fa-instagram', 'fa-flickr', 'fa-adn', 'fa-bitbucket', 'fa-bitbucket-square', 'fa-tumblr', 'fa-tumblr-square', 'fa-long-arrow-down', 'fa-long-arrow-up', 'fa-long-arrow-left', 'fa-long-arrow-right', 'fa-apple', 'fa-windows', 'fa-android', 'fa-linux', 'fa-dribbble', 'fa-skype', 'fa-foursquare', 'fa-trello', 'fa-female', 'fa-male', 'fa-gittip', 'fa-sun-o', 'fa-moon-o', 'fa-archive', 'fa-bug', 'fa-vk', 'fa-weibo', 'fa-renren', 'fa-pagelines', 'fa-stack-exchange', 'fa-arrow-circle-o-right', 'fa-arrow-circle-o-left', 'fa-toggle-left', 'fa-dot-circle-o', 'fa-wheelchair', 'fa-vimeo-square', 'fa-turkish-lira', 'fa-plus-square-o'
	) );
}

function themify_meta_field_fontawesome( $args, $call_before_after = true, $echo = true ) {
	extract($args, EXTR_OVERWRITE);

	if ( isset( $meta_box['meta'] ) && isset( $meta_box['meta']['size'] ) && '' != $meta_box['meta']['size'] && 'small' == $meta_box['meta']['size'] ) {
        $class = 'small';	
    } else {
        $class = '';
    }

	$html = '<div class="icon-preview font-icon-preview">
					<i class="fa ' . $meta_value . '"></i>
				</div>
				<!-- /icon-preview -->';
	$html .= sprintf('<input type="text" id="%s" name="%s" value="%s" size="55" class="themify_input_field themify_fa %s" /> <a class="button button-secondary hide-if-no-js themify_fa_toggle" href="#" data-target="#%s">%s</a>',
		$meta_box['name'], $meta_box['name'], $meta_value, $class, $meta_box['name'], __( 'Insert Icon', 'themify' ) );

	if(isset($meta_box['label']) && '' != $meta_box['label'])
		$html = sprintf('<label for="%s">%s %s</label>', $meta_box['name'], $html, $meta_box['label']);
	
	if ( isset( $meta_box['description'] ) )
		$html .= themify_meta_field_get_description( $meta_box['description'] );
	
	if( isset( $meta_box['before'] ) && $meta_box['before'] ) $html = $meta_box['before'] . $html;
	if( isset( $meta_box['after'] ) && $meta_box['after'] )  $html .= $meta_box['after'];
	
	if($call_before_after)
		$html = themify_before_meta_field($args) . $html . themify_after_meta_field();
	
	if($echo) echo $html;
	else return $html;
}

function themify_font_icons_admin_assets() {
	wp_enqueue_style( 'themify-font-icons-css', THEMIFY_URI . '/fontawesome/css/font-awesome.min.css', array(), THEMIFY_VERSION );
	wp_enqueue_script( 'themify-font-icons-js', THEMIFY_URI . '/js/themify.font-icons-select.js', array( 'jquery' ) );
	add_action( 'admin_footer', 'themify_font_icons_dialog' );
}

function themify_font_icons_dialog() {
	echo themify_get_font_icons_dialog();
}

function themify_get_font_icons_dialog() {
	$icons = '
		<div id="themify_lightbox_fa" class="themify-admin-lightbox clearfix" style="display: none;">
			<h3 class="themify_lightbox_title">' . __( 'Choose icon', 'themify' ) . '</h3>
			<a href="#" class="close_lightbox"><i class="fa fa-times"></i></a>
			<div class="lightbox_container">';

		foreach( themify_get_fontawesome_icons() as $icon ) {
			$icons .= '<a href="#" data-name="' . $icon . '"><i class="fa ' . $icon . '"></i>' . $icon . '</a>';
		}
	$icons .= '
			</div>
		</div>
		<div id="themify_lightbox_overlay"></div>';

	return $icons;
}

/**
 * Setup menu icon functionality
 *
 * @since 1.6.8
 */
function themify_setup_menu_icons() {
	if( is_admin() ) {
		add_filter( 'wp_edit_nav_menu_walker', 'themify_custom_edit_nav_menu_walker' );
		add_action( 'wp_nav_menu_item_custom_fields', 'themify_add_menu_icon_option', 12, 4 );
		add_action( 'wp_update_nav_menu_item', 'themify_update_menu_icon_option', 10, 3 );
		add_action( 'delete_post', 'themify_remove_menu_icon_meta', 1, 3 );
	} else {
		add_filter( 'wp_nav_menu_args', 'themify_add_menu_item_title_filter' );
		add_filter( 'wp_nav_menu', 'themify_remove_menu_item_title_filter' );
	}
}
add_action( 'init', 'themify_setup_menu_icons' );

/**
 * Start looking for menu icons
 */
function themify_add_menu_item_title_filter( $args ) {
	add_filter( 'the_title', 'themify_add_menu_icon', 10, 2 );
	return $args;
}

/**
 * The menu is rendered, we longer need to look for menu icons
 */
function themify_remove_menu_item_title_filter( $nav_menu ) {
	remove_filter( 'the_title', 'themify_add_menu_icon', 10, 2 );
	return $nav_menu;
}

/**
 * Setup custom walker for Nav_Menu_Edit
 *
 * @since 1.6.8
 */
function themify_custom_edit_nav_menu_walker( $walker ) {
	include( THEMIFY_DIR . '/class-themify-walker-nav-menu-edit.php' );
	return 'Themify_Walker_Nav_Menu_Edit';
}

/**
 * Save the icon meta for a menu item. Also removes the meta entirely if the field is cleared.
 *
 * @since 1.6.8
 */
function themify_update_menu_icon_option( $menu_id, $menu_item_db_id, $args ) {
	$meta_key = '_menu_item_icon';
	$meta_value = themify_get_menu_icon( $menu_item_db_id );
	$new_meta_value = stripcslashes( $_POST['menu-item-icon'][$menu_item_db_id] );

	if ( $new_meta_value && '' == $meta_value )
		add_post_meta( $menu_item_db_id, $meta_key, $new_meta_value, true );
	elseif ( $new_meta_value && $new_meta_value != $meta_value )
		update_post_meta( $menu_item_db_id, $meta_key, $new_meta_value );
	elseif ( '' == $new_meta_value && $meta_value )
		delete_post_meta( $menu_item_db_id, $meta_key, $meta_value );
}

/**
 * Clean up the icon meta field when a menu item is deleted
 *
 * @since 1.6.8
 */
function themify_remove_menu_icon_meta( $post_id ) {
	if( is_nav_menu_item( $post_id ) ) {
		delete_post_meta( $post_id, '_menu_item_icon' );
	}
}

/**
 * Display the icon picker for menu items in the backend
 *
 * @since 1.6.8
 */
function themify_add_menu_icon_option( $item_id, $item, $depth, $args ) {
	$saved_meta = themify_get_menu_icon( $item_id );
?>
	<p class="field-icon description description-thin">
		<label for="edit-menu-item-icon-<?php echo $item_id; ?>">
			<?php _e( 'Icon', 'themify' ) ?><br/>
			<input type="text" name="menu-item-icon[<?php echo $item_id; ?>]" id="edit-menu-item-icon-<?php echo $item_id ?>" size="8" class="edit-menu-item-icon themify_field_icon" value="<?php echo esc_attr( $saved_meta ); ?>">
			<a class="button button-secondary hide-if-no-js themify_fa_toggle" href="#" data-target="#edit-menu-item-icon-<?php echo $item_id ?>"><?php _e( 'Insert Icon', 'themify' ); ?></a>
		</label>
	</p>
<?php }

/**
 * Returns the icon name chosen for a given menu item
 *
 * @return string|null
 * @since 1.6.8
 */
function themify_get_menu_icon( $item_id ) {
	return get_post_meta( $item_id, '_menu_item_icon', true );
}

/**
 * Append icon to a menu item
 *
 * @since 1.6.8
 */
function themify_add_menu_icon( $title, $id ) {
	if( $icon = themify_get_menu_icon( $id ) ) {
		$title = '<i class="fa ' . $icon . '"></i> ' . $title;
	}

	return $title;
}

function themify_lightbox_menu_item( $atts, $item, $args ) {
	if( in_array( 'lightbox', $item->classes ) ) {
		$atts['class'] = isset( $atts['class'] ) ? $atts['class'] . ' lightbox' : 'lightbox';
		$atts['href'] = add_query_arg( array( 'iframe' => 'true', 'width' => '100%', 'height' => '100%' ), $atts['href'] );
	}

	return $atts;
}
add_filter( 'nav_menu_link_attributes', 'themify_lightbox_menu_item', 10, 3 );

/**
 * Generates date picker field for Themify Custom Panel.
 * @param array $args Field settings.
 * @param bool $call_before_after Output common wrapping markup before and after the field.
 * @param bool $echo Just return the field or echo it too.
 * @since 1.7.1
 */
function themify_meta_field_date( $args, $call_before_after = true, $echo = true ) {
	wp_enqueue_style( 'themify-datetimepicker-css', THEMIFY_URI . '/css/jquery-ui-timepicker.css', array(), THEMIFY_VERSION );
	wp_enqueue_script( 'themify-datetimepicker-js', THEMIFY_URI . '/js/jquery-ui-timepicker.js', array( 'jquery', 'jquery-ui-datepicker'/*, 'jquery-ui-slider'*/ ), false, true );

	extract($args, EXTR_OVERWRITE);

	if ( isset( $meta_box['meta']['default'] ) && $meta_box['meta']['default'] != '' ) {
        $default = $meta_box['meta']['default'];
    } else {
		$default = '';
    }

	$pick  = isset( $meta_box['meta']['pick'] ) && '' != $meta_box['meta']['pick'] ? $meta_box['meta']['pick']  : __( 'Pick Date', 'themify' );
	$close = isset( $meta_box['meta']['close'] ) && '' != $meta_box['meta']['close'] ? $meta_box['meta']['close'] : __( 'Done', 'themify' );
	$clear = isset( $meta_box['meta']['clear'] ) && '' != $meta_box['meta']['clear'] ? $meta_box['meta']['clear'] : __( 'Clear', 'themify' );
	$date_format = isset( $meta_box['meta']['date_format'] ) && '' != $meta_box['meta']['date_format'] ? $meta_box['meta']['date_format'] : 'yy-mm-dd';
	$time_format = isset( $meta_box['meta']['time_format'] ) && '' != $meta_box['meta']['time_format'] ? $meta_box['meta']['time_format'] : 'hh:mm tt';
	$timeseparator = isset( $meta_box['meta']['timeseparator'] ) && '' != $meta_box['meta']['timeseparator'] ? $meta_box['meta']['timeseparator'] : ' @ ';

	$field = $meta_box['name'];
	$html = sprintf( '
		<div class="disableDateField"></div>
		<input type="text" id="%s" name="%s" value="%s" data-clear="%s" data-label="%s"
		 data-close="%s"
		 data-dateformat="%s" data-timeformat="%s" data-timeseparator="%s" class="themify_input_field medium themifyDatePicker" />
		<input type="button" id="%s" data-picker="%s" value="%s" class="button themifyClearDate themifyOpacityTransition %s" >',
	$field, $field, $meta_value? $meta_value : $default, 'clear-'.$field, $pick, $close, $date_format, $time_format, $timeseparator,
	'clear-'.$field, $field, $clear, $meta_value? 'themifyFadeIn' : '' );
		
	if(isset($meta_box['label']) && '' != $meta_box['label'])
		$html = sprintf('<label for="%s">%s %s</label>', $field, $html, $meta_box['label']);

	$html .= isset( $meta_box['description'] )? themify_meta_field_get_description($meta_box['description']) : '';

	if ( isset( $meta_box['before'] ) ) $html = $meta_box['before'] . $html;
	if ( isset( $meta_box['after'] ) ) $html .= $meta_box['after'];

	if ( $call_before_after ) $html = themify_before_meta_field($args) . $html . themify_after_meta_field();

	if ( $echo ) echo $html;
	else return $html;
}

/**
 * Generates color picker
 * @param array $args Field settings
 * @param bool $call_before_after Whether to output common wrapping markup before and after the field
 * @param bool $echo Whether to echo or return the field
 * @since 1.3.2
 */
function themify_meta_field_color($args, $call_before_after = true, $echo = true){
	extract($args, EXTR_OVERWRITE);

	if(isset($meta_box['meta']['default']) && $meta_box['meta']['default'] != ''){
        $default_color = $meta_box['meta']['default'];
    } else {
        $default_color = '';
    }

	$html = sprintf( '<span class="colorSelect"></span>
	<input type="text" id="%s" name="%s" value="%s" class="themify_input_field colorSelectInput" />
	<input type="button" class="button clearColor" value="' . __('Clear', 'themify') . '">',
		$meta_box['name'], $meta_box['name'], $meta_value? $meta_value : $meta_box['meta']['default'] );

	if(isset($meta_box['label']) && '' != $meta_box['label'])
		$html = sprintf('<label for="%s">%s %s</label>', $meta_box['name'], $html, $meta_box['label']);

	$html .= isset( $meta_box['description'] )? themify_meta_field_get_description($meta_box['description']) : '';

	if ( isset( $meta_box['before'] ) ) $html = $meta_box['before'] . $html;
	if ( isset( $meta_box['after'] ) ) $html .= $meta_box['after'];

	if($call_before_after)
		$html = themify_before_meta_field($args) . $html . themify_after_meta_field();

	if($echo) echo $html;
	else return $html;
}

/**
 * Generates layout field
 * @param array $args Field settings
 * @param bool $call_before_after Whether to output common wrapping markup before and after the field
 * @param bool $echo Whether to echo or return the field
 * @since 1.3.2
 */
function themify_meta_field_layout( $args, $call_before_after = true, $echo = true ) {
	extract($args, EXTR_OVERWRITE);
	
	$ops_html = '';
	
	foreach ( $meta_box['meta'] as $options ) {
		if ( ( '' == $meta_value || !$meta_value || !isset($meta_value)) && ( isset( $options['selected'] ) && $options['selected'] ) ) { 
        	$meta_value = $options['value'];
		}
		if ( $meta_value == $options['value'] ) { 
			$class = 'selected';
		} else {
			$class = '';
		}
		
		if(isset($meta_box['show_title'])){
			$title = isset($options['title'])? $options['title']: ucwords(str_replace('-', ' ', $options['value']));
		} else {
			$title = '';
		}

		// Check image src whether absolute url or relative url
		$img_src = ( '' != parse_url( $options['img'], PHP_URL_SCHEME) ) ? $options['img'] : get_template_directory_uri() . '/' . $options['img'];
		
		$ops_html .= sprintf('<a href="#" class="preview-icon %s"><img src="%s" title="%s" alt="%s" %s /></a>',
			$class, $img_src, $title, $options['value'],
			isset($meta_box['size'])? 'width="'.$meta_box['size'][0].'" height="'.$meta_box['size'][1].'"': ''
		);
	}
	
	$html = sprintf('%s<input type="hidden" name="%s" value="%s" class="val" />',
		$ops_html, $meta_box['name'], $meta_value);
		
	if(isset($meta_box['label']) && '' != $meta_box['label'])
		$html = sprintf('<label for="%s">%s %s</label>', $meta_box['name'], $html, $meta_box['label']);
	
	$html .= isset( $meta_box['description'] )? themify_meta_field_get_description($meta_box['description']) : '';

	if( isset( $meta_box['before'] ) ) $html = $meta_box['before'] . $html;
	if( isset( $meta_box['after'] ) )  $html .= $meta_box['after'];
	
	if($call_before_after)
		$html = themify_before_meta_field($args) . $html . themify_after_meta_field();
	
	if($echo) echo $html;
	else return $html;
}

/**
 * Generates select field disguised with a button
 * @param array $args Field settings
 * @param bool $call_before_after Whether to output common wrapping markup before and after the field
 * @param bool $echo Whether to echo or return the field
 * @since 1.3.2
 */
function themify_meta_field_dropdownbutton( $args, $call_before_after = true, $echo = true ) {
	$name = '';
	extract($args, EXTR_OVERWRITE);

	if(isset($meta_box['main']) && $meta_box['main']) {
		$metakey = $meta_box['name'];
		$meta_class = 'ddbtn-all';
	} else {
		$metakey = $meta_box['name'];
		$meta_class = 'ddbtn-sub';
	}
	
	$toggle_class = '';
    $ext_attr = '';
    $toggle_enable = false;
   	if( isset($meta_box['toggle']) ){
    	$toggle_class .= 'themify-toggle ';
    	$toggle_class .= (is_array($meta_box['toggle'])) ? implode(' ', $meta_box['toggle']) : $meta_box['toggle'];
    }
    if( isset($meta_box['default_toggle']) && $meta_box['default_toggle'] == 'hidden' ){
    	$ext_attr = 'style="display:none;"';
    }
    if( isset($meta_box['enable_toggle']) && $meta_box['enable_toggle'] == true ) {
    	$toggle_class .= ' enable_toggle';
    	$toggle_enable = true;
    }

	$first = '';
	$others = '';
	$default_icon = '';

	foreach($meta_box['states'] as $state) {
		if($state['value'] == $meta_value) {
			$first = '
			<div class="first-ddbtn">
				<a href="#" data-val="'.$state['value'].'" data-name="'.$state['name'].'" title="'.$state['title'].'">
					<img src="'.$state['icon'].'" title="'.$state['title'].'" />
					<span class="ddbtn-name">'.$meta_box['title'].'</span>
				</a>
			</div>';
			$selected = 'selected';
		} else {
			$selected = '';
		}
		$others .= '
			<div class="ddbtn">
				<a href="#" data-sel="'.$selected.'" data-val="'.$state['value'].'" data-name="'.$state['name'].'" title="'.$state['title'].'">
					<img src="'.$state['icon'].'" title="'.$state['title'].'" />
					<span class="ddbtn-label">'.$state['name'].'</span>
				</a>
			</div>';
		if(isset($state['default']) && $state['default']){
			$default_icon = $state['icon'];
		}
	}
	//'toggle_class' => $toggle_class,							'ext_attr' => $ext_attr,
	$html = sprintf('
		<div class="%s %s"><div class="dropdownbutton-group multi-ddbtn">
			<div id="%s" class="dropdownbutton-list multi-%s" data-name="%s" data-def-icon="%s">
			%s<div class="dropdownbutton">%s</div>
			</div>
			<input type="hidden" value="%s" class="widefat %s" id="%s" name="%s" />
		</div></div>',
		$toggle_class, $ext_attr,
		$metakey, $meta_class, $name, $default_icon, // group
		$first, $others, // dropdown
		$meta_value, $meta_class, $metakey, $metakey // hidden field
	);
		
	$html = themify_meta_field_get_label($html, $meta_box);
	
	$html .= isset( $meta_box['description'] )? themify_meta_field_get_description($meta_box['description']) : '';

	if( isset( $meta_box['before'] ) && $meta_box['before'] ) $html = $meta_box['before'] . $html;
	if( isset( $meta_box['after'] ) && $meta_box['after'] )  $html .= $meta_box['after'];
	
	if($call_before_after)
		$html = themify_before_meta_field($args) . $html . themify_after_meta_field();
	
	if($echo) echo $html;
	else return $html;
}

/**
 * Generates select field
 * @param array $args Field settings
 * @param bool $call_before_after Whether to output common wrapping markup before and after the field
 * @param bool $echo Whether to echo or return the field
 * @since 1.3.2
 */
function themify_meta_field_dropdown($args, $call_before_after = true, $echo = true){
	extract($args, EXTR_OVERWRITE);
	
	$ops_html = '';
	
	foreach($meta_box['meta'] as $option){
		$ops_html .= sprintf('<option value="%s" %s>%s</option>',
			$option['value'],
			isset($meta_value) && '' != $meta_value?
				selected($meta_value, $option['value'], false)
				: selected(isset( $option['selected'] )? $option['selected'] : '', true, false),
			$option['name']
		);
	}
	
	$html = sprintf('<select id="%s" name="%s">%s</select>',
		$meta_box['name'], $meta_box['name'], $ops_html);
		
	$html = themify_meta_field_get_label($html, $meta_box);
	
	$html .= isset( $meta_box['description'] )? themify_meta_field_get_description($meta_box['description']) : '';

	if( isset( $meta_box['before'] ) && $meta_box['before'] ) $html = $meta_box['before'] . $html;
	if( isset( $meta_box['after'] ) && $meta_box['after'] )  $html .= $meta_box['after'];
	
	if($call_before_after)
		$html = themify_before_meta_field($args) . $html . themify_after_meta_field();
	
	if($echo) echo $html;
	else return $html;
}

/**
 * Generates separator
 * @param array $args Field settings
 * @param bool $call_before_after Whether to output common wrapping markup before and after the field
 * @param bool $echo Whether to echo or return the field
 * @since 1.3.2
 */
function themify_meta_field_separator($args, $call_before_after = true, $echo = true){
	extract($args, EXTR_OVERWRITE);
	
	$html = isset($meta_box['meta']['html']) && '' != $meta_box['meta']['html']? $meta_box['meta']['html'] : '<hr class="meta_fields_separator" />';
	
	$html .= isset( $meta_box['description'] )? themify_meta_field_get_description($meta_box['description']) : '';
	
	$html = '<div class="themify_field_row clearfix ' . $toggle_class . '" ' . $ext_attr . '>'.$html.'</div>';
	
	if($echo) echo $html;
	else return $html;
}

/**
 * Generates checkbox field
 * @param array $args Field settings
 * @param bool $call_before_after Whether to output common wrapping markup before and after the field
 * @param bool $echo Whether to echo or return the field
 * @since 1.3.2
 */
function themify_meta_field_checkbox($args, $call_before_after = true, $echo = true){
	extract($args, EXTR_OVERWRITE);

	if($meta_value){ $checked = 'checked="checked"'; } else { $checked = ''; }
	
	$html = sprintf('<input type="checkbox" id="%s" name="%s" %s class="%s" data-val="%s" />',
		$meta_box['name'], $meta_box['name'], $checked, $meta_box['name'].'-toggle-control', $meta_box['name']);
		
	if(isset($meta_box['label']) && '' != $meta_box['label'])
		$html = sprintf('<label for="%s">%s %s</label>', $meta_box['name'], $html, $meta_box['label']);
	
	$html .= isset( $meta_box['description'] )? themify_meta_field_get_description($meta_box['description']) : '';
	
	if( isset( $meta_box['before'] ) && $meta_box['before'] ) $html = $meta_box['before'] . $html;
	if( isset( $meta_box['after'] ) && $meta_box['after'] )  $html .= $meta_box['after'];
	
	if($call_before_after)
		$html = themify_before_meta_field($args) . $html . themify_after_meta_field();
	
	if($echo) echo $html;
	else return $html;
}

/**
 * Generates text field
 * @param array $args Field settings
 * @param bool $call_before_after Whether to output common wrapping markup before and after the field
 * @param bool $echo Whether to echo or return the field
 * @since 1.3.2
 */
function themify_meta_field_textbox($args, $call_before_after = true, $echo = true){
	extract($args, EXTR_OVERWRITE);

	if ( isset( $meta_box['meta'] ) && isset( $meta_box['meta']['size'] ) && '' != $meta_box['meta']['size'] && 'small' == $meta_box['meta']['size'] ) {
        $class = 'small';	
    } else {
        $class = '';
    }
	
	$html = sprintf('<input type="text" id="%s" name="%s" value="%s" size="55" class="themify_input_field %s" />',
		$meta_box['name'], $meta_box['name'], $meta_value, $class);
		
	if(isset($meta_box['label']) && '' != $meta_box['label'])
		$html = sprintf('<label for="%s">%s %s</label>', $meta_box['name'], $html, $meta_box['label']);
	
	if ( isset( $meta_box['description'] ) )
		$html .= themify_meta_field_get_description( $meta_box['description'] );
	
	if( isset( $meta_box['before'] ) && $meta_box['before'] ) $html = $meta_box['before'] . $html;
	if( isset( $meta_box['after'] ) && $meta_box['after'] )  $html .= $meta_box['after'];
	
	if($call_before_after)
		$html = themify_before_meta_field($args) . $html . themify_after_meta_field();
	
	if($echo) echo $html;
	else return $html;
}
/**
 * Generates textarea field
 * @param array $args Field settings
 * @param bool $call_before_after Whether to output common wrapping markup before and after the field
 * @param bool $echo Whether to echo or return the field
 * @since 1.3.2
 */
function themify_meta_field_textarea($args, $call_before_after = true, $echo = true){
	extract($args, EXTR_OVERWRITE);

	if( isset( $meta_box['meta'] ) && isset( $meta_box['meta']['size'] ) && $meta_box['meta']['size'] != '' && $meta_box['meta']['size'] == 'small'){
        $class = 'small';	
    } else {
        $class = '';
    }
	
	$html = sprintf('<textarea id="%s" name="%s" size="55" rows="4" class="themify_input_field %s">%s</textarea>',
		$meta_box['name'], $meta_box['name'], $class, $meta_value);
		
	$html = themify_meta_field_get_label($html, $meta_box);
	
	$html .= isset( $meta_box['description'] )? themify_meta_field_get_description($meta_box['description']) : '';
	
	if( isset( $meta_box['before'] ) && $meta_box['before'] ) $html = $meta_box['before'] . $html;
	if( isset( $meta_box['after'] ) && $meta_box['after'] )  $html .= $meta_box['after'];
	
	if($call_before_after)
		$html = themify_before_meta_field($args) . $html . themify_after_meta_field();
	
	if($echo) echo $html;
	else return $html;
}

/**
 * Returns label before or after field
 * @param string $html field markup
 * @param array $meta_box field definition in key => value format
 * @param bool $echo Whether to echo or return the field
 * @return string field markup with label
 * @since 1.3.2
 */
function themify_meta_field_get_label($html, $meta_box, $echo = false){
	if(isset($meta_box['label']) && '' != $meta_box['label']){
		if(isset($meta_box['label_before']) && $meta_box['label_before']){
			$html = sprintf('<label for="%s">%s %s</label>', $meta_box['name'], $meta_box['label'], $html);
		} else {
			$html = sprintf('<label for="%s">%s %s</label>', $meta_box['name'], $html, $meta_box['label']);
		}
	}
	if($echo) echo $html;
	else return $html;
}

function themify_meta_field_get_description($desc){
	return (isset($desc) && '' != $desc)? '<span class="themify_field_description">'.$desc.'</span>' : '';
}
function themify_before_meta_field($args){
	extract($args);

	$html = '
	<input type="hidden" name="' . $meta_box['name'] . '_noncename" id="' .  $meta_box['name'] . '_noncename" value="' . wp_create_nonce( plugin_basename(__FILE__) ) . '" />
	<div class="themify_field_row clearfix ' . $toggle_class . '" ' . $ext_attr . '>
		<div class="themify_field_title">' . $meta_box['title'] . '</div>
		<div class="themify_field themify_field-'.$meta_box['type'].'">';

	$html .= isset($meta_box['meta']['before'])? $meta_box['meta']['before'] : '';
	return $html;
}

function themify_after_meta_field($after = null){
	$html = isset($after)? $after : '';
	$html .= '
		</div>
	</div><!--/themify_field_row -->';
	return $html;
}
	
	/**
	 * Save Custom Write Panel Data
	 * @param number
	 * @return mixed
	 */
	function themify_save_postdata( $post_id ) {  
		global $post, $themify_write_panels;  
		if(isset($_POST['themify_proper_save']) && $_POST['themify_proper_save'] != '') {
			foreach($themify_write_panels as $write_panel){
				
				foreach($write_panel['options'] as $meta_box) {
					if ( 'page' == $_POST['post_type'] ) {
						if ( !current_user_can( 'edit_page', $post_id ))
							return $post_id;
					} else {
						if ( !current_user_can( 'edit_post', $post_id ))
							return $post_id;
					}
					if('multi' == $meta_box['type']){
						// Grouped fields
						foreach ($meta_box['meta']['fields'] as $field) {
							$data = $_POST[$field['name']];
							if('' == get_post_meta($post_id, $field['name']))
								add_post_meta($post_id, $field['name'], $data, true);
							elseif($data != get_post_meta($post_id, $field['name'], true))
								update_post_meta($post_id, $field['name'], $data);
						}
					} else {
						// Single field
						$data = $_POST[$meta_box['name']];
						if('' == get_post_meta($post_id, $meta_box['name']))
							add_post_meta($post_id, $meta_box['name'], $data, true);
						elseif($data != get_post_meta($post_id, $meta_box['name'], true))
							update_post_meta($post_id, $meta_box['name'], $data);
					}
				}  
			}
		} else {
			if ( isset( $post ) && isset( $post->ID ) ) {
				return $post->ID;
			}
			return false;
		}
	}   
	
	/**
	 * Image Helper - Echoes themify_get_image
	 * @param string $options Format string.
	 */
	function themify_image($options){
		echo themify_get_image($options);
	}
	
	/**
	 * Returns the post image, either from Themify Custom Panel fields or from WordPress Featured Image.
	 * @param string $args Format string.
	 * @return string String with <img> tag and optional content prepended and/or appended
	 */
	function themify_get_image( $args ) {
		global $post, $image_width, $image_height, $themify;
		$post_query_category = $themify->query_category;

		$data = themify_get_data();

		parse_str($args, $options);
		foreach( $options as $key => $val ) {
			$$key = $val;
		}

		if ( ! isset( $setting ) ) $setting = '';
		if ( ! isset( $before ) ) $before = '';
		if ( ! isset( $after ) ) $after = '';
		if ( ! isset( $width ) ) $width = '';
		if ( ! isset( $height ) ) $height = '';
		if ( ! isset( $class ) ) $class = '';
		if ( ! isset( $id ) ) $id = '';

		if ( ! isset( $alt ) || '' == $alt ) {
			$alt = isset( $post ) && is_object( $post ) ? get_the_title( $post->ID ) : '';
		}
		if ( isset( $crop ) && ( false == $crop || 'false' == $crop ) ) {
			$crop = '';
		} else {
			$crop = "&amp;zc=1";
		}
		if ( isset( $a ) && $a != '' ) {
			$a = "&amp;a=".$a;
		} else {
			if( isset( $data['setting-img_settings_crop_option'] ) && $data['setting-img_settings_crop_option'] != '' )
				$a = "&amp;a=".$data['setting-img_settings_crop_option'];
			else
				$a = '';
		}
		$check = false;
		if( isset( $q ) && $q != '' ) {
			$q = "&amp;q=".$q;
		} else {
			if ( isset( $data['setting-img_settings_quality'] ) && $data['setting-img_settings_quality'] != '' )
				$q = "&amp;q=".$data['setting-img_settings_quality'];
			else
				$q = '';
		}

		//$ignore = (!$ignore || !isset($ignore) || $ignore == "") ? false : true;
		if ( ! isset( $src ) || '' == $src ) {
			if( isset( $field_name ) && $field_name != '' ) {
				$fields = explode(",", $field_name);
				foreach( $fields as $field ) {
					$field = trim($field);
					if( $field == 'wp_thumb' && function_exists( 'has_post_thumbnail' ) ) {
						if( has_post_thumbnail() && ! $check ) {
							$temp = themify_prep_image( get_the_post_thumbnail( $post->ID ) );
							$src = isset( $temp['src'] )? $temp['src'] : '';
							$class .= isset( $temp['class'] )? ' ' . $temp['class'] : '';
							if( isset($temp['alt']) && '' == $alt && $temp['alt'] != '' ) {
								$alt = $temp['alt'];
							}
							$check = true;
						}
					} else {
						if(get_post_meta($post->ID, $field, true) != '' && get_post_meta($post->ID, $field, true) && !$check){
							$src = get_post_meta($post->ID, $field, true);
							$check = true;
						}
					}
				}
			} else {
				$fields = array('Feature Image', 'feature_image', 'Post Image', 'post_image', 'image');
				foreach ( $fields as $field ) {
					if ( isset( $post ) && is_object( $post ) && get_post_meta($post->ID, $field, true) != '' && !$check ) {
						$src = get_post_meta($post->ID, $field, true);
						$check = true;
					}
				}
				if ( function_exists( 'has_post_thumbnail' ) ) {
					if ( has_post_thumbnail() && ! $check ) {
						$temp = themify_prep_image(get_the_post_thumbnail());
						$src = isset( $temp['src'] )? $temp['src'] : '';
						$class .= isset( $temp['class'] )? ' ' . $temp['class'] : '';
						if( isset( $temp['alt'] ) && '' == $alt && $temp['alt'] != '' ) {
							$alt = $temp['alt'];
						}
						$check = true;
					}
				}
				if ( ! $check ) {
					$tags = array( 'img', 'embed', 'iframe' );
					$content = get_the_content();
					foreach ( $tags as $tag ) {
						$count = substr_count( $content, '<'.$tag );
						if ( $count >= 1 && ! $check ) {
							$start = strpos($content, '<'.$tag, 0);
							$pos = substr($content, $start);
							$end = strpos($pos, '>');
							$temp = themify_prep_image( substr( $pos, 0, $end + 1 ) );
							$ext = explode( '.', $temp['src'] );
							$ext = strtolower( $ext[(count($ext)-1)] );
							if ( strpos( $temp['src'], '.' ) && ( $ext == 'jpg' || $ext == 'jpeg' || $ext == 'gif' || $ext == 'png' ) ) {
								$check = true;
								$src = isset( $temp['src'] )? $temp['src'] : '';
								$class .= isset( $temp['class'] )? $temp['class'] : '';
								if ( isset( $temp['alt'] ) && '' == $alt && $temp['alt'] != '' ) {
									$alt = $temp['alt'];
								}
							}
						}
					}
				}
			}
		}

		// Get width/height from custom fields in single post
		$cfwidth = isset( $post ) && is_object( $post ) ? get_post_meta( $post->ID, 'image_width', true ) : '';
		$cfheight = isset( $post ) && is_object( $post ) ? get_post_meta($post->ID, 'image_height', true) : '';

		// Set width
		if( in_the_loop() && ( ! isset( $ignore ) || ! $ignore ) ) {
			if( is_home() || is_archive() || is_search() ) {
				if( isset( $data["setting-{$setting}_width"] ) && $data["setting-{$setting}_width"] != '' && $setting != '' ) {
					// Use value defined in default index or single post layout
					$width = $data["setting-".$setting."_width"];
				} elseif( isset( $image_width ) && $image_width != '' && ! $ignore ) {
					$width = $image_width;
				} elseif( $cfwidth ) {
					$width = $cfwidth;
				} elseif( isset( $w ) && $w != '' ) {
					$width = $w;
				}
			} if( $post_query_category != '' ) {
				// Use value defined in query category page
				if( $themify->post_image_width )
					$width = $themify->post_image_width;
				else
					$width = $w;

			} if( is_single() ) {
				// Use value defined in single post custom panel
				if( $cfwidth )
					$width = $cfwidth;
				elseif( isset( $data["setting-{$setting}_width"] ) && $data["setting-{$setting}_width"] != '' && $setting != '' ) {
					$width = $data["setting-{$setting}_width"];
				}
				elseif( isset( $w ) && $w != '' ) {
					$width = $w;
				}
			}
		} elseif( isset( $image_width ) && $image_width != '' && ! $ignore ) {
			$width = $image_width;
		} elseif( !in_the_loop() && isset( $data["setting-{$setting}_width"] ) && $data["setting-{$setting}_width"] != '' && $setting != '' ){
			$width = $data["setting-".$setting."_width"];
		} else {
			if( isset( $w ) && $w != '' ) {
				$width = $w;
			}
		}

		//Set height
		if( in_the_loop() && ( ! isset( $ignore ) || !$ignore ) ) {
			if( is_home() || is_archive() || is_search() ) {
				if ( isset( $data["setting-{$setting}_height"] ) && $data["setting-{$setting}_height"] != '' && $setting != '' ) {
					// Use value defined in default index or single post layout
					$height = $data["setting-".$setting."_height"];
				} elseif( isset( $image_height ) && $image_height != '' && ! $ignore ) {
					$height = $image_height;
					//echo 'height in image_height != "" && isset(image_height) !ignore ' . $height;
				} else {
					if ( ( isset( $data['setting-img_settings_vertical_crop_option'] ) && 'no' == $data['setting-img_settings_vertical_crop_option'] ) || 0 == $cfheight ) {
						$height = '';
					} elseif( $cfheight ) {
						$height = $cfheight;
					} elseif( $themify->height )
							$height = $themify->height;
					else {
						if( isset( $h ) && $h != '' ) {
							$height = $h;
						}
					}
					//echo 'height in home archive search ' . $height;
				}
			} if( $post_query_category != '' ) {
				// Use value defined in query category page
				if( $themify->post_image_height )
					$height = $themify->post_image_height;
				else
					$height = $h;
				//var_dump($themify);
				//echo 'height in qc page ' . $height;
			} if( is_single() ) {
				// Use value defined in single post custom panel
				if( $cfheight )
					$height = $cfheight;
				elseif( isset( $data["setting-{$setting}_height"] ) && $data["setting-{$setting}_height"] != '' && $setting != '' ){
					$height = $data["setting-{$setting}_height"];
				} else {
					if( ( isset( $data['setting-img_settings_vertical_crop_option'] ) && 'no' == $data['setting-img_settings_vertical_crop_option'] ) || 0 == $cfheight ) {
						$height = '';
					}
					if( $themify->height ) {
						$height = $themify->height;
					} else {
						if( isset( $h ) && $h != '' ) {
							$height = $h;
						}
					}
				}
			}
		} elseif( isset( $image_height ) && $image_height != '' && !$ignore) {
			$height = $image_height;
		} elseif( !in_the_loop() && isset( $data["setting-{$setting}_height"] ) && $data["setting-{$setting}_height"] != '' && $setting != '' ){
			$height = $data["setting-{$setting}_height"];
		} else {
			if ( isset( $data['setting-img_settings_vertical_crop_option'] ) && 'no' == $data['setting-img_settings_vertical_crop_option'] ) {
				$height = '';
			} else {
				if($h != '' && isset($h)){
					$height = $h;
				}
			}
		}
		// If height is 0, the variable is removed
		if ( 0 == $height ) unset($height);

		// Set custom classes if specified
		if ( isset( $class ) && $class != '') {
			$class = "class='".$class."'";
		}
		if ( isset( $id ) && $id != '' ) {
			$id = "id='".$id."'";
		}

		$p_height = isset( $height ) && $height != '' ? "height='".$height."'" : "";
		$p_width = isset( $width ) && $width != '' ? "width='".$width."'" : "";

		/**
		 * User size selection: one of WP Featured Image sizes, img.php or blank
		 * @var string $feature_size
		 * @since 1.1.5
		 */
		global $feature_size_page;
		$base_feature_size = apply_filters('themify_global_feature_size', 'large');
		//check if global size is set
		if( themify_check('setting-img_settings_use') && '' != themify_get('setting-global_feature_size')) {
			//set feature size
			$feature_size = themify_get('setting-global_feature_size');
		} elseif( '' == themify_get('setting-global_feature_size') ) {
			$feature_size = $base_feature_size;
		}
		//echo '<br/>global/default feature ',$feature_size;

		if( is_front_page() ){
			if( '' != themify_get('setting-image_post_feature_size') && 'blank' != themify_get('setting-image_post_feature_size') ){
				//override size with default index layout size
				$feature_size = themify_get('setting-image_post_feature_size');
				//echo '<br/>is home, using default index layout ',$feature_size;
			} else {
				//nothing in default index layout size
				//$feature_size = 'medium';
				//echo '<br/>is home, nothing in default index layout, using ',$feature_size;
			}
		}

		if ( is_singular() && in_the_loop() ) {
			//echo '<p>is singular</p>';
			//check if post size is set
			if ( '' != themify_get( 'feature_size' ) ) {
				//override global size with post's custom field size
				$feature_size = themify_get( 'feature_size' );
				//echo '<br/>singular, size selected in post drop down ',$feature_size;
			}
			//check if default size for post layout is set
			elseif ( '' != themify_get( 'setting-image_post_single_feature_size' ) && 'blank' != themify_get( 'setting-image_post_single_feature_size' ) ) {
				//override global size with post's custom field size
				$feature_size = themify_get( 'setting-image_post_single_feature_size' );
				//echo '<br/>singular, nothing selected in post drop down, using single post layout ',$feature_size;
			}
		}
		//are we on a page? is query category size set?
		if ( '' != $post_query_category ) {
			//echo '<p>is query category</p>';
			if ( '' ) {
				$feature_size = '';
			}
			if ( '' != themify_get( 'setting-image_post_feature_size' ) && 'blank' != themify_get('setting-image_post_feature_size') ) {
				//override custom field size with default index layout size
				$feature_size = themify_get( 'setting-image_post_feature_size' );
				//echo '<br/>default index layout ',$feature_size;
			}
			if( '' != $feature_size_page && 'blank' != $feature_size_page && isset( $feature_size_page ) ) {
				//override custom field size with query category size
				$feature_size = $feature_size_page;
			}
			//echo '<br/>query category page ',$feature_size_page;
		}
		//are we on an archive page
		if ( is_archive() && ( ! isset( $post_query_category ) || '' == $post_query_category ) ) {
			//echo '<p>is archive</p>';
			if ( themify_check('setting-img_settings_use') ) {
				//set feature size
				if ( '' != themify_get('setting-global_feature_size') ) {
					$feature_size = themify_get('setting-global_feature_size');
				}
				elseif ( '' == $feature_size ) {
					$feature_size = 'medium';
				}
				if ( '' != themify_get( 'setting-image_post_feature_size' ) && 'blank' != themify_get('setting-image_post_feature_size') ){
					$feature_size = themify_get( 'setting-image_post_feature_size' );
				}
			}
			//echo '<br/>archive ',$feature_size;
		}

		/**
		 * For Themify custom post types slider, menu and highlights
		 */
		$thecpt = isset( $post ) && is_object( $post ) ? get_post_type( $post->ID ) : '';
		$iscpt = in_array( $thecpt, themify_specific_post_types() );
		if ( $iscpt ) {
			global $feature_size_cpt;
			$cptquery = $thecpt . '_category';
			//echo '<br/>is a Themify custom post type';
			if ( ! isset( $feature_size_cpt ) ) {
				if ( '' != themify_get( 'setting-global_feature_size' ) ) {
					//echo '<br/>using global featured image size';
					$feature_size = themify_get( 'setting-global_feature_size' );
				} elseif ( '' == themify_get( 'setting-global_feature_size' ) ) {
					//echo '<br/>global featured image size, use medium';
					$feature_size = $base_feature_size;
				}

				if ( '' != themify_get( 'feature_size' ) ) {
					//override global size with post's custom field size
					$feature_size = themify_get( 'feature_size' );
					//echo '<br/>custom post type, size selected in cpt drop down ',$feature_size;
				}
			} else {
				//echo '<br/>is custom post type query category';
				//for pages like Rezo, that have an additional drop down menu
				$feature_size = $feature_size_cpt;
				//echo '<br/>custom post type, size selected in cpt Query drop down ',$feature_size;
			}
		}
		/* end themify custom post types  */


		//if the call has been made outside the loop
		if ( ! in_the_loop() ) {
			$feature_size = 'thumbnail';
		}

		//if an image_size parameter was passed, for example
		if ( isset( $image_size ) ) {
			$feature_size = $image_size;
		}

		$intheloop = in_the_loop() ? 'Yes' : 'No';
		//echo '<br/><strong>In the loop? ' , $intheloop , '</strong>';
		//echo '<br/>Final size to be used is ' , $feature_size;

		//we have a path so let's proceed to show our image
		if ( isset( $src ) && $src != '' && $src ) {
			//is img.php enabled in theme settings and user did not selected a Featured Image size?
			if( ! isset($data['setting-img_settings_use']) || '' == $data['setting-img_settings_use'] || !$data['setting-img_settings_use'] ){

				if ( has_post_thumbnail( $post->ID ) && in_the_loop() ) {

					// Obtain original file for featured image
					if ( false != ( $src_full = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'full' ) ) ) {

						// Parse original src file and original featured image
						$parse_full = parse_url( $src_full[0] );
						$parse_src = parse_url( $src );
						$info_full = pathinfo( $parse_full['path'] );
						$info_src = pathinfo( $parse_src['path'] );

						// Compare base filenames
						if ( $info_full['filename'] == $info_src['filename'] ) {
							// They are the same, let's check for a large size
							if ( false != ( $src_large = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'large' ) ) ) {
								// Change src to use large size of featured image
								$src = $src_large[0];
							}
						}
					}
				}

				$imgphp = THEME_URI . '/themify/img.php';
				if( is_file(THEME_DIR . '/themify/custom-img.php') )
					$imgphp = THEME_URI . '/themify/custom-img.php';

				// Filter $src so it can be manipulated
				$src = apply_filters('themify_image_script_src', $src);

				if ( ! isset( $height ) ) $height = '';

				// If no large size is available, we simply use original one
				return stripslashes($before)."<img src='$imgphp?src=$src&amp;w=$width&amp;h=".$height.$crop.$q.$a."' alt='$alt' $class $id $p_width $p_height />".stripslashes($after);

			} elseif( !in_the_loop() ){
				return /*'<p>Not in the loop</p>'.*/ stripslashes($before)."<img src='$src' alt='$alt' $class $id $p_width $p_height />".stripslashes($after);
			} else {
				//img.php is disabled in theme settings or user selected a Featured Image size

				//check if user entered certain dimensions
				$feature_width = themify_get('image_width');
				$feature_height = themify_get('image_height');

				//user did not selected a size
				if( '' == $feature_size || !has_post_thumbnail() ){
					$id = isset( $id )? $id : '';
					$class = isset( $class )? $class : '';
					$before = isset( $before )? $before : '';
					$after = isset( $after )? $after : '';
					//output original image, useful for backwards compatibility
					return /*'<p>No thumbnail set, using original</p>' .*/ stripslashes($before)."<img src='".$src."' alt='".$alt."' $id $class $p_width $p_height />".stripslashes($after);
				} else {
					//user selected a size, so let's assume he set up an image as featured image
					/**
					 * Store post thumbnail properties
					 * [0] => url [1] => width [2] => height
					 * @var array $thumb
					 */
					$thumb = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), $feature_size );
					//echo '<p>WP Feature image: '. $feature_size .'</p>';

					/**
					 * Start by clearing dimensions to avoid the math formula
					 *
					 * For a singular post/page
					 * 		if dimensions are set in custom panel, use them
					 * 		else if dimensions are set in setting single post, use them
					 * 		else do nothing
					 *
					 * For a query category page
					 * 		if dimensions are set in custom panel, use them
					 * 		else do nothing
					 *
					 * For an archive page
					 * 		if dimensions are set in setting index layout, use them
					 * 		else do nothing
					 *
					 * For a custom post type
					 * 		if dimensions are set in custom panel, use them
					 * 		else do nothing
					 *
					 */

					// Clear dimensions to start
					if( ! isset( $ignore ) || !$ignore ){
						$p_width  = 'width="'.$themify->width.'"';
						$p_height = 'height="'.$themify->height.'"';
					}

					// For singular views
					if( is_singular() && ( ! isset( $ignore ) || !$ignore ) ){
						if( isset($feature_width) )
							$p_width = 'width="'.$feature_width.'"';
						elseif( '' != $data["setting-".$setting."_width"] && '' != $setting )
							$p_width = 'width="'.$data["setting-".$setting."_width"].'"';

						if( isset($feature_height) )
							$p_height = 'height="'.$feature_height.'"';
						elseif( '' != $data["setting-".$setting."_height"] && '' != $setting )
							$p_height = 'height="'.$data["setting-".$setting."_height"].'"';
					}

					// For query pages
					if( ( ! isset( $ignore ) || !$ignore ) && isset( $post_query_category ) ){
						global $feature_size_query_page;
						$queryw = get_post_meta($feature_size_query_page->ID, 'image_width', true);
						$queryh = get_post_meta($feature_size_query_page->ID, 'image_height', true);
						if( '' != $queryw ){
							$p_width = 'width="'.$queryw.'"';
						}
						if( '' != $queryh ){
							$p_height = 'height="'.$queryh.'"';
						}
					}

					// For archive pages and home archive
					if( ( ! isset( $ignore ) || !$ignore ) && (is_home() || is_archive()) ){
						if( isset( $data["setting-{$setting}_width"] ) && '' != $data["setting-{$setting}_width"] && '' != $setting ){
							$p_width = 'width="'.$data["setting-{$setting}_width"].'"';
						}
						if( isset( $data["setting-{$setting}_height"] ) && '' != $data["setting-{$setting}_height"] && '' != $setting ){
							$p_height = 'height="'.$data["setting-{$setting}_height"].'"';
						}
					}

					// For custom post types
					if( ( ! isset( $ignore ) || !$ignore ) && $iscpt ){
						// is it a custom post type query page?
						if( isset($feature_size_cpt) ){
							global $feature_size_query_page;
							$cptw = get_post_meta($feature_size_query_page->ID, $thecpt.'_image_width', true);
							$cpth = get_post_meta($feature_size_query_page->ID, $thecpt.'_image_height', true);
						}
						// is not a custom post type query page so grab the panel settings
						else {
							$cptw = get_post_meta($post->ID, 'image_width', true);
							$cpth = get_post_meta($post->ID, 'image_height', true);
						}
						if( '' != $cptw ){
							$p_width = 'width="'.$cptw.'"';
						}
						if( '' != $cpth ){
							$p_height = 'height="'.$cpth.'"';
						}
					}

					if( 'height="0"' == $p_height ){
						$p_height = '';
					}

					$id = isset( $id )? $id : '';
					$class = isset( $class )? $class : '';
					$before = isset( $before )? $before : '';
					$after = isset( $after )? $after : '';
					
					return stripslashes($before) . /*'using internal img' .*/ "<img src='{$thumb['0']}' alt='$alt' $id $class $p_width $p_height />" . stripslashes($after);
					
				}
			}
		}
	}

/**
 * Sets the WP Featured Image size selected for Query Category pages
 * @since 1.1.5 
 */
function themify_feature_size_page() {
	global $feature_size_page, $feature_size_cpt, $feature_size_query_page, $post;
	$feature_size_query_page = $post;
	/** Get size for WP Featured Image @var String $feature_size_page*/
	$feature_size_page = themify_get( 'feature_size_page' );
	$types = themify_specific_post_types();
	foreach ( $types as $type ) {
		$fs_cpt = themify_get( 'feature_size_' .$type );
		if ( isset( $fs_cpt ) ) {
			$feature_size_cpt = $fs_cpt;
		}
	}
}
add_action( 'template_redirect', 'themify_feature_size_page' );

if ( ! function_exists( 'themify_image_url' ) ) {
	/**
	 * Returns the featured image url
	 * @param bool $echo Specify to echo or return the url
	 * @param string $size The image size to return
	 * @return void|string
	 */
	function themify_image_url( $echo = false, $size = 'full' ) {
		$url = '';
		if ( has_post_thumbnail() ) {
			$image = wp_get_attachment_image_src( get_post_thumbnail_id(), $size );
			$url = $image[0];
		}
		$url = apply_filters( 'themify_image_url', $url );
		if ( $echo ) {
			echo $url;
			return;
		} else {
			return $url;
		}
	}
}

	/**
	 * Image Helper - Prep Image
	 * @param $tag
	 * @return array
	 */
	function themify_prep_image( $tag ) {
		preg_match_all('/(alt|title|src|class)=("[^"]*")/i', $tag, $image);
		foreach($image[0] as $attr){
			parse_str($attr, $tempAttr);
			foreach($tempAttr as $key => $val){
				$tempArray[$key] = str_replace(array('"',"'"),array('',''),$val);	
			}
		}
		$image = isset( $tempArray )? $tempArray : array( 'src' => '', 'alt' => '', 'title' => '' );
		if ( strpos( $image['src'], 'youtube.com' ) || strpos( $image['src'], 'vimeo.com' ) ) {
			$image['src'] = themify_video_image( $image['src'] );
		}
		return array(
			'src' => trim( $image['src'], "\\" ),
			'alt' => $image['alt'],
			'title' => isset( $image['title'] )? $image['title'] : ''
		);
	}
	
	///////////////////////////////////////////
	// Check if file exists
	///////////////////////////////////////////
	function themify_check_remote_file($url){
		if(function_exists("curl_init")){
			$ch = curl_init(); 
			curl_setopt($ch, CURLOPT_URL,$url);
			curl_setopt($ch, CURLOPT_NOBODY, 1);
			curl_setopt($ch, CURLOPT_FAILONERROR, 1);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1); 
			if(curl_exec($ch)!==FALSE){
				return true;
			} else {
				return false;
			}
		} else {
			return is_readable($url);
		}
	}

	///////////////////////////////////////////
	// Vimeo / Youtube Thumbnail grab
	///////////////////////////////////////////
	function themify_video_image($url){
		$image_url = parse_url($url);
		if($image_url['host'] == 'www.youtube.com' || $image_url['host'] == 'youtube.com'){
			parse_str($image_url['query'], $query);
			if(isset($query['v']) && $query['v'] != ""){
				$id = $query['v'];
			} else {
				$path = explode("/",$image_url['path']);
				$id = $path[count($path)-1];
			}
			return themify_https_esc('http://img.youtube.com/vi/').$id."/hqdefault.jpg";				
		} else if($image_url['host'] == 'www.vimeo.com' || $image_url['host'] == 'vimeo.com' || $image_url['host'] == 'player.vimeo.com'){
			parse_str($image_url['query'], $query);
			if(isset($query['clip_id']) && $query['clip_id'] != ""){
				$id = $query['clip_id'];
			} else {
				$path = explode("/",$image_url['path']);
				$id = $path[(count($path)-1)];
			}
			if(function_exists("file_get_contents")){
				$hash = unserialize(file_get_contents(themify_https_esc('http://vimeo.com/api/v2/video/').$id.".php"));
				if(isset($hash[0]) && $hash[0] != ''){
					return $hash[0]["thumbnail_large"]; 
				}
			}
		}
	}
	
	///////////////////////////////////////////
	// Variable Checker
	///////////////////////////////////////////
	function themify_check($var){
		global $post;
		$data = themify_get_data();
		if( isset($data[$var]) && $data[$var] != '' ){
			return true;
		} elseif(is_object($post) && get_post_meta($post->ID, $var, true) != '' && get_post_meta($post->ID, $var, true)){
			return true;
		} else {
			return false;	
		}
	}
	
	///////////////////////////////////////////
	// Version Getter
	///////////////////////////////////////////
	function themify_get( $var ) {
		global $post;
		$data = themify_get_data();
		if ( isset( $data[$var] ) && $data[$var] != '' ) {
			return $data[$var];
		} else if( is_object( $post ) && get_post_meta( $post->ID, $var, true ) != '' ) {
			return get_post_meta( $post->ID, $var, true );
		}
	}
	
	/**
	 * Return post content with the proper filters applied
	 * @param string $more_link_text Text to use for (more...)
	 * @param int $stripteaser Optional. Strip teaser content before the more text
	 * @param string $more_file
	 * @return string Post content
	 */
	function themify_get_content($more_link_text = '(more...)', $stripteaser = 0, $more_file = '') {
		$content = get_the_content($more_link_text, $stripteaser, $more_file);
		$content = apply_filters('the_content', $content);
		$content = str_replace(']]>', ']]&gt;', $content);
		return $content;
	}
	///////////////////////////////////////////
    // Themify Excerpt
    ///////////////////////////////////////////	
	function themify_excerpt($limit) {
		$excerpt = explode(' ', get_the_excerpt(), $limit);
		if (count($excerpt)>=$limit) {
			array_pop($excerpt);
			$excerpt = implode(" ",$excerpt).'...';
		} else {
			$excerpt = implode(" ",$excerpt);
		}
			$excerpt = preg_replace('`[[^]]*]`','',$excerpt);
		return $excerpt;
	}

	///////////////////////////////////////
	// Load theme languages
	///////////////////////////////////////
	load_theme_textdomain( 'themify', THEME_DIR.'/languages' );

	
	/**
	 * Echoes page navigation
	 * @uses themify_get_pagenav
	 * @since 1.0.0
	 */
	function themify_pagenav($before = '', $after = '', $query = false) {
		echo themify_get_pagenav($before, $after, $query);
	}
	/**
	 * Returns page navigation
	 * @param string Markup to show before pagination links
	 * @param string Markup to show after pagination links
	 * @param object WordPress query object to use
	 * @return string
	 * @since 1.2.4
	 */
	function themify_get_pagenav($before = '', $after = '', $query = false) {
		global $wpdb, $wp_query;
		
		if( false == $query ){
			$query = $wp_query;
		}
		$request = $query->request;
		$posts_per_page = intval(get_query_var('posts_per_page'));
		$paged = intval(get_query_var('paged'));
		$numposts = $query->found_posts;
		$max_page = $query->max_num_pages;
	
		if(empty($paged) || $paged == 0) {
			$paged = 1;
		}
		$pages_to_show = apply_filters('themify_filter_pages_to_show', 5);
		$pages_to_show_minus_1 = $pages_to_show-1;
		$half_page_start = floor($pages_to_show_minus_1/2);
		$half_page_end = ceil($pages_to_show_minus_1/2);
		$start_page = $paged - $half_page_start;
		if($start_page <= 0) {
			$start_page = 1;
		}
		$end_page = $paged + $half_page_end;
		if(($end_page - $start_page) != $pages_to_show_minus_1) {
			$end_page = $start_page + $pages_to_show_minus_1;
		}
		if($end_page > $max_page) {
			$start_page = $max_page - $pages_to_show_minus_1;
			$end_page = $max_page;
		}
		if($start_page <= 0) {
			$start_page = 1;
		}
		$out = '';
		if ($max_page > 1) {
			$out .=  $before.'<div class="pagenav clearfix">';
			if ($start_page >= 2 && $pages_to_show < $max_page) {
				$first_page_text = "&laquo;";
				$out .=  '<a href="'.get_pagenum_link().'" title="'.$first_page_text.'" class="number">'.$first_page_text.'</a>';
			}
			if($pages_to_show < $max_page)
				$out .= get_previous_posts_link('&lt;');
			for($i = $start_page; $i  <= $end_page; $i++) {
				if($i == $paged) {
					$out .=  ' <span class="number current">'.$i.'</span> ';
				} else {
					$out .=  ' <a href="'.get_pagenum_link($i).'" class="number">'.$i.'</a> ';
				}
			}
			if($pages_to_show < $max_page)
				$out .= get_next_posts_link('&gt;');
			if ($end_page < $max_page) {
				$last_page_text = "&raquo;";
				$out .=  '<a href="'.get_pagenum_link($max_page).'" title="'.$last_page_text.'" class="number">'.$last_page_text.'</a>';
			}
			$out .=  '</div>'.$after;
		}
		return $out;
	}

	///////////////////////////////////////////
	// Create Recursive Directories
	///////////////////////////////////////////
	function themify_create_dirs($path){
		if (!is_dir($path)){
			$directory_path = "";
			$directories = explode("/",$path);
			array_pop($directories);
			foreach($directories as $directory){
				$directory_path .= $directory."/";
				if (!is_dir($directory_path)){
					mkdir($directory_path);
					chmod($directory_path, 0777);
				}
			}
		}
	}
	
	///////////////////////////////////////////
	// Recursive folder & file chmod change
	///////////////////////////////////////////
	function themify_chmodr($path, $filemode){ 
		if (!is_dir($path)) 
			return chmod($path, $filemode); 
		$dh = opendir($path); 
		while (($file = readdir($dh)) !== false) { 
			if($file != '.' && $file != '..') { 
				$fullpath = $path.'/'.$file; 
				if(is_link($fullpath)) 
					return FALSE; 
				elseif(!is_dir($fullpath) && !chmod($fullpath, $filemode)) 
						return FALSE; 
				elseif(!themify_chmodr($fullpath, $filemode)) 
					return FALSE; 
			} 
		} 
		closedir($dh); 
		if(chmod($path, $filemode)){ 
			return TRUE; 
		} else { 
			return FALSE; 
		}
	}

/**
 * Returns a PLUPLOAD instance. If it's a multisite, checks user quota and shows message if it's not enough to continue upload files.
 * @param $id String
 * @param $params Array $label = '', $thumbs = false, $filelist = false, $multiple = false, $message = '', $fallback = ''
 */
function themify_get_uploader( $id = '', $args = array() ){

	$defaults = array(
		'label'		=> __('Upload', 'themify'),
		'preset'	=> false,
		'preview'   => false,
		'tomedia'	=> false,
		'topost'	=> '',
		'fields'	=> '',
		'featured'	=> '',
		'message'	=> '',
		'fallback'	=> '',
		'dragfiles' => false,
		'confirm'	=> '',
		'medialib'	=> false,
		'formats'	=> 'jpg,jpeg,gif,png,ico,zip,txt,svg',
		'type'		=> 'image'
	);
	$args = wp_parse_args($args, $defaults);
	// Extract $label, $preset, $thumbs, $filelist, $multiple, $message, $fallback, $confirm
	extract( $args );

	$upload_visible = false;

	$html = '';

	if ( is_multisite() && !is_upload_space_available() ) {
		if( '' != $message ){
			$html = $message;
		} else {
			$html = '<small>' . sprintf( __( 'Sorry, you have filled your %s MB storage quota so uploading has been disabled.', 'themify' ), get_space_allowed() ) . '</small>';
		}
	} else {
		if( '' != $fallback )
			$html = $fallback;
		else {
			ob_start();
			// $id is the name of form field. File urls will be submitted in $_POST using this key.
			// If $id == "file" then $_POST["file"] will have all the file urls
			?>
			<!--<input type="hidden" name="<?php echo $id; ?>" id="<?php echo $id; ?>" value="" />-->
			<?php if( $dragfiles ){ ?>
				<div id="<?php echo $id; ?>drag-drop-area" class="plupload-drag-drop-area">
			<?php } ?>
				<?php
				$classes = '';
				if($preset) $classes .= 'add-preset ';
				if($preview) $classes .= 'add-preview ';
				if($tomedia) $classes .= 'add-to-media ';

				$datas = '';
				if('' != $topost) $datas .= 'data-postid="' . $topost . '" ';
				if('' != $fields) $datas .= 'data-fields="' . $fields . '" ';
				if('' != $confirm) $datas .= 'data-confirm="' . $confirm . '" ';
				if('' != $featured) $datas .= 'data-featured="' . $featured . '" ';
				if('' != $formats) $datas .= 'data-formats="' . $formats . '" ';
				?>
				<div class="plupload-upload-uic hide-if-no-js <?php echo $classes; ?>" <?php echo $datas; ?> id="<?php echo $id; ?>plupload-upload-ui">

					<input id="<?php echo $id; ?>plupload-browse-button" type="button" value="<?php echo $label; ?>" class="button plupload-button plupload-<?php echo $id ?>" />

					<span class="ajaxnonceplu" id="ajaxnonceplu<?php echo wp_create_nonce($id . 'themify-plupload'); ?>"></span>

				</div>

			<?php if( $dragfiles ){ ?>
					<small><?php _e(' or drag files here.', 'themify'); ?></small>
				</div>
			<?php } ?>
			<?php

			$html = ob_get_contents();
			ob_end_clean();
		}
		$upload_visible = true;
	}

	if( $medialib ) {
		ob_start();
		?>
		<?php
			$medialib_btn_text = __('Insert Image', 'themify');
			$medialib_datas = array(
				'action' => 'themify_media_lib_browse',
				'media_lib_nonce' => wp_create_nonce( 'media_lib_nonce' ),
				'featured' => ($featured != '') ? 1 : 0,
				'field_name' => $fields,
				'post_id' => $topost
			);
		?>
		<div class="themify_medialib_wrapper">
			<?php echo $upload_visible ? '&nbsp;<em>' . __( 'or', 'themify' ) . '</em>' : ''; ?> &nbsp;
			<a href="#" class="themify-media-lib-browse" data-submit='<?php echo json_encode( $medialib_datas ); ?>' data-uploader-title="<?php _e( 'Browse Image', 'themify' ) ?>" data-uploader-button-text="<?php echo $medialib_btn_text; ?>" data-fields="<?php echo $fields; ?>" data-type="<?php echo $type; ?>"><?php _e( 'Browse Library',
					'themify' ) ?></a>
		</div>
		<?php
		$html .= ob_get_contents();
		ob_end_clean();
	}

	return $html;
}

/**
 * Echoes a PLUPLOAD uploader
 * @uses themify_get_uploader
 */
function themify_uploader($id = '', $args = array()){
	echo themify_get_uploader( $id, $args );
}

/**
 * Check if user has available space in multisite installations
 * @param String $allowed Content to show if there is space available
 * @param Boolean $echo Flag establishing if content must be echoed or returned
 * @return String
 * @since 1.1.5 
 */
function themify_has_quota($allowed, $echo = false, $custom = ''){
	if ( is_multisite() && !is_upload_space_available() ) {
		if( '' != $custom ){
			$message = $custom;
		}
		else{
			$message = '<small>' . sprintf( __( 'Sorry, you have filled your %s MB storage quota so uploading has been disabled.', 'themify' ), get_space_allowed() ) . '</small>';
		}
	}
	else{
		$message = $allowed;
	}
	if($echo){
		echo $message;
	}
	else{
		return $message;
	}
}

/**
 * Display select element with featured image sizes + blank slot
 * @param String $key setting name
 * @return String
 * @since 1.1.5
 */
function themify_feature_image_sizes_select($key = ''){
	/** Define WP Featured Image sizes + blank + Themify's img.php
	 * @var array */
	$themify_layout_feature_sizes = themify_get_image_sizes_list();
	
	$output = '<p class="show_if_disabled_img_php">
				<span class="label">' . __('Featured Image Size', 'themify') . '</span>
				<select name="setting-'.$key.'">';                                                                                              
	foreach($themify_layout_feature_sizes as $option){
		if($option['value'] == themify_get('setting-'.$key.'')){
			$output .= '<option value="'.$option['value'].'" selected="selected">';
				$output .= $option['name'];
			$output .= '</option>';
		} else {
			$output .= '<option value="'.$option['value'].'">'.$option['name'].'</option>';
		}
	}
	$output .= '</select></p>';
	
	return $output;
}

if ( ! function_exists( 'themify_get_image_sizes_list' ) ) {
	/**
	 * Return list of image sizes with labels for translation.
	 * @param bool $nested
	 * @return mixed|void
	 * @since 1.6.8
	 */
	function themify_get_image_sizes_list( $nested = true ) {
		$size_names = apply_filters( 'image_size_names_choose',
			array(
				'thumbnail' => __( 'Thumbnail', 'themify' ),
				'medium' 	=> __( 'Medium', 'themify' ),
				'large' 	=> __( 'Large', 'themify' ),
				'full' 		=> __( 'Original Image', 'themify' )
			)
		);
		$out = array(
			array( 'value' => 'blank', 'name' => '' ),
		);
		foreach( $size_names as $size => $label ) {
			$out[] = array( 'value' => $size, 'name' => $label );
		}
		return apply_filters( 'themify_get_image_sizes_list', $nested ? $out : $size_names, $nested );
	}
}

/**
 * Check if the site is using an HTTPS scheme and returns the proper url
 * @param String $url requested url
 * @return String
 * @since 1.1.5
 */
function themify_https_esc($url = ''){
	if( is_ssl() ){
		$parsed_url = parse_url($url);
		$url = 'https://' . $parsed_url['host'] . $parsed_url['path'];
	}
	return $url;
}

/**
 * Returns an array with the post types managed by Themify,
 * where the Themify Custom Panel is initialized.
 * Filterable using themify_post_types
 * @param Array $types additional post types
 * @return Array
 * @since 1.1.5
 */
function themify_post_types($types = array()){
	$defaults = array_merge(
		array('post', 'page'),
		themify_specific_post_types(),
		$types
	);
	return array_unique(apply_filters('themify_post_types', $defaults));
}

/**
 * Returns an array with the post types that are specific to Themify,
 * where the Themify Custom Panel is initialized.
 * Filterable using themify_post_types
 * @return array
 * @since 1.1.5
 */
function themify_specific_post_types(){
	return array_unique(
		apply_filters('themify_specific_post_types', array(
			'menu',
			'slider',
			'highlight',
			'portfolio',
			'testimonial',
			'section'
		))
	);
}

/**
 * Hijacks themes passed for upgrade checking and remove those from Themify
 * @param Bool
 * @param Array $r List of themes
 * @param String $url URL of upgrade check
 * @return Array
 * @since 1.1.8
 */
function themify_hide_themes( $r, $url ){
	if ( false !== stripos( $url, 'api.wordpress.org/themes/update-check' ) ) {
		$themes = json_decode( $r['body']['themes'] );
		$themes_list = themify_get_theme_names();
		foreach( $themes_list as $theme_name ){
			unset( $themes->themes->{$theme_name} );
		}
		$r['body']['themes'] = json_encode( $themes );
	}
	return $r;
}

/**
 * Get list of themes from Themify's versions.xml
 * @return Array List of themes
 * @since 1.1.8
 */
function themify_get_theme_names(){
	$themes_list = array();
	
	if ( false === ( $themes_list = get_transient( 'themify_themes_list' ) ) ) {
		
		$response = wp_remote_get( 'http://themify.me/versions/versions.xml' );
		if( is_wp_error( $response ) ) {
			echo '<h4>' . __('Can\'t load versions file.', 'themify') . '</h4><p>' . $response->get_error_code(). '</p>';
			return;
		}
		$versionsxml = simplexml_load_string($response['body']);
		foreach($versionsxml->version as $version) {
			$themes_list[] = (string) $version->attributes()->name;
		}
	
	set_transient( 'themify_themes_list', $themes_list, 60*60 ); }
	
	return $themes_list;
}

/**
 * Display an additional column in categories list
 * @since 1.1.8
 */
function themify_custom_category_header($cat_columns){
    $cat_columns['cat_id'] = 'ID';
    return $cat_columns;
}
/**
 * Display ID in additional column in categories list
 * @since 1.1.8
 */
function themify_custom_category($null, $column, $termid){
	return $termid;
}

/**
 * Outputs html to display alert messages in post edit/new screens. Excludes pages.
 * @since 1.2.2
 */
function themify_prompt_message() {
	global $pagenow, $typenow;
	if( ('post.php' == $pagenow || 'post-new.php' == $pagenow) && 'page' != $typenow )
		echo '<div class="prompt-box"><div class="show-error"></div></div><div class="overlay">&nbsp;</div>';
}
add_action( 'admin_notices', 'themify_prompt_message' );

/**
 * Add RSS link tag in header
 */
function themify_head_rss_link(){
	$rss_link = themify_check('setting-custom_feed_url') ? themify_get('setting-custom_feed_url') : get_bloginfo('rss2_url');
	echo "\n".'<!-- RSS Feed -->'."\n".'<link rel="alternate" type="application/rss+xml" title="' . get_bloginfo('name') . ' RSS Feed" href="' . $rss_link . '" />'."\n";
}

if ( ! function_exists( 'themify_get_html_schema' ) ) {
	/**
	 * Generates microdata information for the html tag.
	 * @return string
	 * @since 1.7.4
	 */
	function themify_get_html_schema() {
		$schema = 'http://schema.org/';
		if ( is_single() ) {
			$type = 'Article';
		} elseif( is_author() ) {
			$type = 'ProfilePage';
		} elseif( is_search() ) {
			$type = 'SearchResultsPage';
		} else {
			$type = 'WebPage';
		}
		return 'itemscope="itemscope" itemtype="' . $schema . $type . '"';
	}
}

if ( ! function_exists( 'themify_get_author_link' ) ) {
	/**
	 * Builds the markup for the entry author with microdata information.
	 * @return string
	 * @since 1.7.4
	 */
	function themify_get_author_link() {
		$output = '<span class="author vcard" itemprop="author" itemscope itemtype="http://schema.org/Person"><a class="url fn n" href="' . esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ) . '" rel="author" itemprop="name">' . get_the_author() . '</a></span>';
		return $output;
	}
}

/**
 * Add different CSS classes to body tag.
 * Outputs:
 * 		skin name
 * 		layout
 * @param Array
 * @return Array
 * @since 1.2.2
 */
function themify_body_classes( $classes ) {
	global $themify;

	// Add skin name
	if( $skin = themify_get( 'skin' ) ) {
		$skin_dir = explode( '/', $skin );
		$classes[] = 'skin-' . $skin_dir[sizeof( $skin_dir ) - 2];
	} else {
		$classes[] = 'skin-default';
	}

	// Browser classes
	global $is_gecko, $is_opera, $is_iphone, $is_IE, $is_winIE, $is_macIE;
	$is_android = stripos($_SERVER['HTTP_USER_AGENT'], 'android')? true: false;
	$is_webkit = stripos($_SERVER['HTTP_USER_AGENT'], 'webkit')? true: false;
	$is_ie10 = stripos($_SERVER['HTTP_USER_AGENT'], 'MSIE 10')? true: false;
	$is_ie9 = stripos($_SERVER['HTTP_USER_AGENT'], 'MSIE 9')? true: false;
	$is_ie8 = stripos($_SERVER['HTTP_USER_AGENT'], 'MSIE 8')? true: false;
	$is_ie7 = stripos($_SERVER['HTTP_USER_AGENT'], 'MSIE 7')? true: false;

	$is_not_ie = true;

	$browsers = array(
		'gecko' => $is_gecko,
		'opera' => $is_opera,
		'iphone' => $is_iphone,
		'android' => $is_android,
		'webkit' => $is_webkit,
		'ie' => $is_IE,
		'iewin' => $is_winIE,
		'iemac' => $is_macIE,
		'ie10' => $is_ie10,
		'ie9' => $is_ie9,
		'ie8' => $is_ie8,
		'ie7' => $is_ie7
	);

	foreach( $browsers as $browser => $state ) {
		if ( $state ) {
			$classes[] = $browser;
			if ( stripos( $browser, 'ie' ) !== false ) {
				$is_not_ie = false;
			}
		}
	}
	if ( $is_not_ie ) {
		$classes[] = 'not-ie';
	}
	
	// Add default layout and post layout
	$layout = themify_get('setting-default_layout');
	$post_layout = themify_get('setting-default_post_layout');

	// Set content width
	$classes[] = themify_check( 'content_width' ) ? themify_get( 'content_width' ) : 'default_width';
	
	// It's a page 
	if( is_page() ){
		// It's a page
		$layout = (themify_get('page_layout') != 'default' && themify_check('page_layout')) ? themify_get('page_layout') : themify_get('setting-default_page_layout');
	}
	
	if( themify_is_query_page() ) {
		$classes[] = 'query-page';
		$classes[] = isset($themify->query_post_type) ? 'query-'.$themify->query_post_type: 'query-post';
	}
	
	// It's a post
	if( is_single() ){
		$layout = (themify_get('layout') != 'default' && themify_check('layout')) ? themify_get('layout') : themify_get('setting-default_page_post_layout');
	}

	// It's a singular view (post, page, portfolio, any custom post type)
	if ( is_singular() ) {
		// Post requires password
		if ( post_password_required( get_the_ID() ) ) {
			$classes[] = 'entry-password-required';
		}
	}
	
	// If still empty, set default
	if( apply_filters('themify_default_layout_condition', '' == $layout) ){
		$layout = apply_filters('themify_default_layout', 'sidebar1');
	}
	$classes[] = $layout;
	
	// Set post layout for blog, archive or a query category page
	$post_query_category = isset($themify->query_category)? $themify->query_category : themify_get('query_category');
	if( is_home() || is_archive() || '' != $post_query_category || is_search() ){
		$post_layout = $themify->post_layout;
		if(apply_filters('themify_default_post_layout_condition', '' == $post_layout)){
			$post_layout = apply_filters('themify_default_post_layout', 'list-post');
		}
		$classes[] = $post_layout;
	}
	return apply_filters('themify_body_classes', $classes);
}
add_filter('body_class', 'themify_body_classes');

/**
 * Checks if the image field is the thumbnail or not.
 * @return Bool
 * @since 1.2.2
 */
function themify_is_thumbnail_field($field){
	return apply_filters('themify_is_thumbnail_field', 'post_image' == $field || 'feature_image' == $field);
}

/**
 * Returns logo image.
 * Available filters:
 * 'themify_'.$location.'_logo_tag': filter the HTML tag used to wrap the text or image.
 * 'themify_logo_home_url': filter the home URL linked.
 * 'themify_'.$location.'_logo_html': filter the final HTML output to page.
 * @param string $location Logo location used as key to get theme setting values
 * @return string logo markup
 */
function themify_logo_image($location = 'site_logo', $cssid = 'site-logo'){
	if(themify_get('setting-' . $location) == 'image' && themify_check('setting-'.$location.'_image_value')){
		$logo_tag = apply_filters('themify_'.$location.'_logo_tag', 'div');
		$type = 'image';
	} else {
		$logo_tag = apply_filters('themify_'.$location.'_logo_tag', 'h1');
		$type = 'text';
	}
	$html = '<' . $logo_tag . ' id="' . $cssid . '">';
	$html .= '<a href="'.apply_filters('themify_logo_home_url', home_url()).'" title="'.get_bloginfo('name').'">';
	if('image' == $type){
		$html .= themify_get_image("src=" . themify_get('setting-'.$location.'_image_value') . "&w=" . themify_get('setting-'.$location.'_width') . "&h=" . themify_get('setting-'.$location.'_height') . "&alt=" . urlencode(get_bloginfo('name')));
	} else {
		$html .= get_bloginfo('name');
	}
	$html .= '</a>';
	$html .= '</' . $logo_tag . '>';
	return apply_filters('themify_'.$location.'_logo_html', $html, $location, $logo_tag, $type);
}

/**
 * Registers footer sidebars.
 * @param array $columns Sets of sidebars that can be created.
 * @param string $option How many sidebars are registered.
 * @param array $widget_attr General markup for widgets.
 * @param string $footer_key Theme settings key to use.
 */
function themify_register_grouped_widgets($columns = array(), $widget_attr = array(), $widgets_key = 'setting-footer_widgets', $default_set = 'footerwidget-3col'){
	$data = themify_get_data();
	if(empty($columns)){
		$columns = array(
			'footerwidget-4col' => 4,
			'footerwidget-3col'	=> 3,
			'footerwidget-2col' => 2,
			'footerwidget-1col' => 1,
			'none'			 	=> 0
		);
	}
	$option = (!isset($data[$widgets_key]) || '' == $data[$widgets_key])? $default_set: $data[$widgets_key];
	if(empty($widget_attr)){
		$widget_attr = array(
			'sidebar_name' => __('Footer Widget', 'themify'),
			'sidebar_id' => 'footer-widget',
			'before_widget' => '<div id="%1$s" class="widget %2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h4 class="widgettitle">',
			'after_title' => '</h4>',
		);
	}
	extract($widget_attr);
	
	for($x = 1; $x <= $columns[$option]; $x++){
		register_sidebar(array(
			'name' => $sidebar_name . ' ' .$x,
			'id' => $sidebar_id.'-'.$x,
			'before_widget' => $before_widget,
			'after_widget' => $after_widget,
			'before_title' => $before_title,
			'after_title' => $after_title,
		));
	}
}

/**
 * Adds itemprop='image' microdata to avatar called by author box
 * @param string $avatar The original markup for avatar
 * @return string Modified markup with microdata
 */
function themify_authorbox_microdata($avatar){
	return str_replace("class='avatar", "itemprop='image' class='avatar", $avatar);
}
add_filter('get_avatar', 'themify_authorbox_microdata');

/**
 * Outputs footer text
 * @param string $key The footer text to show. Default: left
 * @param string $block The block of text this is
 * @param string $date_fmt Date format for year shown
 * @param bool $echo Whether to echo or return the markup
 */
function themify_the_footer_text($area = 'left', $wrap = true, $block = '', $date_fmt = 'Y', $echo = true) {
	// Prepare variables
	if('' == $block){
		if('left' == $area){
			$block = 'one';
		} elseif('right' == $area){
			$block = 'two';
		}
	}
	if('one' == $block) {
		$text_block = '&copy; <a href="'.home_url().'">'.get_bloginfo('name').'</a> '.date($date_fmt);
	} elseif('two' == $block) {
		$text_block = __('Powered by <a href="http://wordpress.org">WordPress</a> &bull; <a href="http://themify.me">Themify WordPress Themes</a>', 'themify');
	}
	$key = 'setting-footer_text_'.$area;
	
	// Get definitive text to display, parse through WPML if available
	if ( '' != themify_get($key) ) {
		$data = themify_get_data();
		if ( function_exists( 'icl_t' ) ) {
			$text = icl_t('Themify', $key, $data[$key]);
		} else {
			$text = $data[$key];
		}
	} else {
		$text = $text_block;
	}
	// Start markup
	$html = '';
	$html = apply_filters('themify_footer_text'.$block, $text);
	if ( true === is_bool( $wrap ) && true == $wrap ) {
		$html = '<div class="'.$block.'">' . $html . '</div>';
	} elseif( ! is_bool( $wrap ) ) {
		$html = '<div class="'.$wrap.'">' . $html . '</div>';
	}
	$html = apply_filters('themify_the_footer_text_'.$area, $html);
	if ( $echo ) echo $html;
	return $html;
}

/**
 * Search array by key and value
 * return index array
 * @param type $array 
 * @param type $key 
 * @param type $value 
 * @return array
 */
function themify_search_arr( $array, $key, $value, $duplicate = false, $uniq_key = null, $uniq_val = null ) {
  $results = array();
  themify_search_r( $array, $key, $value, $results, $duplicate, $uniq_key, $uniq_val );
  return $results;
}

/**
 * Function search array by key and value
 * @param type $array 
 * @param type $key 
 * @param type $value 
 * @param type &$results 
 * @param type $duplicate 
 * @param type $uniq_key 
 * @param type $uniq_val 
 * @return type
 */
function themify_search_r( $array, $key, $value, &$results, $duplicate = false, $uniq_key = null, $uniq_val = null ) {
  if ( ! is_array( $array ) )
    return;

  if ( $duplicate ) {
  	if ( isset( $array[$key] ) && $array[$key] == $value )
  		$results[] = $array;
  } else {
  	if ( isset( $array[ $key ] ) && stripos( $array[ $uniq_key ], $uniq_val ) !== false )
  		$results[] = $array;
  }

  foreach ( $array as $subarray )
    themify_search_r( $subarray, $key, $value, $results, $duplicate, $uniq_key, $uniq_val );
}

/**
 * Get styling selector by id or selector
 * @param type $key 
 * @param type $value 
 * @param type $selected 
 * @return string
 */
function themify_get_styling_selector( $key, $value, $context, $duplicate = false, $uniq_key = null, $uniq_val = null ) {
	global $ThemifyConfig;
	$config = $ThemifyConfig->get_config();
	$result = '';
	$arr = themify_search_arr( $config['panel']['styling']['tab'][ $context ]['element'], $key, $value, $duplicate, $uniq_key, $uniq_val );

	if ( isset( $arr[0]['selector'] ) )
		$result = $arr[0]['selector'];

  return $result;
}

/**
 * Return specific array
 * @param type $key 
 * @param type $context 
 * @return array
 */
function themify_get_theme_arr( $key, $context = 'settings' ) {
	global $ThemifyConfig;
	$config = $ThemifyConfig->get_config();
	$return = array();

	if ( isset( $config['panel'][ $context ]['tab'][ $key ] ) )
		$return = $config['panel'][ $context ]['tab'][ $key ];

	return $return;
}

/**
 * Check whether array is associative or indexed
 * @param type $array 
 * @return boolean
 */
function themify_is_associative_array( $array ) {
	return ( is_array( $array ) && ! is_numeric( implode( "", array_keys( $array ) ) ) );
}

/**
 * Get google font lists
 * @return array
 */
function themify_get_google_font_lists() {
	if( !defined('THEMIFY_GOOGLE_FONTS') ) define('THEMIFY_GOOGLE_FONTS', true);
	if( !THEMIFY_GOOGLE_FONTS ) return;

	$fonts = themify_grab_remote_google_fonts();
	return $fonts;
}

/**
 * Grab google fonts lists from api
 * @return array
 */
function themify_grab_remote_google_fonts() {
	if(themify_check('setting-webfonts_subsets') && '' != themify_get('setting-webfonts_subsets')) {
		$user_subsets = explode(',', str_replace(' ', '', themify_get('setting-webfonts_subsets')));
	} else {
		$user_subsets = array();
	}
	$subsets = apply_filters('themify_google_fonts_subsets', array_merge(array('latin'), $user_subsets));
	$subsets_count = count($subsets);
	$response = file_get_contents(THEMIFY_DIR . '/js/google-fonts.json');
	$fonts = array();
	if( $response !== false ) {
		$results = json_decode( $response );
		foreach ( $results->items as $font ) {
			// If user specified additional subsets
			if( $subsets_count > 1) {
				$font_subsets = $font->subsets;
				$subsets_match = true;
				// Check that all specified subsets are available in this font
				foreach ($subsets as $subset) {
					if(!in_array($subset, $font_subsets)) {
						$subsets_match = false;
					}
				}
				// Ok, this font supports all subsets requested by user, add it to the list
				if($subsets_match) {
					$fonts[] = array(
						'family' => $font->family,
						'variant' => $font->variants[0]
					);
				}
			} else {
				$fonts[] = array(
					'family' => $font->family,
					'variant' => $font->variants[0]
				);
			}
		}
	}
	return $fonts;
}

/**
 * Check if given value is google fonts or web safe fonts
 * @param string $value 
 * @return boolean
 */
function themify_is_google_fonts( $value ) {
	global $themify_gfonts;
	$found = false;
	if ( sizeof( $themify_gfonts ) > 0 ) {
		foreach ( $themify_gfonts as $font ) {
			if ( $found ) break;
			if ( $font['family'] == $value ) $found = true;
		}
	}
	return $found;
}

/**
 * Get selected custom css google fonts
 * @return array
 */
function themify_get_custom_css_gfonts() {
	$data = themify_get_data();
	$fonts = array();
	if ( is_array( $data ) ) {
		foreach ( $data as $name => $value ) {
			$array = explode( '-', $name );
			$path = '';
			foreach( $array as $part ) {
				$path .= "['$part']";
			}
			eval("\$config".$path." = \$value;");
		}
		if ( isset( $config['styling'] ) && is_array( $config['styling'] ) ) {
			foreach ( $config['styling'] as $ks => $styling ) {
				foreach ( $styling as $element => $val ) {
					foreach ( $val as $attribute => $v ) {
						switch ( $attribute ) {
							case 'font_family':
								if ( ! empty( $v['value']['value'] ) && themify_is_google_fonts( $v['value']['value'] ) )
									array_push( $fonts, $v['value']['value'] );
								break;
						}
					}
				}
			}
		}
	}
	return $fonts;
}

/**
 * Load google fonts library
 * @param array $fonts 
 * @return type
 */
function themify_enqueue_gfonts() {
	$fonts = themify_get_custom_css_gfonts();
	$families = array();
	if ( themify_check( 'setting-webfonts_subsets' ) && '' != themify_get( 'setting-webfonts_subsets' ) ) {
		$user_subsets = explode( ',', str_replace( ' ', '', themify_get( 'setting-webfonts_subsets' ) ) );
	} else {
		$user_subsets = array();
	}
	$subsets = apply_filters( 'themify_google_fonts_subsets', array_merge( array( 'latin' ), $user_subsets ) );
	$query = null;
	$fonts = array_unique( $fonts );
	foreach ( $fonts as $font ) {
		$words = explode( '-', $font );
		$variant = themify_get_gfont_variant( $font );
		foreach ( $words as $key => $word ) {
			$words[$key] = ucwords( $word );
		}
		array_push( $families, implode( '+', $words ) . ':' . $variant );
	}
	if ( ! empty( $families ) ) {
		$query .= '?family=' . implode( '|', $families );
		$query .= '&subset=' . implode( ',', $subsets );
	
		// check to see if site is uses https
		$http = ( is_ssl() ) ? 'https' : 'http';
		$url = $http.'://fonts.googleapis.com/css';
		$url .= $query;
	
		wp_enqueue_style( 'themify-google-fonts', $url );
	}
}
add_action( 'wp_enqueue_scripts', 'themify_enqueue_gfonts' );

if ( ! function_exists( 'themify_get_gfont_variant' ) ) {
	/**
	 * Get font default variant
	 * @param $family 
	 * @return string
	 */
	function themify_get_gfont_variant( $family ) {
		global $themify_gfonts;
		$variant = 400;
		foreach ($themify_gfonts as $v) {
			if ( $v['family'] == $family ) {
				$variant = $v['variant'];
				break;
			}
		}
		return $variant;
	}
}

function themify_editor_gfonts_config_view() {
	return $GLOBALS['themify_editor_gfonts']->config_view();
}

if(!function_exists('themify_is_query_page')){
	/**
	 * Checks if current page is a query category page
	 * @return bool
	 * @since 1.3.8
	 */
	function themify_is_query_page(){
		global $themify;
		if(isset($themify->query_category) && '' != $themify->query_category){
			return true;
		} else {
			return false;
		}
	}
}

if(!function_exists('themify_options_module')){
	/**
	 * Returns list of <option>
	 * @param array List of options
	 * @return string
	 * @since 1.3.5
	 */
	function themify_options_module($options = array(), $key = '', $associative = true, $default = ''){
		$data = themify_get_data();
		$output = '';
		if(true == $associative) {
			foreach($options as $option){
				$output .= '<option '.selected($option['value'], isset($data[$key])? $data[$key] : $default, false).' value="'.$option['value'].'">'.$option['name'].'</option>';
			}
		} elseif(false == $associative) {
			foreach($options as $option){
				if($option == $data[$key]){
					$output .= '<option value="'.$option.'" selected="selected">'.$option.'</option>';
				} else {
					$output .= '<option value="'.$option.'">'.$option.'</option>';
				}
			}
		}
		return $output;
	}
}

if(!function_exists('themify_lightbox_vars_init')){
	/**
	 * Post Gallery lightbox/fullscreen and single lightbox definition
	 * @return array Lightbox/Fullscreen galleries initialization parameters
	 */
	function themify_lightbox_vars_init(){
		$lightbox_content_images = themify_get('setting-lightbox_content_images');
		$gallery_lightbox = themify_get('setting-gallery_lightbox');
		$lightboxSelector = '.lightbox';
		$overlay_args = array();
		$file_extensions = array('jpg', 'gif', 'png', 'JPG', 'GIF', 'PNG', 'jpeg', 'JPEG');
		$content_images = '';
		$gallery_selector = '';
		foreach ($file_extensions as $ext) {
			$content_images .= '.post-content a[href$='.$ext.'],.page-content a[href$='.$ext.'],';
			$gallery_selector .= '.gallery-icon > a[href$='.$ext.'],';
		}
		$content_images = substr($content_images, 0, -1);
		$gallery_selector = substr($gallery_selector, 0, -1);
		
		// Include Magnific style and script
		wp_enqueue_style ( 'magnific', THEMIFY_URI . '/css/lightbox.css');
		wp_enqueue_script( 'magnific', THEMIFY_URI . '/js/lightbox.js', array('jquery'), false, true );
		
		// Lightbox default settings
		$overlay_args = array(
			'lightboxSelector' 	=> $lightboxSelector,
			'lightboxOn'		=> true,
			'lightboxContentImages' => '' == $lightbox_content_images? false : true,
			'lightboxContentImagesSelector' => $content_images,
			'theme' 			=> apply_filters('themify_overlay_gallery_theme', 'pp_default'),
			'social_tools' 		=> false,
			'allow_resize' 		=> true,
			'show_title' 		=> false,
			'overlay_gallery' 	=> false,
			'screenWidthNoLightbox' => 600,
			'deeplinking' 		=> false,
			'contentImagesAreas' => '.post, .type-page, .type-highlight, .type-slider'
		);
		
		// If user selected lightbox or is a new install/reset
		if('lightbox' == $gallery_lightbox || 'prettyphoto' == $gallery_lightbox || null == $gallery_lightbox){
			$overlay_args['gallerySelector'] = $gallery_selector;
			$overlay_args['lightboxGalleryOn'] = true;
			
		// else if user selected fullscreen gallery
		} elseif('photoswipe' == $gallery_lightbox){
			// Include fullscreen gallery style and script
			wp_enqueue_style(  'photoswipe', THEMIFY_URI . '/css/photoswipe.css');
			wp_enqueue_script( 'photoswipe', THEMIFY_URI . '/js/photoswipe.js', array('jquery'), false, true );
	
			// Parameter to handle fullscreen gallery
			$overlay_args = array_merge($overlay_args, array(
				'fullscreenSelector' => $gallery_selector,
				'fullscreenOn' 	 => true,
				'imageScaleMethod'	=> (themify_get('setting-lightbox_swipe_upscale')) ? 'fit' : 'fitNoUpscale'
			));
		}
		
		return apply_filters('themify_gallery_plugins_args', $overlay_args);
	}
}

if(!function_exists('themify_get_featured_image_link')){
	/**
	 * Returns escaped URL for featured image link
	 * @return string
	 * @since 1.3.5
	 */
	function themify_get_featured_image_link($args = array()) {
		$defaults = array (
			'no_permalink' => false // if there is no lightbox link, don't return a link
		);
		$args = wp_parse_args( $args, $defaults );
		extract( $args, EXTR_SKIP );

		if ( themify_get('external_link') != '') {
			$link = esc_url(themify_get('external_link'));
		} elseif ( themify_get('lightbox_link') != '') {
			$link = esc_url(themify_get('lightbox_link'));
			if(themify_check('iframe_url')) {
				$do_iframe = '?iframe=true&width=100%&height=100%';
			} else {
				$do_iframe = '';
			}
			$link = $link . $do_iframe . '" class="lightbox';
		} elseif(themify_check('link_url')) {
			$link = themify_get('link_url');
		} elseif($no_permalink) {
			$link = '';
		} else {
			$link = get_permalink();
			if(current_theme_supports('themify-post-in-lightbox')){
				if( !is_single() && '' != themify_get('setting-open_inline') ){
					$link = get_permalink().'?post_in_lightbox=1" class="themify-lightbox';
				}
				if( themify_is_query_page() ){
					if( 'no' == themify_get('post_in_lightbox') ){
						$link = get_permalink();
					} else {
						$link = get_permalink().'?post_in_lightbox=1" class="themify-lightbox';
					}
				}
			}
		}
		return apply_filters('themify_get_featured_image_link', $link);
	}
}

if ( ! function_exists( 'themify_lightbox_link_field' ) ) {
	/**
	 * Returns Lightbox Link field definition for themify custom panel
	 * @return array 
	 */
	function themify_lightbox_link_field( $args = array() ) {

		$defaults = array(
			'name' 	=> 'multi_lightbox_link',	
			'title' => __('Lightbox Link', 'themify'), 	
			'description' => '', 				
			'type' 	=> 'multi',			
			'meta'	=> array(
				'fields' => array(
			  		// Lightbox link field
			  		array(
						'name' 	=> 'lightbox_link',
						'label' => '',
						'description' => __('Link Featured Image and Post Title to lightbox image, video or iframe URL <br/>(<a href="http://themify.me/docs/lightbox">learn more</a>)', 'themify'),
						'type' 	=> 'textbox',
						'meta'	=> array(),
						'before' => '',
						'after' => '',
					),
					array(
						'name' 		=> 'iframe_url',
						'label' 		=> __('iFrame URL', 'themify'),
						'description' => '',
						'type' 		=> 'checkbox',
						'before' => '',
						'after' => '',
					),
					array(
						'name' 		=> 'lightbox_icon',
						'label' 		=> __('Add zoom icon on lightbox link', 'themify'),
						'description' => '',
						'type' 		=> 'checkbox',
						'before' => '',
						'after' => '',
					)
				),
				'description' => '',
				'before' => '',
				'after' => '',
				'separator' => ''
			)
		);

		$field = wp_parse_args( $args, $defaults );

		return apply_filters( 'themify_lightbox_link_field', $field );
	}
}

if( ! function_exists( 'themify_image_dimensions_field' ) ) {
	/**
	 * Multi field: Image dimensions fields to enter width and height.
	 * @param array $args
	 * @return mixed|void
	 * @since 1.5.2
	 */
	function themify_image_dimensions_field( $args = array(), $prefix = 'image' ) {

		$defaults = array(
			'type' => 'multi',
			'name' => $prefix . '_dimensions',
			'title' => __('Image Dimension', 'themify'),
			'meta' => array(
				'fields' => array(
					// Image Width
					array(
						'name' => $prefix . '_width',
						'label' => __('width', 'themify'),
						'description' => '',
						'type' => 'textbox',
						'meta' => array('size' => 'small'),
						'before' => '',
						'after' => '',
					),
					// Image Height
					array(
						'name' => $prefix . '_height',
						'label' => __('height', 'themify'),
						'type' => 'textbox',
						'meta' => array( 'size' => 'small'),
						'before' => '',
						'after' => '',
					),
				),
				'description' => __('Enter height = 0 to disable vertical cropping with img.php enabled', 'themify'),
				'before' => '',
				'after' => '',
				'separator' => ''
			)
		);

		$field = wp_parse_args( $args, $defaults );

		return apply_filters( 'themify_image_dimensions_field', $field );
	}
}

if( ! function_exists( 'themify_multi_meta_field' ) ) {
	/**
	 * Definition for tri-state hide meta buttons
	 * @param array $args
	 * @return mixed|void
	 * @since 1.5.2
	 */
	function themify_multi_meta_field( $args = array(), $prefix = 'hide_meta' ) {

		$states = array(
			array(
				'name' => __('Hide', 'themify'),
				'value' => 'yes',
				'icon' => THEMIFY_URI . '/img/ddbtn-check.png',
				'title' => __('Hide this meta', 'themify')
			),
			array(
				'name' => __('Do not hide', 'themify'),
				'value' => 'no',
				'icon' => THEMIFY_URI . '/img/ddbtn-cross.png',
				'title' => __('Show this meta', 'themify')
			),
			array(
				'name' => __('Theme default', 'themify'),
				'value' => '',
				'icon' => THEMIFY_URI . '/img/ddbtn-blank.png',
				'title' => __('Use theme settings', 'themify'),
				'default' => true
			)
		);

		$defaults = array(
			'name' 		=> $prefix . '_multi',
			'title' 	=> __('Hide Post Meta', 'themify'),
			'description' => '',
			'type' 		=> 'multi',
			'meta'		=>  array (
				'fields' => array(
					array(
						'name' => $prefix . '_all',
						'title' => __('Hide All', 'themify'),
						'description' => '',
						'type' => 'dropdownbutton',
						'states' => $states,
						'main' => true,
						'disable_value' => 'yes'
					),
					array(
						'name' => $prefix . '_author',
						'title' => __('Author', 'themify'),
						'description' => '',
						'type' => 'dropdownbutton',
						'states' => $states,
						'sub' => true
					),
					array(
						'name' => $prefix . '_category',
						'title' => __('Category', 'themify'),
						'description' => '',
						'type' => 'dropdownbutton',
						'states' => $states,
						'sub' => true
					),
					array(
						'name' => $prefix . '_comment',
						'title' => __('Comment', 'themify'),
						'description' => '',
						'type' => 'dropdownbutton',
						'states' => $states,
						'sub' => true
					),
					array(
						'name' => $prefix . '_tag',
						'title' => __('Tag', 'themify'),
						'description' => '',
						'type' => 'dropdownbutton',
						'states' => $states,
						'sub' => true
					),
				),
				'description' => '',
				'before' => '',
				'after' => '',
				'separator' => ''
			)
		);

		$field = wp_parse_args( $args, $defaults );

		return apply_filters( 'themify_multi_meta_field', $field );
	}
}


if ( ! function_exists( 'themify_zoom_icon' ) ) {
	/**
	 * Returns zoom icon markup for lightboxed featured image
	 * @return string
	 */
	function themify_zoom_icon( $echo = true ) {
		$icon = '';
		if ( themify_check( 'lightbox_icon' ) ) {
			$icon = '<span class="zoom"></span>';
		}
		if ( $echo )
			echo apply_filters( 'themify_zoom_icon', $icon );
		else
			return apply_filters( 'themify_zoom_icon', $icon );
	}
}

if ( ! function_exists('themify_theme_feed_link') ) {
	/**
	 * Returns the feed link, usually RSS
	 * @param string $setting
	 * @param bool $echo
	 * @return mixed|void
	 * @since 1.5.2
	 */
	function themify_theme_feed_link( $setting = 'setting-custom_feed_url', $echo = true ){
		$out = '';
		if(themify_get( $setting ) != ''){
			$out .= themify_get( $setting );
		} else {
			$out .= get_bloginfo('rss2_url');
		}
		$out = apply_filters('themify_theme_feed_link', $out);
		if( $echo )
			echo $out;
		return $out;
	}
}

if ( ! function_exists( 'themify_get_shortcode_template' ) ) {
	/**
	 * Returns markup
	 * @param $posts
	 * @param string $slug
	 * @param string $name
	 * @param bool $echo
	 * @return mixed|void
	 * @since 1.3.8
	 */
	function themify_get_shortcode_template($posts, $slug = 'includes/loop', $name = 'index', $echo = false) {
		global $post, $themify;
		$themify->is_shortcode_template = true;
		ob_start();
		foreach ( $posts as $post ) {
			setup_postdata( $post );
			get_template_part( $slug, $name );
		}
		$html = ob_get_contents();
		ob_end_clean();
		wp_reset_postdata();
		return apply_filters('themify_get_shortcode_template', $html);
	}
}

if(!function_exists('themify_get_current_post_type')){
	function themify_get_current_post_type() {
		global $post, $typenow, $current_screen;
		if ( $post && $post->post_type )
			return $post->post_type;
		elseif( $typenow )
			return $typenow;
		elseif( $current_screen && $current_screen->post_type )
			return $current_screen->post_type;
		elseif( isset( $_REQUEST['post_type'] ) )
			return sanitize_key( $_REQUEST['post_type'] );
		elseif( isset( $_GET ) && isset( $_GET['post'] ) )
			return get_post_type( $_GET['post'] );
		return null;
	}
}

if(!function_exists('themify_upload_mime_types')) {
	/**
	 * Adds .svg and .svgz to list of mime file types supported by WordPress
	 * @param array WordPress supported mime types
	 * @return array Array extended with svg/svgz support
	 * @since 1.3.9
	 */
	function themify_upload_mime_types( $existing_mime_types = array() ) {
		$existing_mime_types['svg'] = 'image/svg+xml';
		$existing_mime_types['svgz'] = 'image/svg+xml';
		return $existing_mime_types;
	}
	add_filter('upload_mimes', 'themify_upload_mime_types');
}

if( ! function_exists('themify_parse_video_embed_vars') ) {
	/**
	 * Add wmode transparent and post-video container for responsive purpose
	 * @param string $html The embed markup.
	 * @param string $url The URL embedded.
	 * @return string The modified embed markup.
	 */
	function themify_parse_video_embed_vars($html, $url) {
		$services = array(
			'youtube.com',
			'youtu.be',
			'blip.tv',
			'vimeo.com',
			'dailymotion.com',
			'hulu.com',
			'viddler.com',
			'qik.com',
			'revision3.com',
			'wordpress.tv',
			'wordpress.com',
			'funnyordie.com'
		);
		$video_embed = false;
		foreach( $services as $service ) {
			if( stripos($html, $service) ) {
				$video_embed = true;
				break;
			}
		}
		if( $video_embed ) {
			$html = '<div class="post-video">' . $html . '</div>';
			if( strpos( $html, "<embed src=" ) !== false ) {
				$html = str_replace('</param><embed', '</param><param name="wmode" value="transparent"></param><embed wmode="transparent" ', $html);
				return $html;
			} else {
				if( strpos( $html, 'wmode=transparent' ) == false ) {
					if( stripos($url, 'youtube') || stripos($url, 'youtu.be') ) {

						if( stripos($url, 'youtu.be') ) {
							$parsed = parse_url($url);
							$ytq = isset( $parsed['query'] )? $parsed['query']: '';
							$url = 'http://www.youtube.com/embed' . $parsed['path'] . '?wmode=transparent&fs=1' . $ytq;
						} else {
							$parsed = parse_url($url);
							parse_str($parsed['query'], $query);

							$parsed['scheme'] .= '://';

							$parsed['path'] = '/embed/'.$query['v'];
							unset($query['v']);

							$query['wmode'] = 'transparent';
							$query['fs'] = '1';

							$parsed['query'] = '?';
							foreach ( $query as $param => $value ) {
								$parsed['query'] .= $param . '=' . $value . '&';
							}
							$parsed['query'] = substr($parsed['query'], 0, -1);

							$url = implode('', $parsed);
						}

						return preg_replace('/src="(.*)" (frameborder)/i', 'src="'.$url.'" $2', $html);
					} else {
						$search = array('?fs=1', '?fs=0');
						$replace = array('?fs=1&wmode=transparent', '?fs=0&wmode=transparent');
						$html = str_replace($search, $replace, $html);
						return $html;
					}
				} else {
					return $html;
				}
			}
		} else {
			return '<div class="post-embed">' . $html . '</div>';
		}
	}
	add_filter('embed_oembed_html', 'themify_parse_video_embed_vars', 10, 2);
}

/////////////////////// Woocommerce Routines //////////////////////////

// Remove default WC wrappers
remove_action( 'woocommerce_before_main_content', 'woocommerce_output_content_wrapper', 10);
remove_action( 'woocommerce_after_main_content', 'woocommerce_output_content_wrapper_end', 10);

// Remove default WC sidebar
remove_action( 'woocommerce_sidebar', 'woocommerce_get_sidebar', 10);

// Remove breadcrumb for later insertion within Themify wrapper
remove_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20 );

// Add Themify wrappers
add_action( 'woocommerce_before_main_content', 'themify_before_shop_content', 20);
add_action( 'woocommerce_after_main_content', 'themify_after_shop_content', 20);

// Add Themify sidebar
add_action( 'themify_content_after', 'themify_wc_compatibility_sidebar', 10);

if(!function_exists('themify_before_shop_content')) {
	/**
	 * Add initial portion of wrapper
	 * @since 1.4.6
	 */
	function themify_before_shop_content() { ?>
		<!-- layout -->
		<div id="layout" class="pagewidth clearfix">

			<?php themify_content_before(); // Hook ?>

			<!-- content -->
			<div id="content" class="<?php echo (is_product() || is_shop()) ? 'list-post':''; ?>">

				<?php
				if(!themify_check('setting-hide_shop_breadcrumbs')) {
					themify_breadcrumb_before();
					woocommerce_breadcrumb();
					themify_breadcrumb_after();
				}
				themify_content_start(); // Hook
	}
}

if(!function_exists('themify_after_shop_content')) {
	/**
	 * Add end portion of wrapper
	 * @since 1.4.6
	 */
	function themify_after_shop_content() {
				if (is_search() && is_post_type_archive() ) {
					add_filter( 'woo_pagination_args', 'woocommerceframework_add_search_fragment', 10 );
				}
				themify_content_end(); // Hook ?>

			</div>
			<!-- /#content -->

			<?php themify_content_after() // Hook ?>

		</div><!-- /#layout -->
	<?php
	}
}

if(!function_exists('themify_wc_compatibility_sidebar')) {
	/**
	 * Add sidebar if it's enabled in theme settings
	 * @since 1.4.6
	 */
	function themify_wc_compatibility_sidebar(){
		// Check if WC is active and this is a WC-managed page
		if( !themify_is_woocommerce_active() || !is_woocommerce() ) return;

		$sidebar_layout = 'sidebar1';

		if( is_product() ) {
			if( themify_check('setting-single_product_layout') ) {
				$sidebar_layout = themify_get('setting-single_product_layout');
			} elseif( themify_check('setting-default_page_post_layout') ) {
				$sidebar_layout = themify_get('setting-default_page_post_layout');
			}
		} else {
			if( themify_check('setting-shop_layout') ) {
				$sidebar_layout = themify_get('setting-shop_layout');
			} elseif( themify_check('setting-default_layout') ) {
				$sidebar_layout = themify_get('setting-default_layout');
			}
		}

		themify_ecommerce_sidebar_before(); // Hook

		if ( $sidebar_layout != 'sidebar-none' ) {
			get_sidebar();
		}

		themify_ecommerce_sidebar_after(); // Hook
	}
}

if( ! function_exists( 'themify_is_woocommerce_active' ) ) {
	/**
	 * Checks if Woocommerce plugin is active and returns the proper value
	 * @return bool
	 * @since 1.4.6
	 */
	function themify_is_woocommerce_active() {
		$plugin = 'woocommerce/woocommerce.php';
		$network_active = false;
		if ( is_multisite() ) {
			$plugins = get_site_option( 'active_sitewide_plugins' );
			if ( isset( $plugins[$plugin] ) )
				$network_active = true;
		}
		return in_array( $plugin, apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) || $network_active;
	}
}

/////////////////////// End Woocommerce Routines //////////////////////////

if ( ! function_exists( 'themify_get_term_description' ) ) {
	/**
	 * Returns term description
	 * @param string $taxonomy The taxonomy for the term that will be described.
	 * @return string
	 * @since 1.5.6
	 */
	function themify_get_term_description( $taxonomy = 'category' ) {
		$term_description = term_description( 0, $taxonomy );
		if ( ! empty( $term_description ) ) {
			return apply_filters( 'themify_get_term_description', '<div class="category-description">' . $term_description . '</div>' );
		} else {
			return '';
		}
	}
}

if ( ! function_exists( 'themify_get_all_terms_ids' ) ) {
	/**
	 * Returns all IDs from the given taxonomy
	 * @param string $tax Taxonomy to retrieve terms from.
	 * @return array $term_ids Array of all taxonomy terms
	 * @since 1.5.6
	 */
	function themify_get_all_terms_ids($tax = 'category') {
		if ( ! $term_ids = wp_cache_get( 'all_'.$tax.'_ids', $tax ) ) {
			$term_ids = get_terms( $tax, array('fields' => 'ids', 'get' => 'all') );
			wp_cache_add( 'all_'.$tax.'_ids', $term_ids, $tax );
		}
		return $term_ids;
	}
}

if ( ! function_exists('themify_get_google_web_fonts_list') ) {
	/**
	 * Returns a list of Google Web Fonts
	 * @return array
	 * @since 1.5.6
	 */
	function themify_get_google_web_fonts_list() {
		$google_fonts_list = array(
			array('value' => '', 'name' => ''),
			array(
				'value' => '',
				'name' => '--- '.__('Google Fonts', 'themify').' ---'
			)
		);
		foreach( wp_list_pluck( themify_get_google_font_lists(), 'family' ) as $font ) {
			$google_fonts_list[] = array(
				'value' => $font,
				'name' => $font
			);
		}
		return apply_filters('themify_get_google_web_fonts_list', $google_fonts_list);
	}
}

if ( ! function_exists('themify_get_web_safe_font_list') ) {
	/**
	 * Returns a list of web safe fonts
	 * @param bool $only_names Whether to return only the array keys or the values as well
	 * @return mixed|void
	 * @since 1.0.0
	 */
	function themify_get_web_safe_font_list($only_names = false) {
		$web_safe_font_names = array(
			'Arial, Helvetica, sans-serif',
			'Verdana, Geneva, sans-serif',
			'Georgia, \'Times New Roman\', Times, serif',
			'\'Times New Roman\', Times, serif',
			'Tahoma, Geneva, sans-serif',
			'\'Trebuchet MS\', Arial, Helvetica, sans-serif',
			'Palatino, \'Palatino Linotype\', \'Book Antiqua\', serif',
			'\'Lucida Sans Unicode\', \'Lucida Grande\', sans-serif'
		);

		if( ! $only_names ) {
			$web_safe_fonts = array(
				array('value' => 'default', 'name' => '', 'selected' => true),
				array('value' => '', 'name' => '--- '.__('Web Safe Fonts', 'themify').' ---')
			);
			foreach( $web_safe_font_names as $font ) {
				$web_safe_fonts[] = array(
					'value' => $font,
					'name' => str_replace( '\'', '"', $font )
				);
			}
		} else {
			$web_safe_fonts = $web_safe_font_names;
		}

		return apply_filters( 'themify_get_web_safe_font_list', $web_safe_fonts );
	}
}

if ( ! function_exists( 'themify_generic_slider_controls' ) ) {
	/**
	 * Creates a general module to setup slider parameters
	 * @param $prefix
	 * @return string
	 */
	function themify_generic_slider_controls( $prefix ) {
		/**
		 * Associative array containing theme settings
		 * @var array
		 */
		$data = themify_get_data();

		$auto_options = apply_filters( 'themify_generic_slider_auto',
			array(
				__('4 Secs (default)', 'themify') => 4000,
				__('Off', 'themify') => 'off',
				__('1 Sec', 'themify') => 1000,
				__('2 Secs', 'themify') => 2000,
				__('3 Secs', 'themify') => 3000,
				__('4 Secs', 'themify') => 4000,
				__('5 Secs', 'themify') => 5000,
				__('6 Secs', 'themify') => 6000,
				__('7 Secs', 'themify') => 7000,
				__('8 Secs', 'themify') => 8000,
				__('9 Secs', 'themify') => 9000,
				__('10 Secs', 'themify')=> 10000
			)
		);
		$speed_options = apply_filters( 'themify_generic_slider_speed',
			array(
				__('Fast', 'themify') => 500,
				__('Normal', 'themify') => 1000,
				__('Slow', 'themify') => 1500
			)
		);
		$effect_options = array(
			array('name' => __('Slide', 'themify'), 'value' => 'slide'),
			array('name' => __('Fade', 'themify'), 'value' =>'fade')
		);

		/**
		 * Auto Play
		 */
		$output = '<p>
						<span class="label">' . __('Auto Play', 'themify') . '</span>
						<select name="'.$prefix.'autoplay">';
						foreach($auto_options as $name => $val){
							$output .= '<option value="'.$val.'" ' . selected($data[$prefix.'autoplay'], $data[$prefix.'autoplay']? $val: 4000, false) . '>'.$name.'</option>';
						}
		$output .= '	</select>
					</p>';

		/**
		 * Effect
		 */
		$output .= '<p>
						<span class="label">' . __('Effect', 'themify') . '</span>
						<select name="'.$prefix.'effect">'.
						themify_options_module($effect_options, $prefix.'effect') . '
						</select>
					</p>';

		/**
		 * Transition Speed
		 */
		$output .= '<p>
						<span class="label">' . __('Transition Speed', 'themify') . '</span>
						<select name="'.$prefix.'transition_speed">';
						foreach($speed_options as $name => $val){
							$output .= '<option value="'.$val.'" ' . selected($data[$prefix.'transition_speed'], $data[$prefix.'transition_speed']? $val: 500, false) . '>'.$name.'</option>';
						}
		$output .= '	</select>
					</p>';

		return apply_filters( 'themify_generic_slider_controls', $output );
	}
}

if ( function_exists( 'icl_register_string' ) ) {
	/**
	 * Make dynamic strings in Themify theme available for translation with WPML String Translation
	 * @param $context
	 * @param $name
	 * @param $value
	 * @since 1.5.3
	 */
	function themify_register_wpml_strings( $context, $name, $value ) {
	    $value = maybe_unserialize( $value );
	    if ( is_array( $value ) ) {
	        foreach ( $value as $k => $v ) {
				themify_register_wpml_strings( $context, $k, $v );
			}
	    } else {
			$translatable = array(
				'setting-footer_text_left',
				'setting-footer_text_right',
				'setting-homepage_welcome',
				'setting-action_text',
			);
			foreach ( array('one','two','three','four','five','six','seven','eight','nine','ten') as $option ) {
				$translatable[] = 'setting-slider_images_' . $option . '_title';
				$translatable[] = 'setting-header_slider_images_' . $option . '_title';
				$translatable[] = 'setting-footer_slider_images_' . $option . '_title';
			}
			if ( stripos( $name, 'title_themify-link' ) || in_array( $name, $translatable ) ) {
				icl_register_string( $context, $name, $value );
			}
	    }
	}
	themify_register_wpml_strings( 'Themify', 'Themify Option', themify_get_data() );
}

if ( ! function_exists( 'themify_is_touch' ) ) {
	/**
	* Returns true if it's a phone or tablet
	* @return mixed
	* @since 1.6.8
	*/
	function themify_is_touch( $check = 'all' ) {
		global $themify_mobile_detect;
		switch ( $check ) {
			case 'all':
			return $themify_mobile_detect->isMobile();
			break;
			case 'phone':
			return $themify_mobile_detect->isMobile() && ! $themify_mobile_detect->isTablet();
			break;
			case 'tablet':
			return $themify_mobile_detect->isTablet();
			break;
		}
	}
}

if ( ! function_exists( 'themify_js_window_resize' ) ) {
	/**
	 * Trigger window resize event on JS
	 * @since 1.6.8
	 */
	function themify_js_window_resize() {
		echo "\n<script>\n\tjQuery(window).load(function(){ jQuery(window).resize(); });\n</script>\n";
	}
	add_action( 'wp_footer', 'themify_js_window_resize', 99999 );
}

/**
 * Display the Hook Content admin screen
 *
 * @since 1.6.9
 */
function themify_hooks_config_view() {
	return $GLOBALS['themify_hooks']->config_view();
}

if ( ! function_exists( 'themify_wpml_pagination_setup' ) && class_exists( 'SitePress' ) ) {
	/**
	 * Checks if WPML is active and if so, sets the correct page number.
	 * @param $wp_query
	 * @since 1.7.3
	 */
	function themify_wpml_pagination_setup( $wp_query ) {
		$paged = 1;
		if ( get_query_var( 'paged' ) ) {
			$paged = get_query_var( 'paged' );
		} elseif( get_query_var( 'page' ) ) {
			$paged = get_query_var( 'page' );
		}
		set_query_var( 'paged', $paged );
	}
	add_action( 'pre_get_posts', 'themify_wpml_pagination_setup' );
}

/**
 * Checks that status of the image script.
 * @return bool
 * @since 1.7.4
 */
function themify_is_image_script_disabled() {
	if ( themify_check( 'setting-img_settings_use' ) ) {
		return true;
	}
	return false;
}

/**
 * Load demo importer classname and it's dependencies.
 *
 * @since 1.7.6
 */
function themify_import_sample_content_setup() {

	define( 'WP_LOAD_IMPORTERS', true );

	require_once ABSPATH . 'wp-admin/includes/taxonomy.php';
	require_once ABSPATH . 'wp-admin/includes/post.php';
	require_once ABSPATH . 'wp-admin/includes/image.php';
	include THEMIFY_DIR . '/demo-import/demo-importer.php';

	class Themify_Import extends WP_Import {

		/**
		 * Replace attachments with the placeholder image provided by the theme.
		 *
		 * @return int $post_id
		 * @since 1.7.6
		 */
		public function process_attachment( $post, $url ) {
			$upload = wp_upload_bits( $post['post_name'] . '.jpg', null, file_get_contents( get_template_directory() . '/sample/image-placeholder.jpg' ) );

			if ( $info = wp_check_filetype( $upload['file'] ) )
				$post['post_mime_type'] = $info['type'];
			else
				return new WP_Error( 'attachment_processing_error', __( 'Invalid file type', 'themify' ) );

			$post['guid'] = $upload['url'];
			$post_id = wp_insert_attachment( $post, $upload['file'] );
			wp_update_attachment_metadata( $post_id, wp_generate_attachment_metadata( $post_id, $upload['file'] ) );

			return $post_id;
		}

		/**
		 * Replace the original post author with "themify" user.
		 *
		 * @since 1.7.6
		 */
		public function __get_author_mapping() {
			$user_id = wp_create_user( 'themify', wp_generate_password() );
			foreach ( $this->authors as $i => $old_login ) {
				$santized_old_login = sanitize_user( $old_login, true );
				$old_id = isset( $this->authors[$old_login]['author_id'] ) ? intval($this->authors[$old_login]['author_id']) : false;
				$this->processed_authors[$old_id] = $user_id;
				$this->author_mapping[$santized_old_login] = $user_id;
			}
		}
	}
}

/**
 * Performs importing the sample contents to replicate the theme's demo site
 *
 * @since 1.7.6
 */
function themify_do_import_sample_contents() {
	do_action( 'themify_before_demo_import' );

	themify_import_sample_content_setup();
	$import = new Themify_Import();
	$import->fetch_attachments = true;
	$import->import( get_template_directory().'/sample/sample-content.gz' );

	if( file_exists( THEME_DIR . '/sample/demo-settings.php' ) ) {
		require_once( THEME_DIR . '/sample/demo-settings.php' );
	}

	do_action( 'themify_after_demo_import' );
}

/**
 * Undo demo setup and reverts back to state before importing the sample contents.
 * Does not remove post/pages that have been modified by the user.
 *
 * @since 1.7.6
 */
function themify_undo_import_sample_content() {
	do_action( 'themify_before_demo_erase' );
	
	themify_import_sample_content_setup();
	$import = new Themify_Import();
	$data = $import->parse( get_template_directory().'/sample/sample-content.gz' );

	foreach( $data['categories'] as $cat ) {
		$term_id = term_exists( $cat['category_nicename'], 'category' );
		if( $term_id ) {
			if ( is_array($term_id) ) $term_id = $term_id['term_id'];
			if ( isset($cat['term_id']) ) {
				wp_delete_category( $term_id );
			}
		}
	}

	foreach( $data['tags'] as $tag ) {
		$term_id = term_exists( $tag['tag_slug'], 'post_tag' );
		if( $term_id ) {
			if ( is_array($term_id) ) $term_id = $term_id['term_id'];
			if ( isset($tag['term_id']) ) {
				wp_delete_term( $term_id, 'post_tag' );
			}
		}
	}

	foreach( $data['terms'] as $term ) {
		$term_id = term_exists( $term['slug'], $term['term_taxonomy'] );
		if ( $term_id ) {
			if ( is_array($term_id) ) $term_id = $term_id['term_id'];
			if ( isset($term['term_id']) ) {
				wp_delete_term( $term_id, $term['term_taxonomy'] );
			}
		}
	}

	foreach( $data['posts'] as $post ) {
		$post_exists = post_exists( $post['post_title'], '', $post['post_date'] );
		if( $post_exists && get_post_type( $post_exists ) == $post['post_type'] ) {
			/* check if the post has not been modified since it was created */
			if( $post['post_date'] == get_post_field( 'post_modified', $post_exists ) ) {
				wp_delete_post( $post_exists, true ); // true: bypass trash
			}
		}
	}

	do_action( 'themify_after_demo_erase' );
}

/**
 * Set a default title for the front page
 *
 * @return string
 * @since 1.7.6
 */
function themify_filter_wp_title( $title, $sep ) {
	if( empty( $title ) && ( is_home() || is_front_page() ) ) {
		return get_bloginfo( 'name' );
	}

	return $title;
}
add_filter( 'wp_title', 'themify_filter_wp_title', 10, 2 );

/**
 * Performs a beautified dump of a variable
 * @param mixed $var By reference. Variable to dump.
 */
if(!function_exists('themify_dumpit')){
	function themify_dumpit(&$var, $var_name = NULL, $indent = NULL, $reference = NULL){
		$do_dump_indent = "<span style='color:#666666;'>|</span> &nbsp;&nbsp; ";
		$reference = $reference.$var_name;
		$keyvar = 'the_do_dump_recursion_protection_scheme'; $keyname = 'referenced_object_name';
		echo "<div style='text-align:left; background-color:white; font: 100% monospace; color:black;'>";
		if (is_array($var) && isset($var[$keyvar])){ $real_var = &$var[$keyvar]; $real_name = &$var[$keyname];
			$type = ucfirst(gettype($real_var));
			echo "$indent$var_name <span style='color:#666666'>$type</span> = <span style='color:#e87800;'>&amp;$real_name</span><br>";
		}else{$var = array($keyvar => $var, $keyname => $reference);
	$avar = &$var[$keyvar];	$type = ucfirst(gettype($avar));
	if($type == "String") $type_color = "<span style='color:green'>";
	elseif($type == "Integer") $type_color = "<span style='color:red'>";
	elseif($type == "Double"){ $type_color = "<span style='color:#0099c5'>"; $type = "Float"; }
	elseif($type == "Boolean") $type_color = "<span style='color:#92008d'>";
	elseif($type == "NULL") $type_color = "<span style='color:black'>";
			if(is_array($avar)){$count = count($avar);echo "$indent" . ($var_name ? "$var_name => ":"") . "<span style='color:#666666'>$type ($count)</span><br>$indent(<br>";
			$keys = array_keys($avar);
				foreach($keys as $name){ $value = &$avar[$name]; themify_dumpit($value, "['$name']", $indent.$do_dump_indent, $reference);}	echo "$indent)<br>";}elseif(is_object($avar)){	echo "$indent$var_name <span style='color:#666666'>$type</span><br>$indent(<br>";
				foreach($avar as $name=>$value) themify_dumpit($value, "$name", $indent.$do_dump_indent, $reference);
				echo "$indent)<br>"; }elseif(is_int($avar)) echo "$indent$var_name = <span style='color:#666666'>$type(".strlen($avar).")</span> $type_color".htmlentities($avar)."</span><br>"; 	elseif(is_string($avar)) echo "$indent$var_name = <span style='color:#666666'>$type(".strlen($avar).")</span> $type_color\"".htmlentities($avar)."\"</span><br>"; elseif(is_float($avar)) echo "$indent$var_name = <span style='color:#666666'>$type(".strlen($avar).")</span> $type_color".htmlentities($avar)."</span><br>"; elseif(is_bool($avar)) echo "$indent$var_name = <span style='color:#666666'>$type(".strlen($avar).")</span> $type_color".($avar == 1 ? "TRUE":"FALSE")."</span><br>";
			elseif(is_null($avar)) echo "$indent$var_name = <span style='color:#666666'>$type(".strlen($avar).")</span> {$type_color}NULL</span><br>";
			else echo "$indent$var_name = <span style='color:#666666'>$type(".strlen($avar).")</span> ".htmlentities($avar)."<br>";	$var = $var[$keyvar];	} echo '</div>';}}

?>