<?php

/*-----------------------------------------------------------------------------------

	Plugin Name: Timeline Recent Custom Posts Widget
	Plugin URI: http://www.anarieldesign.com
	Description: A widget that allows the display timeline posts.
	Version: 1.0
	Author: Anariel Design
	Author URI: http://www.anarieldesign.com

-----------------------------------------------------------------------------------*/


// Add function to widgets_init that'll load our widget.
add_action( 'widgets_init', 'goodolwine_timeline_widgets' );


// Register widget.
function goodolwine_timeline_widgets() {
	register_widget( 'goodolwine_timeline_Widget' );
}

// Widget class.
class goodolwine_timeline_widget extends WP_Widget {


/*-----------------------------------------------------------------------------------*/
/*	Widget Setup
/*-----------------------------------------------------------------------------------*/
	
	function goodolwine_timeline_Widget() {
	
		/* Widget settings. */
		$widget_ops = array( 'classname' => 'goodolwine_timeline_widget', 'description' => __('Timeline Posts', 'goodolwine') );

		/* Widget control settings. */
		$control_ops = array( 'width' => 300, 'height' => 350, 'id_base' => 'goodolwine_timeline_widget' );

		/* Create the widget. */
		$this->WP_Widget( 'goodolwine_timeline_widget', __('Good Ol Wine - Timeline Posts', 'goodolwine'), $widget_ops, $control_ops );
	}


/*-----------------------------------------------------------------------------------*/
/*	Display Widget
/*-----------------------------------------------------------------------------------*/
         function update($new_instance, $old_instance) { 
			return $new_instance;	 
		}
	function widget( $args, $instance ) {
		extract( $args );
		extract($instance);	
		
		$title = apply_filters('widget_title', $instance['title'] );

		/* Our variables from the widget settings. */
		$instance['title'] = $instance['title'];
		
		$title_one = $instance['title_one'];
		$number = $instance['number'];
		
		/* Added by WPML Copmpatibility team. */
        if (function_exists('icl_translate')) { $title_one = icl_translate('good_wine_widget', "$widget_id-widget[title_one]", $title_one); }
        if (function_exists('icl_translate')) { $number = icl_translate('good_wine_widget', "$widget_id-widget[number]", $number); }

		/* Before widget (defined by themes). */
		echo $before_widget;

		/* Display Widget */
		?>
 <div class="winesintro">
<h2 class="center"><?php echo $title; ?></h2>
<div class="entry-content">
  <h3><?php echo $title_one; ?></h3>
</div>
</div>
            <!-- Timeline  ==================================================
================================================== -->
 <section class="timeline">
      <div class="grids">
       <?php 
                    $query = new WP_Query();
                    $query->query('posts_per_page='.$number.'&ignore_sticky_posts=1&post_type=timeline');
                    ?>
  <?php if ($query->have_posts()) : while ($query->have_posts()) : $query->the_post(); ?>
  
        <div class="grid">
          <figure> <a href="<?php the_permalink() ?>">
            <?php 
		if ( has_post_thumbnail() ) { // check if the post has a Post Thumbnail assigned to it.
		  the_post_thumbnail();
		} 
       ?>
            </a> </figure>
          <article class="history">
            <h3 class="title">
              <?php the_title(); ?>
            </h3>
            <?php the_excerpt(); ?>
          </article>
        </div>
       <?php endwhile; endif; ?>
  <?php wp_reset_query(); ?>
      </div>
      <section>
            
  <?php

		/* After widget (defined by themes). */
		echo $after_widget;
	}

/*-----------------------------------------------------------------------------------*/
/*	Widget Settings
/*-----------------------------------------------------------------------------------*/
	 
	function form( $instance ) {

		/* Set up some default widget settings. */
		$defaults = array(
		'title' => 'Our timeline',
		'title_one' => 'Best timeline from our archive',
		
		'number' => 8
		
		);
		$instance = wp_parse_args( (array) $instance, $defaults ); ?>
  
  <!-- Widget Title: Text Input -->
  <p>
    <label for="<?php echo $this->get_field_id( 'title' ); ?>">
      <?php _e('Title:', 'goodolwine') ?>
    </label>
    <input type="text" class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance['title']; ?>" />
  </p>
  
   <p>
    <label for="<?php echo $this->get_field_id( 'title_one' ); ?>">
      <?php _e('Text under the title:', 'goodolwine') ?>
    </label>
    <input type="text" class="widefat" id="<?php echo $this->get_field_id( 'title_one' ); ?>" name="<?php echo $this->get_field_name( 'title_one' ); ?>" value="<?php echo $instance['title_one']; ?>" />
  </p>
  
  <!-- Widget Title: Text Input -->
  <p>
    <label for="<?php echo $this->get_field_id( 'number' ); ?>">
      <?php _e('Amount to show:', 'goodolwine') ?>
    </label>
    <input type="text" class="widefat" id="<?php echo $this->get_field_id( 'number' ); ?>" name="<?php echo $this->get_field_name( 'number' ); ?>" value="<?php echo $instance['number']; ?>" />
  </p>
  
  <?php
	}
}