<?php

/*-----------------------------------------------------------------------------------

	Plugin Name: Recent Posts Widget
	Plugin URI: http://www.anarieldesign.com
	Description: A widget that allows the display latest posts.
	Version: 1.0
	Author: Anariel Design
	Author URI: http://www.anarieldesign.com

-----------------------------------------------------------------------------------*/


// Add function to widgets_init that'll load our widget.
add_action( 'widgets_init', 'goodolwine_blogpost_widgets' );


// Register widget.
function goodolwine_blogpost_widgets() {
	register_widget( 'goodolwine_blogpost_Widget' );
}

// Widget class.
class goodolwine_blogpost_widget extends WP_Widget {


/*-----------------------------------------------------------------------------------*/
/*	Widget Setup
/*-----------------------------------------------------------------------------------*/
	
	function goodolwine_blogpost_Widget() {
	
		/* Widget settings. */
		$widget_ops = array( 'classname' => 'goodolwine_blogpost_widget', 'description' => __('Your site most recent Posts.', 'goodolwine') );

		/* Widget control settings. */
		$control_ops = array( 'width' => 300, 'height' => 350, 'id_base' => 'goodolwine_blogpost_widget' );

		/* Create the widget. */
		$this->WP_Widget( 'goodolwine_blogpost_widget', __('Good Ol Wine - Recent Posts', 'goodolwine'), $widget_ops, $control_ops );
	}


/*-----------------------------------------------------------------------------------*/
/*	Display Widget
/*-----------------------------------------------------------------------------------*/
	
	function widget( $args, $instance ) {
		extract( $args );
		
		$title = apply_filters('widget_title', $instance['title'] );

		/* Our variables from the widget settings. */
		$number = $instance['number'];
		$category = $instance['category'];

		/* Before widget (defined by themes). */
		echo $before_widget;

		/* Display Widget */
		?>
<?php /* Display the widget title if one was input (before and after defined by themes). */
				if ( $title )
					echo $before_title . $title . $after_title;
				?>
  <?php 
                    $query = new WP_Query();
                    $query->query('category_name='.$category.'&posts_per_page='.$number.'&ignore_sticky_posts=1');
                    ?>
  <?php if ($query->have_posts()) : while ($query->have_posts()) : $query->the_post(); ?>
  
  <div class="bg title">
    <section class="cbp-so-section">
      <div class="left">
        <figure class="cbp-so-side cbp-so-side-left">
          <?php if ( has_post_thumbnail() ): ?>
          <a href="<?php the_permalink(); ?>">
          <?php the_post_thumbnail(); ?>
          </a>
          <?php endif; ?>
        </figure>
      </div>
      <div class="page hfeed site">
        <div id="main" class="site-main">
          <div class="right">
            <article class="cbp-so-side cbp-so-side-right">
              <h4 class="date">
                <?php the_date(); ?>
              </h4>
              <h3 class="special">
                <?php the_title(); ?>
              </h3>
              <?php the_excerpt(); ?>
            </article>
          </div>
        </div>
      </div>
    </section>
    <!-- cbp-so-section ends here --> 
  </div>
    <?php endwhile; endif; ?>
  <?php wp_reset_query(); ?>
  
  <?php

		/* After widget (defined by themes). */
		echo $after_widget;
	}


/*-----------------------------------------------------------------------------------*/
/*	Update Widget
/*-----------------------------------------------------------------------------------*/
	
	function update( $new_instance, $old_instance ) {
		
		$instance = $old_instance;
		
		/* Strip tags to remove HTML (important for text inputs). */
		$instance['title'] = strip_tags( $new_instance['title'] );
		$instance['number'] = strip_tags( $new_instance['number'] );
		$instance['category'] = strip_tags( $new_instance['category'] );

		/* No need to strip tags for.. */

		return $instance;
	}
	

/*-----------------------------------------------------------------------------------*/
/*	Widget Settings
/*-----------------------------------------------------------------------------------*/
	 
	function form( $instance ) {

		/* Set up some default widget settings. */
		$defaults = array(
		'title' => '',
		
		'number' => 1,
		'category' => ''
		
		);
		$instance = wp_parse_args( (array) $instance, $defaults ); ?>
  
  <!-- Widget Title: Text Input -->
  <p>
    <label for="<?php echo $this->get_field_id( 'title' ); ?>">
      <?php _e('Title:', 'goodolwine') ?>
    </label>
    <input type="text" class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance['title']; ?>" />
  </p>
  
  <!-- Widget Title: Text Input -->
  <p>
    <label for="<?php echo $this->get_field_id( 'number' ); ?>">
      <?php _e('Amount to show:', 'goodolwine') ?>
    </label>
    <input type="text" class="widefat" id="<?php echo $this->get_field_id( 'number' ); ?>" name="<?php echo $this->get_field_name( 'number' ); ?>" value="<?php echo $instance['number']; ?>" />
  </p>
  
  <p>
  <label for="<?php echo $this->get_field_id( 'category' ); ?>">
    <?php _e('Category:', 'goodolwine') ?>
  </label>
  <input type="text" class="widefat" id="<?php echo $this->get_field_id( 'category' ); ?>" name="<?php echo $this->get_field_name( 'category' ); ?>" value="<?php echo $instance['category']; ?>" />
</p>
  <?php
	}
}

