<?php

/*-----------------------------------------------------------------------------------

	Name: God Ol' Wine Welcome Note Widget
	Description: Welcome note with opening hours
	
-----------------------------------------------------------------------------------*/


// Add function to widgets_init that'll load our widget.
add_action( 'widgets_init', 'godolwine_biobox_widgets' );


// Register widget.
function godolwine_biobox_widgets() {
	register_widget( 'godolwine_biobox_Widget' );
}

// Widget class.
class godolwine_biobox_widget extends WP_Widget {


/*-----------------------------------------------------------------------------------*/
/*	Widget Setup
/*-----------------------------------------------------------------------------------*/
	
	function godolwine_biobox_Widget() {
	
		/* Widget settings. */
		$widget_ops = array( 'classname' => 'godolwine_biobox_widget', 'description' => __('Welcome Note', 'godolwine') );

		/* Widget control settings. */
		$control_ops = array( 'width' => 300, 'height' => 350, 'id_base' => 'godolwine_biobox_widget' );

		/* Create the widget. */
		$this->WP_Widget( 'godolwine_biobox_widget', __('Good Ol Wine - Welcome Note Widget', 'godolwine'), $widget_ops, $control_ops );
	}
/*-----------------------------------------------------------------------------------*/
/*	Display Widget
/*-----------------------------------------------------------------------------------*/
        function update($new_instance, $old_instance) { 
			return $new_instance;	 
		}
	function widget( $args, $instance ) {
		extract( $args );
		extract($instance);	
		
		$title = apply_filters('widget_title', $instance['title'] );

		/* Our variables from the widget settings. */
		$instance['title'] = $instance['title'];
		
		$title_one = $instance['title_one'];
		$title_two = $instance['title_two'];
		$daily = $instance['daily']; 
		$title_three = $instance['title_three']; 
		$holidays = $instance['holidays'];  
		
		/* Added by WPML Copmpatibility team. */
        if (function_exists('icl_translate')) { $title_one = icl_translate('good_wine_widget', "$widget_id-widget[title_one]", $title_one); }
        if (function_exists('icl_translate')) { $title_two = icl_translate('good_wine_widget', "$widget_id-widget[title_two]", $title_two); }
        if (function_exists('icl_translate')) { $daily = icl_translate('good_wine_widget', "$widget_id-widget[daily]", $daily); }
		if (function_exists('icl_translate')) { $title_three = icl_translate('good_wine_widget', "$widget_id-widget[title_three]", $title_three); }
        if (function_exists('icl_translate')) { $holidays = icl_translate('good_wine_widget', "$widget_id-widget[holidays]", $holidays); }

		/* Before widget (defined by themes). */
		echo $before_widget;

		/* Display Widget */
		?>
        
         <div class="home-welcome">
        <h3 class="footerspecial"><?php echo $title; ?> <br>
            <?php echo $title_one; ?></h3>
          <h4><?php echo $title_two; ?> <br>
            <?php echo $daily; ?></h4>
            <br>
             <h4><?php echo $title_three; ?> <br>
            <?php echo $holidays; ?></h4>
          </div>
        
<?php

		/* After widget (defined by themes). */
		echo $after_widget;
	}

/*-----------------------------------------------------------------------------------*/
/*	Widget Settings
/*-----------------------------------------------------------------------------------*/
	 
	function form( $instance ) {

		/* Set up some default widget settings. */
		$defaults = array(
	
			'title' => 'Welcome to Winery',
			
			'title_one' => 'Good Ol Wine',
			
			'title_two' => 'Open Daily',
			
			'daily' => '12:00am-8:00pm',
			
			'title_three' => 'Holidays',
			
			'holidays' => '12:00am-5:00pm',
			
			
		
		);
		$instance = wp_parse_args( (array) $instance, $defaults ); ?>

<!-- Widget Title: Text Input -->
<p>
  <label for="<?php echo $this->get_field_id( 'title' ); ?>">
    <?php _e('Welcome Text First Row:', 'godolwine') ?>
  </label>
  <br>
  <textarea type="text" rows="3" cols="45" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>"><?php echo $instance['title']; ?></textarea>
</p>
<hr>
<p>
  <label for="<?php echo $this->get_field_id( 'title_one' ); ?>">
    <?php _e('Welcome Text Second Row:', 'godolwine') ?>
  </label>
  <br>
  <textarea type="text" rows="3" cols="45" id="<?php echo $this->get_field_id( 'title_one' ); ?>" name="<?php echo $this->get_field_name( 'title_one' ); ?>"><?php echo $instance['title_one']; ?></textarea>
</p>
<hr>
<p>
  <label for="<?php echo $this->get_field_id( 'title_two' ); ?>">
    <?php _e('Open Daily Text:', 'godolwine') ?>
  </label>
  <br>
  <textarea type="text" rows="3" cols="45" id="<?php echo $this->get_field_id( 'title_two' ); ?>" name="<?php echo $this->get_field_name( 'title_two' ); ?>"><?php echo $instance['title_two']; ?></textarea>
</p>
<hr>
<p>
  <label for="<?php echo $this->get_field_id( 'daily' ); ?>">
    <?php _e('Daily Opening Hours:', 'godolwine') ?>
  </label>
  <br>
  <textarea type="text" rows="3" cols="45" id="<?php echo $this->get_field_id( 'daily' ); ?>" name="<?php echo $this->get_field_name( 'daily' ); ?>"><?php echo $instance['daily']; ?></textarea>
</p>

<hr>
<p>
  <label for="<?php echo $this->get_field_id( 'title_three' ); ?>">
    <?php _e('Holidays Text:', 'godolwine') ?>
  </label>
  <br>
  <textarea type="text" rows="3" cols="45" id="<?php echo $this->get_field_id( 'title_three' ); ?>" name="<?php echo $this->get_field_name( 'title_three' ); ?>"><?php echo $instance['title_three']; ?></textarea>
</p>
<hr>
<p>
  <label for="<?php echo $this->get_field_id( 'holidays' ); ?>">
    <?php _e('Holidays Hours:', 'godolwine') ?>
  </label>
  <br>
  <textarea type="text" rows="3" cols="45" id="<?php echo $this->get_field_id( 'holidays' ); ?>" name="<?php echo $this->get_field_name( 'holidays' ); ?>"><?php echo $instance['holidays']; ?></textarea>
</p>
<?php
	}
}