<?php
/**
 * Template Name: Wine Products Page 
 *
 * @package Good Ol' Wine
 */

get_header( 'custom' ); ?>
<?php if ( has_post_thumbnail() ): ?>
<?php while ( have_posts() ) : the_post(); ?>
<?php $image_id = get_post_thumbnail_id(); ?>
<?php $image_url = wp_get_attachment_image_src($image_id,'small');   ?>

<div class="header version section" style="background-image:url(<?php echo $image_url[0]; ?>);"></div>
<?php endwhile; // end of the loop. ?>

<!-- Page Content ==================================================
================================================== -->
<div class="pagewrap">
<div class="page hfeed site">
  <div id="main" class="site-main">
    <?php while ( have_posts() ) : the_post(); ?>
    <?php get_template_part( 'content', 'winepage' ); ?>
    <?php endwhile; // end of the loop. ?>
    <?php 
//list terms in a given taxonomy using wp_list_categories (also useful as a widget if using a PHP Code plugin)
$taxonomy     = 'wineproducts_cat';
$orderby      = 'name'; 
$show_count   = 0;      // 1 for yes, 0 for no
$pad_counts   = 0;      // 1 for yes, 0 for no
$hierarchical = 1;      // 1 for yes, 0 for no
$title        = '';

$args = array(
  'taxonomy'     => $taxonomy,
  'orderby'      => $orderby,
  'show_count'   => $show_count,
  'pad_counts'   => $pad_counts,
  'hierarchical' => $hierarchical,
  'title_li'     => $title
);
?>
    <?php 
// query args
$query = array(
'post_type' => 'wineproducts',
'posts_per_page' => 9999999,
'paged' => ( get_query_var('paged') ? get_query_var('paged') : true )
);
// query
query_posts( $query );

global $more;
$more = 0;
?>
    
    <!-- Wines ==================================================
================================================== -->
    <div class="wines">
      <div class="main">
        <ul class="cbp-ig-grid">
          <?php 
	  if ( have_posts() ) : while ( have_posts() ) : the_post();?>
          <li> <a href="<?php the_permalink() ?>">
            <?php 
		if ( has_post_thumbnail() ) { // check if the post has a Post Thumbnail assigned to it.
		  the_post_thumbnail();
		} 
       ?>
            <h3 class="cbp-ig-title">
              <?php the_title(); ?>
            </h3>
            <span class="cbp-ig-category">
            <?php the_excerpt(); ?>
            </span> </a>
            <?php
endwhile;
else :
?>
          </li>
        </ul>
        <?php
 
endif; // END the Wordpress Loop
?>
      </div>
      <!-- main ends here --> 
    </div>
    <!-- wines ends here --> 
  </div>
</div>
</div>
<?php else: ?>

<!-- Page Content ==================================================
================================================== -->

<div class="page layout hfeed site">
<div id="main" class="site-main">
  <?php while ( have_posts() ) : the_post(); ?>
  <?php get_template_part( 'content', 'winepage' ); ?>
  <?php endwhile; // end of the loop. ?>
  <?php 
//list terms in a given taxonomy using wp_list_categories (also useful as a widget if using a PHP Code plugin)
$taxonomy     = 'wineproducts_cat';
$orderby      = 'name'; 
$show_count   = 0;      // 1 for yes, 0 for no
$pad_counts   = 0;      // 1 for yes, 0 for no
$hierarchical = 1;      // 1 for yes, 0 for no
$title        = '';

$args = array(
  'taxonomy'     => $taxonomy,
  'orderby'      => $orderby,
  'show_count'   => $show_count,
  'pad_counts'   => $pad_counts,
  'hierarchical' => $hierarchical,
  'title_li'     => $title
);
?>
  <?php 
// query args
$query = array(
'post_type' => 'wineproducts',
'posts_per_page' => 9999999,
'paged' => ( get_query_var('paged') ? get_query_var('paged') : true )
);
// query
query_posts( $query );

global $more;
$more = 0;
?>
  
  <!-- Wines ==================================================
================================================== -->
  <div class="wines">
    <div class="main">
      <ul class="cbp-ig-grid">
        <?php 
	  if ( have_posts() ) : while ( have_posts() ) : the_post();?>
        <li> <a href="<?php the_permalink() ?>">
          <?php 
		if ( has_post_thumbnail() ) { // check if the post has a Post Thumbnail assigned to it.
		  the_post_thumbnail();
		} 
       ?>
          <h3 class="cbp-ig-title">
            <?php the_title(); ?>
          </h3>
          <span class="cbp-ig-category">
          <?php the_excerpt(); ?>
          </span> </a>
          <?php
endwhile;
else :
?>
        </li>
      </ul>
      <?php
 
endif; // END the Wordpress Loop
?>
    </div>
    <!-- main ends here --> 
  </div>
  <!-- wines ends here --> 
</div>
</div>
<?php endif; ?>
<?php get_footer( 'custom' ); ?>
