<?php
/**
 * The template for displaying Search Results pages.
 *
 * @package Good Ol' Wine
 */

get_header( 'custom' ); ?>

<div class="page hfeed site">
  <div id="main" class="site-main archive"> <br />
    <div class="hero page-header without-featured-image">
      <div>
        <div>
          <div>
            <h1 class="page-title">
              <?php
							if ( have_posts() ) :
								printf( __( 'Search Results for: %s', 'goodolwine' ), '<span>' . get_search_query() . '</span>' );
							else :
								_e( 'Nothing Found', 'goodolwine' );
							endif;
						?>
            </h1>
          </div>
        </div>
      </div>
    </div>
    <section id="primary" class="content-area single">
      <div id="content" class="site-content" role="main">
        <?php if ( have_posts() ) : ?>
        <?php while ( have_posts() ) : the_post(); ?>
        <?php get_template_part( 'content', 'search' ); ?>
        <?php endwhile; ?>
        <?php goodolwine_content_nav( 'nav-below' ); ?>
        <?php else : ?>
        <?php get_template_part( 'no-results', 'search' ); ?>
        <?php endif; ?>
      </div>
      <!-- #content --> 
    </section>
    <!-- #primary -->
    
    <?php get_sidebar(); ?>
  </div>
</div>
<?php get_footer(); ?>
