<?php
/**
 * Template Name: Grid Page
 *
 * @package Good Ol' Wine
 */

get_header( 'custom' ); ?>
<?php if ( has_post_thumbnail() ): ?>
<?php while ( have_posts() ) : the_post(); ?>
<?php $image_id = get_post_thumbnail_id(); ?>
<?php $image_url = wp_get_attachment_image_src($image_id,'small');   ?>

<div class="header version section" style="background-image:url(<?php echo $image_url[0]; ?>);"></div>
<div class="pagewrap">
  <div class="page hfeed site">
    <div id="main" class="site-main">
      <div class="clearfix gridpage">
        <h1 class="page-title">
          <?php the_title(); ?>
        </h1>
        <?php endwhile; ?>
        <?php rewind_posts(); ?>
        <?php while ( have_posts() ) : the_post(); ?>
        <?php get_template_part( 'content', 'page' ); ?>
        <?php endwhile; // end of the loop. ?>
      </div>
      <div class="child-pages columns clearfix">
        <?php
					$child_pages = new WP_Query( array(
						'post_type'      => 'page',
						'orderby'        => 'menu_order',
						'order'          => 'ASC',
						'post_parent'    => $post->ID,
						'posts_per_page' => 999,
						'no_found_rows'  => true,
					) );

					while ( $child_pages->have_posts() ) : $child_pages->the_post();
						 get_template_part( 'content', 'grid' );
					endwhile;
					wp_reset_postdata();
				?>
      </div>
      <!-- .child-pages -->
      
      <?php
				// If comments are open or we have at least one comment, load up the comment template
				if ( comments_open() || '0' != get_comments_number() )
					comments_template();
			?>
    </div>
  </div>
</div>
<?php else: ?>
<div class="page layout hfeed site">
  <div id="main" class="site-main">
    <h1 class="page-title">
      <?php the_title(); ?>
    </h1>
    <?php while ( have_posts() ) : the_post(); ?>
    <?php get_template_part( 'content', 'page' ); ?>
    <?php endwhile; // end of the loop. ?>
  </div>
  <div class="child-pages columns clearfix">
    <?php
					$child_pages = new WP_Query( array(
						'post_type'      => 'page',
						'orderby'        => 'menu_order',
						'order'          => 'ASC',
						'post_parent'    => $post->ID,
						'posts_per_page' => 999,
						'no_found_rows'  => true,
					) );

					while ( $child_pages->have_posts() ) : $child_pages->the_post();
						 get_template_part( 'content', 'grid' );
					endwhile;
					wp_reset_postdata();
				?>
  </div>
  <!-- .child-pages -->
  
  <?php
				// If comments are open or we have at least one comment, load up the comment template
				if ( comments_open() || '0' != get_comments_number() )
					comments_template();
			?>
</div>
</div>
<?php endif; ?>
<?php get_footer( 'custom' ); ?>
