<?php
/**
 * Jetpack Compatibility File
 * See: http://jetpack.me/
 *
 * @package Good Ol' Wine
 */

/**
 * Add theme support for Infinite Scroll.
 * See: http://jetpack.me/support/infinite-scroll/
 */
function goodolwine_infinite_scroll_setup() {
	add_theme_support( 'infinite-scroll', array(
		'container' => 'content',
		'footer'    => 'page',
	) );
}
add_action( 'after_setup_theme', 'goodolwine_infinite_scroll_setup' );

/**
 * Do we have footer widgets? Or is it viewed from iPad or mobile?
 * If so let's switch to the "click to load" type IS
 *
 * @return bool
 */

function goodolwine_has_footer_widgets( $has_widgets ) {
	if ( Jetpack_User_Agent_Info::is_ipad() || ( function_exists( 'jetpack_is_mobile' ) && jetpack_is_mobile() ) || is_active_sidebar( 'sidebar-2' ) )

		return true;

	return $has_widgets;
}
add_filter( 'infinite_scroll_has_footer_widgets', 'goodolwine_has_footer_widgets' );

/**
 * Add theme support for Social Links
 * See: http://jetpack.me/support/social-links/
 */
function goodolwine_social_links() {
	add_theme_support( 'social-links', array(
		'facebook',
		'twitter',
		'linkedin',
		'tumblr',
	) );
}
add_action( 'after_setup_theme', 'goodolwine_social_links' );