<?php
/**
 * goodolwine Theme Customizer
 *
 * @package Good Ol' WIne
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function goodolwine_customize_register( $wp_customize ) {
	$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
	$wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';
/**
 * Adds the individual sections for custom logo
 */
$wp_customize->add_section( 'goodolwine_logo_section' , array(
    'title'       => __( 'Logo', 'goodolwine' ),
    'priority'    => 20,
    'description' => 'Upload a logo to replace the default site name and description in the header',
) );
$wp_customize->add_setting( 'goodolwine_logo', array(
	'sanitize_callback' => 'esc_url_raw',
) );
$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'goodolwine_logo', array(
    'label'    => __( 'Logo', 'goodolwine' ),
    'section'  => 'goodolwine_logo_section',
    'settings' => 'goodolwine_logo',
) ) );
/*-----------------------------------------------------------------------------------*/
/*	Adds the individual sections, settings, and controls to the theme customizer
/*-----------------------------------------------------------------------------------*/
    $wp_customize->add_section(
        'goodolwine_section_one',
        array(
            'title' => 'Copyright Settings',
            'description' => 'This is a settings section.',
            'priority' => 22,
        )
    );
	$wp_customize->add_setting(
    'copyright_textbox',
    array(
        'default' => 'Good Old Wine by Anariel Design. All rights reserved.',
		'sanitize_callback' => 'goodolwine_sanitize_text',
    )
);
$wp_customize->add_control(
    'copyright_textbox',
    array(
        'label' => 'Copyright text',
        'section' => 'goodolwine_section_one',
        'type' => 'text',
    )
);
$wp_customize->add_setting(
    'hide_copyright',
	array(
	'sanitize_callback' => 'goodolwine_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'hide_copyright',
    array(
        'type' => 'checkbox',
        'label' => 'Hide copyright text',
        'section' => 'goodolwine_section_one',
    )
);
/**
 * Adds the individual sections for custom favicon
 */
   $wp_customize->add_section( 'goodolwine_favicon_section' , array(
    'title'       => __( 'Favicon', 'goodolwine' ),
    'priority'    => 23,
    'description' => 'Upload a favicon',
) );
$wp_customize->add_setting( 
	'goodolwine_favicon',
	array(
	'sanitize_callback' => 'esc_url_raw',
	)
);
$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'goodolwine_favicon', array(
    'label'    => __( 'Favicon', 'goodolwine' ),
    'section'  => 'goodolwine_favicon_section',
    'settings' => 'goodolwine_favicon',
) ) );

/**
 * Adds the individual sections for custom colors
 */
	$wp_customize->add_setting('goodolwine_link_color', array(
        'default'           => '#5d2331',
        'sanitize_callback' => 'sanitize_hex_color'
    ));
 
    $wp_customize->add_control( new WP_Customize_Color_Control($wp_customize, 'goodolwine_link_color', array(
        'label'    => __('Change color of the dark red elements', 'goodolwine'),
        'section'  => 'colors',
		'priority' => 25,
        'settings' => 'goodolwine_link_color',
    )));
	
	$wp_customize->add_setting('goodolwine_linkone_color', array(
        'default'           => '#000',
        'sanitize_callback' => 'sanitize_hex_color'
    ));
 
    $wp_customize->add_control( new WP_Customize_Color_Control($wp_customize, 'goodolwine_linkone_color', array(
        'label'    => __('Change black background color elements ', 'goodolwine'),
        'section'  => 'colors',
		'priority' => 26,
        'settings' => 'goodolwine_linkone_color',
    )));
}
add_action( 'customize_register', 'goodolwine_customize_register' );
/**
 * Sanitization
 */
//Checkboxes
function goodolwine_sanitize_checkbox( $input ) {
	if ( $input == 1 ) {
		return 1;
	} else {
		return '';
	}
}
//Integers
function goodolwine_sanitize_int( $input ) {
    if( is_numeric( $input ) ) {
        return intval( $input );
    }
}
//Text
function goodolwine_sanitize_text( $input ) {
    return wp_kses_post( force_balance_tags( $input ) );
}
//No sanitize - empty function for options that do not require sanitization -> to bypass the Theme Check plugin
function goodolwine_no_sanitize( $input ) {
}
/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function goodolwine_customize_preview_js() {
	wp_enqueue_script( 'goodolwine-customizer', get_template_directory_uri() . '/js/customizer.js', array( 'customize-preview' ), '20130529', true );
}
add_action( 'customize_preview_init', 'goodolwine_customize_preview_js' );

function goodolwine_customizer_css() {
    ?>
    <style type="text/css">
        button, input[type="button"], input[type="reset"], input[type="submit"], button:focus, html input[type="button"]:focus, input[type="reset"]:focus, input[type="submit"]:focus, button:hover, html input[type="button"]:hover, input[type="reset"]:hover, input[type="submit"]:hover, .button:hover, .menu-toggle, .main-small-navigation div, .page-links > span, .entry-content .page-links a:hover, .entry-content .page-links a:active, .site-content [class*="navigation"] a, #content [class*="navigation"] a, #main [class*="navigation"] a, .widget_calendar #wp-calendar tbody a:hover, .footer .widget_calendar #wp-calendar caption, .footer a.homebutton, #infinite-handle span:hover, .tribe-events-list-widget h4, .tribe-events-widget-link a, #infinite-handle span { background-color: <?php echo get_theme_mod( 'goodolwine_link_color' ); ?>; }
		
		.site-branding, .soliloquy-theme-metro .soliloquy-caption .soliloquy-caption-inside p, .left.wines .entry-content a, .sticky .postdate.single, .single-tribe_events .tribe-events-schedule .tribe-events-cost, a.home:before { background: <?php echo get_theme_mod( 'goodolwine_link_color' ); ?>; }
		
		.home-welcome h3, .cbp-so-section .widget-title, .cbp-so-section .widget-title, .page blockquote, blockquote cite, .entry-title a:hover, .entry-meta a:hover, .galleryformat .entry-meta a:hover, .categories-links a:hover, .tags-links, .entry-header .entry-meta, .entry-meta a, footer.entry-meta .edit-link a:before, .cbp-ig-grid .cbp-ig-title, .cbp-ig-grid .cbp-ig-category, .cbp-ig-grid li > a:hover .cbp-ig-icon:before, .cbp-ig-grid li > a:hover .cbp-ig-title, h3.special, .right .cbp-so-side a.excerpt-link, a.more-link, a.excerpt-link, .format-aside .entry-content .entry-title a:hover, .format-quote .entry-content .entry-title a:hover, .postdate.single a:hover, .archive a.excerpt-link, .wp-caption-text, .site-content .navigation-comment a, .site-content .navigation-comment a:hover, .comment-notes, .logged-in-as, .no-comments, .trackback .edit-link a, .pingback .edit-link a, .comment-meta a, .comment-meta a:hover, #cancel-comment-reply-link, #cancel-comment-reply-link:hover, .widget a, .widget_flickr #flickr_badge_uber_wrapper a:hover, .widget_rss ul a, .widget_recent_entries .post-date, .widget_text a, .sidebar-widget-area .widgettitle, .sidebar-widget-area .widget-title, .sidebar-widget-area .widget-title a, .social-links a, .page-title a, #infinite-footer .blog-credits, #infinite-footer .blog-credits a, #infinite-footer .blog-info a:hover, #infinite-footer .blog-credits a:hover, #main div.sharedaddy h3.sd-title, .tribe-events-list .vevent.hentry a.tribe-events-read-more, a.home, .intro-content h3,  .entry-header .entry-meta,  .entry-format a:hover:before, .entry-date a:hover:before, .byline a:hover:before, .edit-link a:hover:before, .comments-link a:hover:before, .full-size-link a:hover:before, .parent-post-link a:hover:before, .comment-reply-link:hover:before, .comment-reply-login:hover:before .tribe-events-back a, #tribe-events a { color: <?php echo get_theme_mod( 'goodolwine_link_color' ); ?>; }
		
		.woocommerce ul.products a { color: <?php echo get_theme_mod( 'goodolwine_link_color' ); ?>!important; }
		
		input[type="text"]:focus, input[type="email"]:focus, input[type="password"]:focus, input[type="search"]:focus, textarea:focus { border-color: <?php echo get_theme_mod( 'goodolwine_link_color' ); ?>; }
		
		.widget_text a:hover { border--bottom-color: <?php echo get_theme_mod( 'goodolwine_link_color' ); ?>; }
		
		#masthead, #mastheadone, .postdate.single, .grid .history, span.amount, #mastheadtwo, .single .product span.amount { background: <?php echo get_theme_mod( 'goodolwine_linkone_color' ); ?>; }
		
	    #tribe-bar-form .tribe-bar-submit input[type=submit] { background: <?php echo get_theme_mod( 'goodolwine_linkone_color' ); ?>!important; }
		
		.footer, .navigation-main ul ul, .site-footer { background-color: <?php echo get_theme_mod( 'goodolwine_linkone_color' ); ?>; }
		
		.sidebar-widget-area { border-top-color: <?php echo get_theme_mod( 'goodolwine_linkone_color' ); ?>; }
		
		.room { border-right-color: <?php echo get_theme_mod( 'goodolwine_linkone_color' ); ?>; }


    </style>
    <?php
}
add_action( 'wp_head', 'goodolwine_customizer_css' );