<?php
/**
 * Sample implementation of the Custom Header feature
 * http://codex.wordpress.org/Custom_Headers
 *
 * @package Good Ol' Wine
 */

/**
 * Setup the WordPress core custom header feature.
 *
 * Use add_theme_support to register support for WordPress 3.4+
 * as well as provide backward compatibility for previous versions.
 * Use feature detection of wp_get_theme() which was introduced
 * in WordPress 3.4.
 *
 * @todo Rework this function to remove WordPress 3.4 support when WordPress 3.6 is released.
 *
 * @uses goodolwine_header_style()
 * @uses goodolwine_admin_header_style()
 * @uses goodolwine_admin_header_image()
 *
 * @package goodolwine
 */
function goodolwine_custom_header_setup() {
	$args = array(
		'default-image'          => '',
		'default-text-color'     => 'ffffff',
		'width'                  => 2600,
		'height'                 => 1000,
		'flex-height'            => true,
		'flex-width'             => true,
		'uploads'       => true,
		'wp-head-callback'       => 'goodolwine_header_style',
		'admin-head-callback'    => 'goodolwine_admin_header_style',
		'admin-preview-callback' => 'goodolwine_admin_header_image',
	);

	$args = apply_filters( 'goodolwine_custom_header_args', $args );

	if ( function_exists( 'wp_get_theme' ) ) {
		add_theme_support( 'custom-header', $args );
	} else {
		// Compat: Versions of WordPress prior to 3.4.
		define( 'HEADER_TEXTCOLOR',    $args['default-text-color'] );
		define( 'HEADER_IMAGE',        $args['default-image'] );
		define( 'HEADER_IMAGE_WIDTH',  $args['width'] );
		define( 'HEADER_IMAGE_HEIGHT', $args['height'] );
		 add_theme_support( $args['wp-head-callback'], $args['admin-head-callback'], $args['admin-preview-callback'] );
	}
}
add_action( 'after_setup_theme', 'goodolwine_custom_header_setup' );

/**
 * Shiv for get_custom_header().
 *
 * get_custom_header() was introduced to WordPress
 * in version 3.4. To provide backward compatibility
 * with previous versions, we will define our own version
 * of this function.
 *
 * @todo Remove this function when WordPress 3.6 is released.
 * @return stdClass All properties represent attributes of the curent header image.
 *
 * @package goodolwine
 */

if ( ! function_exists( 'get_custom_header' ) ) {
	function get_custom_header() {
		return (object) array(
			'url'           => get_header_image(),
			'thumbnail_url' => get_header_image(),
			'width'         => HEADER_IMAGE_WIDTH,
			'height'        => HEADER_IMAGE_HEIGHT,
		);
	}
}

if ( ! function_exists( 'goodolwine_header_style' ) ) :
/**
 * Styles the header image and text displayed on the blog
 *
 * @see goodolwine_custom_header_setup().
 */
function goodolwine_header_style() {

	// If no custom options for text are set, let's bail
	// get_header_textcolor() options: HEADER_TEXTCOLOR is default, hide text (returns 'blank') or any hex value
	if ( HEADER_TEXTCOLOR == get_header_textcolor() )
		return;
	// If we get this far, we have custom styles. Let's do this.
	?>
	<style type="text/css">
	<?php
		// Has the text been hidden?
		if ( ! display_header_text() ) :
	?>
		.site-title,
		.site-description {
			position: absolute;
			clip: rect(1px 1px 1px 1px); /* IE6, IE7 */
			clip: rect(1px, 1px, 1px, 1px);
		}
		.site-title {
			font-family: 'Allura', cursive;
		}
	<?php
		// If the user has set a custom color for the text use that
		else :
	?>
		.site-title a,
		.site-description {
			color: #<?php echo get_header_textcolor(); ?>;
		}
	<?php endif; ?>
	</style>
	<?php
}
endif; // goodolwine_header_style

if ( ! function_exists( 'goodolwine_admin_header_style' ) ) :
/**
 * Styles the header image displayed on the Appearance > Header admin panel.
 *
 * @see goodolwine_custom_header_setup().
 */
function goodolwine_admin_header_style() {
?>
	<style type="text/css">
	.appearance_page_custom-header #headimg {
		border: none;
		min-height: 30px;
		background: #5d2331;
		padding: 5px 20px;
		text-align: center;
		display:inline-block;
		width:auto;
	}
	<?php if ( ! display_header_text() ) : ?>
	#headimg h1 {
		position: absolute !important;
		clip: rect(1px 1px 1px 1px); /* IE7 */
		clip: rect(1px, 1px, 1px, 1px);
	}
	<?php endif; ?>
	#headimg h1 {
		font-size: 34px;
		font-weight: 700;
		letter-spacing: -0.025em;
		line-height: 1.0909090909;
		margin: 10px 0 0 0;
		font-family: 'Great Vibes', cursive;
		text-transform: none;
		letter-spacing: .1em;
		line-height: 1.2413793103;
 }
	#headimg h4 {
		text-shadow: none;
		letter-spacing: .75em;
		font-size: .8em;
		padding: 10px 0 10px 0;
		border-bottom: 1px dashed #451924;
		border-top: 1px dashed #451924;
		text-transform:uppercase;
}
	#headimg h1 a {
		text-decoration: none;
	}
	#headimg img {
		height: auto;
		margin-bottom: 12px;
		max-width: 2600px;
		vertical-align: middle;
	}
	</style>
<?php
}
endif; // goodolwine_admin_header_style

if ( ! function_exists( 'goodolwine_admin_header_image' ) ) :
/**
 * Custom header image markup displayed on the Appearance > Header admin panel.
 *
 * @see goodolwine_custom_header_setup().
 */
function goodolwine_admin_header_image() { ?>
    <?php $header_image = get_header_image();
		if ( ! empty( $header_image ) ) : ?>
			<img src="<?php echo esc_url( $header_image ); ?>" alt="" />
		<?php endif; ?>
       <div id="headimg">
		<?php $style = ' style="color:#' . get_header_textcolor() . ';"'; ?>
		<h1 class="displaying-header-text"><a id="name"<?php echo $style; ?> onclick="return false;" href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php bloginfo( 'name' ); ?></a></h1>
        <h4 class="displaying-header-text" id="desc"<?php echo $style; ?>><?php bloginfo( 'description' ); ?></h4>
		</div>
<?php }
endif; // goodolwine_admin_header_image