<?php
/**
 * The Header for our theme.
 *
 * Displays all of the <head> section and everything up till <div id="main">
 *
 * @package Good Ol' Wine
 */
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>" />
<meta name="viewport" content="width=device-width" />
<!-- Favicons ==================================================
================================================== -->
<link rel="shortcut icon" href="<?php echo get_theme_mod( 'goodolwine_favicon' ); ?>">
<title>
<?php wp_title( '|', true, 'right' ); ?>
</title>
<link rel="profile" href="http://gmpg.org/xfn/11" />
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />
<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<?php do_action( 'before' ); ?>
<header id="mastheadtwo" class="site-header" role="banner">
  <div class="page hfeed site">
   <?php if ( get_theme_mod( 'goodolwine_logo' ) ) : ?>
        <div class="site-logo"> <a href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" rel="home"><img src="<?php echo get_theme_mod( 'goodolwine_logo' ); ?>" alt="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>"></a> </div>
        <?php else : ?>
    <div class="site-branding">
      <h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home">
        <?php bloginfo( 'name' ); ?>
        </a></h1>
      <h2 class="site-description">
        <?php bloginfo( 'description' ); ?>
      </h2>
    </div>
     <?php endif; ?>
    <nav id="site-navigation" class="navigation-main" role="navigation">
      <h1 class="menu-toggle winegenericon">
        <?php _e( 'Menu', 'goodolwine' ); ?>
      </h1>
      <div class="screen-reader-text skip-link"><a href="#content" title="<?php esc_attr_e( 'Skip to content', 'goodolwine' ); ?>">
        <?php _e( 'Skip to content', 'goodolwine' ); ?>
        </a></div>
      <?php wp_nav_menu( array( 'theme_location' => 'primary' ) ); ?>
    </nav>
  </div>
</header>
<!-- #masthead -->
