<?php
/**
 * goodolwine functions and definitions
 *
 * @package Good Ol' Wine
 */

/**
 * Set the content width based on the theme's design and stylesheet.
 */
if ( ! isset( $content_width ) )
	$content_width = 1470; /* pixels */

if ( ! function_exists( 'goodolwine_setup' ) ) :
/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which runs
 * before the init hook. The init hook is too late for some features, such as indicating
 * support post thumbnails.
 */
function goodolwine_setup() {

	/**
	 * Custom template tags for this theme.
	 */
	require( get_template_directory() . '/inc/template-tags.php' );

	/**
	 * Custom functions that act independently of the theme templates
	 */
	require( get_template_directory() . '/inc/extras.php' );

	/**
	 * Customizer additions
	 */
	require( get_template_directory() . '/inc/customizer.php' );

	/**
	 * Add default posts and comments RSS feed links to head
	 */
	add_theme_support( 'automatic-feed-links' );

	/**
	 * Enable support for Post Thumbnails on posts and pages
	 */
	add_theme_support( 'post-thumbnails' );
	
	/**
	 * Adding several sizes for Post Thumbnails
	 */
	add_image_size( 'goodolwine-circle-thumbnail', 300, 300 );
	
	// This theme allows users to set a custom background
	add_theme_support( 'custom-background' );

	/**
	 * This theme uses wp_nav_menu() in one location.
	 */
	register_nav_menus( array(
		'primary' => __( 'Primary Menu', 'goodolwine' ),
	) );

	/**
	 * Enable support for Post Formats
	 */
	add_theme_support( 'post-formats', array( 'aside', 'image', 'video', 'quote', 'link', 'gallery' ) );
}
endif; // goodolwine_setup
add_action( 'after_setup_theme', 'goodolwine_setup' ); 

/**
 * Register widgetized area and update sidebar with default widgets
 */
function goodolwine_widgets_init() {
	register_sidebar( array(
		'name'          => __( 'Slider Sidebar', 'goodolwine' ),
		'description'   => 'Use this sidebar in case you want slider instead of the Custom Header Image (like in the live preview - Home with Slider) - drag and drop Soliloquy Widget inside this sidebar.',
		'id'            => 'sidebar-slider',
		'before_widget' => '<aside id="%1$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );
	register_sidebar( array(
		'name'          => __( 'Right Sidebar', 'goodolwine' ),
		'description'   => 'Sidebar used on blog front page, single-post page and contact page',
		'id'            => 'sidebar-1',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );
	
	register_sidebar( array(
		'name'          => __( 'Footer Widget Area', 'goodolwine' ),
		'description'   => 'Sidebar used for the footer. You can have one-column, two-columns or three-columns content area',
		'id'            => 'sidebar-2',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );
	
	register_sidebar( array(
		'name'          => __( 'Widget Area One - Latest Post', 'goodolwine' ),
		'description'   => 'This sidebar is just if you want to use Good Ol Wine - Recent Posts Widget on the Front Page - Home',
		'id'            => 'sidebar-6',
		'before_widget' => '<aside id="%1$s" class="widget %2$s custom">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );

	register_sidebar( array(
		'name'          => __( 'Widget Area Two - Three Columns Block', 'goodolwine' ),
		'description'   => 'Three Columns Block for front and story pages  - we used Welcome Note Widget, Text Widget and Social Icons Widget',
		'id'            => 'sidebar-3',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );

	register_sidebar( array(
		'name'          => __( 'Widget Area Three - Additional', 'goodolwine' ),
		'description'   => 'You can use this content area instead of Front Page Widget Area Two or you can use both at the same time',
		'id'            => 'sidebar-4',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );
	
	register_sidebar( array(
		'name'          => __( 'Widget Area Four - Wine Products or Timeline Posts', 'goodolwine' ),
		'description'   => 'Used for front and story pages. We used Good Ol Wine - Wine Products Widget and Timeline Posts',
		'id'            => 'sidebar-5',
		'before_widget' => '<aside id="%1$s" class="widget %2$s custom">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );
}
add_action( 'widgets_init', 'goodolwine_widgets_init' );

/**
 * Count the number of widgets and create a class name.
 */
function goodolwine_widget_counter( $sidebar_id ) {
	$the_sidebars = wp_get_sidebars_widgets();

	if ( ! isset( $the_sidebars[$sidebar_id] ) )
		$count = 0;
	else
		$count = count( $the_sidebars[$sidebar_id] );

	switch ( $count ) {
		case '1':
			$class = 'one-widget';
			break;
		case '2':
			$class = 'two-widgets';
			break;
		case '3':
			$class = 'three-widgets';
			break;
		default :
			$class = 'more-than-three-widgets';
	}

	echo $class;
}
/**
 * Make theme available for translation
 * Translations can be filed in the /languages/ directory
 */
load_theme_textdomain( 'goodolwine', get_template_directory() . '/languages' );

$locale = get_locale();
$locale_file = get_template_directory() . "/languages/$locale.php";
	if ( is_readable( $locale_file ) )
		require_once( $locale_file );
/**
 * Enqueue the Open Sans font.
 */
function goodolwine_fonts() {
    $protocol = is_ssl() ? 'https' : 'http';
    wp_enqueue_style( 'goodolwine-damion', "$protocol://fonts.googleapis.com/css?family=Lora:400,700,400italic,700italic|Ubuntu:300,400,500,700,300italic,400italic,500italic,700italic|Great+Vibes&amp;subset=latin,cyrillic,latin-ext,cyrillic-ext,greek-ext,greek" );}
add_action( 'wp_enqueue_scripts', 'goodolwine_fonts' );
/**
 * Enqueue scripts and styles
 */
function goodolwine_scripts() {
	wp_enqueue_style( 'goodolwine-style', get_stylesheet_uri() );
	wp_enqueue_style( 'goodolwine-ihover', get_template_directory_uri() . '/css/ihover.css' );
	wp_enqueue_script( 'goodolwine-navigation', get_template_directory_uri() . '/js/navigation.js', array(), '20120206', true );
	wp_enqueue_script( 'goodolwine-corner', get_template_directory_uri() . '/js/jquery.corner.js', array(), '2.13', true );
	wp_enqueue_script( 'goodolwine-skip-link-focus-fix', get_template_directory_uri() . '/js/skip-link-focus-fix.js', array(), '20130115', true );
	if ( is_page_template( 'page-templates/front-page.php' )
	|| is_page_template( 'page-templates/front-page-two.php' ) ) {
	wp_enqueue_script( 'goodolwine-general', get_template_directory_uri() . '/js/general.js', array(), '1.0', true );
	wp_enqueue_script( 'goodolwine-modernizr', get_template_directory_uri() . '/js/modernizr.custom.js', array(), '20130605', true );
	wp_enqueue_script( 'goodolwine-classie', get_template_directory_uri() . '/js/classie.js', array(), '20130605', true );
	wp_enqueue_script( 'goodolwine-scroller', get_template_directory_uri() . '/js/cbpScroller.js', array(), '1.0', true );
	}
	if ( is_active_sidebar( 'sidebar-2' ) ) {
		wp_enqueue_script( 'jquery-masonry' );
		wp_enqueue_script( 'goodolwine-functions', get_template_directory_uri() . '/js/functions.js', array( 'jquery', 'jquery-masonry' ), '20130605', true );
	}
	wp_enqueue_script( 'goodolwine-general', get_template_directory_uri() . '/js/generalone.js', array(), '1.0', true );
	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) )
		wp_enqueue_script( 'comment-reply' );

	if ( is_singular() && wp_attachment_is_image() )
		wp_enqueue_script( 'goodolwine-keyboard-image-navigation', get_template_directory_uri() . '/js/keyboard-image-navigation.js', array( 'jquery' ), '20120202' );
}
add_action( 'wp_enqueue_scripts', 'goodolwine_scripts' );

// ============== Define constants
define('goodolwine_widgets', get_template_directory() . '/widgets/');
// ============== Load widgets
require_once( goodolwine_widgets .'widget-blog.php' );
require_once( goodolwine_widgets .'widget-wines.php' );
require_once( goodolwine_widgets .'widget-timeline.php' );
require_once( goodolwine_widgets .'welcome.php' );
require_once( goodolwine_widgets .'footer-welcome.php' );

/**
 * Appends post title to Aside and Quote posts
 *
 * @param string $content
 * @return string
 */
function goodolwine_conditional_title( $content ) {

	if ( has_post_format( 'aside' ) || has_post_format( 'quote' ) ) {
		if ( ! is_singular() )
			$content .= the_title( '<h1 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h1>', false );
		else
			$content .= the_title( '<h1 class="entry-title">', '</h1>', false );
	}

	return $content;
}
add_filter( 'the_content', 'goodolwine_conditional_title', 0 );

/**
 * Returns a "Read More" link for excerpts
 *
 */
function goodolwine_read_more_link() {
	return ' <a href="'. esc_url( get_permalink() ) . '" class="excerpt-link">' . __( 'Read More', 'goodolwine' ) . '</a>';
}

/**
 * Replaces "[...]" (appended to automatically generated excerpts) with an ellipsis and goodolwine_read_more_link().
 */
function goodolwine_auto_excerpt_more( $more ) {
	return ' &hellip;' . goodolwine_read_more_link();
}
add_filter( 'excerpt_more', 'goodolwine_auto_excerpt_more' );

/**
 * Implement the Custom Header feature
 */
require( get_template_directory() . '/inc/custom-header.php' );

/**
 * Using Shortcodes inside Text Widget
 */
add_filter('widget_text', 'do_shortcode');

/**
 * Load Jetpack compatibility file.
 */
if ( file_exists( get_template_directory() . '/inc/jetpack.php' ) )
	require( get_template_directory() . '/inc/jetpack.php' );
/**
 * WooCommerce
 *
 * Unhook sidebar
 */
remove_action( 'woocommerce_sidebar', 'woocommerce_get_sidebar', 10);
add_theme_support( 'woocommerce' );
add_filter( 'loop_shop_per_page', create_function( '$cols', 'return 40;' ), 20 );
//* Add a custom class for menu items having children
//* Source: https://gist.github.com/devinsays/5210667
 
function add_menu_parent_class( $items ) {
 
    $parents = array();
    foreach ( $items as $item ) {
        if ( $item->menu_item_parent && $item->menu_item_parent > 0 ) {
            $parents[] = $item->menu_item_parent;
        }
    }
 
    foreach ( $items as $item ) {
        if ( in_array( $item->ID, $parents ) ) {
            $item->classes[] = 'has-children';
        }
    }
 
    return $items;
}
add_filter( 'wp_nav_menu_objects', 'add_menu_parent_class' );
/**
 * Sets the post excerpt length to 40 characters.
 */
function goodolwine_excerpt_length( $length ) {
	return 30;
}
add_filter( 'excerpt_length', 'goodolwine_excerpt_length' );
/*-----------------------------------------------------------------------------------*/
/*	Remove More Jump link
/*-----------------------------------------------------------------------------------*/ 
function remove_more_jump_link($link) { 
	$offset = strpos($link, '#more-');
	if ($offset) {
		$end = strpos($link, '"',$offset);
	}
	if ($end) {
		$link = substr_replace($link, '', $offset, $end-$offset);
	}
	return $link;
}
add_filter('the_content_more_link', 'remove_more_jump_link');
