<?php
/**
 * The template for displaying the footer.
 *
 * Contains the footer content
 *
 * @package Good Ol' Wine
 */
?>

<div class="footer">
  <div class="page hfeed site">
    <div class="footerwidgets">
      <?php get_sidebar( 'footer' ); ?>
    </div>
  </div>
  <footer id="colophon" class="site-footer clear" role="contentinfo">
    <div class="page hfeed site">
      <div class="site-info">
        <?php if( get_theme_mod( 'hide_copyright' ) == '') { ?>
        <?php esc_attr_e('&copy;', 'goodolwine'); ?>
        <?php _e(date('Y')); ?>
        <a href="<?php echo home_url('/') ?>" title="<?php echo esc_attr(get_bloginfo('name', 'display')); ?>"> <?php echo get_theme_mod( 'copyright_textbox', 'No copyright information has been saved yet.' ); ?> </a>
        <?php } // end if ?> </div>
      <!-- .site-info -->
    </div>
    <!-- #page --> 
  </footer>
  <!-- #colophon --> 
</div>
<?php wp_footer(); ?>
</body></html>