<?php
/**
 * @package Good Ol' Wine
 */
?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

  <?php if ( has_post_thumbnail() ): ?>
  <div class="blogfeatureimage">
 <div class="ih-item square effect6"><a href="<?php the_permalink(); ?>">
                <div class="img">
                  <?php 
		if ( has_post_thumbnail() ) { // check if the post has a Post Thumbnail assigned to it.
		  the_post_thumbnail();
		} 
       ?>
                </div>
                </a> </div>
  </div>
  <?php endif; ?>

  <div class="clearfix">
  <header class="entry-header">
    <?php
				if ( is_single() ) :
					the_title( '<h1 class="entry-title">', '</h1>' );
				else :
					the_title( '<h1 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h1>' );
				endif;
			?>
  </header>
  <!-- .entry-header -->
   <div class="postdate single">
    <?php
				if ( 'post' == get_post_type() )
					goodolwine_posted_on();
			?>
  </div>
  </div>
  
  <?php if ( is_search() ) : // Only display Excerpts for Search ?>
  <div class="entry-summary">
    <?php the_excerpt(); ?>
  </div>
  <!-- .entry-summary -->
  <?php else : ?>
  <div class="entry-content">
    <?php the_content( __( 'Read More', 'goodolwine' ) ); ?>
    <div class="entry-meta">
      <?php if ( false != get_post_format() ) : ?>
      <span class="entry-format"> <a href="<?php echo esc_url( get_post_format_link( get_post_format() ) ); ?>" title="<?php echo esc_attr( sprintf( __( 'All %s posts', 'goodolwine' ), get_post_format_string( get_post_format() ) ) ); ?>"><?php echo get_post_format_string( get_post_format() ); ?></a> </span>
      <?php endif; ?>
      <?php edit_post_link( __( 'Edit', 'goodolwine' ), '<span class="edit-link">', '</span>' ); ?>
      <?php if ( ! post_password_required() && ( comments_open() || '0' != get_comments_number() ) ) : ?>
      <span class="comments-link">
      <?php comments_popup_link( __( 'Leave a comment', 'goodolwine' ), __( '1 Comment', 'goodolwine' ), __( '% Comments', 'goodolwine' ) ); ?>
      </span>
      <?php endif; ?>
    </div>
    <!-- .entry-meta -->
    
    <?php
			wp_link_pages( array(
				'before'      => '<div class="page-links"><span class="page-links-title">' . __( 'Pages:', 'goodolwine' ) . '</span>',
				'after'       => '</div>',
				'link_before' => '<span>',
				'link_after'  => '</span>'
			) );
		?>
  </div>
  <?php endif; ?>
</article>
<!-- #post-## -->