<?php
/**
 * @package Good Ol' Wine
 */
?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
  <?php if ( has_post_thumbnail() ): ?>
  
  <div class="clearfix">
    <div class="post-wrap">
      <div class="post-content">
        <div class="post-content-inner">
          <div class="article-wrap">
            <article class="cbp-so-side cbp-so-side-left">
              <header class="entry-header">
                <?php
				if ( is_single() ) :
					the_title( '<h2 class="entry-title">', '</h2>' );
				else :
					the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
				endif;
			?>
              </header>
              <!-- .entry-header -->
              
              <?php if ( is_search() ) : // Only display Excerpts for Search ?>
              <div class="entry-summary">
                <?php the_excerpt(); ?>
              </div>
              <!-- .entry-summary -->
              <?php else : ?>
              <div class="entry-content">
                <?php global $more; $more = 0; the_content( __( 'Read More', 'goodolwine' ) ); ?>
              </div>
              <?php endif; ?>
            </article>
          </div>
          <div class="media">
            <figure class="cbp-so-side cbp-so-side-right">
              <?php the_post_thumbnail(); ?>
            </figure>
          </div>
        </div>
      </div>
    </div>
  </div>
  <?php else: ?>
  <div class="clearfix">
    <article class="cbp-so-side cbp-so-side-left">
      <header class="entry-header">
        <?php
				if ( is_single() ) :
					the_title( '<h2 class="entry-title">', '</h2>' );
				else :
					the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
				endif;
			?>
      </header>
      <!-- .entry-header -->
      
      <?php if ( is_search() ) : // Only display Excerpts for Search ?>
      <div class="entry-summary">
        <?php the_excerpt(); ?>
      </div>
      <!-- .entry-summary -->
      <?php else : ?>
      <div class="entry-content">
        <?php global $more; $more = 0; the_content( __( 'Read More', 'goodolwine' ) ); ?>
      </div>
      <?php endif; ?>
    </article>
    <div class="featured-image">
      <figure class="cbp-so-side cbp-so-side-right">
        <?php the_post_thumbnail(); ?>
      </figure>
    </div>
  </div>
  <?php endif; ?>
</article>
<!-- #post-## -->