<?php
/**
 * @package Good Ol' Wine
 */
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
  <?php if ( has_post_thumbnail() ): ?>
  <div class="blogfeatureimage">
 <div class="ih-item square effect6"><a href="<?php the_permalink(); ?>">
                <div class="img">
                  <?php 
		if ( has_post_thumbnail() ) { // check if the post has a Post Thumbnail assigned to it.
		  the_post_thumbnail();
		} 
       ?>
                </div>
                </a> </div>
  </div>
  <?php endif; ?>

  <div class="clearfix">
  <header class="entry-header">
    <?php
				if ( is_single() ) :
					the_title( '<h1 class="entry-title">', '</h1>' );
				else :
					the_title( '<h1 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h1>' );
				endif;
			?>
  </header>
  <!-- .entry-header -->
   <div class="postdate single">
    <?php
				if ( 'post' == get_post_type() )
					goodolwine_posted_on();
			?>
  </div>
  </div>
  
   <?php if ( is_search() ) : // Only display Excerpts for Search ?>
  <div class="entry-summary">
    <?php the_excerpt(); ?>
  </div>
  <!-- .entry-summary -->
  <?php else : ?>
  <div class="entry-content">
    <?php the_content( __( 'Read More', 'goodolwine' ) ); ?>
    </div>
      <?php endif; ?>
  
  <br>
  <footer class="entry-footer archive">
    <?php
			/* translators: used between list items, there is a space after the comma */
			$category_list = get_the_category_list( __( ', ', 'goodolwine' ) );

			/* translators: used between list items, there is a space after the comma */
			$tag_list = get_the_tag_list( '', __( ', ', 'goodolwine' ) );

			if ( ! goodolwine_categorized_blog() ) {
				// This blog only has 1 category so we just need to worry about tags in the meta text
				if ( '' != $tag_list ) {
					$meta_text = __( 'This entry was tagged %2$s. Bookmark the <a href="%3$s" rel="bookmark">permalink</a>.', 'goodolwine' );
				} else {
					$meta_text = __( 'Bookmark the <a href="%3$s" rel="bookmark">permalink</a>.', 'goodolwine' );
				}

			} else {
				// But this blog has loads of categories so we should probably display them here
				if ( '' != $tag_list ) {
					$meta_text = __( 'This entry was posted in %1$s and tagged %2$s. Bookmark the <a href="%3$s" rel="bookmark">permalink</a>.', 'goodolwine' );
				} else {
					$meta_text = __( 'This entry was posted in %1$s. Bookmark the <a href="%3$s" rel="bookmark">permalink</a>.', 'goodolwine' );
				}

			} // end check for categories on this blog

			printf(
				$meta_text,
				$category_list,
				$tag_list,
				get_permalink()
			);
		?>
    <?php edit_post_link( __( 'Edit', 'goodolwine' ), '<span class="edit-link">', '</span>' ); ?>
  </footer>
  <!-- .entry-footer --> 
</article>
<!-- #post-## -->