<?php
/**
 * The template for displaying Archive pages.
 *
 * Learn more: http://codex.wordpress.org/Template_Hierarchy
 *
 * @package Good Ol' Wine
 */

get_header( 'customnews' ); ?>
<div class="pagewrap">
<div class="page hfeed site">
    <div id="main" class="site-main">
    <div class="hero page-header without-featured-image">
		<div>
			<div>
				<div>
					<h1 class="page-title">
					<?php
						if ( have_posts() ) :
							if ( is_category() ) :
								printf( __( 'Category Archives: %s', 'goodolwine' ), '<span>' . single_cat_title( '', false ) . '</span>' );

							elseif ( is_tag() ) :
								printf( __( 'Tag Archives: %s', 'goodolwine' ), '<span>' . single_tag_title( '', false ) . '</span>' );

							elseif ( is_author() ) :
								the_post();
								printf( __( 'Author Archives: %s', 'goodolwine' ), '<span class="vcard"><a class="url fn n" href="' . esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ) . '" title="' . esc_attr( get_the_author() ) . '" rel="me">' . get_the_author() . '</a></span>' );
								rewind_posts();

							elseif ( is_day() ) :
								printf( __( 'Daily Archives: %s', 'goodolwine' ), '<span>' . get_the_date() . '</span>' );

							elseif ( is_month() ) :
								printf( __( 'Monthly Archives: %s', 'goodolwine' ), '<span>' . get_the_date( 'F Y' ) . '</span>' );

							elseif ( is_year() ) :
								printf( __( 'Yearly Archives: %s', 'goodolwine' ), '<span>' . get_the_date( 'Y' ) . '</span>' );

							elseif ( is_tax( 'post_format', 'post-format-aside' ) ) :
								_e( 'Asides', 'goodolwine' );

							elseif ( is_tax( 'post_format', 'post-format-image' ) ) :
								_e( 'Images', 'goodolwine');

							elseif ( is_tax( 'post_format', 'post-format-video' ) ) :
								_e( 'Videos', 'goodolwine' );

							elseif ( is_tax( 'post_format', 'post-format-quote' ) ) :
								_e( 'Quotes', 'goodolwine' );

							elseif ( is_tax( 'post_format', 'post-format-link' ) ) :
								_e( 'Links', 'goodolwine' );

							elseif ( is_tax( 'post_format', 'post-format-gallery' ) ) :
								_e( 'Galleries', 'goodolwine' );

							elseif ( is_tax( 'post_format', 'post-format-audio' ) ) :
								_e( 'Audio', 'goodolwine' );

							elseif ( is_tax( 'post_format', 'post-format-status' ) ) :
								_e( 'Statuses', 'goodolwine' );

							elseif ( is_tax( 'post_format', 'post-format-chat' ) ) :
								_e( 'Chats', 'goodolwine' );

							else :
								_e( 'Archives', 'goodolwine' );

							endif;
						else :
					 		_e( 'Oops! Nothing Found.', 'goodolwine' );
						endif;
					?>
					</h1>
				</div>
			</div>
		</div>
    </div>
	<div id="primary" class="content-area single">
		<div id="content" class="site-content" role="main"> 
                    <?php if ( have_posts() ) : ?>
			<?php
				if ( is_category() ) :
					$category_description = category_description();
					if ( ! empty( $category_description ) ) :
						echo apply_filters( 'category_archive_meta', '<div class="taxonomy-description">' . $category_description . '</div>' );
					endif;
				elseif ( is_tag() ) :
					$tag_description = tag_description();
					if ( ! empty( $tag_description ) ) :
						echo apply_filters( 'tag_archive_meta', '<div class="taxonomy-description">' . $tag_description . '</div>' );
					endif;
				endif;
			?>
			<?php while ( have_posts() ) : the_post(); ?>
				<?php get_template_part( 'content-archive', get_post_format() );?>
			<?php endwhile; ?>
			<?php goodolwine_content_nav( 'nav-below' ); ?>
		<?php else : ?>
			<?php get_template_part( 'no-results', 'archive' ); ?>
		<?php endif; ?>
		</div><!-- #content -->
	</div><!-- #primary -->
<?php get_sidebar(); ?>
</div>
</div>
</div>
<?php get_footer(); ?>