/***************************************************************************
 *
 * 	----------------------------------------------------------------------
 * 						DO NOT EDIT THIS FILE
 *	----------------------------------------------------------------------
 * 
 *  				     Copyright (C) Themify
 * 
 *	----------------------------------------------------------------------
 *
 ***************************************************************************/
jQuery(document).ready(function($){
	
	// Themify Directory
	app_url = themify_js_vars.app_url;
	// URL for the parent theme
	theme_url = themify_js_vars.theme_url;
	// site url
	blog_url = themify_js_vars.blog_url;
	complete_status = true;
	current_obj = '';

	var $body = $('body');

	/*******************************************************************************/
	/* Tab Events */
	
	//
	// Create Tabs
	//
	$('#maintabnav a').click(function(event){
		event.preventDefault();
		window.location.hash = this.hash;
		return false;
	});
	$('#content, .maintab').tabs(
		{
			fx: { opacity: 'toggle', duration: 200 },
			cache: true,
			select: function(event, ui) {
                jQuery(this).css('height', jQuery(this).height());
                jQuery(this).css('overflow', 'hidden');
        },
        show: function(event, ui) {
                jQuery(this).css('height', 'auto');
                jQuery(this).css('overflow', 'visible');
        }
		}
	);
	
	/*******************************************************************************/
	/* Global Events  */

	//
	// Validation of Numbers
	//
	$('.valid_num').keyup(function(e){
		if(!is_numeric($(this).val())){
			$(this).val($(this).val().substring(0,($(this).val().length-1)));	
		}
	}).on('input paste', function(e){
		$(this).trigger('keyup');
	});
	
	/**
	 * Save user settings
	 * Uses nonces for security
	 */
	$('.save-button').click(function(e){
		e.preventDefault();						 
		showAlert();
		var data = $('#themify').serialize();
		$.post(
			ajaxurl,
			{
				'action': 'themify_save',
				'data': data,
				'nonce' : themify_js_vars.nonce
			},
			function(data) {
				hideAlert();
			}
		);
		return false;
	});
	/**
	 * Save user settings when pressing Shift+Enter
	 */
	if($('#themify').length > 0){
		$(document).on('keydown', function(event){
			if (83 == event.which && (true == event.ctrlKey || true == event.metaKey)) {
				event.preventDefault();
				$('.save-button').trigger('click');
			}
		});
	}
	/**
	 * Reset user styling
	 */
	$("#reset-styling").on('click', function(e){
		e.preventDefault();
		var reply = confirm(themify_lang.confirm_reset_styling);
		if(reply){
			showAlert();
			var data = $('#themify').serialize();
			$.post(
				ajaxurl,
				{
					'action': 'themify_reset_styling',
					'data'  : data,
					'nonce' : themify_js_vars.nonce
				},
				function(data){
					hideAlert();
					window.location.reload(true);
				}
			);
		}
	});
	/**
	 * Reset user settings
	 */
	$("#reset-setting").on('click', function(e){
		e.preventDefault();
		var reply = confirm(themify_lang.confirm_reset_settings);
		if(reply){
			showAlert();
			var data = $('#themify').serialize();
			$.post(
				ajaxurl,
				{
					'action': 'themify_reset_setting',
					'data'  : data,
					'nonce' : themify_js_vars.nonce
				},
				function(data){
					hideAlert();
					window.location.reload(true);
				}
			);									   
		}
	});
	
	//
	// Upgrade Theme / Framework
	//
	$(".upgrade-framework, .upgrade-theme").on('click', function(e){
		e.preventDefault();
		var reply = confirm(themify_lang.check_backup), 
			el = $(this);
		if($(this).hasClass('upgrade-theme')){
			var type = "theme";
		} else {
			var type = "framework";	
		}
		if($(this).parent().hasClass('login')){
			var login = true;	
		} else {
			var login = false;	
		}
		if(reply){
			if(login){
				showLogin();
			} else {
				//showAlert();
				window.location = blog_url + "wp-admin/admin.php?page=themify&action=upgrade&type=" + type + "&login=false";
			}
		}
	});
	
	//
	// Login Validation
	//
	$(".upgrade-login").on('click', function(e){
		e.preventDefault();										   
		var el = $(this), 
			username = el.parent().parent().find('.username').val(),
			password = el.parent().parent().find('.password').val(),
			login = $(".upgrade-theme").parent().hasClass('login');
		if(username != "" && password != ""){
			hideLogin();
			showAlert();
			$.post(
				ajaxurl,
				{
					'action':'themify_validate_login',
					'type':'theme',
					'login':login,
					'username':username,
					'password':password
				},
				function(data){
					data = jQuery.trim(data);
					if(data == 'true'){
						hideAlert();
						jQuery('#themify_update_form').submit();
					} else if(data == 'false') {
						hideAlert('error');	
						showLogin('error');
					}
				}
			);																					
		} else {
			hideAlert('error');	
			showLogin('error');							   
		}
	});
	//
	// Hide Overlay
	//
	$(".overlay").on('click', function(){
		hideLogin();
	});
	
	/*******************************************************************************/
	/* Style Module Events */
	
	//
	// Padding / Margin
	//
	$('.padding-switch, .margin-switch').click(function(){
		var parent = $(this).parent().parent().parent();
		var num = 0;
		if($(this).is(":checked")){
			if(parent.find(".individuals input:first").val() != ''){
				num = parent.find(".individuals input:first").val();
			}
			parent.find(".individuals").fadeOut(200, function(){ 
				parent.find(".same").fadeIn(200).find("input").val(num); 
			}).find("input").val('');
		} else {
			if(parent.find(".same input").val() != ''){
				num = parent.find(".same input").val();
			}
			parent.find(".same").fadeOut(200, function(){
				parent.find(".individuals").fadeIn(200).find("input").val(num);					
			}).find("input").val('');
		}
	});
	//
	// Border
	//
	$('.border-switch').click(function(){
		var parent = $(this).parent().parent();
		var color = '';
		var num = 0;
		if($(this).is(":checked")){
			if(parent.parent().find(".individuals input[type=text]:nth-child(1)").val() != ''){
				color = parent.parent().find(".individuals input[type=text]:nth-child(1)").val();
			}
			if(parent.parent().find(".individuals input:nth-child(2)").val() != ''){
				num = parent.parent().find(".individuals input:nth-child(2)").val();
			}
			var true_color = parent.parent().find(".individuals .colorSelect").css('background-color');
			parent.parent().find(".individuals .colorSelect").css('background-color','#ffffff');
			parent.parent().find(".individuals input[type=text]").val('');
			parent.parent().find(".individuals").fadeOut(200, function(){
				parent.parent().find(".same input[type=text]:nth-child(1)").val(color);
				parent.parent().find(".same .colorSelect").css("background-color",true_color);
				parent.parent().find(".same").fadeIn(200).find("input[type=text]:nth-child(2)").val(num);
				parent.parent().find(".same select").val(parent.parent().find('.individuals select:first option:selected').val());
			});
	
		} else {
			if(parent.parent().find(".same input[type=text]:nth-child(1)").val() != ''){
				color = parent.parent().find(".same input[type=text]:nth-child(1)").val();
			}
			if(parent.parent().find(".same input:nth-child(2)").val() != ''){
				num = parent.parent().find(".same input:nth-child(2)").val();
			}
			var true_color = parent.parent().find(".same .colorSelect").css('background-color');
			parent.parent().find(".same .colorSelect").css('background-color','#ffffff');
			parent.parent().find(".same input").val('');
			parent.parent().find(".same").fadeOut(200, function(){
				parent.parent().find(".individuals select").val(parent.parent().find('.same select:first option:selected').val());
				parent.parent().find(".individuals").fadeIn(200).find("input[type=text]:nth-child(2)").val(num);
				parent.parent().find(".individuals .borders input[type=text]:nth-child(1)").val(color);
				parent.parent().find(".individuals .borders .colorSelect").css("background-color",true_color);
			});
		}
	});
	//
	// Background-Color Transparent
	//
	$('.colorTransparent').click(function(){
		if($(this).is(":checked")){
			var $parent = $(this).parent();
			$parent.find("input[type=text]").attr('disabled', true).val('').addClass('opacity-7');
			$parent.find('.colorSelect').minicolors('value', '#ffffff');
			$('.clearColor, .minicolors', $parent).hide();
		} else {
			$(this).parent().find("input[type=text]").removeAttr('disabled').removeClass('opacity-7');
			$('.minicolors', $parent).show();	
		}
	});
	//
	// Background-Image No BG Image
	//
	$('.noBgImage').each(function(){
		if($(this).is(":checked")){
			var $parent = $(this).parent();
			$parent.find("input[type=text]").attr('disabled', true).val('').addClass('opacity-7');
			$('.plupload-button', $parent).hide();
		}
	});
	$('.noBgImage').click(function(){
		if($(this).is(":checked")){
			var $parent = $(this).parent();
			$parent.find("input[type=text]").attr('disabled', true).val('').addClass('opacity-7');
			$('.plupload-button', $parent).hide();
		} else {
			$(this).parent().find("input[type=text]").removeAttr('disabled').removeClass('opacity-7');
			$('.plupload-button', $parent).show();	
		}
	});
	//
	// Background-Position 
	//
	$('.background_position.positionX').change(function(){
		$(this).parent().find('.valueX').val($('option:selected', this).val());
	});
	$('.background_position.positionY').change(function(){
		$(this).parent().find('.valueY').val($('option:selected', this).val());
	});
	//
	// Background-Image Thumb
	//
	$('.preset').on('click', '.backgroundThumb', function(e){
		e.preventDefault();
		var alt = $(this).attr("alt");
		$(this).parent().parent().find('.backgroundThumb.selected').removeClass('selected');
		$(this).addClass('selected');
		$(this).parent().parent().parent().find('.background_image input[type=text]').removeAttr('disabled').val(alt);
		$(this).parent().parent().parent().find('.background_image input:checkbox').attr('checked', false);
	});
	//
	// Background-Image Remove Selection on Blur
	//
	$('.background_image .upload-file').on('blur', function(e){
		if($(this).val() == ''){
			$(this).parent().parent().find('.backgroundThumb.selected').removeClass('selected');
		}
	});
	//
	// Background-Image None
	//
	$('.background_image input:checkbox').on('click',function(){
		if($(this).is(":checked")){
			$(this).parent().parent().find('.backgroundThumb.selected').removeClass('selected');
			$(this).parent().parent().find('.background_image input[type=text]').attr('disabled', true).val('');							  
		} else {
			$(this).parent().parent().find('.background_image input[type=text]').removeAttr('disabled');
		}
	});
	//
	// Delete Image
	//
	$('.preset').on('click', 'span', function(e){
		e.preventDefault();
		el = $(this);
		var reply = confirm(themify_lang.confirm_delete_image);
		// Check if it has an attachment ID
		if(reply){
			$.post(
				ajaxurl,
				{
					'action': 'themify_delete_preset',
					'file': el.attr('title'),
					'nonce' : themify_js_vars.nonce
				},
				function(data) {
					if(el.parent().parent().parent().find('.background_image input[type=text]').val() == el.parent().find("img").attr("alt")){
						el.parent().parent().parent().find('.background_image input[type=text]').val('');	
					}
					el.parent().remove();
					$('.preset a[title="'+el.parent().attr('title')+'"]').remove();
					$('.upload-file').each(function(index){
						if($(this).val() == el.parent().find('img').attr('alt')){
							$(this).val('');
						}
					});
				}
			);
		}
	});
	//
	// Position
	//
	$('.select_position').change(function(){
		var val = $('option:selected', this).val();
		if(val == 'absolute' || val == 'fixed'){
			$(this).parent().parent().find('.position_display').show(200);	
		} else {
			$(this).parent().parent().find('.position_display').hide(200);	
		}	
	});
	//
	// Color Picker
	//
	$('.colorSelect').each(function(){
		var input = $(this).parent().parent().find('.colorSelectInput'),
				set_color = (input.val() == '') ? '#ffffff' : input.val(),
				minicolors = $(this);

		minicolors.minicolors({
			defaultValue: set_color,
			textfield: false,
			change: function(hex, opacity) {
				// Generate text to show in console
				var text = hex ? hex : '', colorField = this.parent().parent();
				colorField.find('.colorSelectInput').val(text.replace('#', ''));
				$('.clearColor', colorField).show();
			}
		});
	});
	// Set or clear color swatch based on input value
	$(document).on('blur', '.colorSelectInput', function() {
		var $parent = $(this).parent();
		if('' == $(this).val()){
			$parent.find('.colorSelect').minicolors('value', '#ffffff');
			$('.clearColor', $parent).hide();
		} else {
			$('.colorSelect', $parent).minicolors('value', '#' + $(this).val());
			$('.clearColor', $parent).show();
		}
	});
	// Clear swatch and input
	$(document).on('click', '.clearColor', function(){
		$(this).parent().find('.colorSelect').minicolors('value', '#ffffff');
		$(this).parent().find('.colorSelectInput').val('');
		$(this).hide();
	});
	$('.themify_field-color').each(function(index){
		if('' != $('.colorSelectInput', $(this)).val()){
			$('.clearColor', $(this)).show();
		}
		if($('.colorTransparent', $(this)).prop('checked')){
			$('.minicolors', $(this)).hide();
		}
	});
	$( '.colorSelectInput' ).on('keyup', function(e){
		if ( $(this).val().indexOf( '#' ) !== -1 ) {
			$(this).val( $(this).val().replace( '#', '' ) );
		}
	});

	//
	// Font-Family
	//
	$('.fontFamily').change(function(){
		if($('option:selected', this).val() == 'custom'){
			$(this).parent().find('.value').show();
			$(this).parent().find('.value input').val('');
		} else {
			$(this).parent().find('.value').hide();
			$(this).parent().find('.value input').val($('option:selected', this).val());
		}
	});
	//
	// Site-Logo
	//
	$("input[name='setting-site_logo'], input[name='setting-footer_logo']").change(function(){
		if($(this).val() == "image"){
			$(this).parent().parent().find(".image").fadeIn(200);
			$(this).parent().parent().find(".image").css("display","block");
		} else {
			$(this).parent().parent().find(".image").fadeOut();
		}
	});
	//
	// Feature Box Image / Posts Display
	//
	$(".feature-box-display").click(function(){
		if($(this).val() == "images"){
			$(this).parent().parent().find(".feature_box_posts").fadeOut(200, function(){
				$(this).parent().parent().find(".feature_box_images").fadeIn(200);																		
			});
		} else {
			$(this).parent().parent().find(".feature_box_images").fadeOut(200, function(){
				$(this).parent().parent().find(".feature_box_posts").fadeIn(200);																			
			});
		}
	});
	//
	// Generic show/hide block for radio buttons
	// Requires the value="x" and a data-hide="y" where y is the suffix of the block to hide
	//
	$(".block-toggle").click(function(){
		var $self = $(this),
			val = $self.val(),
			hide = $self.data('hide');
		$self.parent().parent().find('.feature_box_' + hide).fadeOut(200, function(){
			$self.parent().parent().find('.feature_box_' + val).fadeIn(200);
		});
	});
	//
	// Feature Box Enabled Display
	//
	$(".feature_box_enabled_check").change(function(){
		if('on' == $(this).val()){
			$(this).parent().parent().find(".feature_box_enabled_display").fadeIn(200);
		} else {
			$(this).parent().parent().find(".feature_box_enabled_display").fadeOut(200);
		}
	});
	
	/**
	 * Display box if checkbox is checked
	 * Markup required
	 * 	<div class="row">
	 * 		<input type="checkbox" class="box_enabled_check" />
	 * 		<*tag* class="box_enabled_display">
	 * 			<select>
	 */
	$(".box_enabled_check").click(function(){
		if($(this).is(":checked")){
			$(this).parent().find(".box_enabled_display").fadeIn(200);
		} else {
			$(this).parent().find(".box_enabled_display").fadeOut(200);
		}
	});
	if($('.box_enabled_check').is(":checked")){
		$('.box_enabled_check').parent().find(".box_enabled_display").show();
	}
	
	/**
	 * Display matched boxes if checkbox is checked
	 * Markup required
	 * <input type="checkbox" class="box_enabled_check" />
	 * <span class="box_enabled_display">
	 */
	$(".disable_img_php").click(function(){
		if($('.disable_img_php').is(":checked")){
			$( '.show_if_disabled_img_php' ).fadeIn(200);
			$( '.show_if_enabled_img_php' ).fadeOut(200);
		} else {
			$( '.show_if_disabled_img_php' ).fadeOut(200);
			$( '.show_if_enabled_img_php' ).fadeIn(200);
		}
	});
	if($('.disable_img_php').is(":checked")){
		$(".show_if_disabled_img_php").show();
	}
	else{
		if($('.disable_img_php').not(":checked")){
			$(".show_if_enabled_img_php").show();
		}
	}
	
	$('.gallery_lightbox_type').change(function(){
		var lightboxIndex = $('.gallery_lightbox_type').prop('selectedIndex');
		if(lightboxIndex != 1){
			$( '.show_if_photoswipe_enabled' ).fadeOut(200);
		} else {
			$( '.show_if_photoswipe_enabled' ).fadeIn(200);
		}
	}).change();
	
	//
	// Layout Options 
	//
	$(".preview-icon").click(function(e){
		e.preventDefault();
		$(this).parent().find(".selected").removeClass("selected");
		$(this).addClass("selected");
		$(this).parent().find(".val").val($(this).find("img").attr("alt"));
	});

	//
	// Toggle Active Layout Icons and Post Format Icons
	//
	if($('.enable_toggle').length > 0){
		$('.themify-toggle').hide();
	}
	$('.enable_toggle .preview-icon').on('click', function(e){
		// toggle
		var img_alt = $(this).find("img").attr("alt"),
			toggle_class = ($.trim(img_alt) != '') ? '.'+img_alt+'-toggle' : '.default-toggle';
		$(this).closest('.inside').find('.themify-toggle').hide();
		$(this).closest('.inside').find( toggle_class ).show();
		e.preventDefault();
	});
	$('.enable_toggle .preview-icon.selected').each(function(){
		var img_alt = $(this).find("img").attr("alt"),
			toggle_class = (img_alt != '' && img_alt != 'default') ? '.'+img_alt+'-toggle' : '.default-toggle';
		$( toggle_class ).show();
	});
	
	// Toggle Post Format Fields by Radio Button
	$('.enable_toggle input[type=radio]').on('click', function() {
		var val = $(this).val(),
			toggle_class = (val != 0 && val != '') ? '.'+val+'-toggle' : '.default-toggle',
			$siblings = $(this).siblings('input[type=radio]');

		$siblings.each(function(){
			var sib_val = $(this).val();
			if ( sib_val != 0 && sib_val !== '' ) $( '.' + sib_val + '-toggle').hide();
		});

		$(toggle_class).each(function(){
			$(this).show();
			if ( $(this).hasClass('enable_toggle_child') ) {
				var $child_siblings = $(this).find('input[type=radio]:checked').siblings('input[type=radio]');
				$child_siblings.each(function(){
					var sib_val = $(this).val();
					setTimeout(function(){
						if ( sib_val != 0 && sib_val !== '' ) $( '.' + sib_val + '-toggle').hide();
					}, 500);
				});
			}
		});
	});
	$('.enable_toggle').each(function(){
		var $checked = $(this).find('input[type=radio]:checked'),
			val = $checked.val(),
			toggle_class = (val != 0 && val !== '') ? '.'+val+'-toggle' : '.default-toggle';
		$(toggle_class).show();
		$checked.siblings('input[type=radio]').each(function(){
			var val = $(this).val();
			setTimeout(function(){
				// hide siblings
				if (val != 0 && val !== '') $( '.' + val + '-toggle').hide();
			}, 500);
		});
	});
	
	// Toggle Post Format Fields by Checkbox.
	// TODO: Works with single checkbox selection, not yet with combinations.
	$('.enable_toggle input[type=checkbox]').on('click', function() {
		var val = $(this).data('val'),
			toggle_class = (val != 0 && val != '') ? '.'+val+'-toggle' : '.default-toggle';
		
		$(this).closest('.inside').find('.themify-toggle').hide();
		
		if($(this).prop('checked')){
			$(this).closest('.inside').find( toggle_class ).show();
		}
	});
	$('.enable_toggle input[type=checkbox]:checked').each(function() {
		var val = $(this).data('val'),
			toggle_class = (val != 0 && val !== '') ? '.'+val+'-toggle' : '.default-toggle';
		$( toggle_class ).show();
	});
	
	/*******************************************************************************/
	/* Skin CSS Load */
	
	//
	// Skins Load
	//
	$(".skin-preview").click(function(e){
		e.preventDefault();
		$(".skin-preview img.selected").removeClass();
		$(this).find("img").addClass('selected');
		$("input[name='skin']").val($(this).find("img").attr('id'));
	});
	
	/*******************************************************************************/
	/*	Display Alerts */
	
	function showLogin(status){
		$('.prompt-box .show-login').show();
		$('.prompt-box .show-error').hide();
		if(status == 'error'){
			if($('.prompt-box .prompt-error').length == 0){
				$('.prompt-box .prompt-msg').after('<p class="prompt-error">' + themify_lang.invalid_login + '</p>');
			}
		} else {
			$('.prompt-box .prompt-error').remove();
		}
		$(".overlay, .prompt-box").fadeIn(500);	
	}	
	function hideLogin(){
		$(".overlay, .prompt-box").fadeOut(500);
	}
	function showAlert(){
		$(".alert").addClass("busy").fadeIn(800);
	}
	function hideAlert(status){
		if(status == 'error'){
			status = 'error';
			showErrors();
		} else {
			status = 'done';	
		}
		$(".alert").removeClass("busy").addClass(status).delay(800).fadeOut(800, function(){
			$(this).removeClass(status);											   
		});
	}
	function showErrors(verbose){
		$(".overlay, .prompt-box").delay(900).fadeIn(500);	
		$('.prompt-box .show-error').show();
		$('.prompt-box .show-error p').remove();
		$('.prompt-box .error-msg').after('<p class="prompt-error">' + verbose + '</p>');
		$('.prompt-box .show-login').hide();
	}
	
	/*******************************************************************************/
	/*	Is Numeric Function */
	
	function is_numeric(string){
		var ValidChars = " 0123456789.+-";
		var IsNumber = true;
		var Char;
		for (i = 0; i < string.length && IsNumber == true; i++){ 
			Char = string.charAt(i); 
			if(ValidChars.indexOf(Char) == -1){
				IsNumber = false;
			}
		}
		return IsNumber;
	}
	
	/**
	 * Group drop down containing Featured Image sizes with the Featured Image field
	 * .featimgdropdown
	 */
	if( $('.featimgcontrol').length > 0 && $('.featimgdropdown').length > 0 ) {
		$('.featimgcontrol').each( function(index) {
			$(this).append($(this).next($('.featimgdropdown')));
		});
	}
	
	/**
	 * Map layout icons to values and bind clicks
	 */
	$(".themify_field .preview-icon").click(function(e){
        e.preventDefault();
        $(this).parent().find(".selected").removeClass("selected");
        $(this).addClass("selected");
        $(this).parent().find(".val").val($(this).find("img").attr("alt"));
    });
    /**
     * Bind categories select to value field
     */
    $(".themify_field .query_category").blur(function(e){
        $(this).parent().find(".val").val($(this).val());
    }).keyup(function(){
    	$(this).parent().find(".val").val($(this).val());
    });
	$('.themify_field .query_category_single').change(function() {
    	$(this).parent().find(".query_category, .val").val($(this).val());
    });
    
    /**
     * Dropdownbutton
     */
    $('.dropdownbutton-group').each(function(index){
    	var $elf = $(this);
    	$elf.on('hover', '.dropdownbutton-list', function(event){
    		event.preventDefault();
    		var $a = $(this);
    		if($a.hasClass('disabled')) {
    			return false;
    		}
    		if(event.type == 'mouseenter') {
    			if(!$a.children('.dropdownbutton').is(':visible')) {
    				$a.children('.dropdownbutton').show();
    			}
    		}
    		if(event.type == 'mouseleave') {
    			if($a.children('.dropdownbutton').is(':visible')) {
    				$a.children('.dropdownbutton').hide();
    			}
    		}
    	});
    	$elf.on('click', '.first-ddbtn a', function(event){
    		event.preventDefault();
    	});
    	$elf.on('click', '.ddbtn a', function(event){
    		event.preventDefault();
    		var ddimgsrc = $(this).find('img').attr('src'),
    				val = $(this).data('val'),
    				parent = $(this).closest('.dropdownbutton-list'),
    				inputID = parent.attr('id');
    		$(this).closest('.dropdownbutton-list').find('.first-ddbtn img').attr('src', ddimgsrc);
    		$(this).closest('.dropdownbutton').hide();
    		$('input#' + inputID).val(val);
    		if(parent.next().hasClass('ddbtn-all')) {

				if($elf.hasClass('multi-ddbtn')) {
					var $ddbtnList = $('.multi-ddbtn-sub', $elf.parent().parent()),
						$ddbtnInput = $('.multi-ddbtn-sub + input', $elf.parent().parent());					
				} else {
					var inputVal = parent.next(),
						$ddbtnList = inputVal.prev().siblings('.dropdownbutton-list'),
						$ddbtnInput = inputVal.siblings('input');
				}

				if(parent.next().val() == 'yes') {
					$ddbtnList.addClass('disabled opacity-5');
					$ddbtnList.each(function(){
						var defIcon = $(this).data('def-icon');
						$(this).find('.first-ddbtn img').attr('src', defIcon);
					});
					$ddbtnInput.val(''); // clear value
				} else {
					$ddbtnList.removeClass('disabled opacity-5');
				}

    		}
    	});
    	// disabled other options on dom load
    	var selectAll = $elf.find('input.ddbtn-all');
    	if( selectAll.val() == 'yes' ) {
    		if($elf.hasClass('multi-ddbtn')) {
    			$('.multi-ddbtn-sub', $elf.parent().parent()).addClass('disabled opacity-5');
    		} else {
    			selectAll.prev().siblings('.dropdownbutton-list').addClass('disabled opacity-5');
    		}
    	}
    });
    
    /**
     * Post meta checkboxes
     */
    $('.post-meta-group').each(function(index){
    	var $elf = $(this);
    	if($('.meta-all', $elf).prop('checked')){
    		$('.meta-sub', $elf).prop('disabled', true).parent().addClass('opacity-7');
    	}
    	$elf.on('click', '.meta-all', function(event){
    		var $all = $(this);
			if($all.prop('checked')){
				//$all.prop('checked', true);
				$('.meta-sub', $elf).prop('disabled', true).prop('checked', false).parent().addClass('opacity-7');
			} else {
				//$all.prop('checked', false);
				$('.meta-sub', $elf).prop('disabled', false).parent().removeClass('opacity-7');
			}
    	});
	});

	/**
    * Post meta checkboxes - Mostly the same than before, but adding hidden field update.
    */
    $('.custom-post-meta-group').each(function(index){
    	var $elf = $(this), states_str = $('input[type="text"]', $elf).val(), states = {};

    	// Backwards compatibility
    	if('yes' == states_str){
    		$('.meta-all', $elf).val('yes').prop('checked', true);
    		$('.meta-sub', $elf).val('yes').prop('disabled', true).parent().addClass('opacity-7');
    	} else {
			// Parse string
			states_arr = states_str.split('&');
			for (i = 0; i < states_arr.length; i++) {
				state = states_arr[i].split('=');
				states[state[0]] = state[1];
			};
			for(meta in states){
				if('yes' == states[meta]){
					$('#'+meta, $elf).val('yes').prop('checked', true);
				}
			}
			if($('.meta-all', $elf).prop('checked')){
	    		$('.meta-sub', $elf).prop('disabled', true).prop('checked', false).parent().addClass('opacity-7');
	    	}
    	}
    	$elf.on('click', '.meta-all', function(event){
    		var $all = $(this);
			if($all.prop('checked')){
				$('.meta-sub', $elf).val('yes').prop('disabled', true).prop('checked', false).parent().addClass('opacity-7');
				$all.val('yes');
			} else {
				$('.meta-sub', $elf).val('no').prop('disabled', false).parent().removeClass('opacity-7');
				$all.val('no');
			}
			savePostMetaStates($elf);
    	});
    	$elf.on('click', '.meta-sub', function(event){
    		var $sub = $(this);
    		if($sub.prop('checked')){
				$sub.val('yes');
			} else {
				$sub.val('no');
			}
			savePostMetaStates($elf);
    	});
	});
	function savePostMetaStates($et){
		var state = '';
		$('input[type="checkbox"]', $et).each(function(){
			state += $(this).attr('id') + '=' + $(this).val() + '&';
		});
		$('input[type="text"]', $et).val(state.slice(0,-1));
	}

	/**
	 * Social Links Panel
	 */
	var $socialType = $('#social-link-type' ),
		$socialLinksWrapper = $('#social-links-wrapper'),
		$socialLinkIDs = $('#setting-link_field_ids'),
		$socialLinkHash = $('#setting-link_field_hash');

	/**
	 * Link type selector
	 */
	if($('input[value=font-icon]', $socialType).prop('checked')) {
		$('.image-icon', $socialLinksWrapper).fadeOut();
		$('.font-icon', $socialLinksWrapper).fadeIn();
	} else {
		$('.font-icon', $socialLinksWrapper).fadeOut();
		$('.image-icon', $socialLinksWrapper).fadeIn();
	}
	$('input', $socialType).on('click', function(){
		var $self = $(this);
		if($self.prop('checked')) {
			$('.' + $self.data('hide'), $socialLinksWrapper).fadeOut();
			$('.' + $self.val(), $socialLinksWrapper).fadeIn();
		}
	});
    
    /**
     * Links settings page
     */
	// Set up drag & drop
	$socialLinksWrapper.sortable({
		placeholder: 'social-link-placeholder',
		handle: '.social-drag',
		update: function( event, ui ) {
			var field_ids = {};
			$('.social-link-item').each(function(){
				field_ids[$(this).attr('id')] = $(this).attr('id');
			});
			$socialLinkIDs.val(JSON.stringify(field_ids));
		}
    });
	
	// Remove Link
	$socialLinksWrapper.on('click', '.remove-item', function(event) {
		event.preventDefault();
		var field_ids = JSON.parse($socialLinkIDs.val()),
			removeId = $(this).data('removelink');

		$('#' + removeId).remove();
		delete field_ids[removeId];
		$socialLinkIDs.val(JSON.stringify(field_ids))
	});
	
	// Add Link
	$('.add-social-link a').click(function(e) {
		var field_ids = JSON.parse($socialLinkIDs.val()),
			hash = parseInt($socialLinkHash.val()),
			type = 'image-icon';
		e.preventDefault();
		if($('input[value=font-icon]', $socialType).prop('checked')) {
			type = 'font-icon';
		}
		$.post(
			ajaxurl,
			{
				'action': 'themify_add_link_field',
				'nonce' : themify_js_vars.nonce,
				'fid'   : hash,
				'type'  : type
			},
			function(data){
				// Insert new link block
				$('#social-links-wrapper').append(data);

				var $plupload = $('#themify-link-' + $socialLinkHash.val() + ' .plupload-upload-uic'),
					$colorPicker = $('#themify-link-' + $socialLinkHash.val() + ' .colorSelect');
				
				// Add new key/element to JSON object
				field_ids['themify-link-' + $socialLinkHash.val()] = 'themify-link-' + $socialLinkHash.val();
				$socialLinkIDs.val(JSON.stringify(field_ids));

				if ( $plupload.length > 0 ) {
					// Initialize plupload in this new field
					themify_create_pluploader($plupload);
				}

				if ( $colorPicker.length > 0 ) {
					// Initialize color pickers for this new field
					$colorPicker.minicolors( {
						defaultValue: '#ffffff',
						letterCase: 'lowercase',
						change: function(hex, opacity) {
							$(this).parent().next().val(hex.replace( '#', '' ));
						}
					} );
				}

				// Increase hash number
				$socialLinkHash.val(hash + 1);
			}
		);
		
	});

	/**
	 * Date Picker
	 */
	$('.themifyDatePicker').each(function(){
		var $self = $(this),
			label = $self.data('label'),
			close = $self.data('close' ),
			dateformat = $self.data('dateformat' ),
			timeformat = $self.data('timeformat' ),
			timeseparator = $self.data('timeseparator' );
		$self.datetimepicker({
			showOn: 'both',
			showButtonPanel: true,
			closeButton: close,
			buttonText: label,
			dateFormat: dateformat,
			timeFormat: timeformat,
			stepMinute: 5,
			separator: timeseparator,
			onClose: function( date ) {
				if ( '' != date ) {
					$( '#' + $self.data('clear') ).addClass('themifyFadeIn');
				}
			},
			beforeShow: function(input, inst) {
				$('#ui-datepicker-div').addClass( 'themifyDateTimePickerPanel' );
			}
		});
		$self.next().addClass('button');
	});
	/**
	 * Clear Date Button
	 */
	$body.on('click', '.themifyClearDate', function(e){
		e.preventDefault();
		var $self = $(this);
		$( '#' + $self.data('picker') ).val('');
		$self.removeClass('themifyFadeIn');
	});
	
	// Tabs for Custom Panel
	if($('.ilc-htabs li').length > 1) {
		ilcTabs({ilctabs  : '#themify-meta-box-tabs'});
	} else {
		$('.ilc-tab').show();
		$('.ilc-htabs li').addClass('select');
	}
	
	// set tabs cookie
	$('.ilc-htabs a').on('click', function(){
		themifySetCookie('themify-builder-tabs', $(this).attr('id'));
	});
	
	// active tabs cookie
	if( typeof(themifyGetCookie('themify-builder-tabs')) != 'undefined' && themifyGetCookie('themify-builder-tabs') !== null ){
		$( '#' + themifyGetCookie('themify-builder-tabs')).trigger('click');
	}
	
	// Validate slug input
	$('.slug-rewrite').each(function(){
		$(this).on('keypress', function (event) {
			var regex = new RegExp("^[a-z0-9_\-]+$"),
				key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
			if (!regex.test(key)) {
				event.preventDefault();
				return false;
			}
		});
	});
	
	$('#themify').on('click', '.refresh-webfonts', function(event){
		event.preventDefault();
		var reply = confirm(themify_lang.confirm_refresh_webfonts);
		if(reply){
			var data = $('#themify').serialize();
			$.post(
				ajaxurl,
				{
					'action': 'themify_save',
					'data': data,
					'nonce' : themify_js_vars.nonce
				},
				function(data) {
					showAlert();
					$.post(
						ajaxurl,
						{
							'action': 'themify_refresh_webfonts',
							'nonce' : themify_js_vars.nonce
						},
						function(data){
							hideAlert();
							window.location.reload(true);
						}
					);
				}
			);
		}
	});

	var Themify_Visibility;
	Themify_Visibility = {
		target: '',

		getDocHeight: function() {
			var D = document;
			return Math.max(
				Math.max(D.body.scrollHeight, D.documentElement.scrollHeight),
				Math.max(D.body.offsetHeight, D.documentElement.offsetHeight),
				Math.max(D.body.clientHeight, D.documentElement.clientHeight)
			);
		},

		showLightbox: function( target ) {
			var top = $(document).scrollTop() + 80,
				$lightbox = $("#themify_lightbox_visibility");

			$('#themify_lightbox_overlay').show();
			$.ajax({
				'type' : 'POST',
				url: ajaxurl,
				data: {
					action: 'themify_get_visibility_options',
					selected: Themify_Visibility.target.val(),
					nonce: themify_js_vars.nonce
				},
				success: function(data){
					$( '.lightbox_container', $lightbox ).append(data);
					$lightbox
					.show()
					.css('top', Themify_Visibility.getDocHeight())
					.animate({
						'top': top
					}, 800 );
					$('#visibility-tabs', $lightbox).tabs();
					$('#visibility-tabs .themify-visibility-inner-tabs', $lightbox).tabs();
				}
			});
		},

		closeLightbox: function( callback ){
			$('#themify_lightbox_visibility').animate({
				'top': Themify_Visibility.getDocHeight()
			}, 800, function() {
				$('#themify_lightbox_overlay').hide();
				$('#themify_lightbox_visibility').hide();
				if( typeof(callback) === 'function' ) {
					callback();
				}
				Themify_Visibility.clearOptions();
			});
		},

		clearOptions: function(){
			$('#themify_lightbox_visibility .lightbox_container').empty();
		}
	}

	var $body = $('body'),
		$lightbox = $('#themify_lightbox_visibility');

	$body.on('click', '.themify-add-hook a', function(){
		var field_ids = JSON.parse( $('#themify-hooks-field-ids').val() ),
			new_field_id = 1;
		if( field_ids.length > 0 ) {
			new_field_id = Math.max.apply(null, field_ids) + 1;
		} else {
			field_ids = [];
		}
		$.ajax({
			url: ajaxurl,
			type: 'post',
			data: {
				action: 'themify_hooks_add_item',
				field_id : new_field_id,
				nonce: themify_js_vars.nonce
			},
			success: function(data){
				field_ids.push( new_field_id );
				$('#themify-hooks-field-ids').val( JSON.stringify( field_ids ) );
				$('#hook-content-list').append(data);
			}
		});
		return false;
	});

	$body.on('click', '.themify-visibility-toggle', function(){
		Themify_Visibility.target = $(this).next();
		Themify_Visibility.showLightbox();
		return false;
	});

	$body.on('click', '#themify_lightbox_visibility .close_lightbox, #themify_lightbox_overlay', function(){
		Themify_Visibility.closeLightbox();
	});

	$lightbox.on('click', '.visibility-save', function(){
		var data = $( 'form', $lightbox ).serialize();
		Themify_Visibility.target.val( data );
		Themify_Visibility.closeLightbox();
		return false;
	});

	$lightbox.on('click', '.uncheck-all', function(){
		$('input:checkbox', $lightbox).removeAttr( 'checked' );
		return false;
	});

	$body.on('click', '#setting-hooks .remove-item', function(){
		var field_ids = JSON.parse( $('#themify-hooks-field-ids').val() );
		var $item = $(this).closest('.social-link-item').fadeOut('fast', function(){
			var removeId = $item.attr('data-id');
			for( var key in field_ids ) {
				if( field_ids[key] == removeId ) {
					field_ids.splice( key, 1 );
				}
			}
			$('#themify-hooks-field-ids').val( JSON.stringify( field_ids ) );
		});
		return false;
	});

	// Set up drag & drop
	$('#hook-content-list').sortable({
		placeholder: 'social-link-placeholder',
		handle: '.social-drag',
		update: function( event, ui ) {
			var field_ids = [];
			$('#hook-content-list li').each(function(){
				field_ids.push( parseInt( $(this).attr('data-id') ) );
			});
			$('#themify-hooks-field-ids').val( JSON.stringify( field_ids ) );
		}
	});

	if( $('.see-hook-locations').length > 0 ) {
		$('.see-hook-locations').magnificPopup({ 
			type: 'iframe',
			iframe: {
				markup: '<div class="mfp-iframe-scaler" style="max-width: 100% !important; height: 100%;">'+
				'<div class="mfp-close"></div>'+
				'<iframe class="mfp-iframe" frameborder="0" allowfullscreen></iframe>'+
				'</div>',
			}
		});
	}

	$('#setting-editor-gfonts-list').change(function(){
		var fonts = $(this).val();
		$(this).next().val( JSON.stringify( fonts ) );
	}).change();

	var $demo_import_buttons = $('.import-sample-content'),
		$demo_erase_buttons = $('.erase-sample-content');

	$demo_import_buttons.click(function(){
		var $button = $(this);
		if( $button.hasClass( 'disabled' ) ) {
			return false;
		}
		if( ! window.confirm( 'This will import demo and override current Themify panel settings.' ) ) {
			return false;
		}
		$demo_import_buttons.addClass( 'disabled' );
		$.ajax({
			url: ajaxurl,
			data: {
				action: 'themify_import_sample_content',
				nonce: themify_js_vars.nonce
			},
			type: 'POST',
			success: function(data){
			},
			beforeSend: function(){
				$button
				.find('span').text( $button.attr('data-importing') ).end()
				.find('i').removeClass().addClass( 'fa fa-cog fa-spin' );
			},
			complete: function(){
				$button.addClass('import-success').click(function(){
					$(this).parent().find('.dismiss-import-notice:first').click();
				})
				.find('span').text( $button.attr('data-success') ).end()
				.find('i').removeClass().addClass( 'fa fa-check-circle' );

				$demo_erase_buttons.removeClass( 'disabled' )
				.find('i').removeClass().addClass('fa fa-times').end()
				.find('span').text( $demo_erase_buttons.attr('data-default') );
			}
		});
		return false;
	});
	$demo_erase_buttons.click(function(){
		var $button = $(this);
		if( $button.hasClass( 'disabled' ) ) {
			return false;
		}
		$demo_erase_buttons.addClass( 'disabled' );
		$.ajax({
			url: ajaxurl,
			data: {
				action: 'themify_erase_sample_content',
				nonce: themify_js_vars.nonce
			},
			type: 'POST',
			success: function(data){
			},
			beforeSend: function(){
				$button
				.find('span').text( $button.attr('data-erasing') ).end()
				.find('i').removeClass().addClass('fa fa-cog fa-spin');
			},
			complete: function(){
				$button
				.find('span').text( $button.attr('data-success') ).end()
				.find('i').removeClass().addClass( 'fa fa-check-circle' );

				$demo_import_buttons.removeClass( 'disabled' ).removeClass( 'import-success' )
				.find('i').removeClass().addClass('fa fa-arrow-down').end()
				.find('span').text( $demo_import_buttons.attr('data-default') );
			}
		});
		return false;
	});
	$('.dismiss-import-notice').click(function(){
		$.ajax({
			url: ajaxurl,
			data: {
				action: 'themify_dismiss_import_notice',
				nonce: themify_js_vars.nonce
			},
			type: 'POST',
			success: function(data){
				$('#demo-import-notice').fadeOut();
			}
		});
		return false;
	});
});


function themifySetCookie(name,value) {
	document.cookie = name+"="+value+"; path=/"; }
function themifyGetCookie(name) {
	name = name + "=";
	var ca = document.cookie.split(';');
	for(var i=0; i < ca.length; i++) {
		var c = ca[i];
		while (' ' == c.charAt(0)) c = c.substring(1,c.length);
		if (0 == c.indexOf(name)) return c.substring(name.length,c.length);	}
	return null; }
