# Release Notes

What are the changes for each release?

## v2.2.4 (2020-12-18)

**Bug fixes:**

- **[distributed-feature,middleware]** Add a period option in the distributed rate limit middleware
- **[authentication]** Add support for not operator in JWT claims expressions
- **[swarm]** TLS provider optimization
- **[teectl]** Fix credentials command
- Fix issue where docker client was never closed

**Documentation:**

- **[authentication]** Improve the LDAP documentation
- Fix restore command reference
- Add traefikee/teectl credentials command reference

## v2.2.3 (2020-10-06)

**Bug fixes:**

- **[authentication,middleware]** Fix JWT middleware when using dynamic JWKs with the `iss` property ending with a trailing slash
- **[licensing]** Allow to refresh a license status

## v1.3.5 (2020-09-11)

**Bug fixes:**

- **[dockeree]** Fix for compliance with DockerEE UCP v3.1+

## v2.2.2 (2020-08-28)

**Bug fixes:**

- **[authentication]** Fix the OIDC middleware to be compliant with Azure Active Directory

**Documentation:**

- **[maesh]** Add service mesh operating guide

## v2.1.7 (2020-08-28)

**Bug fixes:**

- **[cli,distributed-feature]** Add a flag to control the distributed port on the controllers and proxies
- **[cli,teectl,ux]** Make Dial call asynchronous to get meaningful errors in grpc calls
- **[webui]** Update License page to properly display long license names

## v2.2.1 (2020-07-29)

**Bug fixes:**

- **[authentication,middleware]** Fix nested values forwarding support on auth middlewares
- **[traefik]** Update Traefik to v2.2.8 (fix CVE-2020-15129)

**Documentation:**

- Update licensing server address in documentation

## v2.1.6 (2020-07-29)

**Bug fixes:**

- **[authentication,middleware]** Fix nested values forwarding support on JWT and oauth token introspection
- **[traefik]** Update Traefik to v2.2.8

## v1.3.3 (2020-07-29)

**Bug fixes:**

- **[api]** Sanitize X-Forwarded-Prefix when redirecting to the API

## v2.2.0 (2020-07-21)

**Enhancements:**

- **[maesh]** Maesh Integration
- **[authentication,middlewares]** OpenID Connect Middleware
- **[authentication,middlewares]** Handle Dynamic JWKS URLs in the JWT Middleware
- **[cli,maesh]** Allow using Mesh without ingress proxy
- **[maesh,webui]** Add Maesh Section to Dashboard
- **[webui]** Update Ingress Overview page
- **[webui]** Move TraefikEE current content into ingress section
- **[api]** Add cluster errors endpoint
- **[api,maesh]** Expose platform information on the API
- **[webui]** Handle mesh availability based on cluster information 
- **[webui]** Improve logic for Errors Table on Main Overview page and sort them
- **[webui]** Add a page displaying mesh interconnections using a flow diagram.
- **[authentication,middleware]** Update JWT middleware to handle JWK sets in files
- **[api,maesh]** Add service mesh availability to license information endpoint
- **[webui]** Remove unnecessary Card titles on Mesh Overview page
- **[webui]** Add ability to navigate to each section from the ingress overview page
- **[webui]** Add ability to navigate to each section from the main overview page
- **[traefik]** Update Traefik to v2.2.7

**Bug fixes:**

- **[api,maesh]** Make Mesh service API consistent
- **[api]** Sort ingress errors API to make it consistent
- **[webui]** Display charts correctly when there are no service on Overview pages
- **[webui]** Fix unclickable search inputs
- **[acme,maesh,teectl]** Improve error message on license enabled features
- **[maesh]** Remove liveness port declaration from mesh proxy Daemonset
- **[authentication,middleware]** Improve stability with the KubernetesCRD provider
- **[licensing,webui]** Correctly count ingresses for license information
- **[webui,maesh]** Update Mesh Services page to show Additional Features on the table

**Documentation:**

- **[cli]** Clarify cluster credentials documentation
- Rename "Operating" section to "Operations"
- **[middleware]** Fix TOML snippets in OIDC documentation
- **[webui]** Clean up dashboard operating guide
- Introduce the Configuration Discovery Section in Documentation
- Clean up the Glossary page for TraefikEE 2.2 w/Maesh integration
- Add service mesh language to Concepts page
- Fix middleware configuration snippet format
- **[authentication,middlewares]** Document OpenID Connect Middleware
- **[maesh]** Document Maesh Integration
- **[webui]** Modify dashboard images

**Misc:**

- **[maesh,traefik]** Update Maesh to v1.3.1

## v2.1.5 (2020-07-21)

**Bug fixes:**

- **[authentication]** Fix default values for the HMAC middleware

**Documentation:**

- **[authentication,middleware]** Fix TOML snippets in JWT and OAuth documentation

**Misc:**

- Update Traefik to v2.2.7

## v2.2.0-rc3 (2020-07-17)

**Documentation:**

- **[cli]** Clarify cluster credentials documentation
- Rename "Operating" section to "Operations"

## v2.0.5 (2020-07-15)

**Bug fixes:**

- **[cli,teectl]** Evaluate path before using it in restore
- **[k8s,teectl]** Only pick Running pods to port forward on them
- **[licensing]** Only take into account ready nodes in proxy count
- **[middleware]** Fix default value for in-flight request middleware
- **[providers]** Fix potential panic in the provider controller
- **[raft-api]** Prevent panic when calling recover in parallel
- **[raft-api]** Add a retry mechanism when failing to connect to the control socket
- **[teectl]** fix kubeconfig env with multiple file paths
- **[webui]** fix: always have `@{provider_name}` in service slugs
- **[webui]** WebUI: Prevent Icons from being animated on the WebUI
- **[webui]** Only show Server Status on HTTP Service Detail pages

**Documentation:**

- **[distributed-feature,middleware]** Fix in-flight request middleware documentation snippet
- Removed erroneous flag to teectl setup gen in docs/content/getting-started.md
- Remove entrypoints in test service on swarm install guide

**Misc:**

- **[logs]** Add file closing and reopening when receiving SIGUSR1
- **[webui]** WebUI: Add a 404 page handler similar to the Traefik OSS
- **[webui]** Centralize Menu Navigation items

## v2.2.0-rc2 (2020-07-09)

**Bug fixes:**

- **[acme,maesh,teectl]** Improve error message on license enabled features
- **[maesh]** Remove liveness port declaration from mesh proxy Daemonset
- **[authentication,middleware]** Improve stability with the KubernetesCRD provider

**Documentation:**

- **[middleware]** Fix TOML snippets in OIDC documentation
- **[webui]** Clean up dashboard operating guide

**Misc:**

- **[maesh,traefik]** Update Maesh to v1.3.1

## v2.1.4 (2020-06-26)

**Bug fixes:**

- **[logs]** Fix potential panic when enabling access logs middleware

## v2.2.0-rc1 (2020-06-26)

**Enhancements:**

- **[authentication,middleware]** Update JWT middleware to handle JWK sets in files
- **[api,maesh]** Add service mesh availability to license information endpoint
- **[webui]** Remove unnecessary Card titles on Mesh Overview page
- **[webui]** Add ability to navigate to each section from the ingress overview page
- **[webui]** Add ability to navigate to each section from the main overview page

**Bug fixes:**

- **[licensing,webui]** Correctly count ingresses for license information
- **[webui,maesh]** Update Mesh Services page to show Additional Features on the table

**Documentation:**

- Introduce the Configuration Discovery Section in Documentation

## v2.2.0-beta2 (2020-06-18)

**Enhancements:**

- **[api,maesh]** Expose platform information on the API
- **[webui]** Handle mesh availability based on cluster information 
- **[webui]** Improve logic for Errors Table on Main Overview page and sort them
- **[webui]** Add a page displaying mesh interconnections using a flow diagram.

**Bug fixes:**

- **[api,maesh]** Make Mesh service API consistent
- **[api]** Sort ingress errors API to make it consistent
- **[webui]** Display charts correctly when there are no service on Overview pages
- **[webui]** Fix unclickable search inputs

**Documentation:**

- Clean up the Glossary page for TraefikEE 2.2 w/Maesh integration
- Add service mesh language to Concepts page
- Fix middleware configuration snippet format

## v2.1.3 (2020-06-26)

**Bug fixes:**

- **[logs]** Close and reopen log files on SIGUSR1

## v2.1.2 (2020-06-08)

**Bug fixes:**

- **[traefik]** Avoid chaining the middlewares multiple times

**Documentation:**

- **[authentication,middlewares]** Add all authentication middlewares of 2.1 to the compare table

## v2.2.0-beta1 (2020-06-05)

**Enhancements:**

- **[maesh]** Maesh Integration
- **[authentication,middlewares]** OpenID Connect Middleware
- **[authentication,middlewares]** Handle Dynamic JWKS URLs in the JWT Middleware
- **[cli,maesh]** Allow using Mesh without ingress proxy
- **[maesh,webui]** Add Maesh Section to Dashboard
- **[webui]** Update Ingress Overview page
- **[webui]** Move TraefikEE current content into ingress section
- **[api]** Add cluster errors endpoint

**Documentation:**

- **[authentication,middlewares]** Document OpenID Connect Middleware
- **[maesh]** Document Maesh Integration
- **[webui]** Modify dashboard images

## v2.1.1 (2020-05-19)

**Bug fixes:**

- **[traefik]** Add back the services health check

**Documentation:**

- **[authentication]** Add note to make the query param explicit in JWT middleware
- Fix checksum links in documentation
- Fix download path for teectl in getting-started page

## v1.3.2 (2020-05-04)

**Bug fixes:**

- **[webui]** Security fix (QID-11827) for the Dashboard route

**Documentation:**

- **[k8s]** Fix dashboard operating guide documentation

## v2.1.0 (2020-04-14)

**Enhancements:**

- **[authentication,middlewares]** Add JWT authentication middleware
- **[authentication,middlewares]** Implement the HMAC middleware
- **[authentication,middlewares]** Add oAuth Token Introspection middleware
- **[cli,raft-api]** Add traefikee recover command
- **[k8s,teectl]** Use random port for kubernetes port forward
- **[metrics]** Add additional middleware tracing
- **[teectl,ux]** Add cluster management commands
- **[teectl]** Cluster regain access
- **[teectl]** Add `teectl create credentials` command
- **[traefik]** Move to Traefik v2.2.0
- **[webui]** WebUI: Add UDP pages to the Dashboard

**Bug fixes:**

- **[webui]** Fix service links
- **[middlewares]** Stop leaking errors in middleware
- **[teectl]** Fix cluster context for `teectl get ac` command
- **[teectl]** Dont override config on import
- **[teectl]** Resolve cluster correctly when getting creds
- **[authentication,middlewares]** Fix `forwardHeaders` property with booleans
- **[cli,ux]** Do not show empty defaults in CLI help
- **[logs]** Fixed badly worded license log message
- **[teectl]** Skip directories in GetClusters.
- **[webui]** Fix SubNav bar not showing detail
- **[webui]** WebUI: Fix Proxies not showing on Dashboard
- **[webui]** WebUI: display plugin name instead of just &#39;plugin&#39; on Detail pages
- **[webui]** WebUI: Fix Empty TLS options wording

**Documentation:**

- Fix JWT documentation
- Add time sensitivity to HMAC doc
- Improve rootless documentation regarding volumes
- **[teectl,ux]** Cluster management docs
- **[teectl]** Fix credentials documentation
- Add note about using correct cluster name
- Move middleware in docs
- Doc: update a:hover style to avoid blurry links on FF
- fix: avoid link/menu width increase on hover

## v2.1.0-rc6 (2020-04-08)

**Bug fixes:**

- **[webui]** Fix service links

## v2.1.0-rc5 (2020-04-07)

**Bug fixes:**

- **[middlewares]** Stop leaking errors in middleware
- **[teectl]** Fix cluster context for `teectl get ac` command
- **[teectl]** Dont override config on import
- **[teectl]** Resolve cluster correctly when getting creds

**Documentation:**

- Fix JWT documentation
- Add time sensitivity to HMAC doc
- Improve rootless documentation regarding volumes

## v2.1.0-rc4 (2020-04-03)

**Enhancements:**

- **[authentication,middlewares]** Add JWT authentication middleware
- **[authentication,middlewares]** Implement the HMAC middleware
- **[authentication,middlewares]** Add oAuth Token Introspection middleware
- **[cli,raft-api]** Add traefikee recover command
- **[k8s,teectl]** Use random port for kubernetes port forward
- **[metrics]** Add additional middleware tracing
- **[teectl,ux]** Add cluster management commands
- **[teectl]** Cluster regain access
- **[teectl]** Add `teectl create credentials` command
- **[traefik]** Move to Traefik v2.2.0
- **[webui]** WebUI: Add UDP pages to the Dashboard

**Bug fixes:**

- **[authentication,middlewares]** Fix `forwardHeaders` property with booleans
- **[cli,ux]** Do not show empty defaults in CLI help
- **[logs]** Fixed badly worded license log message
- **[teectl]** Skip directories in GetClusters.
- **[webui]** Fix SubNav bar not showing detail
- **[webui]** WebUI: Fix Proxies not showing on Dashboard
- **[webui]** WebUI: display plugin name instead of just &#39;plugin&#39; on Detail pages
- **[webui]** WebUI: Fix Empty TLS options wording

**Documentation:**

- **[teectl,ux]** Cluster management docs
- **[teectl]** Fix credentials documentation
- Add note about using correct cluster name
- Move middleware in docs
- Doc: update a:hover style to avoid blurry links on FF
- fix: avoid link/menu width increase on hover

## v2.0.4 (2020-03-30)

**Bug fixes:**

- **[api]** Override api version endpoint
- **[traefik]** Move traefikee to traefik v2.1.9
- **[webui]** WebUI: display plugin name instead of just &#39;plugin&#39; on Detail pages

**Documentation:**

- Add doc section about integrating with external load balancers

## v1.3.1 (2020-03-30)

**Bug fixes:**

- **[acme]** Return no error when waited service doesn't exist.

## v2.0.3 (2020-03-17)

**Bug fixes:**

- **[cli]** Detect entrypoint address conflict before apply
- **[teectl]** Fix teectl file path on Windows

**Documentation:**

- **[authentication]** Document LDAP options
- Add a guide to install TraefikEE behind a proxy

## v2.0.2 (2020-02-17)

**Enhancements:**

- **[webui]** WebUI: add links to service and middlewares from HTTP/TCP Router detail pages

**Bug fixes:**

- **[raft-api]** Fix config deletion
- **[teectl,ux]** Fix connect error to be more clear
- **[webui]** WebUI: extend background color when the screen is too big
- **[webui]** WebUI: Fix middleware property access

## v2.0.1 (2020-02-09)

**Enhancements:**

- **[api]** Api-proxy graceful shutdown
- **[webui]** Improve user experience by adding some smooth animations

**Bug fixes:**

- **[raft-api]** Increase dynamic configuration limits
- **[traefik]** Update traefik dependency to v2.1.4

## v2.0.0 (2020-02-03)

**Enhancements:**

- **[acme]** ACME Integration
- **[api,webui]** Enable TraefikEE Dashboard
- **[authentication]** Integrate LDAP authentication
- **[backup]** Restore backup implementation
- **[distributed-feature,middlewares]** Migrate ratelimit
- **[distributed-feature,middlewares]** Migrate inflightreq
- **[dockeree]** DockerEE integration
- **[k8s]** Be compliant with Openshift
- **[middlewares]** Force case middleware
- **[swarm]** Bring back autodiscovery
- **[teectl]** Separate traefikee and teectl commands
- **[teectl]** Implement  teectl get static-config
- **[webui]** Overview page

**Bug fixes:**

- **[metrics]** Apply datadog env variables

**Documentation:**

- Add ACME documentation
- Swarm and DockerEE installation guide
- Prometheus documentation
- Document concepts
- Add migrating to TraefikEE v2 documentation
- Add Uninstall documentation page
- Modify Swarm Network Autodiscory
- Add TLS documentation
- Add Operating/In Flight Request limit guide
- Update version upgrade documentation
- Added Dynamic Configuration docs
- Add LDAP authentication documentation
- Modify the Static Configuration docs
- Install guide for kubernetes
- Add operations/dashboard section
- Update on-premise install guide
- Add Disaster Recovery guide
- Add Operating/Rate Limit guide

## v2.0.0-rc3 (2020-02-03)

**Enhancements:**

- **[webui]** WebUI: Improve data visualization for tables in small screens
- Add limits to docker deployment

**Bug fixes:**

- **[acme,backup]** Fix restore when cert resolver name contain numbers
- **[acme,backup]** Fix backup of ACME certificates
- **[acme]** Fix premium acme account
- **[distributed-feature]** Fix panic when closing a TraefikEE node which failed to launch dist srv
- **[k8s,metrics]** Remove prometheus annotations
- **[teectl]** Fix rbac rules to allow a full support dump on k8s

**Documentation:**

- Add ACME documentation
- Swarm and DockerEE installation guide
- Prometheus documentation
- Document concepts
- Add migrating to TraefikEE v2 documentation
- Add Uninstall documentation page
- Modify Swarm Network Autodiscory
- Add TLS documentation

## v2.0.0-rc2 (2020-01-27)

**Enhancements:**

- **[swarm]** Better network names on swarm
- **[teectl,ux]** Add setup gen message
- **[teectl]** Allow teectl to work in a container
- **[webui]** WebUI: Add tooltips in some cells of the dashboard tables

**Bug fixes:**

- **[distributed-feature]** Fix log spam distributed feats
- **[k8s]** More realistic limit for proxy nodes
- **[raft-api]** Fix Provider Controller stop
- **[raft-api]** Augment limits
- **[raft-api]** Cleanup API socket and control socket before starting

**Documentation:**

- Add Operating/In Flight Request limit guide
- Update version upgrade documentation
- Added Dynamic Configuration docs
- Add LDAP authentication documentation
- Modify the Static Configuration docs
- Install guide for kubernetes
- Add operations/dashboard section
- Rework Operating section
- Update on-premise install guide
- Add Disaster Recovery guide
- Update Glossary section in the documentation
- Add Operating/Rate Limit guide

## v2.0.0-rc1 (2020-01-17)

**Enhancements:**

- **[acme]** ACME Integration
- **[api,webui]** Enable TraefikEE Dashboard
- **[authentication]** Integrate LDAP authentication
- **[backup]** Restore backup implementation
- **[cli]** Bring back support commands
- **[distributed-feature,middlewares]** Migrate ratelimit
- **[distributed-feature,middlewares]** Migrate inflightreq
- **[dockeree]** DockerEE integration
- **[k8s]** Be compliant with Openshift
- **[middlewares]** Force case middleware
- **[swarm]** Bring back autodiscovery
- **[teectl]** Separate traefikee and teectl commands
- **[teectl]** Implement  teectl get static-config
- **[ux]** Rename socketpath

**Bug fixes:**

- **[metrics]** Apply datadog env variables

## v1.3.0 (2019-12-24)

**Enhancements:**

- **[licensing,ux]** Add validate command
- **[traefik]** Enable the file provider

**Bug fixes:**

- **[tracing]** Fix tracing with datadog

## v1.3.0-rc1 (2019-12-23)

**Enhancements:**

- **[licensing,ux]** Add validate command
- **[traefik]** Enable the file provider

**Bug fixes:**

- **[tracing]** Fix tracing with datadog

## v1.2.1 (2019-11-05)

**Enhancements:**

- **[k8s,traefikeectl]** AKS support
- **[logs]** Hide spam from ip resolver from metrics
- **[metrics]** Add dogstatd support

## v1.2.1-rc1 (2019-11-04)

**Enhancements:**

- **[k8s,traefikeectl]** AKS support
- **[logs]** Hide spam from ip resolver from metrics
- **[metrics]** Add dogstatd support

## v1.1.15 (2019-10-31)

**Bug fixes:**

- **[acme,cli]** Fix backup without acme account
- **[ctlapi]** Fix support list-services cmd
- **[metrics]** Fix panic on metrics controller

## v1.1.14 (2019-10-29)

**Bug fixes:**

- **[acme]** Fix backup with internal ACME account
- **[backup,ctlapi]** Fixed an issue preventing from restoring very large backups
- **[ctlapi]** Removes the socket file if it already exists during bootstrap
- **[raft-api]** Allows running multiple providers with conflicting name prefixes

## v1.2.0 (2019-10-02)

**Enhancements:**

- **[acme,ctlapi,traefikeectl]** Add acme-list-certificates commands
- **[acme]** Add an ID to certificates when listing them
- **[acme]** Add ACME account from backup file
- **[cli,traefikeectl]** Add support (diagnose) dump command to traefikee / traefikeectl
- **[distributed-feature]** Refactor distributed features
- **[distributed-feature]** Distributed Connection Limiting
- **[distributed-feature]** Improve connection limit feature
- **[dockeree,traefikeectl]** Make traefikeectl work in DockerEE environments
- **[helm]** OpenShift compatibility
- **[logs,traefikeectl]** Add traefikeectl log format option &#34;--logformat&#34;
- **[tls]** Added default cert for deployment
- **[traefikeectl]** Prevent accidental traefikeectl connect

**Bug fixes:**

- **[acme]** Fix panic when truncating SANs in acme-list-certificates

**Documentation:**

- **[swarm]** Add docs to set the Dashboard to another entrypoint on swarm

## v1.2.0-rc2 (2019-10-01)

**Enhancements:**

- **[traefikeectl]** Add --skipdeploy option on traefikeectl install
- Search multiple socket paths

## v1.1.13 (2019-09-30)

**Bug fixes:**

- **[acme]** Fix potential bug with TLS
- **[traefik]** Update traefik dependency to v1.7.18

## v1.1.12 (2019-09-24)

**Bug fixes:**

- **[traefik]** Update traefik dependency to v1.7.17

## v1.2.0-rc1 (2019-09-20)

**Enhancements:**

- **[acme,ctlapi,traefikeectl]** Add acme-list-certificates commands
- **[acme]** Make it possible to add ACME accounts from backup file
- **[cli,traefikeectl]** Add support (diagnose) dump command to traefikee / traefikeectl
- **[distributed-feature]** Distributed Connection Limiting
- **[dockeree,traefikeectl]** Make traefikeectl work in DockerEE environments
- **[helm]** OpenShift compatibility
- **[logs,traefikeectl]** Add traefikeectl log format option `--logformat`
- **[tls]** Add a single default certificate for the entire deployment
- **[traefikeectl]** Prevent accidental traefikeectl connect

**Bug fixes:**

- **[acme]** Fix panic when truncating SANs in acme-list-certificates

**Documentation:**

- **[swarm]** Add docs to set the Dashboard to another entrypoint on swarm

## v1.1.11 (2019-09-19)

**Bug fixes:**

- **[backup]** Allow restoring TLS Entrypoint

**Documentation:**

- Fix release note

## v1.1.10 (2019-09-17)

**Bug fixes:**

- **[acme,tls]** Update traefik server to v1.7.15
- **[acme,tls]** Added check on ACME account private key
- **[acme,tls]** Stop ACME from generating existing certificates
- **[acme]** Wait for service update when removing a challenge
- **[api,licensing]** Fix nil pointer dereference in internal cluster API
- **[api,raft-api]** Set grpc.MaxCallRecvMsgSize on grpc list calls and backup system
- **[cli]** traefikeectl - fix default values when using a config file

**Documentation:**

- Fix Getting started and modify the raft api references in release and changelog files
- Update tooling for documentation for faster and improved docs checking
- Docs/exclude includes dir

## v1.1.9 (2019-08-29)

**Bug fixes:**

- **[raft-api]** Keep config name under 64 characters
- **[tls]** Load default certificate content when loading TLS content

**Documentation:**

- Docs cleanup

## v1.1.8 (2019-08-20)

**Bug fixes:**

- **[distributed-feature,logs,ux]** Less verbose logs on rate limit middleware
- **[infrastructure]** Move to Go 1.12 (Fix HTTP/2 CVEs)

## v1.1.7 (2019-08-13)

**Bug fixes:**

- **[logs]** Allow customizing log formatter in TraefikEE
- **[traefik]** Make hijackConnectionTracker.Close thread safe

**Misc:**

- **[ux]** Remove unnecessary message on key
- **[traefik]** Update Traefik to 1.7.13

## v1.1.6 (2019-07-30)

**Bug fixes:**

- **[raft-api]** Fix/grpc message size + few panics
- **[traefik]** Dont leak certificates on debug

## v1.1.5 (2019-07-26)

**Bug fixes:**

- **[k8s]** Fix installation files

## v1.1.4 (2019-07-26)

**Bug fixes:**

- **[raft-api]** Add Down Data Nodes grace period

**Documentation:**

- Various documentation improvements

## v1.1.3 (2019-07-17)

**Bug fixes:**

- Fix force case header middleware

## v1.1.2 (2019-07-16)

**Enhancements:**

- **[logs]** Add a log displaying license info upon validation
- Add header casing middleware

**Bug fixes:**

- **[distributed-feature]** Do not use proxy for ratelimit connections

## v1.1.1 (2019-07-08)

**Bug fixes:**

- **[k8s,traefikeectl]** Hotfix k8s install with clustername specified

## v1.0.7 (2019-07-05)

**Bug fixes:**

- **[k8s]** Fix proxy support

**Documentation:**

- Fix typo in traefikeectl install help

## v1.1.0 (2019-06-25)

**Enhancements:**

- **[acme]** Add ACME account manager
- **[acme]** Add ACME certificate manager
- **[distributed-feature,traefik]** Add distributed rate limiting
- **[distributed-feature]** Add ping and healthcheck command
- **[helm,k8s]** Add k8s `/ping` readinessProbe
- **[licensing]** Change license server port to `443`
- **[swarm]** Add network autodiscovery
- **[swarm]** Make TraefikEE able to use UCP bundles to work on DockerEE worker nodes only

**Bug fixes:**

- **[backup]** Tar archives now have a modification time set properly
- **[tls,traefik]** Remove base64 encoding and fix mTLS support

**Misc:**

- **[licensing,traefikeectl]** Improve error message on license validation problem

## v1.0.6 (2019-06-19)

**Bug fixes:**

- **[licensing]** Add a validation timeout

**Documentation:**

- Fix yaml in documentation

## v1.0.5 (2019-06-06)

**Bug fixes:**

- **[traefik]** Revert &#34;Upgrade traefik to version v1.7.12&#34;

## v1.0.4 (2019-06-06)

**Bug fixes:**

- **[cli]** Decode TLS certificates provided by traefikeectl
- **[ctlapi]** generate credentials valid one hour before the system time
- **[traefik]** Upgrade traefik to version v1.7.12

## v1.0.3 (2019-06-03)

**Bug fixes:**

- **[acme]** ACME Challenge: Wait for server service update before notifying LE.

**Documentation:**

- Hotfix swarm control node documentation

## v1.0.2 (2019-05-15)

**Enhancements:**

- **[helm,traefikeectl]** Add the --version on helm install if the chart is containous/traefikee
- **[traefikeectl]** Add support command

**Documentation:**

- Fix documentation nit, correct option is --traefikeesocket

## v1.0.1 (2019-05-06)

**Bug fixes:**

- **[swarm]** support docker systemd cgroup driver in cgroups file extraction

**Documentation:**

- Modify on-premise installation documentation
- Fix dockeree solution guide

## v1.0.0 (2019-04-17)

**Enhancements:**

- **[licensing]** Stats deployed configuration
- **[licensing]** Update the license system
- **[ux]** Fix misleading error in traefikeectl

**Bug fixes:**

- **[acme]** Fix ACME certificate restoration
- **[acme]** Acme challenge timeout too short
- **[helm,traefikeectl]** Always use kube config path for helm commands
- **[k8s]** Do not provision persistent volumes in multi control node mode
- **[swarm,traefikeectl]** Fix output when not enough workers in target swarm cluster

**Documentation:**

- **[k8s,swarm]** Document upgrade operation
- Add troubleshooting guide for lost quorum
- Adds a &#34;Docker-EE&#34; solution guide

## v1.0.0-rc1 (2019-04-11)

**Enhancements:**

- **[k8s,traefikeectl,ux]** Hide helm commands that are used for checking purposes
- **[licensing]** Update the license system
- **[ux]** Fix misleading error in traefikeectl

**Bug fixes:**

- **[acme]** Acme challenge timeout too short
- **[helm,traefikeectl]** Always use kube config path for helm commands
- **[k8s]** Do not provision persistent volumes in multi controller mode

**Documentation:**

- **[k8s]** Improve yaml installation guides
- **[k8s,swarm]** Document upgrade operation
- **[swarm,traefikeectl]** Be able to lauch multiple TraefikEE clusters on a swarm cluster.
- Adds a &#34;Docker-EE&#34; solution guide (new section) in the documentation
