---
title: "Traefik Enterprise Release Notes"
description: "In this documentation section, you will find all the changes for each Traefik Enterprise release."
---

# Release Notes

What are the changes for each release?

## v2.11.17 (2026-01-20)

**Documentation:**

- Add a note about Docker v29+

**Misc:**

- **[traefik]** Update to Traefik v2.11.35
- [CVE-2026-22045](https://nvd.nist.gov/vuln/detail/CVE-2026-22045) (Advisory [GHSA-cwjm-3f7h-9hwqj](https://github.com/traefik/traefik/security/advisories/GHSA-cwjm-3f7h-9hwq))

**Bug fixes:**

- Fix log for encodedCharacters

## v2.11.16 (2026-01-20)

Release canceled.

## v2.11.15 (2025-07-29)

**Misc:**

- **[traefik]** Update to Traefik v2.11.28 and to go1.24
- Fix [CVE-2025-54386](https://nvd.nist.gov/vuln/detail/CVE-2025-54386)

## v2.11.14 (2025-06-03)

**Misc:**

- **[traefik]** Update to [Traefik v2.11.25](https://github.com/traefik/traefik/releases/tag/v2.11.25)
- **[authentication,middleware]** Bump github.com/open-policy-agent/opa to v1.4.2

## v2.11.13 (2025-04-23)

**Misc:**

- **[traefik]** Update to [Traefik v2.11.24](https://github.com/traefik/traefik/releases/tag/v2.11.24)
- Fix [CVE-2025-32431](https://nvd.nist.gov/vuln/detail/CVE-2025-32431)
- **[authentication,middleware]** Bump go-jose and opa dependencies
- Fix [CVE-2025-27144](https://nvd.nist.gov/vuln/detail/CVE-2025-27144)
- Fix [CVE-2024-28180](https://nvd.nist.gov/vuln/detail/CVE-2024-28180)
- Fix [CVE-2024-6531](https://nvd.nist.gov/vuln/detail/CVE-2024-6531)

## v2.11.12 (2025-02-12)

**Bug fixes:**

- **[authentication,middleware]** Avoid JWT middleware panic when no JWKS and kid in token header
- **[authentication]** Fix redirect when the state is broken

**Misc:**

- **[traefik]** Update to [Traefik v2.11.20](https://github.com/traefik/traefik/releases/tag/v2.11.20)

## v2.11.11 (2024-12-11)

**Misc:**

- **[traefik]** Update to [Traefik v2.11.15](https://github.com/traefik/traefik/releases/tag/v2.11.15)
- Fix [CVE-2024-53259](https://nvd.nist.gov/vuln/detail/CVE-2024-53259)

## v2.11.10 (2024-11-28)

**Misc:**

- **[traefik]** Update to [Traefik v2.11.14](https://github.com/traefik/traefik/releases/tag/v2.11.14)
- Fix [CVE-2024-52003](https://nvd.nist.gov/vuln/detail/CVE-2024-52003)

## v2.11.9 (2024-11-27)

Release canceled.

## v2.11.8 (2024-10-16)

**Bug fixes:**

- **[middleware]** Close Valkeyrie store when middleware not in use
- **[vault]** Fix Vault authentication when using namespace

## v2.10.18 (2024-10-15)

**Bug fixes:**

- **[middleware]** Fix the Compress Middleware to handle cases when the response has no Content-Type and no body.
- **[vault]** Fix Vault authentication when using namespace

## v2.11.7 (2024-10-04)

**Bug fixes:**

- **[authentication,middleware]** Allow configuration of the redis connection pool size
- **[middleware]** Fix the Compress Middleware to handle cases when the response has no Content-Type and no body.

## v2.11.6 (2024-10-01)

**Bug fixes:**

- **[middleware]** Fix Compress Middleware when there is no Content-Type on no body response code

## v2.10.17 (2024-09-30)

**Bug fixes:**

- **[middleware]** Fix Compress Middleware when there is no Content-Type on no body response code

## v2.11.5 (2024-09-17)

**Misc:**

- **[traefik]** Update to [Traefik v2.11.9](https://github.com/traefik/traefik/releases/tag/v2.11.9) and to go 1.23
- Fix [CVE-2024-45410](https://nvd.nist.gov/vuln/detail/CVE-2024-45410)

## v2.10.16 (2024-09-17)

**Bug fixes:**

- Bump google.golang.org/grpc to v1.64.1

**Misc:**

- **[traefik]** Update to [Traefik v2.11.9](https://github.com/traefik/traefik/releases/tag/v2.11.9) and to go 1.23
- Fix [CVE-2024-45410](https://nvd.nist.gov/vuln/detail/CVE-2024-45410)

## v2.11.4 (2024-08-07)

**Misc:**

- **[traefik]** Update to [Traefik v2.11.8](https://github.com/traefik/traefik/releases/tag/v2.11.8)

## v2.10.15 (2024-08-07)

**Documentation:**

- Add Traefik update to the release note
- Improve license management documentation

**Misc:**

- **[traefik]** Update to [Traefik v2.11.8](https://github.com/traefik/traefik/releases/tag/v2.11.8)

## v2.10.14 (2024-07-30)

**Bug fixes:**

- **[middleware]** Stop goroutine when OIDC middleware is not used anymore
- **[middleware]** Add issuerHost option to communicate with the OIDC provider directly

**Misc:**

- **[traefik]** Update to [Traefik v2.11.7](https://github.com/traefik/traefik/releases/tag/v2.11.7)

## v2.11.3 (2024-07-10)

**Bug fixes:**

- **[authentication,middleware,kv]** Fix Redis Sentinel support for OIDC and OAuth Token Introspection middlewares
- **[authentication]** Fix JWT middleware iss claim usage in the jwksURL option
- Fix [CVE-2024-39321](https://www.cve.org/CVERecord?id=CVE-2024-39321)
- Fix [CVE-2024-35255](https://nvd.nist.gov/vuln/detail/CVE-2024-35255)
- Fix [CVE-2024-24790](https://www.cve.org/CVERecord?id=CVE-2024-24790)

**Documentation:**

- Remove ambiguity between authentication and authorization from the doc

**Misc:**

- **[traefik]** Update to [Traefik v2.11.6](https://github.com/traefik/traefik/releases/tag/v2.11.6)

## v2.10.13 (2024-07-09)

**Bug fixes:**

- **[authentication]** Fix JWT middleware iss claim usage in the jwksURL option
- Fix [CVE-2024-39321](https://www.cve.org/CVERecord?id=CVE-2024-39321)
- Fix [CVE-2024-35255](https://nvd.nist.gov/vuln/detail/CVE-2024-35255)
- Fix [CVE-2024-24790](https://www.cve.org/CVERecord?id=CVE-2024-24790)

**Documentation:**

- Remove ambiguity between authentication and authorization from the doc

**Misc:**

- **[traefik]** Update to [Traefik v2.11.6](https://github.com/traefik/traefik/releases/tag/v2.11.6)

## v2.11.2 (2024-05-29)

**Enhancements:**

- **[traefik]** Update to Traefik [v2.11.3](https://github.com/traefik/traefik/releases/tag/v2.11.3)

**Bug fixes:**

- **[middleware]** Fix the CSRF cookie path
- Fixes [GHSA-f7cq-5v43-8pwp](https://github.com/traefik/traefik/security/advisories/GHSA-f7cq-5v43-8pwp) (Related to [CVE-2024-24788](https://www.cve.org/CVERecord?id=CVE-2024-24788))

**Documentation:**

- docs: add loglevel, logformat, and logfilepath parameters

## v2.10.12 (2024-05-23)

**Bug fixes:**

- **[licensing]** Fix anonymization of static configuration

**Documentation:**

- **[plugins]** Update plugins documentation

## v2.11.1 (2024-04-25)

**Bug fixes:**

- **[middleware]** Do not send empty post logout redirect URL
- **[middleware]** Fix jwksURL concatenation when iss has a path
- Fix [CVE-2024-28869](https://www.cve.org/CVERecord?id=CVE-2024-28869)
- Fix [CVE-2023-45288](https://www.cve.org/CVERecord?id=CVE-2023-45288)

**Documentation:**

- **[middleware]** Document ignorebackenderrors option

**Misc:**

- **[traefik]** Update to [Traefik v2.11.2](https://github.com/traefik/traefik/releases/tag/v2.11.2)

## v2.10.11 (2024-04-25)

**Bug fixes:**

- Fix jwksURL concatenation when iss has a path
- Fix [CVE-2024-28869](https://www.cve.org/CVERecord?id=CVE-2024-28869)
- Fix [CVE-2023-45288](https://www.cve.org/CVERecord?id=CVE-2023-45288)

## v2.11.0 (2024-03-06)

**Enhancements:**

- **[k8s]** Update Kubernetes CRD definitions
- **[k8s,middleware]** Support loading of OIDC clientID from k8s secret
- **[middleware]** Support OIDC backchannel logout
- **[middleware]** Add CSRF protection to the OIDC middleware
- **[middleware]** Add static client credentials to the OAuth Client Credentials middleware
- **[middleware]** Add secretValues and secretNonBase64Encoded attributes on apiKeys
- **[middleware]** Add ignoreBackendErrors option in error page middleware. If you are using Kubernetes don't forget to update your CRDs
- **[traefik]** [Feat upgrade to Traefik v2.11.0](https://github.com/traefik/traefik/releases/tag/v2.11.0)

**Bug fixes:**

- **[middleware,authentication]** Fix logout redirect
- Patch CVE-2024-24783
- Patch CVE-2023-45290
- Patch CVE-2023-45289

**Documentation:**

- Fix typo in CHANGELOG
- **[authentication]** Fix doc for api key

## v2.10.10 (2024-03-06)

**Bug fixes:**

- Fix access token claims with forward headers option
- Patch CVE-2024-24783
- Patch CVE-2023-45290
- Patch CVE-2023-45289

**Documentation:**

- **[helm]** Documentation - Static provisioning and EKS Fargate

## v2.11.0-rc1 (2024-02-15)

**Enhancements:**

- **[traefik]** [Feat upgrade to Traefik v2.11.0](https://github.com/traefik/traefik/releases/tag/v2.11.0)
- **[middleware]** Add ignoreBackendErrors option in error page middleware. If you are using Kubernetes don't forget to update your CRDs

**Bug fixes:**

- **[middleware,authentication]** Fix logout redirect

**Documentation:**

- **[authentication]** Fix doc for api key

## v2.10.9 (2024-02-14)

**Documentation:**

- **[k8s]** Update Kubernetes CRD reference documentation
- **[k8s]** Modify Kubernetes Installation Menu
- **[k8s]** Add static volumes provisioning with helm chart

## v2.9.8 (2024-02-08)

**Bug fixes:**

- **[metrics]** Increment reload config metric on dynamic configuration apply
- **[authentication]** Fix hash OAuth client credentials token cache key

## v2.11.0-beta2 (2024-01-25)

**Enhancements:**

- **[middleware]** Add secretValues and secretNonBase64Encoded attributes on apiKeys
- Bump Traefik to v2.11-rc2

**Documentation:**

- Fix typo in CHANGELOG

## v2.11.0-beta1 (2024-01-11)

**Enhancements:**

- **[k8s,middleware]** Support loading of OIDC clientID from k8s secret
- **[k8s]** Update Kubernetes CRD definitions
- **[middleware]** Support OIDC backchannel logout
- **[middleware]** Add CSRF protection to the OIDC middleware
- **[middleware]** Add static client credentials to the OAuth Client Credentials middleware
- Update to Traefik v2.11

## v2.10.8 (2024-01-10)

**Bug fixes:**

- Update to [Traefik v2.10.7](https://github.com/traefik/traefik/releases/tag/v2.10.7)
- Add initialConfigPropagationDelay option

**Documentation:**

- **[k8s]** Fix Kubernetes Supported versions
- **[k8s]** Update Kubernetes supported versions

## v2.10.7 (2023-12-12)

**Bug fixes:**

- Patch CVE-2023-39326

## v2.9.7 (2023-12-12)

**Bug fixes:**

- Patch CVE-2023-39326
- **[vault]** Fix apply of default static config values to Vault KV provider

## v2.10.6 (2023-12-01)

**Bug fixes:**

- Update to [Traefik v2.10.6](https://github.com/traefik/traefik/releases/tag/v2.10.6)

## v2.9.6 (2023-11-30)

**Bug fixes:**

- Update to Traefik v2.9 and bump to go 1.21

**Documentation:**

- docs: update instructions for v2.0 of the Chart

## v2.10.5 (2023-10-12)

**Bug fixes:**

- Update to [Traefik v2.10.5](https://github.com/traefik/traefik/releases/tag/v2.10.5)
- Patch CVE-2023-39325
- Patch CVE-2023-44487
- **[raft-api]** Add an info message when the cluster does not contain any proxy

**Documentation:**

- [Doc] Adding registry systemd unit file

## v2.9.5 (2023-10-12)

**Bug fixes:**

- Patch CVE-2023-39325
- Patch CVE-2023-44487

## v2.10.4 (2023-07-28)

**Bug fixes:**

- **[middleware]** Fix ratelimit denyOnError behavior

## v2.9.4 (2023-07-28)

**Bug fixes:**

- **[metrics]** Enable Prometheus provider cleanup when only the router&#39;s metrics level is activated
- **[middleware]** Fix ratelimit denyOnError behavior
- **[swarm]** Add label for swarm network discovery

**Documentation:**

- **[teectl]** Add arm64 teectl link in doc
- **[traefik-mesh]** Update API endpoint descriptions

## v2.10.3 (2023-07-26)

**Bug fixes:**

- **[middleware]** Fix distributed ratelimit middleware with small limit
- **[providers]** Fix the Vault provider to handle correctly the mTLS connection
- **[raft-api]** Bump raft API version
- **[traefik]** Bump to Traefik [v2.10.4](https://github.com/traefik/traefik/releases/tag/v2.10.4)

**Documentation:**

- **[middleware]** Add missing rate limit options
- Add default value for the cluster name in the Helm documentation

## v2.10.2 (2023-06-20)

- **[traefik]** Bump to Traefik [v2.10.3](https://github.com/traefik/traefik/releases/tag/v2.10.3)

**Bug fixes:**

- **[k8s,authentication]** Fix Kubernetes secret loading for auth sources

**Documentation:**

- Adjust warning admonition

## v2.9.3 (2023-05-04)

**Bug fixes:**

- **[webui]** Add TCP middleware support in dashboard
- **[middleware]** 103 Early hints support for Compress middleware

## v2.10.1 (2023-04-28)

- **[traefik]** Bump to Traefik [v2.10.1](https://github.com/traefik/traefik/releases/tag/v2.10.1)

## v2.10.0 (2023-04-26)

**Enhancements:**

- **[authentication,middleware]** oidc: support claims from access token
- **[middleware]** ratelimit: add relevant headers in response
- **[k8s,authentication,middleware]** Support referencing Kubernetes secrets values in auth sources
- **[traefik]** Bump to Traefik v2.10.0

## v2.10.0-rc1 (2023-04-18)

**Enhancements:**

- **[authentication,middleware]** oidc: support claims from access token
- **[middleware]** ratelimit: add relevant headers in response

## v2.9.2 (2023-04-11)

**Bug fixes:**

- Patch CVE-2023-29013

**Documentation:**

- **[k8s]** Update Kubernetes version

## v2.8.6 (2023-04-07)

**Bug fixes:**

- **[authentication,middleware]** Fix case sensitivity issue when filling plugins default values
- **[distributed-feature,middleware]** Fix ratelimit zero value for &#39;average&#39;
- **[middleware]** Upgrade open-policy-agent version (0.48.0)
- **[traefik]** Fix empty TCP or UDP configuration applications
- **[middleware]** Fix middleware plugins default config value fill out
- Patch CVE-2023-29013

**Documentation:**

- **[providers]** Add ECS Fargate installation documentation
- Update Documentation Copyright Text

## v2.9.1 (2022-12-13)

**Bug fixes:**

- Patch CVE-2022-23469
- Patch CVE-2022-46153
- Patch CVE-2022-41717

**Documentation:**

- docs: update traefik helm repository

## v2.8.5 (2022-12-12)

**Bug fixes:**

- Patch CVE-2022-23469
- Patch CVE-2022-46153
- Patch CVE-2022-41717

## v2.9.0 (2022-11-21)

**Enhancements:**

- **[authentication,middleware]** Support PS256, PS384 and PS512 signature algorithms in JWT middleware
- **[authentication,middleware]** Look for JWTs in form data in addition to query parameters
- **[traefik,pilot]** Remove Traefik Pilot support and update Traefik to v2.9.1

**Documentation:**

- Add Windows named pipe examples
- Fix the guide to upgrade version in Swarm

## v2.9.0-rc1 (2022-11-18)

**Enhancements:**

- **[authentication,middleware]** Support PS256, PS384 and PS512 signature algorithms in JWT middleware
- **[authentication,middleware]** Look for JWTs in form data in addition to query parameters
- **[traefik,pilot]** Remove Traefik Pilot support and update Traefik to v2.9.5

**Documentation:**

- Add Windows named pipe examples
- Fix the guide to upgrade version in Swarm

## v2.9.0-beta1 (2022-11-04)

**Enhancements:**

- **[authentication,middleware]** Support PS256, PS384 and PS512 signature algorithms in JWT middleware
- **[traefik,pilot]** Remove Traefik Pilot support and update Traefik to v2.9.1

**Documentation:**

- Add Windows named pipe examples
- Fix the guide to upgrade version in Swarm

## v2.8.4 (2022-10-24)

**Bug fixes:**

- **[distributed-feature]** Improve distributed rate limit accuracy

**Documentation:**

- Fix version upgrade in Swarm

## v2.7.6 (2022-10-19)

**Bug fixes:**

- **[distributed-feature]** Improve distributed rate limit accuracy

**Documentation:**

- Fix version upgrade in Swarm

## v2.8.3 (2022-10-03)

**Bug fixes:**

- Patch CVE-2022-27664

## v2.7.5 (2022-09-30)

**Bug fixes:**

- Patch CVE-2022-27664
- Correctly interpret periods as seconds when no unit is specified in the distributed rate limit middleware

**Documentation:**

- Add missing `discovery.static.peers` argument when installing TraefikEE on-premise

## v2.8.2 (2022-09-20)

**Bug fixes:**

- Fix possible proxy node crash when upgrading to v2.8

## v2.8.1 (2022-09-19)

Release canceled.

## v2.7.4 (2022-09-16)

**Bug fixes:**

- **[teectl]** Fix configuration detection for teectl apply

## v2.7.3 (2022-09-07)

**Bug fixes:**

- **[api]** Display default TLS options when used in the Dashboard
- **[backup]** Fix missing API credentials bundle when doing backups
- **[providers,vault]** Skip certificates that are not properly formatted in the Vault KV provider

## v2.8.0 (2022-08-29)

**Enhancements:**

- **[apiportal]** Add Support for API Portal Groups
- **[authentication,middleware]** Add Templating Support for OAuth Token Introspection Custom Headers
- **[authentication,middleware]** Add Vault Kubernetes authentication method
- **[authentication,middleware]** Enhance authentication middlewares with new options to manage TLS, timeout and connection retry
- **[metrics]** Add support for Datadog globalTags
- **[webui]** Add Plugins and Hub links to the Dashboard Header and Remove Pilot iframe

## v2.8.0-rc1 (2022-08-29)

**Enhancements:**

- **[apiportal]** Add Support for API Portal Groups
- **[authentication,middleware]** Add Templating Support for OAuth Token Introspection Custom Headers
- **[authentication,middleware]** Add Vault Kubernetes authentication method
- **[metrics]** Add support for Datadog globalTags
- **[webui]** Add Plugins and Hub links to the Dashboard Header and Remove Pilot iframe

## v2.7.2 (2022-08-25)

**Bug fixes:**

- **[authentication,middleware]** Fixes an error in the OIDC middleware that could occur when upgrading from previous versions
- **[acme]** Fix ACME provider failure when migrating from 2.5 to 2.6

## v2.7.1 (2022-08-22)

**Bug fixes:**

- **[traefik-mesh]** Fix for CoreDNS patching in RKE2
- **[metrics]** Fix Datadog memory leak when the agent is unreachable
- **[traefik]** Update Traefik (fixes an issue with the HostRegexp and the Query matchers)

**Misc:**

- **[traefik-mesh]** Update Mesh to v1.4.7 (compatible with Kubernetes v1.24+)
- Update to go1.19

## v2.6.8 (2022-08-22)

**Bug fixes:**

- Fix for CoreDNS patching in RKE2

**Misc:**

- Update to go1.19

## v2.6.7 (2022-08-19)

Release canceled.

## v2.6.6 (2022-08-05)

**Bug fixes:**

- **[metrics]** Fix Datadog memory leak when the agent is unreachable
- **[traefik]** Update Traefik (fixes an issue with the HostRegexp and the Query matchers)

**Misc:**

- **[traefik-mesh]** Update Mesh to v1.4.7 (compatible with Kubernetes v1.24+)

## v2.7.0 (2022-06-28)

**Enhancements:**

- **[authentication,middleware]** Add OAuth 2.0 Client Credentials Middleware
- **[authentication,middleware]** Support PKCE in OIDC middleware
- **[ctlapi]** Support running TraefikEE on bare-metal Windows host
- **[apiportal]** Test the API from the API Portal

## v2.6.5 (2022-06-28)

**Bug fixes:**

- Support Datadog `DD_AGENT_HOST` environment variable
- Fix an issue that caused Datadog metrics loss when reloading the static configuration

**Documentation:**

- Fix a bad helm command in documentation

## v2.7.0-rc1 (2022-06-17)

**Enhancements:**

- **[authentication,middleware]** Add OAuth 2.0 Client Credentials Middleware
- **[authentication,middleware]** Support PKCE in OIDC middleware
- **[ctlapi]** Support running TraefikEE on bare-metal Windows host
- **[apiportal]** Test APIs from the API Portal

## v2.6.4 (2022-05-30)

**Bug fixes:**

- **[authentication,middleware]** Fix missing backend storage error when using ETCD

**Misc:**

- **[apiportal]** Improve the Contract API link wording

## v2.6.3 (2022-05-25)

Release canceled.

## v2.6.2 (2022-05-25)

Release canceled.

## v2.5.10 (2022-05-23)

**Bug fixes:**

- **[apiportal]** Avoid duplicated menu entries in APIPortal
- **[authentication,middleware]** Ensure forwarded headers overwrite client sent headers in authentication middlewares

**Documentation:**

- Fix version upgrade process for minor versions
- Add configMapKey to the Helm install command

## v2.6.1 (2022-03-31)

**Bug fixes:**

- **[authentication,middleware]** Support PROXY env vars in OIDC client

**Documentation:**

- **[infrastructure]** Adds missing arm64 binary download link and release notes
- **[apiportal]** Add API Portal dynamic path examples

## v2.5.9 (2022-03-29)

**Bug fixes:**

- **[authentication]** Support PROXY env var in HTTP clients

## v2.6.0 (2022-03-10)

**Enhancements:**

- **[apiportal]** Add support for YAML specification files for API Portal
- **[authentication,middleware]** Add discoveryParams and allow the consent prompt removal in OIDC middleware
- **[authentication,middleware]** Store session data in KV store
- **[authentication,middleware]** Allow specifying TLS configuration for OIDC AuthSource
- **[middleware,cache]** Add status codes exclusion option for cache middleware
- **[providers]** Add namespace support for Vault Provider and Certificate Resolver
- **[teectl]** Add teectl command to update license

**Bug fixes:**

- **[authentication,middleware]** Use custom HTTP client for OIDC requests

**Misc:**

- **[infrastructure]** Add support for ARM v8 64 Bits

## v2.5.8 (2022-03-09)

**Bug fixes:**

- **[authentication]** Ensures OIDC forwarded headers excludes client sent headers

**Documentation:**

- **[middleware]** Fix broken links to Traefik proxy documentation
- **[middleware]** Update outdated links

## v2.4.21 (2022-03-08)

**Bug fixes:**

- **[authentication]** Ensures OIDC forwarded headers excludes client sent headers

**Documentation:**

- **[authentication,middleware]** Fix authParams example for Docker
- **[middleware]** Fix broken link to basic authentication middleware

## v2.5.7 (2022-02-16)

**Bug fixes:**

- **[traefik]** Update Traefik (fix CVE-2022-23632)

## v2.4.20 (2022-02-15)

**Bug fixes:**

- **[cli]** Set plugin token from environment variable before validation
- **[traefik]** Update Traefik (fix CVE-2022-23632)

## v2.5.6 (2022-01-20)

**Bug fixes:**

- **[traefik]** Mitigate request context memory leak

## v2.4.19 (2022-01-19)

**Bug fixes:**

- **[traefik,plugins]** Mitigate memory leaks

## v2.5.5 (2022-01-18)

**Bug fixes:**

- **[traefik,plugins]** Mitigate memory leaks

## v2.5.4 (2022-01-07)

**Bug fixes:**

- **[raft-api]** Fix dynamic configuration propagation

## v2.5.3 (2021-12-23)

**Bug fixes:**

- **[traefik]** Update Traefik to v2.5.6

## v2.4.18 (2021-12-23)

**Bug fixes:**

- **[cli]** Fix missing plugin and join tokens environment variables

## v2.5.2 (2021-12-16)

**Enhancements:**

- Update Traefik to v2.5.5

**Documentation:**

- **[helm]** Add Helm deployment instructions

## v2.4.17 (2021-12-16)

**Bug fixes:**

- **[apiportal]** Add error logging for API portal services
- **[apiportal]** Fix query params in API portal path for list handler
- **[apiportal]** Fix query params in OpenAPI path

**Documentation:**

- **[apiportal]** Update service name for API portal
- **[k8s]** Fix broken Kubernetes documentation links

## v2.4.16 (2021-12-15)

Release canceled.

## v2.5.1 (2021-11-24)

**Bug fixes:**

- **[cli]** Fix teectl templating on Windows

## v2.4.15 (2021-11-10)

**Bug fixes:**

- **[cli]** CLI: ignore proxy settings for local socket connection
- **[providers]** Add TLS support for Vault KV provider and Vault PKI certificate resolver

## v2.5.0 (2021-09-27)

**Enhancements:**

- **[licensing]** Add offline mode support
- **[apiportal]** Allow API Portal config to be specified dynamically
- **[authentication]** Add OIDC post login and logout redirect urls
- **[cli]** Add OS affinity on Kubernetes manifests
- **[distributed-feature]** Add Timeout and DenyOnError options to distributed rate limit middleware
- **[providers]** Add Traefik provider support
- Embed Traefik v2.5

**Bug fixes:**

- **[middleware,providers]** Strip middleware declaration from Traefik provider configs
- **[providers]** Fix merging multiple cluster configs for the Traefik provider
- **[teectl]** Update installation to support Kubernetes 1.22+

**Documentation:**

- **[authentication,middleware]** Add API Key Authentication middleware
- feat: LimitNOFILE documented for on-premise installation
- Clarify OIDC forwardHeaders source

**Misc:**

- Update Traefik Provider documentation image

## v2.4.14 (2021-09-24)

**Enhancements:**

- **[traefik-mesh]** Update Mesh version to v1.4.4
- **[traefik-mesh]** Update Mesh version to v1.4.2

**Bug fixes:**

- **[middleware]** Fix OIDC middleware

## v2.5.0-beta7 (2021-08-23)

**Enhancements:**

- **[apiportal]** Allow API Portal config to be specified dynamically
- **[authentication]** Add OIDC post login and logout redirect urls
- **[traefik]** Update Traefik v2.5.1

**Bug fixes:**

- **[teectl]** Update installation to support Kubernetes 1.22+

## v2.4.13 (2021-08-10)

**Bug fixes:**

- **[plugins]** Increase retry timeout when initializing plugins
- **[traefik]** Fix KV provider by removing unwanted trailing slashes in key
- **[traefik]** Avoid unauthorized middleware cross namespace reference

## v2.5.0-beta6 (2021-08-09)

**Enhancements:**

- **[traefik]** Update Traefik to v2.5.0-rc5

## v2.5.0-beta5 (2021-08-06)

Release cancelled.

## v2.4.12 (2021-08-06)

**Enhancements:**

- **[traefik]** Update Traefik to v2.4.13

## v2.3.6 (2021-08-05)

**Bug fixes:**

- **[teectl]** Fix teectl connection when using multiple hosts
- **[traefik]** Backport hop-by-hop headers fix (CVE-2021-32813)

**Documentation:**

- Fix wrong socket use in on-premises example

## v2.5.0-beta4 (2021-07-28)

**Bug fixes:**

- **[providers]** Fix merging multiple cluster configs for the Traefik provider

**Documentation:**

- Clarify OIDC forwardHeaders source

## v2.4.11 (2021-07-27)

**Bug fixes:**

- **[backup]** Fix missing nested values from static config on backup restore

## v2.5.0-beta3 (2021-07-22)

**Enhancements:**

- **[cli]** Add OS affinity on Kubernetes manifests

**Bug fixes:**

- **[middleware,providers]** Strip middleware declaration from Traefik provider configs

## v2.4.10 (2021-07-16)

**Bug fixes:**

- **[backup]** Fix configuration parsing during version upgrade
- **[tracing]** Add Instana Environment Variable

## v2.4.9 (2021-07-15)

**Bug fixes:**

- **[providers]** Always restart the providers on error
- **[middleawres]** Accesslog: support multiple values for a given header

## v2.4.8 (2021-07-05)

**Bug fixes:**

- **[teectl]** Fix Refresh License Command

**Documentation:**

- Update whoami image tag in documentation

## v2.4.7 (2021-06-14)

**Bug fixes:**

- **[authentication]** Fix OIDC final redirect and session cookie domain
- **[cli]** Fix Mesh RBAC templates
- **[acme]** Fix challenges

**Documentation:**

- Add information about teectl distribution for Apple M1

## v2.5.0-beta2 (2021-05-28)

**Enhancements:**

- **[distributed-feature]** Add Timeout and DenyOnError options to distributed rate limit middleware
- **[providers]** Add Traefik provider support

## v2.4.6 (2021-06-07)

**Bug fixes:**

- **[authentication,middleware]** Fix OIDC state cookie domain

**Documentation:**

- Add FIPS documentation

## v2.4.5 (2021-05-21)

**Bug fixes:**

- **[plugins]** Fix middleware configuration parsing

## v2.4.4 (2021-03-26)

**Bug fixes:**

- **[acme]** Fix ACME ALPN-TLS challenge
- **[traefik-mesh]** Fix Traefik Mesh templates

## v2.4.3 (2021-03-15)

**Bug fixes:**

- **[middleware]** Updates traefik/oxy
- **[teectl]** Fix azure auth through Active Directory
- **[teectl]** Fix teectl connection when using multiple hosts

**Documentation:**

- fix on-premises multi controller doc

## v2.3.5 (2021-03-08)

**Bug fixes:**

- **[traefik]** Fix rate limit middleware

## v2.5.0-beta1 (2021-02-16)

**Enhancements:**

- **[licensing]** Add offline mode support
- **[authentication,middleware]** Add API Key Authentication middleware

## v2.4.2 (2021-02-15)

**Bug fixes:**

- **[middleware,traefik]** Update traefik fork version to get compress middleware fix

**Documentation:**

- Update documentation to point to v2.4

## v2.3.4 (2021-02-15)

**Enhancements:**

- **[traefik]** Update Traefik to v2.3.7

**Bug fixes:**

- **[traefik]** Fix metrics reset issue

## v2.4.1 (2021-02-03)

**Bug fixes:**

- **[acme]** Fix DNS Challenge with Power DNS

**Documentation:**

- **[middleware]** Fix headings in OPA documentation

## v2.4.0 (2021-01-15)

**Enhancements:**

- **[acme]** Add ACME certificate deletion command
- **[authentication,middleware]** Add OPA middleware
- **[authentication,logs]** Write Authentication User Information in the AccessLogs
- **[cli,teectl,ux]** Add timeout flag to teectl commands
- **[cli,teectl]** Add environment variables for license and join tokens
- **[pilot]** Add Pilot Metrics to Proxies
- **[pilot]** Add Public/Private Plugin support

## v2.3.3 (2021-01-15)

**Bug fixes:**

- **[acme]** Fix ACME certificate restore from backup

**Documentation:**

- Update version upgrade documentation
- Add teectl remote access section to on-premises install guide

## v2.4.0-rc2 (2021-01-05)

**Documentation:**

- **[authentication]** Open Policy Agent Middleware User Guide

## v2.3.2 (2020-12-28)

**Bug fixes:**

- **[logs,tls]** Remove spammy log in TLS provider

**Documentation:**

- Remove invalid root key in static config reference

## v2.2.5 (2020-12-23)

**Bug fixes:**

- **[logs,tls]** Remove spammy log in TLS provider

**Documentation:**

- Remove invalid root key in static config reference

## v2.3.1 (2020-12-18)

**Bug fixes:**

- **[cli]** Fix credentials commands for On-Premise

**Documentation:**

- **[gitops]** Make GitOps install guide less destructive
- Add AWS ECS install guide
- Add Nomad Install guide

## v2.4.0-rc1 (2020-12-18)

**Enhancements:**

- **[acme]** Add ACME certificate deletion command
- **[authentication,logs]** Write Authentication User Information in the AccessLogs
- **[authentication,middleware]** Add OPA middleware
- **[authentication,providers]** Add support for HashiCorp Vault AppRole authentication
- **[cli,teectl,ux]** Add timeout flag to teectl commands
- **[cli,teectl]** Add environment variables for license and join tokens
- **[pilot,plugins]** Add plugin support
- **[pilot]** Add Pilot Metrics to Proxies

## v2.2.4 (2020-12-18)

**Bug fixes:**

- **[distributed-feature,middleware]** Add a period option in the distributed rate limit middleware
- **[authentication]** Add support for not operator in JWT claims expressions
- **[swarm]** TLS provider optimization
- **[teectl]** Fix credentials command
- Fix issue where docker client was never closed

**Documentation:**

- **[authentication]** Improve the LDAP documentation
- Fix restore command reference
- Add traefikee/teectl credentials command reference

## v2.3.0 (2020-10-16)

**Enhancements:**

[api] Add API Portal to display the OpenAPI Spec of services
[cache,middleware] Introduce HTTP cache middleware
[gitops] Enable GitOps flow installation
[providers] Introduce VAULT as a certificates provider
[tls] Introduce VAULT as certificates resolver
[teectl,tls] Add a way to replace existing TLS certificates using the --force option
[teectl] Add server version to teectl version command
[traefik] Move to traefik v2.3
[traefik] Support DRAIN state in Health Check
[cli] Add `traefikee healthcheck` command

**Bug fixes:**

[teectl, traefik-mesh] Fix Traefik Mesh Name in Kubernetes Manifest
[authentication, middleware] Fix JWT middleware when using dynamic JWKs with the iss property ending with a trailing slash
[licensing] Allow refreshing a license status

## v2.3.0-rc2 (2020-10-07)

**Bug fixes:**

- **[teectl, traefik-mesh]** Fix Traefik Mesh Name in Kubernetes Manifest

## v2.2.3 (2020-10-06)

**Bug fixes:**

- **[authentication,middleware]** Fix JWT middleware when using dynamic JWKs with the `iss` property ending with a trailing slash
- **[licensing]** Allow to refresh a license status

## v2.3.0-rc1 (2020-10-05)

**Enhancements:**

- **[api]** Add API Portal to display the OpenAPI Spec of services
- **[cache,middleware]** Introduce HTTP cache middleware
- **[gitops]** Enable GitOps flow installation
- **[providers]** Introduce VAULT as a certificates provider
- **[tls]** Introduce VAULT as certificates resolver
- **[teectl,tls]** Add a way to replace existing TLS certificates using the `--force` option
- **[teectl]** Add server version to `teectl version` command
- **[traefik]** Move to traefik v2.3
- **[traefik]** Support DRAIN state in Health Check

## v1.3.5 (2020-09-11)

**Bug fixes:**

- **[dockeree]** Fix for compliance with DockerEE UCP v3.1+

## v2.2.2 (2020-08-28)

**Bug fixes:**

- **[authentication]** Fix the OIDC middleware to be compliant with Azure Active Directory

**Documentation:**

- **[maesh]** Add service mesh operating guide

## v2.1.7 (2020-08-28)

**Bug fixes:**

- **[cli,distributed-feature]** Add a flag to control the distributed port on the controllers and proxies
- **[cli,teectl,ux]** Make Dial call asynchronous to get meaningful errors in grpc calls
- **[webui]** Update License page to properly display long license names

## v2.2.1 (2020-07-29)

**Bug fixes:**

- **[authentication,middleware]** Fix nested values forwarding support on auth middlewares
- **[traefik]** Update Traefik to v2.2.8 (fix CVE-2020-15129)

**Documentation:**

- Update licensing server address in documentation

## v2.1.6 (2020-07-29)

**Bug fixes:**

- **[authentication,middleware]** Fix nested values forwarding support on JWT and oauth token introspection
- **[traefik]** Update Traefik to v2.2.8

## v1.3.3 (2020-07-29)

**Bug fixes:**

- **[api]** Sanitize X-Forwarded-Prefix when redirecting to the API

## v2.2.0 (2020-07-21)

**Enhancements:**

- **[maesh]** Maesh Integration
- **[authentication,middlewares]** OpenID Connect Middleware
- **[authentication,middlewares]** Handle Dynamic JWKS URLs in the JWT Middleware
- **[cli,maesh]** Allow using Mesh without ingress proxy
- **[maesh,webui]** Add Maesh Section to Dashboard
- **[webui]** Update Ingress Overview page
- **[webui]** Move TraefikEE current content into ingress section
- **[api]** Add cluster errors endpoint
- **[api,maesh]** Expose platform information on the API
- **[webui]** Handle mesh availability based on cluster information
- **[webui]** Improve logic for Errors Table on Main Overview page and sort them
- **[webui]** Add a page displaying mesh interconnections using a flow diagram.
- **[authentication,middleware]** Update JWT middleware to handle JWK sets in files
- **[api,maesh]** Add service mesh availability to license information endpoint
- **[webui]** Remove unnecessary Card titles on Mesh Overview page
- **[webui]** Add ability to navigate to each section from the ingress overview page
- **[webui]** Add ability to navigate to each section from the main overview page
- **[traefik]** Update Traefik to v2.2.7

**Bug fixes:**

- **[api,maesh]** Make Mesh service API consistent
- **[api]** Sort ingress errors API to make it consistent
- **[webui]** Display charts correctly when there are no service on Overview pages
- **[webui]** Fix unclickable search inputs
- **[acme,maesh,teectl]** Improve error message on license enabled features
- **[maesh]** Remove liveness port declaration from mesh proxy Daemonset
- **[authentication,middleware]** Improve stability with the KubernetesCRD provider
- **[licensing,webui]** Correctly count ingresses for license information
- **[webui,maesh]** Update Mesh Services page to show Additional Features on the table

**Documentation:**

- **[cli]** Clarify cluster credentials documentation
- Rename "Operating" section to "Operations"
- **[middleware]** Fix TOML snippets in OIDC documentation
- **[webui]** Clean up dashboard operating guide
- Introduce the Configuration Discovery Section in Documentation
- Clean up the Glossary page for TraefikEE 2.2 w/Maesh integration
- Add service mesh language to Concepts page
- Fix middleware configuration snippet format
- **[authentication,middlewares]** Document OpenID Connect Middleware
- **[maesh]** Document Maesh Integration
- **[webui]** Modify dashboard images

**Misc:**

- **[maesh,traefik]** Update Maesh to v1.3.1

## v2.1.5 (2020-07-21)

**Bug fixes:**

- **[authentication]** Fix default values for the HMAC middleware

**Documentation:**

- **[authentication,middleware]** Fix TOML snippets in JWT and OAuth documentation

**Misc:**

- Update Traefik to v2.2.7

## v2.2.0-rc3 (2020-07-17)

**Documentation:**

- **[cli]** Clarify cluster credentials documentation
- Rename "Operating" section to "Operations"

## v2.0.5 (2020-07-15)

**Bug fixes:**

- **[cli,teectl]** Evaluate path before using it in restore
- **[k8s,teectl]** Only pick Running pods to port forward on them
- **[licensing]** Only take into account ready nodes in proxy count
- **[middleware]** Fix default value for in-flight request middleware
- **[providers]** Fix potential panic in the provider controller
- **[raft-api]** Prevent panic when calling recover in parallel
- **[raft-api]** Add a retry mechanism when failing to connect to the control socket
- **[teectl]** fix kubeconfig env with multiple file paths
- **[webui]** fix: always have `@{provider_name}` in service slugs
- **[webui]** WebUI: Prevent Icons from being animated on the WebUI
- **[webui]** Only show Server Status on HTTP Service Detail pages

**Documentation:**

- **[distributed-feature,middleware]** Fix in-flight request middleware documentation snippet
- Removed erroneous flag to teectl setup gen in docs/content/getting-started.md
- Remove entrypoints in test service on swarm install guide

**Misc:**

- **[logs]** Add file closing and reopening when receiving SIGUSR1
- **[webui]** WebUI: Add a 404 page handler similar to the Traefik OSS
- **[webui]** Centralize Menu Navigation items

## v2.2.0-rc2 (2020-07-09)

**Bug fixes:**

- **[acme,maesh,teectl]** Improve error message on license enabled features
- **[maesh]** Remove liveness port declaration from mesh proxy Daemonset
- **[authentication,middleware]** Improve stability with the KubernetesCRD provider

**Documentation:**

- **[middleware]** Fix TOML snippets in OIDC documentation
- **[webui]** Clean up dashboard operating guide

**Misc:**

- **[maesh,traefik]** Update Maesh to v1.3.1

## v2.1.4 (2020-06-26)

**Bug fixes:**

- **[logs]** Fix potential panic when enabling access logs middleware

## v2.2.0-rc1 (2020-06-26)

**Enhancements:**

- **[authentication,middleware]** Update JWT middleware to handle JWK sets in files
- **[api,maesh]** Add service mesh availability to license information endpoint
- **[webui]** Remove unnecessary Card titles on Mesh Overview page
- **[webui]** Add ability to navigate to each section from the ingress overview page
- **[webui]** Add ability to navigate to each section from the main overview page

**Bug fixes:**

- **[licensing,webui]** Correctly count ingresses for license information
- **[webui,maesh]** Update Mesh Services page to show Additional Features on the table

**Documentation:**

- Introduce the Configuration Discovery Section in Documentation

## v2.2.0-beta2 (2020-06-18)

**Enhancements:**

- **[api,maesh]** Expose platform information on the API
- **[webui]** Handle mesh availability based on cluster information
- **[webui]** Improve logic for Errors Table on Main Overview page and sort them
- **[webui]** Add a page displaying mesh interconnections using a flow diagram.

**Bug fixes:**

- **[api,maesh]** Make Mesh service API consistent
- **[api]** Sort ingress errors API to make it consistent
- **[webui]** Display charts correctly when there are no service on Overview pages
- **[webui]** Fix unclickable search inputs

**Documentation:**

- Clean up the Glossary page for TraefikEE 2.2 w/Maesh integration
- Add service mesh language to Concepts page
- Fix middleware configuration snippet format

## v2.1.3 (2020-06-26)

**Bug fixes:**

- **[logs]** Close and reopen log files on SIGUSR1

## v2.1.2 (2020-06-08)

**Bug fixes:**

- **[traefik]** Avoid chaining the middlewares multiple times

**Documentation:**

- **[authentication,middlewares]** Add all authentication middlewares of 2.1 to the compare table

## v2.2.0-beta1 (2020-06-05)

**Enhancements:**

- **[maesh]** Maesh Integration
- **[authentication,middlewares]** OpenID Connect Middleware
- **[authentication,middlewares]** Handle Dynamic JWKS URLs in the JWT Middleware
- **[cli,maesh]** Allow using Mesh without ingress proxy
- **[maesh,webui]** Add Maesh Section to Dashboard
- **[webui]** Update Ingress Overview page
- **[webui]** Move TraefikEE current content into ingress section
- **[api]** Add cluster errors endpoint

**Documentation:**

- **[authentication,middlewares]** Document OpenID Connect Middleware
- **[maesh]** Document Maesh Integration
- **[webui]** Modify dashboard images

## v2.1.1 (2020-05-19)

**Bug fixes:**

- **[traefik]** Add back the services health check

**Documentation:**

- **[authentication]** Add note to make the query param explicit in JWT middleware
- Fix checksum links in documentation
- Fix download path for teectl in getting-started page

## v1.3.2 (2020-05-04)

**Bug fixes:**

- **[webui]** Security fix (QID-11827) for the Dashboard route

**Documentation:**

- **[k8s]** Fix dashboard operating guide documentation

## v2.1.0 (2020-04-14)

**Enhancements:**

- **[authentication,middlewares]** Add JWT authentication middleware
- **[authentication,middlewares]** Implement the HMAC middleware
- **[authentication,middlewares]** Add oAuth Token Introspection middleware
- **[cli,raft-api]** Add traefikee recover command
- **[k8s,teectl]** Use random port for kubernetes port forward
- **[metrics]** Add additional middleware tracing
- **[teectl,ux]** Add cluster management commands
- **[teectl]** Cluster regain access
- **[teectl]** Add `teectl create credentials` command
- **[traefik]** Move to Traefik v2.2.0
- **[webui]** WebUI: Add UDP pages to the Dashboard

**Bug fixes:**

- **[webui]** Fix service links
- **[middlewares]** Stop leaking errors in middleware
- **[teectl]** Fix cluster context for `teectl get ac` command
- **[teectl]** Dont override config on import
- **[teectl]** Resolve cluster correctly when getting creds
- **[authentication,middlewares]** Fix `forwardHeaders` property with booleans
- **[cli,ux]** Do not show empty defaults in CLI help
- **[logs]** Fixed badly worded license log message
- **[teectl]** Skip directories in GetClusters.
- **[webui]** Fix SubNav bar not showing detail
- **[webui]** WebUI: Fix Proxies not showing on Dashboard
- **[webui]** WebUI: display plugin name instead of just &#39;plugin&#39; on Detail pages
- **[webui]** WebUI: Fix Empty TLS options wording

**Documentation:**

- Fix JWT documentation
- Add time sensitivity to HMAC doc
- Improve rootless documentation regarding volumes
- **[teectl,ux]** Cluster management docs
- **[teectl]** Fix credentials documentation
- Add note about using correct cluster name
- Move middleware in docs
- Doc: update a:hover style to avoid blurry links on FF
- fix: avoid link/menu width increase on hover

## v2.1.0-rc6 (2020-04-08)

**Bug fixes:**

- **[webui]** Fix service links

## v2.1.0-rc5 (2020-04-07)

**Bug fixes:**

- **[middlewares]** Stop leaking errors in middleware
- **[teectl]** Fix cluster context for `teectl get ac` command
- **[teectl]** Dont override config on import
- **[teectl]** Resolve cluster correctly when getting creds

**Documentation:**

- Fix JWT documentation
- Add time sensitivity to HMAC doc
- Improve rootless documentation regarding volumes

## v2.1.0-rc4 (2020-04-03)

**Enhancements:**

- **[authentication,middlewares]** Add JWT authentication middleware
- **[authentication,middlewares]** Implement the HMAC middleware
- **[authentication,middlewares]** Add oAuth Token Introspection middleware
- **[cli,raft-api]** Add traefikee recover command
- **[k8s,teectl]** Use random port for kubernetes port forward
- **[metrics]** Add additional middleware tracing
- **[teectl,ux]** Add cluster management commands
- **[teectl]** Cluster regain access
- **[teectl]** Add `teectl create credentials` command
- **[traefik]** Move to Traefik v2.2.0
- **[webui]** WebUI: Add UDP pages to the Dashboard

**Bug fixes:**

- **[authentication,middlewares]** Fix `forwardHeaders` property with booleans
- **[cli,ux]** Do not show empty defaults in CLI help
- **[logs]** Fixed badly worded license log message
- **[teectl]** Skip directories in GetClusters.
- **[webui]** Fix SubNav bar not showing detail
- **[webui]** WebUI: Fix Proxies not showing on Dashboard
- **[webui]** WebUI: display plugin name instead of just &#39;plugin&#39; on Detail pages
- **[webui]** WebUI: Fix Empty TLS options wording

**Documentation:**

- **[teectl,ux]** Cluster management docs
- **[teectl]** Fix credentials documentation
- Add note about using correct cluster name
- Move middleware in docs
- Doc: update a:hover style to avoid blurry links on FF
- fix: avoid link/menu width increase on hover

## v2.0.4 (2020-03-30)

**Bug fixes:**

- **[api]** Override api version endpoint
- **[traefik]** Move traefikee to traefik v2.1.9
- **[webui]** WebUI: display plugin name instead of just &#39;plugin&#39; on Detail pages

**Documentation:**

- Add doc section about integrating with external load balancers

## v1.3.1 (2020-03-30)

**Bug fixes:**

- **[acme]** Return no error when waited service doesn't exist.

## v2.0.3 (2020-03-17)

**Bug fixes:**

- **[cli]** Detect entrypoint address conflict before apply
- **[teectl]** Fix teectl file path on Windows

**Documentation:**

- **[authentication]** Document LDAP options
- Add a guide to install TraefikEE behind a proxy

## v2.0.2 (2020-02-17)

**Enhancements:**

- **[webui]** WebUI: add links to service and middlewares from HTTP/TCP Router detail pages

**Bug fixes:**

- **[raft-api]** Fix config deletion
- **[teectl,ux]** Fix connect error to be more clear
- **[webui]** WebUI: extend background color when the screen is too big
- **[webui]** WebUI: Fix middleware property access

## v2.0.1 (2020-02-09)

**Enhancements:**

- **[api]** Api-proxy graceful shutdown
- **[webui]** Improve user experience by adding some smooth animations

**Bug fixes:**

- **[raft-api]** Increase dynamic configuration limits
- **[traefik]** Update traefik dependency to v2.1.4

## v2.0.0 (2020-02-03)

**Enhancements:**

- **[acme]** ACME Integration
- **[api,webui]** Enable TraefikEE Dashboard
- **[authentication]** Integrate LDAP authentication
- **[backup]** Restore backup implementation
- **[distributed-feature,middlewares]** Migrate ratelimit
- **[distributed-feature,middlewares]** Migrate inflightreq
- **[dockeree]** DockerEE integration
- **[k8s]** Be compliant with Openshift
- **[middlewares]** Force case middleware
- **[swarm]** Bring back autodiscovery
- **[teectl]** Separate traefikee and teectl commands
- **[teectl]** Implement  teectl get static-config
- **[webui]** Overview page

**Bug fixes:**

- **[metrics]** Apply datadog env variables

**Documentation:**

- Add ACME documentation
- Swarm and DockerEE installation guide
- Prometheus documentation
- Document concepts
- Add migrating to TraefikEE v2 documentation
- Add Uninstall documentation page
- Modify Swarm Network Autodiscory
- Add TLS documentation
- Add Operating/In Flight Request limit guide
- Update version upgrade documentation
- Added Dynamic Configuration docs
- Add LDAP authentication documentation
- Modify the Static Configuration docs
- Install guide for kubernetes
- Add operations/dashboard section
- Update on-premise install guide
- Add Disaster Recovery guide
- Add Operating/Rate Limit guide

## v2.0.0-rc3 (2020-02-03)

**Enhancements:**

- **[webui]** WebUI: Improve data visualization for tables in small screens
- Add limits to docker deployment

**Bug fixes:**

- **[acme,backup]** Fix restore when cert resolver name contain numbers
- **[acme,backup]** Fix backup of ACME certificates
- **[acme]** Fix premium acme account
- **[distributed-feature]** Fix panic when closing a TraefikEE node which failed to launch dist srv
- **[k8s,metrics]** Remove prometheus annotations
- **[teectl]** Fix rbac rules to allow a full support dump on k8s

**Documentation:**

- Add ACME documentation
- Swarm and DockerEE installation guide
- Prometheus documentation
- Document concepts
- Add migrating to TraefikEE v2 documentation
- Add Uninstall documentation page
- Modify Swarm Network Autodiscory
- Add TLS documentation

## v2.0.0-rc2 (2020-01-27)

**Enhancements:**

- **[swarm]** Better network names on swarm
- **[teectl,ux]** Add setup gen message
- **[teectl]** Allow teectl to work in a container
- **[webui]** WebUI: Add tooltips in some cells of the dashboard tables

**Bug fixes:**

- **[distributed-feature]** Fix log spam distributed feats
- **[k8s]** More realistic limit for proxy nodes
- **[raft-api]** Fix Provider Controller stop
- **[raft-api]** Augment limits
- **[raft-api]** Cleanup API socket and control socket before starting

**Documentation:**

- Add Operating/In Flight Request limit guide
- Update version upgrade documentation
- Added Dynamic Configuration docs
- Add LDAP authentication documentation
- Modify the Static Configuration docs
- Install guide for kubernetes
- Add operations/dashboard section
- Rework Operating section
- Update on-premise install guide
- Add Disaster Recovery guide
- Update Glossary section in the documentation
- Add Operating/Rate Limit guide

## v2.0.0-rc1 (2020-01-17)

**Enhancements:**

- **[acme]** ACME Integration
- **[api,webui]** Enable TraefikEE Dashboard
- **[authentication]** Integrate LDAP authentication
- **[backup]** Restore backup implementation
- **[cli]** Bring back support commands
- **[distributed-feature,middlewares]** Migrate ratelimit
- **[distributed-feature,middlewares]** Migrate inflightreq
- **[dockeree]** DockerEE integration
- **[k8s]** Be compliant with Openshift
- **[middlewares]** Force case middleware
- **[swarm]** Bring back autodiscovery
- **[teectl]** Separate traefikee and teectl commands
- **[teectl]** Implement  teectl get static-config
- **[ux]** Rename socketpath

**Bug fixes:**

- **[metrics]** Apply datadog env variables

## v1.3.0 (2019-12-24)

**Enhancements:**

- **[licensing,ux]** Add validate command
- **[traefik]** Enable the file provider

**Bug fixes:**

- **[tracing]** Fix tracing with datadog

## v1.3.0-rc1 (2019-12-23)

**Enhancements:**

- **[licensing,ux]** Add validate command
- **[traefik]** Enable the file provider

**Bug fixes:**

- **[tracing]** Fix tracing with datadog

## v1.2.1 (2019-11-05)

**Enhancements:**

- **[k8s,traefikeectl]** AKS support
- **[logs]** Hide spam from ip resolver from metrics
- **[metrics]** Add dogstatd support

## v1.2.1-rc1 (2019-11-04)

**Enhancements:**

- **[k8s,traefikeectl]** AKS support
- **[logs]** Hide spam from ip resolver from metrics
- **[metrics]** Add dogstatd support

## v1.1.15 (2019-10-31)

**Bug fixes:**

- **[acme,cli]** Fix backup without acme account
- **[ctlapi]** Fix support list-services cmd
- **[metrics]** Fix panic on metrics controller

## v1.1.14 (2019-10-29)

**Bug fixes:**

- **[acme]** Fix backup with internal ACME account
- **[backup,ctlapi]** Fixed an issue preventing from restoring very large backups
- **[ctlapi]** Removes the socket file if it already exists during bootstrap
- **[raft-api]** Allows running multiple providers with conflicting name prefixes

## v1.2.0 (2019-10-02)

**Enhancements:**

- **[acme,ctlapi,traefikeectl]** Add acme-list-certificates commands
- **[acme]** Add an ID to certificates when listing them
- **[acme]** Add ACME account from backup file
- **[cli,traefikeectl]** Add support (diagnose) dump command to traefikee / traefikeectl
- **[distributed-feature]** Refactor distributed features
- **[distributed-feature]** Distributed Connection Limiting
- **[distributed-feature]** Improve connection limit feature
- **[dockeree,traefikeectl]** Make traefikeectl work in DockerEE environments
- **[helm]** OpenShift compatibility
- **[logs,traefikeectl]** Add traefikeectl log format option &#34;--logformat&#34;
- **[tls]** Added default cert for deployment
- **[traefikeectl]** Prevent accidental traefikeectl connect

**Bug fixes:**

- **[acme]** Fix panic when truncating SANs in acme-list-certificates

**Documentation:**

- **[swarm]** Add docs to set the Dashboard to another entrypoint on swarm

## v1.2.0-rc2 (2019-10-01)

**Enhancements:**

- **[traefikeectl]** Add --skipdeploy option on traefikeectl install
- Search multiple socket paths

## v1.1.13 (2019-09-30)

**Bug fixes:**

- **[acme]** Fix potential bug with TLS
- **[traefik]** Update traefik dependency to v1.7.18

## v1.1.12 (2019-09-24)

**Bug fixes:**

- **[traefik]** Update traefik dependency to v1.7.17

## v1.2.0-rc1 (2019-09-20)

**Enhancements:**

- **[acme,ctlapi,traefikeectl]** Add acme-list-certificates commands
- **[acme]** Make it possible to add ACME accounts from backup file
- **[cli,traefikeectl]** Add support (diagnose) dump command to traefikee / traefikeectl
- **[distributed-feature]** Distributed Connection Limiting
- **[dockeree,traefikeectl]** Make traefikeectl work in DockerEE environments
- **[helm]** OpenShift compatibility
- **[logs,traefikeectl]** Add traefikeectl log format option `--logformat`
- **[tls]** Add a single default certificate for the entire deployment
- **[traefikeectl]** Prevent accidental traefikeectl connect

**Bug fixes:**

- **[acme]** Fix panic when truncating SANs in acme-list-certificates

**Documentation:**

- **[swarm]** Add docs to set the Dashboard to another entrypoint on swarm

## v1.1.11 (2019-09-19)

**Bug fixes:**

- **[backup]** Allow restoring TLS Entrypoint

**Documentation:**

- Fix release note

## v1.1.10 (2019-09-17)

**Bug fixes:**

- **[acme,tls]** Update traefik server to v1.7.15
- **[acme,tls]** Added check on ACME account private key
- **[acme,tls]** Stop ACME from generating existing certificates
- **[acme]** Wait for service update when removing a challenge
- **[api,licensing]** Fix nil pointer dereference in internal cluster API
- **[api,raft-api]** Set grpc.MaxCallRecvMsgSize on grpc list calls and backup system
- **[cli]** traefikeectl - fix default values when using a config file

**Documentation:**

- Fix Getting started and modify the raft api references in release and changelog files
- Update tooling for documentation for faster and improved docs checking
- Docs/exclude includes dir

## v1.1.9 (2019-08-29)

**Bug fixes:**

- **[raft-api]** Keep config name under 64 characters
- **[tls]** Load default certificate content when loading TLS content

**Documentation:**

- Docs cleanup

## v1.1.8 (2019-08-20)

**Bug fixes:**

- **[distributed-feature,logs,ux]** Less verbose logs on rate limit middleware
- **[infrastructure]** Move to Go 1.12 (Fix HTTP/2 CVEs)

## v1.1.7 (2019-08-13)

**Bug fixes:**

- **[logs]** Allow customizing log formatter in TraefikEE
- **[traefik]** Make hijackConnectionTracker.Close thread safe

**Misc:**

- **[ux]** Remove unnecessary message on key
- **[traefik]** Update Traefik to 1.7.13

## v1.1.6 (2019-07-30)

**Bug fixes:**

- **[raft-api]** Fix/grpc message size + few panics
- **[traefik]** Dont leak certificates on debug

## v1.1.5 (2019-07-26)

**Bug fixes:**

- **[k8s]** Fix installation files

## v1.1.4 (2019-07-26)

**Bug fixes:**

- **[raft-api]** Add Down Data Nodes grace period

**Documentation:**

- Various documentation improvements

## v1.1.3 (2019-07-17)

**Bug fixes:**

- Fix force case header middleware

## v1.1.2 (2019-07-16)

**Enhancements:**

- **[logs]** Add a log displaying license info upon validation
- Add header casing middleware

**Bug fixes:**

- **[distributed-feature]** Do not use proxy for ratelimit connections

## v1.1.1 (2019-07-08)

**Bug fixes:**

- **[k8s,traefikeectl]** Hotfix k8s install with clustername specified

## v1.0.7 (2019-07-05)

**Bug fixes:**

- **[k8s]** Fix proxy support

**Documentation:**

- Fix typo in traefikeectl install help

## v1.1.0 (2019-06-25)

**Enhancements:**

- **[acme]** Add ACME account manager
- **[acme]** Add ACME certificate manager
- **[distributed-feature,traefik]** Add distributed rate limiting
- **[distributed-feature]** Add ping and healthcheck command
- **[helm,k8s]** Add k8s `/ping` readinessProbe
- **[licensing]** Change license server port to `443`
- **[swarm]** Add network autodiscovery
- **[swarm]** Make TraefikEE able to use UCP bundles to work on DockerEE worker nodes only

**Bug fixes:**

- **[backup]** Tar archives now have a modification time set properly
- **[tls,traefik]** Remove base64 encoding and fix mTLS support

**Misc:**

- **[licensing,traefikeectl]** Improve error message on license validation problem

## v1.0.6 (2019-06-19)

**Bug fixes:**

- **[licensing]** Add a validation timeout

**Documentation:**

- Fix yaml in documentation

## v1.0.5 (2019-06-06)

**Bug fixes:**

- **[traefik]** Revert &#34;Upgrade traefik to version v1.7.12&#34;

## v1.0.4 (2019-06-06)

**Bug fixes:**

- **[cli]** Decode TLS certificates provided by traefikeectl
- **[ctlapi]** generate credentials valid one hour before the system time
- **[traefik]** Upgrade traefik to version v1.7.12

## v1.0.3 (2019-06-03)

**Bug fixes:**

- **[acme]** ACME Challenge: Wait for server service update before notifying LE.

**Documentation:**

- Hotfix swarm control node documentation

## v1.0.2 (2019-05-15)

**Enhancements:**

- **[helm,traefikeectl]** Add the --version on helm install if the chart is containous/traefikee
- **[traefikeectl]** Add support command

**Documentation:**

- Fix documentation nit, correct option is --traefikeesocket

## v1.0.1 (2019-05-06)

**Bug fixes:**

- **[swarm]** support docker systemd cgroup driver in cgroups file extraction

**Documentation:**

- Modify on-premise installation documentation
- Fix dockeree solution guide

## v1.0.0 (2019-04-17)

**Enhancements:**

- **[licensing]** Stats deployed configuration
- **[licensing]** Update the license system
- **[ux]** Fix misleading error in traefikeectl

**Bug fixes:**

- **[acme]** Fix ACME certificate restoration
- **[acme]** Acme challenge timeout too short
- **[helm,traefikeectl]** Always use kube config path for helm commands
- **[k8s]** Do not provision persistent volumes in multi control node mode
- **[swarm,traefikeectl]** Fix output when not enough workers in target swarm cluster

**Documentation:**

- **[k8s,swarm]** Document upgrade operation
- Add troubleshooting guide for lost quorum
- Adds a &#34;Docker-EE&#34; solution guide

## v1.0.0-rc1 (2019-04-11)

**Enhancements:**

- **[k8s,traefikeectl,ux]** Hide helm commands that are used for checking purposes
- **[licensing]** Update the license system
- **[ux]** Fix misleading error in traefikeectl

**Bug fixes:**

- **[acme]** Acme challenge timeout too short
- **[helm,traefikeectl]** Always use kube config path for helm commands
- **[k8s]** Do not provision persistent volumes in multi controller mode

**Documentation:**

- **[k8s]** Improve yaml installation guides
- **[k8s,swarm]** Document upgrade operation
- **[swarm,traefikeectl]** Be able to lauch multiple TraefikEE clusters on a swarm cluster.
- Adds a &#34;Docker-EE&#34; solution guide (new section) in the documentation
