# Release Notes

What are the changes for each release?

## v1.1.15 (2019-10-31)

**Bug fixes:**

- **[acme,cli]** Fix backup without acme account
- **[ctlapi]** Fix support list-services cmd
- **[metrics]** Fix panic on metrics controller

## v1.1.14 (2019-10-29)

**Bug fixes:**

- **[acme]** Fix backup with internal ACME account
- **[backup,ctlapi]** Fixed an issue preventing from restoring very large backups
- **[ctlapi]** Removes the socket file if it already exists during bootstrap
- **[raft-api]** Allows running multiple providers with conflicting name prefixes

## v1.1.13 (2019-09-30)

**Bug fixes:**

- **[acme]** Fix potential bug with TLS
- Update traefik dependency to v1.7.18

## v1.1.12 (2019-09-24)

**Bug fixes:**

- **[traefik]** Update traefik dependency to v1.7.17

## v1.1.11 (2019-09-19)

**Bug fixes:**

- **[backup]** Allow restoring TLS Entrypoint

**Documentation:**

- Fix release note

## v1.1.10 (2019-09-17)

**Bug fixes:**

- **[acme,tls]** Update traefik server to v1.7.15
- **[acme,tls]** Added check on ACME account private key
- **[acme,tls]** Stop ACME from generating existing certificates
- **[acme]** Wait for service update when removing a challenge
- **[api,licensing]** Fix nil pointer dereference in internal cluster API
- **[api,raft-api]** Set grpc.MaxCallRecvMsgSize on grpc list calls and backup system
- **[cli]** traefikeectl - fix default values when using a config file

**Documentation:**

- Fix Getting started and modify the raft api references in release and changelog files
- Update tooling for documentation for faster and improved docs checking
- Docs/exclude includes dir

## v1.1.9 (2019-08-29)

**Bug fixes:**

- **[raft-api]** Keep config name under 64 characters
- **[tls]** Load default certificate content when loading TLS content

**Documentation:**

- Docs cleanup

## v1.1.8 (2019-08-20)

**Bug fixes:**

- **[distributed-feature,logs,ux]** Less verbose logs on rate limit middleware
- **[infrastructure]** Move to Go 1.12 (Fix HTTP/2 CVEs)

## v1.1.7 (2019-08-13)

**Bug fixes:**

- **[logs]** Allow customizing log formatter in TraefikEE
- **[traefik]** Make hijackConnectionTracker.Close thread safe

**Misc:**

- **[ux]** Remove unnecessary message on key
- **[traefik]** Update Traefik to 1.7.13

## v1.1.6 (2019-07-30)

**Bug fixes:**

- **[raft-api]** Fix/grpc message size + few panics
- **[traefik]** Dont leak certificates on debug

## v1.1.5 (2019-07-26)

**Bug fixes:**

- **[k8s]** Fix installation files

## v1.1.4 (2019-07-26)

**Bug fixes:**

- **[raft-api]** Add Down Data Nodes grace period

**Documentation:**

- Various documentation improvements

## v1.1.3 (2019-07-17)

**Bug fixes:**

- Fix force case header middleware

## v1.1.2 (2019-07-16)

**Enhancements:**

- **[logs]** Add a log displaying license info upon validation
- Add header casing middleware

**Bug fixes:**

- **[distributed-feature]** Do not use proxy for ratelimit connections

## v1.1.1 (2019-07-08)

**Bug fixes:**

- **[k8s,traefikeectl]** Hotfix k8s install with clustername specified

## v1.0.7 (2019-07-05)

**Bug fixes:**

- **[k8s]** Fix proxy support

**Documentation:**

- Fix typo in traefikeectl install help

## v1.1.0 (2019-06-25)

**Enhancements:**

- **[acme]** Add ACME account manager
- **[acme]** Add ACME certificate manager
- **[distributed-feature,traefik]** Add distributed rate limiting
- **[distributed-feature]** Add ping and healthcheck command
- **[helm,k8s]** Add k8s `/ping` readinessProbe
- **[licensing]** Change license server port to `443`
- **[swarm]** Add network autodiscovery
- **[swarm]** Make TraefikEE able to use UCP bundles to work on DockerEE worker nodes only

**Bug fixes:**

- **[backup]** Tar archives now have a modification time set properly
- **[tls,traefik]** Remove base64 encoding and fix mTLS support

**Misc:**

- **[licensing,traefikeectl]** Improve error message on license validation problem

## v1.0.6 (2019-06-19)

**Bug fixes:**

- **[licensing]** Add a validation timeout

**Documentation:**

- Fix yaml in documentation

## v1.0.5 (2019-06-06)

**Bug fixes:**

- **[traefik]** Revert &#34;Upgrade traefik to version v1.7.12&#34;

## v1.0.4 (2019-06-06)

**Bug fixes:**

- **[cli]** Decode TLS certificates provided by traefikeectl
- **[ctlapi]** generate credentials valid one hour before the system time
- **[traefik]** Upgrade traefik to version v1.7.12

## v1.0.3 (2019-06-03)

**Bug fixes:**

- **[acme]** ACME Challenge: Wait for server service update before notifying LE.

**Documentation:**

- Hotfix swarm control node documentation

## v1.0.2 (2019-05-15)

**Enhancements:**

- **[helm,traefikeectl]** Add the --version on helm install if the chart is containous/traefikee
- **[traefikeectl]** Add support command

**Documentation:**

- Fix documentation nit, correct option is --traefikeesocket

## v1.0.1 (2019-05-06)

**Bug fixes:**

- **[swarm]** support docker systemd cgroup driver in cgroups file extraction

**Documentation:**

- Modify on-premise installation documentation
- Fix dockeree solution guide

## v1.0.0 (2019-04-17)

**Enhancements:**

- **[licensing]** Stats deployed configuration
- **[licensing]** Update the license system
- **[ux]** Fix misleading error in traefikeectl

**Bug fixes:**

- **[acme]** Fix ACME certificate restoration
- **[acme]** Acme challenge timeout too short
- **[helm,traefikeectl]** Always use kube config path for helm commands
- **[k8s]** Do not provision persistent volumes in multi control node mode
- **[swarm,traefikeectl]** Fix output when not enough workers in target swarm cluster

**Documentation:**

- **[k8s,swarm]** Document upgrade operation
- Add troubleshooting guide for lost quorum
- Adds a &#34;Docker-EE&#34; solution guide

## v1.0.0-rc1 (2019-04-11)

**Enhancements:**

- **[k8s,traefikeectl,ux]** Hide helm commands that are used for checking purposes
- **[licensing]** Update the license system
- **[ux]** Fix misleading error in traefikeectl

**Bug fixes:**

- **[acme]** Acme challenge timeout too short
- **[helm,traefikeectl]** Always use kube config path for helm commands
- **[k8s]** Do not provision persistent volumes in multi control node mode

**Documentation:**

- **[k8s]** Improve yaml installation guides
- **[k8s,swarm]** Document upgrade operation
- **[swarm,traefikeectl]** Be able to lauch multiple TraefikEE clusters on a swarm cluster.
- Adds a &#34;Docker-EE&#34; solution guide (new section) in the documentation

## v1.0.0-beta24 (2019-04-04)

**Enhancements:**

- **[helm,raft-api,traefikeectl]** Add single control node feature
- **[swarm,traefikeectl]** Swarm single control node
- **[helm,k8s,traefikeectl]** One Control Node mode for Kubernetes
- **[raft-api,ux]** Add log to display cleanup period
- **[traefikeectl,ux]** Modify options to set the single control node mode available
- **[traefikeectl]** UX Improvements

**Bug fixes:**

- **[cli]** Check whether a cluster with the name exist before installing
- **[traefikeectl]** Fix cluster config serialization when cluster already exists
- **[webui]** Fix web ui issues

**Documentation:**

- **[traefikeectl]** Single control node as default mode.

## v1.0.0-beta23 (2019-03-20)

**Enhancements:**

- **[backup,ctlapi,traefikeectl]** Restore feature
- **[backup]** Implement backup
- **[ctlapi]** Add mTLS to client
- **[ctlapi]** Add mTLS to server
- **[helm]** Add annotation on data node to allow prometheus to collect metrics
- **[logs,traefikeectl]** Don&#39;t tell users to specify a flag if already present
- **[raft-api]** Allow customizing the cluster cleanup period
- **[traefikeectl]** Make traefikeectl on-premise possible
- **[traefikeectl]** Configurable unix socket

**Bug fixes:**

- **[backup]** Dont create zip backups as .tar.zip
- **[backup]** Fix backup hanging up forever on invalid archive type
- **[cli,k8s,traefikeectl]** Require default StorageClass for k8s
- **[ctlapi,traefikeectl,ux]** Return n/a for raft reachability of data node
- **[ctlapi]** Expose traefikeectl api through a unix socket.
- **[helm,traefikeectl]** Output errors on stderr, hide helm spam
- **[k8s,traefikeectl]** Check for the beta annotation of the default storage class.
- **[metrics,swarm]** Get metrics in Swarm
- **[webui]** Fix webui 404 on  refresh.
- **[webui]** Make API list nodes uses action package.

**Documentation:**

- **[backup]** Adds troubleshooting guides (new section) in the documentation for Backup/Restore
- **[helm]** Remove helm install, and add values customization
- **[k8s]** Add documentation note about automatic secret generation
- Document  installation behind an HTTP(S) proxy
- Adds a new &#34;Resources&#34; documentation page to list webinars and blog posts
- Add support link to documentation menu
- Document auth secret creation methods and format

## v1.0.0-beta22 (2019-02-26)

**Enhancements:**

- **[api,traefikeectl]** Deploy over API: Implement client.
- **[backup,raft-api]** Store deployed configuration in the cluster
- **[backup]** Traefikee backup command
- **[ctlapi,traefikeectl]** List nodes over API
- **[ctlapi,traefikeectl]** Implement automatic API discovery for the traefikeectl API address
- **[k8s,traefikeectl]** Add port forwarding for Kubernetes
- **[raft-api]** Modify the time to live for a dirty node
- **[traefik]** Upgrade traefik to version v1.7.9
- **[traefikeectl,webui]** Add Post-Install note about dashboard password recovery

**Bug fixes:**

- **[helm,k8s,traefikeectl]** Use helm list to ensure that a release is installed
- **[k8s,swarm,traefikeectl]** Fix deploy with default value
- **[swarm]** Fix install --force on Swarm and Improve swarm client

## v1.0.0-beta21 (2019-02-14)

**Enhancements:**

- **[k8s,swarm,traefikeectl]** Implement Traefikeectl Connect
- **[k8s,swarm,traefikeectl]** Rework CTL flags and serialization for API

**Bug fixes:**

- **[helm,k8s,traefikeectl]** Create readinessprobe, and update verify loop
- **[helm,traefikeectl,webui]** Fix dashboard redirect on root path
- **[raft-api]** Replace --controlnode option by --peeraddresses to allow multiple peer addresses during node start

**Documentation:**

- **[k8s,swarm]** Update routing page + Improve swarm installation

## v1.0.0-beta20 (2019-02-06)

**Enhancements:**

- **[helm]** Allow user to use deployment instead of statefulset

**Documentation:**

- Add on-premise installation guide

## v1.0.0-beta19 (2019-01-30)

**Bug fixes:**

- **[traefikeectl]** Fix traefikeectl GCP connection

## v1.0.0-beta18 (2019-01-23)

**Enhancements:**

- **[k8s,swarm,traefikeectl]** Make install not overwrite cluster unless --force
- **[k8s,swarm,traefikeectl]** Remove IgnoreTraefikeeHome option
- **[k8s,swarm,traefikeectl]** Add log level for k8s and swarm providers

**Bug fixes:**

- **[acme]** Allow multi deploy with ACME configuration
- **[acme]** Fix ALPN and HTTP ACME challenges
- **[helm,k8s,traefikeectl]** Fix installation in k8s failing because of clusterrolebinding "tiller" already existing
- **[logs,traefikeectl]** Make LogLevel override Debug option regarding cluster'&#39;'s log level in ctl

**Documentation:**

- **[swarm]** Advanced install guide for swarm

## v1.0.0-beta17 (2019-01-22)

**Bug fixes:**

- **[helm,traefikeectl]** Error when helm not installed on local computer

## v1.0.0-beta16 (2019-01-21)

**Enhancements:**

- **[acme]** Upgrade traefik version to 1.7.7
- **[logs]** add a log to print version when starting nodes
- Add timeouts to http clients

**Bug fixes:**

- **[helm,traefikeectl]** Fix installation on Kubernetes with traefikeectl, when no Helm is installed
- **[swarm,traefikeectl]** Fix for dockeree
- **[swarm,traefikeectl]** Make swarm.RemoveNetwork wait until network is deleted

## v1.0.0-beta15 (2019-01-15)

**Bug fixes:**

- **[licensing]** Fix http proxy

**Documentation:**

- **[infrastructure]** Only prints errors when verifying links and html for the documentation

## v1.0.0-beta14 (2019-01-14)

**Enhancements:**

- **[metrics]** Requalify the metrics message in DEBUG
- **[swarm,traefikeectl]** Implement deploy command for swarm

**Bug fixes:**

- **[swarm,traefikeectl]** Fix swarm uninstall

**Documentation:**

- Happy 2019

## v1.0.0-beta13 (2019-01-08)

**Enhancements:**

- **[helm,traefikeectl]** Do not download chart if not needed, and use helm home

**Bug fixes:**

- **[k8s,traefikeectl]** Fix Helm version check

## v1.0.0-beta12 (2019-01-07)

**Enhancements:**

- **[cli,k8s,swarm,traefikeectl]** Traefikeectl refactor
- **[helm]** Enable HTTPS in Helm Chart by default
- **[k8s,traefikeectl]** Add `traefikeectl deploy --file` feature
- **[swarm,traefikeectl]** Implement swarm list nodes
- **[swarm,traefikeectl]** Add filtering to swarm logs
- **[swarm,traefikeectl]** Add option to control timeout value for swarm
- **[swarm,traefikeectl]** Add serialization for Swarm &amp; change the way we name serialized configs
- **[swarm,traefikeectl]** Add logs command
- **[tls,traefikeectl]** Set TLS certificates to traefikeectl

**Bug fixes:**

- **[swarm,traefikeectl]** Make swarm install fail if we have less that one data node.
- **[swarm,traefikeectl]** Download and cache assets per version + minor fixes on downloader
- **[traefikeectl]** Rename download-folder option to downloadfolder for consistency
- **[traefikeectl]** Replace default HTTP client in the downloader
- **[traefikeectl]** Fix dashboard option names
- **[traefikeectl]** Log in deserialization only if provider config was found

## v1.0.0-beta11 (2018-12-19)

**Enhancements:**

- **[helm,traefikeectl]** Do not download helm if already present
- **[swarm,traefikeectl]** Allow `traefikeectl` to use local docker-compose files for Docker Swarm installations
- **[swarm,traefikeectl]** Fix installation to Docker Swarm with replicated mode for control nodes
- **[traefikeectl]** Add a `version` command to `traefikeectl`

**Bug fixes:**

- **[helm,traefikeectl]** Fix dashboard credentials not working when installing in Kubernetes
- **[k8s,traefikeectl]** Use the flag `--clustername` when running commands with `traefikeectl`
- **[k8s,traefikeectl]** Wait for namespace to be deleted before installing when `--kubernetes.deletenamespace` flag is used
- **[swarm,traefikeectl]**Fix Docker Swarm installation failing because of a wrong s3 URL for assets
- Upgrade Traefik version to v1.7.6

## v1.0.0-beta10 (2018-12-11)

**Features:**

- Initial Public Release during the Kubecon US 2018
- Support for Kubernetes
- Support for Docker Swarm Mode
