/**
 * Theme Customizer enhancements for a better user experience.
 *
 * Contains handlers to make Theme Customizer preview reload changes asynchronously.
 */

( function( $ ) {

	
	// Site title and description.
	wp.customize( 'blogname', function( value ) {
		value.bind( function( to ) {
			$( '.site-title a' ).text( to );
		} );
	} );
	wp.customize( 'blogdescription', function( value ) {
		value.bind( function( to ) {
			$( '.site-description' ).text( to );
		} );
	} );
	// Header text color.
	wp.customize( 'header_textcolor', function( value ) {
		value.bind( function( to ) {
			if ( 'blank' === to ) {
				$( '.site-branding' ).addClass( 'hide-header-text' );
			} else {
				$( '.site-branding' ).removeClass( 'hide-header-text' );
			}
		} );
	} );

	/* NEW FROM @mit*/


	wp.customize( 'sub_menu_color', function( value ) {
		value.bind( function( newval ) {
			//alert(newval);
			$('.top-navigation ul ul li > a').css( 'color', newval );
		} );
	} );

	wp.customize( 'sub_menu_color', function( value ) {
		value.bind( function( newval ) {
			//alert(newval);
			$('#header-right-menu ul ul li > a').css( 'color', newval );
		} );
	} );	
	// HEADER
	wp.customize( 'header_menu_text_fonts', function( value ) {
		value.bind( function( newval ) {
			if(newval != 'none' || newval != 'none'){
				$("head").append("<link href='//fonts.googleapis.com/css?family=" + newval + "' rel='stylesheet' type='text/css'>");
				$('.top-navigation ul li > a').css( 'font-family', newval );
				$('#header-right-menu ul li > a').css( 'font-family', newval );
			}
		} );
	} );

	

	wp.customize( 'header_separator_symbol', function( value ) {
		value.bind( function( newval ) {
			$('.top-navigation').removeClass( 'sp-colon' );
			$('.top-navigation').removeClass( 'sp-pipeline' );
			$('.top-navigation').removeClass( 'sp-none' );
			$('.top-navigation').addClass( newval );

			$('#header-right-menu').removeClass( 'sp-colon' );
			$('#header-right-menu').removeClass( 'sp-pipeline' );
			$('#header-right-menu').removeClass( 'sp-none' );
			$('#header-right-menu').addClass( newval );
		} );
	} );

	wp.customize( 'header_menu_text_fonts_styles', function( value ) {
		value.bind( function( newval ) {
			$('.top-navigation ul li > a').css( 'font-style', newval );
			$('#header-right-menu ul li > a').css( 'font-style', newval );
		} );
	} );

	wp.customize( 'header_menu_text_fonts_weights', function( value ) {
		value.bind( function( newval ) {
			$('.top-navigation ul li > a').css( 'font-weight', newval );
			$('#header-right-menu ul li > a').css( 'font-weight', newval );
		} );
	} );

	wp.customize( 'header_menu_text_size_custom', function( value ) {
		value.bind( function( newval ) {
			$('.top-navigation ul li > a').css( 'font-size', newval+"px" );
			$('#header-right-menu ul li > a').css( 'font-size', newval+"px" );
		} );
	} );
	wp.customize( 'header_menu_text_spacing', function( value ) {
		value.bind( function( newval ) {
			$('.top-navigation ul li > a').css( 'letter-spacing', newval+"px" );
			$('#header-right-menu ul li > a').css( 'letter-spacing', newval+"px" );
		} );
	} );

	wp.customize( 'header_menu_spacing', function( value ) {
		value.bind( function( newval ) {
			$('.top-navigation ul li > a').css( 'padding-right', newval+"px" );
			$('#header-right-menu ul li > a').css( 'padding-right', newval+"px" );
		} );
	} );



	// FOOTER
	wp.customize( 'footer_menu_text_fonts', function( value ) {
		value.bind( function( newval ) {
			if(newval != 'none' || newval != '' ){
				$("head").append("<link href='https://fonts.googleapis.com/css?family=" + newval + "' rel='stylesheet' type='text/css'>");
			}
			$('#footer-right-menu ul li > a').css( 'font-family', newval );
			$('#footer-horizontal-menu ul li > a').css( 'font-family', newval );
			//$('#footer-button-container-inner').css( 'font-family', newval );
		} );
	} );

	

	wp.customize( 'footer_menu_text_fonts_styles', function( value ) {
		value.bind( function( newval ) {
			$('#footer-right-menu ul li > a').css( 'font-style', newval );
			$('#footer-horizontal-menu ul li > a').css( 'font-style', newval );
		} );
	} );

	

	wp.customize( 'footer_menu_text_fonts_weights', function( value ) {
		value.bind( function( newval ) {
			$('#footer-right-menu ul li > a').css( 'font-weight', newval );
			$('#footer-horizontal-menu ul li > a').css( 'font-weight', newval );
		} );
	} );

	
	wp.customize( 'footer_menu_text_size_custom', function( value ) {
		value.bind( function( newval ) {
			$('#footer-right-menu ul li > a').css( 'font-size', newval+"px" );
			$('#footer-horizontal-menu ul li > a').css( 'font-size', newval+"px" );
		} );
	} );

	wp.customize( 'footer_menu_text_spacing', function( value ) {
		value.bind( function( newval ) {
			$('#footer-right-menu ul li > a').css( 'letter-spacing', newval+"px" );
			$('#footer-horizontal-menu ul li > a').css( 'letter-spacing', newval+"px" );
		} );
	} );

	

	$('#content_TesseractTheme').unbind('load');

	function hexToRgb(hex) {
		var result = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(hex);
		return result ? {
			r: parseInt(result[1], 16),
			g: parseInt(result[2], 16),
			b: parseInt(result[3], 16)
		} : null;
	}

	HTMLElement.prototype.alpha = function(a) {
		current_color = getComputedStyle(this).getPropertyValue("background-color");
		match = /rgba?\((\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*(,\s*\d+[\.\d+]*)*\)/g.exec(current_color)
		a = a > 1 ? (a / 100) : a;
		this.style.backgroundColor = "rgba(" + [match[1],match[2],match[3],a].join(',') +")";
	}

	wp.customize( 'tesseract_header_colors_bck_color', function( value ) {
		value.bind( function( to ) {
			$( '.site-header, .site-header .cart-content-details, .main-navigation ul ul a, #header-right-menu ul ul a' ).css('background-color', to);
		} );
	} );

	wp.customize('tesseract_header_colors_bck_color_opacity', function(value){
		value.bind(function( to ){

			var bg = $('.site-header').css('background-color');
			if (bg.indexOf('a') == -1){
				var result = bg.replace(')', ', ' + to/100 + ')').replace('rgb', 'rgba');
			} else if( bg.indexOf('a') > 0 ) {

				var colorString = bg,
					colorsOnly = colorString.substring(colorString.indexOf('(') + 1, colorString.lastIndexOf(')')).split(/,\s*/),
					red = colorsOnly[0],
					green = colorsOnly[1],
					blue = colorsOnly[2],
					opacity = colorsOnly[3];

				var result = 'rgba(' + colorsOnly[0] + ', ' + colorsOnly[1] + ', ' + colorsOnly[2] + ', ' + to/100 + ')';
			}
			$('.site-header, .site-header .cart-content-details, .main-navigation ul ul a, #header-right-menu ul ul a').css( 'background-color', result);

			if ( ( $('body.home').length > 0 ) && ( to < 100 ) ) {
				$( 'body' ).addClass( 'transparent-header' );
			} else {
				$( 'body' ).removeClass( 'transparent-header' );
			}

		});
	});
	
	
	
	wp.customize('tesseract_footer_colors_bck_color_opacity', function(value){
		value.bind(function( to ){

			var bg = $('.site-footer').css('background-color');
			if (bg.indexOf('a') == -1){
				var result = bg.replace(')', ', ' + to/100 + ')').replace('rgb', 'rgba');
			} else if( bg.indexOf('a') > 0 ) {

				var colorString = bg,
					colorsOnly = colorString.substring(colorString.indexOf('(') + 1, colorString.lastIndexOf(')')).split(/,\s*/),
					red = colorsOnly[0],
					green = colorsOnly[1],
					blue = colorsOnly[2],
					opacity = colorsOnly[3];

				var result = 'rgba(' + colorsOnly[0] + ', ' + colorsOnly[1] + ', ' + colorsOnly[2] + ', ' + to/100 + ')';
			}
			$('.site-footer').css( 'background-color', result);

			if ( ( $('body.home').length > 0 ) && ( to < 100 ) ) {
				$( 'body' ).addClass( 'transparent-footer' );
			} else {
				$( 'body' ).removeClass( 'transparent-footer' );
			}

		});
	});
	
	
	
	
	
	
	wp.customize( 'tesseract_vertical_header_width', function( value ) {
		value.bind( function( to ) {
			$( '.verticalLeftHeader, .verticalRightHeader' ).css('width', to+'px');
			$( '.verticalNavLeftContainer #content_TesseractTheme' ).css('margin-left', to+'px');
			$( '.verticalNavRightContainer #content_TesseractTheme' ).css('margin-right', to+'px');
		} );
	} );
	

	wp.customize( 'tesseract_header_colors_text_color', function( value ) {
		value.bind( function( to ) {

			$( '.site-header, .site-header h1, .site-header h2, .site-header h3, .site-header h4, .site-header h5, .site-header h6, #header-button-container-inner, #header-button-container-inner a' ).css('color', to);

			$( '#masthead_TesseractTheme .search-field' ).focus(function() {
				var color = $(this).hasClass('watermark') ? '#ccc' : to;
				$(this).css('color', color);
			})
			$( '#masthead_TesseractTheme .search-field' ).blur(function() {
				var color = $(this).hasClass('watermark') ? '#ccc' : to;
				$(this).css('color', color);
			})

		} );
	} );

	wp.customize( 'tesseract_header_colors_link_color', function( value ) {
		value.bind( function( to ) {
			$( '.site-header a, .main-navigation ul ul a, #header-right-menu ul ul a' ).not('a.button').css('color', to);
		} );
	} );

	wp.customize( 'tesseract_header_colors_link_hover_color', function( value ) {
		value.bind( function( to ) {
			var origColor = $( '.site-header a' ).css('color');
			$( '.site-header a' ).not('.a.button').hover(
				function() {
					$(this).css('color', to);
				}, function() {
					$(this).css('color', origColor);
				}
			)
		} );
	} );

	wp.customize( 'tesseract_header_content_if_button', function( value ) {
		value.bind( function( to ) {
			$( '#header-button-container' ).html(to);
		} );
	} );

	wp.customize( 'tesseract_footer_colors_bck_color', function( value ) {
		value.bind( function( to ) {
			$( '#colophon_TesseractTheme' ).css('background-color', to);
		} );
	} );

	wp.customize( 'tesseract_footer_colors_text_color', function( value ) {
		value.bind( function( to ) {
			$( '#colophon_TesseractTheme' ).css('color', to);
			$( '#colophon_TesseractTheme .search-field' ).focus(function() {
				var color = $(this).hasClass('watermark') ? '#ccc' : to;
				$(this).css('color', color);
			})
			$( '#colophon_TesseractTheme .search-field' ).blur(function() {
				var color = $(this).hasClass('watermark') ? '#ccc' : to;
				$(this).css('color', color);
			})

		} );
	} );

	wp.customize( 'tesseract_footer_colors_heading_color', function( value ) {
		value.bind( function( to ) {
			$( '#colophon_TesseractTheme h1, #colophon_TesseractTheme h2, #colophon_TesseractTheme h3, #colophon_TesseractTheme h4, #colophon_TesseractTheme h5, #colophon_TesseractTheme h6' ).css('color', to);
		} );
	} );
	

	wp.customize( 'tesseract_footer_colors_link_color', function( value ) {
		value.bind( function( to ) {
			var red = hexToRgb(to).r,
			green = hexToRgb(to).g,
			blue = hexToRgb(to).b,
			rgbArray = red + ', ' + green + ', ' + blue;

			$( '#colophon_TesseractTheme a' ).css('color', to);

			if ( $('#horizontal-menu-before').length > 0 ) {
				$( '#horizontal-menu-before' ).css('border-right', 'rgba(' + rgbArray + ', 0.25) solid 1px');
			}
			if ( $('#horizontal-menu-after').length > 0 ) {
				$( '#horizontal-menu-after' ).css('border-left', 'rgba(' + rgbArray + ', 0.25) solid 1px');
			}
			$('#footer-banner.footbar-active').css('border-top', 'rgba(' + rgbArray + ', 0.15) solid 1px');
		} );
	} );

	wp.customize( 'tesseract_footer_colors_link_hover_color', function( value ) {
		value.bind( function( to ) {
			var origColor = $( '#colophon_TesseractTheme a' ).css('color');
			$( '#colophon_TesseractTheme a' ).hover(
				function() {
					$(this).css('color', to);
				}, function() {
					$(this).css('color', origColor);
				}
			)
		} );
	} );
	
	wp.customize( 'tesseract_blog_titlecolor', function( value ) {
		value.bind( function( to ) {
			$( '#bloglist_title h2.entry-title, #bloglist_title h2.entry-title a, #blogpost_title h1.entry-title' ).css('color', to);
		} );
	} );
	
	wp.customize( 'tesseract_blog_buttoncolor', function( value ) {
		value.bind( function( to ) {
			$( '#bloglist_morebutton' ).css('color', to);
		} );
	} );
	
	wp.customize( 'tesseract_woocommerce_titlecolor', function( value ) {
		value.bind( function( to ) {
			$( '#prodlist_title h3, .summary h1' ).css('color', to);
		} );
	} );
	
	wp.customize( 'tesseract_woocommerce_pricecolor', function( value ) {
		value.bind( function( to ) {
			$( '.sales-price, .regular-pricenew, .woocommerce div.product p.price, .woocommerce div.product span.price' ).css('color', to);
		} );
	} );
	
	wp.customize( 'tesseract_woocommerce_pricecolor', function( value ) {
		value.bind( function( to ) {
			$( '.sales-price, .woocommerce div.product p.price, .woocommerce div.product span.price' ).css('color', to);
		} );
	} );
	
	wp.customize( 'tesseract_woocommerce_price_size', function( value ) {
		value.bind( function( to ) {
			$( '.wooshop-price' ).css('font-size', to+'px');
		} );
	} );
	
	wp.customize( 'tesseract_woocommerce_buttonbgcolor', function( value ) {
		value.bind( function( to ) {
			$( '.wooprod-button a' ).css('background-color', to);
		} );
	} );
	
	wp.customize( 'tesseract_woocommerce_button_radius', function( value ) {
		value.bind( function( to ) {
			$( '.wooprod-button a' ).css('border-radius', to+'px');
		} );
	} );
	
	wp.customize( 'tesseract_blog_buttonbgcolor', function( value ) {
		value.bind( function( to ) {
			$( '.blmore a' ).css('background-color', to);
		} );
	} );
	
	wp.customize( 'tesseract_blog_buttoncolor', function( value ) {
		value.bind( function( to ) {
			$( '#bloglist_morebutton .blmore, #bloglist_morebutton .blmore a, #bloglist_morebutton .blmore a:hover' ).css('color', to);
		} );
	} );
	
	wp.customize( 'tesseract_blog_button_radius', function( value ) {
		value.bind( function( to ) {
			$( '.blmore a' ).css('border-radius', to+'px');
		} );
	} );
	
	wp.customize( 'tesseract_blog_button_txt', function( value ) {
		value.bind( function( to ) {
			$( '.blmore a' ).text( to );
		} );
	} );

	wp.customize( 'tesseract_mobmenu_background_color', function( value ) {
		value.bind( function( to ) {
			$( '.sidr' ).css('background-color', to);
		} );
	} );

	wp.customize( 'tesseract_mobmenu_link_color', function( value ) {
		value.bind( function( to ) {
			$( '.sidr .sidr-class-menu-item a, .sidr .sidr-class-menu-item span' ).css('color', to);
		} );
	} );

	wp.customize( 'tesseract_mobmenu_link_hover_color', function( value ) {
		value.bind( function( to ) {
			$( '.sidr .sidr-class-menu-item a, .sidr .sidr-class-menu-item span' ).each(function() {
				var origColor = $( this ).css('color');
				$( this ).hover(
					function() {
						$(this).css('color', to);
					}, function() {
						$(this).css('color', origColor);
					}
				)
			})
		} );
	} );

	wp.customize( 'tesseract_mobmenu_link_hover_background_color', function( value ) {
		value.bind( function( to ) {
			switch(to) {
				case 'dark':
					$( '.sidr .sidr-class-menu-item a, .sidr .sidr-class-menu li span' ).css( 'background', 'rgba(0, 0, 0, .2)' ); break;
				case 'light':
					$( '.sidr .sidr-class-menu-item a, .sidr .sidr-class-menu li span' ).css( 'background', 'rgba(255, 255, 255, .1)' ); break;
				case 'custom':
					$( '.sidr .sidr-class-menu-item a, .sidr .sidr-class-menu li span' ).css( 'background', tesseract_vars.mobmenu_link_hover_background_color_custom ); break;
			}
		} );
	} );

	wp.customize( 'tesseract_mobmenu_link_hover_background_color_custom', function( value ) {
		value.bind( function( to ) {
			$( '.sidr .sidr-class-menu-item a, .sidr .sidr-class-menu-item span' ).each(function() {
				var origBck = $( this ).css('background');
				$( this ).hover(
					function() {
						$(this).css('background', to);
					}, function() {
						$(this).css('background', origBck);
					}
				)
			})
		} );
	} );

	wp.customize( 'tesseract_mobmenu_shadow_color_custom', function( value ) {
		value.bind( function( to ) {

			var shad_r = hexToRgb(to).r,
			shad_g = hexToRgb(to).g,
			shad_b = hexToRgb(to).b,
			shad_rgbArray = shad_r + ', ' + shad_g + ', ' + shad_b;

			$( '.sidr ul li > a, .sidr ul li > span, #sidr-id-header-button-container-inner > *' ).css({
				'-webkit-box-shadow': 'inset 0 -1px rgba( ' + shad_rgbArray + ' , 0.2)',
				'-moz-box-shadow': 'inset 0 -1px rgba( ' + shad_rgbArray + ' , 0.2)',
				'box-shadow': 'inset 0 -1px rgba( ' + shad_rgbArray + ' , 0.2)'
			})

			$('.sidr > div > ul > li:first-child > a, .sidr > div > ul > li:first-child > span').css({
				'-webkit-box-shadow': 'inset 0 -1px rgba( ' + shad_rgbArray + ', 0.2), inset 0 1px rgba( ' + shad_rgbArray + ', 0.2)',
				'-moz-box-shadow': 'inset 0 -1px rgba( ' + shad_rgbArray + ', 0.2), inset 0 1px rgba( ' + shad_rgbArray + ', 0.2)',
				'box-shadow': 'inset 0 -1px rgba( ' + shad_rgbArray + ', 0.2), inset 0 1px rgba( ' + shad_rgbArray + ',  0.2)'
			});

			$('.sidr ul.sidr-class-hr-social li a, .sidr ul.sidr-class-hr-social li a:first-child').css({
				'-webkit-box-shadow': '0 1px 0 0 rgba( ' + shad_rgbArray + ' , 0.25)',
				'-moz-box-shadow': '0 1px 0 0 rgba( ' + shad_rgbArray + ', 0.25)',
				'box-shadow': '0 1px 0 0 rgba( ' + shad_rgbArray + ', 0.25)'
			});

		} );
	} );

	wp.customize( 'tesseract_mobmenu_search_color', function( value ) {
		value.bind( function( to ) {
			$( '.sidr-class-search-field, .sidr .search-form input[type="search"]' ).css( 'color', to );

		} );
	} );

	wp.customize( 'tesseract_mobmenu_search_background_color', function( value ) {
		value.bind( function( to ) {
			var mobmenu_searchBckColor = ( to == 'dark' ) ? 'rgba(0, 0, 0, .15)': 'rgba(255, 255, 255, 0.15)';
			$( '.sidr-class-search-field, .sidr-class-search-form input[type="search"]' ).css('background-color', mobmenu_searchBckColor);
		} );
	} );

	wp.customize( 'tesseract_mobmenu_buttons_background_color', function( value ) {
		value.bind( function( to ) {
			switch(to) {
				case 'dark':
					$( '#sidr-id-header-button-container-inner' ).css( 'background', 'rgba(0, 0, 0, .2)' ); break;
				case 'light':
					$( '#sidr-id-header-button-container-inner' ).css( 'background', 'rgba(255, 255, 255, .1)' ); break;
				case 'custom':
					$( '#sidr-id-header-button-container-inner' ).css( 'background', tesseract_vars.mobmenu_buttons_background_color_custom ); break;
			}
		} );
	} );

	wp.customize( 'tesseract_mobmenu_buttons_background_color_custom', function( value ) {
		value.bind( function( to ) {
			$( '#sidr-id-header-button-container-inner' ).css( 'background', to );
		} );
	} );

	wp.customize( 'tesseract_mobmenu_buttons_text_color', function( value ) {
		value.bind( function( to ) {
			$( '#sidr-id-header-button-container-inner, #sidr-id-header-button-container-inner > h1, #sidr-id-header-button-container-inner > h2, #sidr-id-header-button-container-inner > h3, #sidr-id-header-button-container-inner > h4, #sidr-id-header-button-container-inner > h5, #sidr-id-header-button-container-inner > h6' ).css( 'color', to );
		} );
	} );

	wp.customize( 'tesseract_mobmenu_buttons_link_color', function( value ) {
		value.bind( function( to ) {
			$( '#sidr-id-header-button-container-inner a, #sidr-id-header-button-container-inner button' ).css( 'color', to );
		} );
	} );


	wp.customize( 'tesseract_mobmenu_buttons_link_hover_color', function( value ) {
		value.bind( function( to ) {
			$( '#sidr-id-header-button-container-inner a, #sidr-id-header-button-container-inner button' ).each(function() {
				var origColor = $( this ).css('color');
				$( this ).hover(
					function() {
						$(this).css('color', to);
					}, function() {
						$(this).css('color', origColor);
					}
				)
			})
		} );
	} );

	wp.customize( 'tesseract_mobmenu_maxbtn_sep_color', function( value ) {
		value.bind( function( to ) {

			var max_r = hexToRgb(to).r,
			max_g = hexToRgb(to).g,
			max_b = hexToRgb(to).b,
			max_rgbArray = 'inset 0 -1px rgba( ' + max_r + ', ' + max_g + ', ' + max_b + ', 0.2)';

			$( '.sidr ul li > a, .sidr ul li > span, #sidr-id-header-button-container-inner > *, #sidr-id-header-button-container-inner button' ).css({
				'-webkit-box-shadow': max_rgbArray,
				'-moz-box-shadow': max_rgbArray,
				'box-shadow': max_rgbArray
			})

		} );
	} );

	wp.customize( 'tesseract_mobmenu_maxbtn_sep_color', function( value ) {
		value.bind( function( to ) {
			var mobmenu_maxbtnSepColor = ( to == 'dark' ) ? 'inset 0 -1px rgba(0, 0, 0, .1)': 'inset 0 -1px rgba(255, 255, 255, 0.1)';
			$( '.sidr ul li > a, .sidr ul li > span, #sidr-id-header-button-container-inner > *, #sidr-id-header-button-container-inner button' ).css({
				'-webkit-box-shadow': mobmenu_maxbtnSepColor,
				'-moz-box-shadow': mobmenu_maxbtnSepColor,
				'box-shadow': mobmenu_maxbtnSepColor
			});
		} );
	} );

	wp.customize( 'tesseract_header_logo_height', function( value ) {
		value.bind( function( to ) {
			$('#site-banner .site-logo img').animate({
				'height': to
			}, 50);
		} );
	} );

	wp.customize( 'tesseract_header_height', function( value ) {
		value.bind( function( to ) {
			$('#masthead_TesseractTheme').animate({
				'padding-top': to,
				'padding-bottom': to
			}, 50);
		} );
	} );
	
	
	wp.customize( 'tesseract_vertical_header_width', function( value ) {
		value.bind( function( to ) {
			$('#masthead_TesseractTheme .site-banner vertical').animate({
				'padding-left': to,
				'padding-right': to
			}, 400);
		} );
	} );

	wp.customize( 'tesseract_header_blocks_width_prop', function( value ) {
		value.bind( function( to ) {
			var parentWidth = $('#site-banner-main').width(),
			toLeft = (to/100)*parentWidth,
			toRight = parentWidth - ((to/100)*parentWidth);
			$('#site-banner-left').animate({
				'width': toLeft
			}, 150);
			$('#site-banner-right').animate({
				'width': toRight
			}, 150);
		} );
	} );

	wp.customize( 'tesseract_footer_logo_height', function( value ) {
		value.bind( function( to ) {
			$('#footer-banner .site-logo img').animate({
				'height': to
			}, 50);
		} );
	} );
	
	
	wp.customize( 'tesseract_footer_content_if_unbranding', function( value ) {
		value.bind( function( to ) {
			$( '#footer-banner .footer-extreme-right' ).text( to );
		} );
	} )
	

	wp.customize( 'tesseract_footer_height', function( value ) {
		value.bind( function( to ) {
			$('#colophon_TesseractTheme').animate({
				'padding-top': to,
				'padding-bottom': to
			}, 50);
		} );
	} );

	wp.customize( 'tesseract_footer_blocks_width_prop', function( value ) {
		value.bind( function( to ) {
			var parentWidth = $('#footer-banner').width(),
			toLeft = (to/100)*parentWidth,
			toRight = parentWidth - ((to/100)*parentWidth);
			$('#horizontal-menu-wrap').animate({
				'width': toLeft
			}, 150);
			$('#footer-banner-right').animate({
				'width': toRight
			}, 150);
		} );
	} );

	wp.customize( 'tesseract_woocommerce_cartcolor', function( value ) {
		value.bind( function( to ) {
			$( '.icon-shopping-cart' ).css( 'color', to );
		});
	});



} )( jQuery );