package com.frevvo.forms.cli.shell;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

import asg.cliche.Command;

import com.frevvo.forms.cli.ApiHelper;
import com.frevvo.forms.cli.core.EntryShell;
import com.frevvo.forms.cli.util.Util;
import com.frevvo.forms.client.ApplicationFeed;
import com.frevvo.forms.client.SubmissionFeed;
import com.frevvo.forms.client.SubmissionQuery;
import com.frevvo.forms.client.TaskFeed;
import com.frevvo.forms.client.TaskQuery;
import com.frevvo.forms.client.UserEntry;
import com.frevvo.forms.client.util.AutoLoginUserInfo;
import com.google.gdata.util.ServiceException;

/**
 * Shell context for all commands related to user entries
 */
public class UserEntryShell extends EntryShell<UserEntry> {
	public static final String PATH_ELEMENT = null;

	private AutoLoginUserInfo ui;
	
	public UserEntryShell(UserEntry entry, String tenantUser) {
		this(entry, tenantUser, null);
	}
	
	public UserEntryShell(UserEntry entry, String tenantUser, AutoLoginUserInfo ui) {
		super(tenantUser, entry);
		this.ui = ui;
	}

	public AutoLoginUserInfo getUi() {
		return ui;
	}
	
	@Command(name="openUrl", description="OPEN the given link as this user (maybe you have a public in tenant link to a form and want to use it as this user?)")
	public String openUrl(String url){
		if (url == null)
			return "You need to provide the link url you want to open";

		try {
			int i;
			if( getUi() != null ){
				if( url.indexOf('?') < 0 )
					url += '?';
				else
					url += '&';
				url += getUi().apiKey;
			}
			Util.openURL(new URL(url).toString());
			return "Opening url as " + getEntry().getId()  +": " + url;
		} catch (MalformedURLException e) {
			return "Invalid url : " + e.getMessage();
		}
	}
	
	@Command(name= "apps", description = "SELECT apps for this user (e.g. 'apps')")
	public String applications() throws IOException, ServiceException {

		UserEntry user = getEntry();
		ApplicationFeed apps = user.getApplicationFeed();

		return go(new ApplicationFeedShell(apps));
	}

	@Command(name = "subs", description = "SELECT subs for this user (e.g. 'subs')")
	public String submissions() throws IOException, ServiceException {

		URL feedUrl = getService().getFeedURL(SubmissionFeed.class);
		SubmissionQuery query = new SubmissionQuery(feedUrl);
		SubmissionFeed subs = getService().getFeed(query, SubmissionFeed.class);

		return go(new SubmissionFeedShell(subs));
	}

	@Command(name = "tasks", description = "SELECT tasks for this user (e.g. 'tasks')")
	public String tasks() throws IOException, ServiceException {

		URL tasksUrl = getService().getFeedURL(TaskFeed.class);
		TaskQuery tasksQuery = new TaskQuery(tasksUrl);
		TaskFeed tasks = getService().getFeed(tasksQuery, TaskFeed.class);

		// TODO : we shouldnt need this
		URL feedUrl = new URL(tasks.getSelfLink().getHref());
		tasksQuery = new TaskQuery(feedUrl);

		return go(new TaskFeedShell(tasks, tasksQuery));
	}

	@Override
	public void cliLeaveLoop() {
		try {
			if (getService() != null)
				getService().logout();
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}

	@Override
	protected String print(UserEntry entry) {
		return ApiHelper.print(getEntry());
	}
}