package com.frevvo.forms.cli.shell;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

import asg.cliche.Command;

import com.frevvo.forms.cli.ApiHelper;
import com.frevvo.forms.cli.core.FeedShell;
import com.frevvo.forms.cli.util.Util;
import com.frevvo.forms.client.TaskEntry;
import com.frevvo.forms.client.TaskFeed;
import com.frevvo.forms.client.TaskQuery;
import com.frevvo.forms.client.util.AutoLoginUserInfo;
import com.google.gdata.util.ServiceException;

/**
 * Shell context for all commands related to task feeds
 */
public class TaskFeedShell extends
		FeedShell<TaskFeed, TaskEntry, TaskEntryShell> {
	public static final String PATH_ELEMENT = "tasks";
	private AutoLoginUserInfo ui;
	private String username;

	public TaskFeedShell(TaskFeed feed, TaskQuery query) {
		this(feed, query, PATH_ELEMENT, null);
	}

	public TaskFeedShell(TaskFeed feed, TaskQuery query, String userTenant, AutoLoginUserInfo ui) {
		super((userTenant!=null?userTenant + '/':"") + PATH_ELEMENT, feed, TaskFeed.class);
		this.ui = ui;
		this.username = (userTenant!=null?userTenant + '/':""); 
	}
	
	public String getUsername() {
		return username;
	}
	
	public AutoLoginUserInfo getUi() {
		return ui;
	}
	
	@Override
	protected TaskEntry createEntry(String name, String description)
			throws IOException, ServiceException {
		return null; // not supported
	}

	@Override
	protected TaskEntryShell createEntryShell(TaskEntry entry) {
		return new TaskEntryShell(entry);
	}

	@Override
	protected String print(TaskFeed feed) {
		return ApiHelper.print(feed);
	}
	
	@Command(name="openUrl", description="OPEN the given link as this user (maybe you have a public in tenant link to a form and want to use it as this user?)")
	public String openUrl(String url){
		if (url == null)
			return "You need to provide the link url you want to open";

		try {
			int i;
			if( getUi() != null ){
				if( url.indexOf('?') < 0 )
					url += '?';
				else
					url += '&';
				url += "apikey=" + getUi().apiKey;
			}
			Util.openURL(new URL(url).toString());
			return "Opening url as " + getUsername()  +": " + url;
		} catch (MalformedURLException e) {
			return "Invalid url : " + e.getMessage();
		}
	}
}
