package com.frevvo.forms.cli.shell;

import java.util.HashMap;
import java.util.Map;

import asg.cliche.Command;

import com.frevvo.forms.cli.ApiHelper;
import com.frevvo.forms.cli.core.EntryShell;
import com.frevvo.forms.client.FormTypeEntry;
import com.frevvo.forms.client.TaskEntry;
import com.frevvo.forms.client.TaskEntry;
import com.google.gdata.data.Link;
import com.google.gdata.util.ServiceException;

/**
 * Shell context for all commands related to task entries
 */
public class TaskEntryShell extends EntryShell<TaskEntry> {
	public TaskEntryShell(TaskEntry entry) {
		super(entry.getTitle().getPlainText(), entry);
	}

	@Command(name = "view", description = "VIEW this task (e.g. 'view')")
	public String view() throws ServiceException {

		TaskEntry task = getEntry();
		Map<String, Object> params = new HashMap<String, Object>();
		params.put(FormTypeEntry.FORMTYPE_READONLY_PARAMETER, true);
		Link l = task.getFormTypePopupLink(params);
		openLink(l);

		return "Viewing submission " + l.getHref();
	}

	@Command(name = "edit", description = "EDIT this task (e.g. 'edit')")
	public String edit() throws ServiceException {

		TaskEntry task = getEntry();
		Map<String, Object> params = new HashMap<String, Object>();
		params.put(FormTypeEntry.FORMTYPE_READONLY_PARAMETER, false);
		Link l = task.getFormTypePopupLink(params);
		openLink(l);

		return "Editing submission " + l.getHref();
	}

	@Override
	protected String print(TaskEntry entry) {
		return ApiHelper.print(getEntry());
	}
}