package com.frevvo.forms.cli.shell;

import java.io.IOException;

import asg.cliche.Command;

import com.frevvo.forms.cli.ApiHelper;
import com.frevvo.forms.cli.core.QueryShell;
import com.frevvo.forms.client.SubmissionEntry;
import com.frevvo.forms.client.SubmissionFeed;
import com.frevvo.forms.client.SubmissionQuery;
import com.google.gdata.util.ServiceException;

/**
 * Shell context for all commands related to submission queries
 */
public class SubmissionQueryShell
		extends
		QueryShell<SubmissionFeed, SubmissionEntry, SubmissionEntryShell, SubmissionQuery> {
	public static final String PATH_ELEMENT = "subs";

	private SubmissionQueryShell(SubmissionFeed feed, SubmissionQuery query) {
		super(PATH_ELEMENT, feed, SubmissionFeed.class, query);
	}

	@Command(name = "filter", description = "FILTER this query (e.g. 'filter $key1 eq 2')")
	public String filter(String... filter) {
		try {
			SubmissionQuery query = getQuery();
			query.setFilter(filter);
			refreshFeed(query);

			return print();
		} catch (Exception e) {
			return "Could not get feed: " + e.getMessage();
		}
	}

	@Override
	protected SubmissionEntry createEntry(String name, String description)
			throws IOException, ServiceException {
		return null;
	}

	@Override
	protected SubmissionEntryShell createEntryShell(SubmissionEntry entry) {
		return new SubmissionEntryShell(entry);
	}

	@Override
	protected String print(SubmissionFeed feed) {
		try {
			return ApiHelper.print(feed);
		} catch (ServiceException e) {
			return "Could not print submission entries: " + e.getMessage();
		}
	}
}
