package com.frevvo.forms.cli.shell;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import asg.cliche.Command;

import com.frevvo.forms.cli.ApiHelper;
import com.frevvo.forms.cli.core.EntryShell;
import com.frevvo.forms.client.FormTypeEntry;
import com.frevvo.forms.client.SubmissionEntry;
import com.google.gdata.data.Link;
import com.google.gdata.util.ServiceException;

/**
 * Shell context for all commands related to submission entries
 */
public class SubmissionEntryShell extends EntryShell<SubmissionEntry> {
	public SubmissionEntryShell(SubmissionEntry entry) {
		super(entry.getTitle().getPlainText(), entry);
	}

	@Command(name = "view", description = "VIEW this submission (e.g. 'view')")
	public String view() throws ServiceException {

		SubmissionEntry sub = getEntry();
		Map<String, Object> params = new HashMap<String, Object>();
		params.put(FormTypeEntry.FORMTYPE_READONLY_PARAMETER, true);
		Link l = sub.getFormTypePopupLink(params);
		openLink(l);

		return "Viewing submission " + l.getHref();
	}

	@Command(name = "edit", description = "EDIT this submission (e.g. 'edit')")
	public String edit() throws ServiceException {

		SubmissionEntry sub = getEntry();
		Map<String, Object> params = new HashMap<String, Object>();
		params.put(FormTypeEntry.FORMTYPE_READONLY_PARAMETER, false);
		Link l = sub.getFormTypePopupLink(params);
		openLink(l);

		return "Editing submission " + l.getHref();
	}

	@Command(name = "docs", description = "SHOW all documents (xml, attachments and snapshots) (e.g. 'docs')")
	public String xmlDocs() {

		SubmissionEntry sub = getEntry();
		List<Link> xmlDocs = sub.getDocumentLinks();

		return ApiHelper.print(xmlDocs);
	}

	@Command(name = "doc", description = "OPEN a link in the browser (e.g. 'openLink {link#}')")
	public String xmlDdoc(int i) {

		SubmissionEntry sub = getEntry();
		List<Link> xmlDocs = sub.getDocumentLinks();
		Link xmlDoc = xmlDocs.get(i);
		Link l = openLink(xmlDoc);

		return "Openned link " + l.getHref();
	}

	@Override
	protected String print(SubmissionEntry entry) {
		return ApiHelper.print(getEntry());
	}
}