package com.frevvo.forms.cli.shell;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

import asg.cliche.Command;

import com.frevvo.forms.cli.ApiHelper;
import com.frevvo.forms.cli.core.FeedShell;
import com.frevvo.forms.client.SchemaEntry;
import com.frevvo.forms.client.SchemaFeed;
import com.google.gdata.data.media.MediaStreamSource;
import com.google.gdata.util.ServiceException;

/**
 * Shell context for all commands related to schema feeds
 */
public class SchemaFeedShell extends
		FeedShell<SchemaFeed, SchemaEntry, SchemaEntryShell> {
	public static final String PATH_ELEMENT = "schemas";

	public SchemaFeedShell(SchemaFeed feed) {
		super(PATH_ELEMENT, feed, SchemaFeed.class);
	}

	@Command(name = "up", description = "UPLOAD a schema (e.g. 'upload /var/contacts.xsd')")
	public String upload(String filePath) throws IOException, ServiceException {
		File f = new File(filePath);
		if (!f.exists())
			return "File " + filePath + " doesnt exist";

		try {
			// upload
			FileInputStream fis = new FileInputStream(f);
			try {
				SchemaFeed schemas = getFeed();
				MediaStreamSource ms = new MediaStreamSource(fis,
						"application/xml");
				SchemaEntry schema = schemas.insert(ms);

				go(createEntryShell(schema));
				return "Schema " + ApiHelper.getName(schema)
						+ " successfully uploaded";
			} finally {
				fis.close();
			}
		} catch (ServiceException ex) {
			return "Could not upload XSD "
					+ filePath + ": " + ex.getMessage();
		} catch (Exception ex) {
			return "Could not upload XSD " + filePath + ": "
					+ ex.getMessage();
		}
	}

	@Override
	protected SchemaEntry createEntry(String name, String description)
			throws IOException, ServiceException {
		return null; // not supported
	}

	@Override
	protected SchemaEntryShell createEntryShell(SchemaEntry entry) {
		return new SchemaEntryShell(entry);
	}

	@Override
	protected String print(SchemaFeed feed) {
		try {
		return ApiHelper.print(feed);
		}catch (Exception e) {
			return "Could not print schemas " + ": " + e.getMessage();
		}
	}
}
