package com.frevvo.forms.cli.shell;

import java.io.IOException;

import com.frevvo.forms.cli.ApiHelper;
import com.frevvo.forms.cli.core.EntryShell;
import com.frevvo.forms.client.SchemaEntry;
import com.google.gdata.util.ServiceException;

/**
 * Shell context for all commands related to schema entries
 */
public class SchemaEntryShell extends EntryShell<SchemaEntry> {
	public SchemaEntryShell(SchemaEntry entry) {
		super(entry.getTitle().getPlainText(), entry);
	}

//	@Command(name = "docs", description = "LIST all top-level types from this schema (e.g. 'docs')")
//	public String docTypes() throws IOException, ServiceException {
//
//		SchemaEntry schema = getEntry();
//		DocumentTypeFeed docs = schema.getDocumentTypeFeed();
//
//		return go(new DocumentTypeFeedShell(docs));
//	}

	@Override
	protected String print(SchemaEntry entry) {
		try {
			return ApiHelper.print(getEntry());
		} catch (IOException | ServiceException e) {
			return "Could not print schema " + ": " + e.getMessage();
		}
	}
}