package com.frevvo.forms.cli.shell;

import java.io.IOException;
import java.net.MalformedURLException;

import asg.cliche.Command;

import com.frevvo.forms.cli.ApiHelper;
import com.frevvo.forms.cli.core.FeedShell;
import com.frevvo.forms.client.ApplicationEntry;
import com.frevvo.forms.client.DocumentTypeEntry;
import com.frevvo.forms.client.DocumentTypeFeed;
import com.frevvo.forms.client.FormTypeEntry;
import com.frevvo.forms.client.SchemaEntry;
import com.frevvo.forms.client.SchemaFeed;
import com.google.gdata.util.ServiceException;

/**
 * Shell context for all commands related to document feeds
 */
public class DocumentTypeFeedShell extends
		FeedShell<DocumentTypeFeed, DocumentTypeEntry, DocumentTypeEntryShell> {
	public static final String PATH_ELEMENT = "docs";

	private FormTypeEntry form;
	
	public DocumentTypeFeedShell(FormTypeEntry form, DocumentTypeFeed feed) {
		super(PATH_ELEMENT, feed, DocumentTypeFeed.class);
		this.form = form;
	}

	public FormTypeEntry getFormTypeEntry() {
		return form;
	}
	
	
	@Command(name = "add", description = "LIST all forms (e.g. 'add {elementName} {namespace}')")
	public String addDocType(String element, String namespace) throws IOException, ServiceException {
		if( element == null || element.length() == 0 )
			return "Missing element name.";
		
		ApplicationEntry app = form.getOnwerEntry();
		SchemaFeed schemas = app.getSchemaFeed();
	
		// find the DocumenType in one of the schemas
		DocumentTypeEntry docType = findSchemaElement(schemas, element, namespace);
		if( docType == null )
			return "Could not find schema element identified by " + namespace + "#" + element;
		
		// add the DocumentType to the form as a new data source
		DocumentTypeFeed docTypes = getFeed();
		
		docType = docTypes.insert(docType);
		
		return "DocumentType (" + namespace + "#" + element + ") added to form " + form.getTitle().getPlainText();
	}

	private DocumentTypeEntry findSchemaElement(SchemaFeed schemas, String element, String namespace) throws MalformedURLException, IOException, ServiceException {
		String docRef = (namespace != null?namespace+"#":"")+ element;
		for(SchemaEntry schema : schemas.getEntries()){
			
			DocumentTypeFeed elems = schema.getDocumentTypeFeed();
			for(DocumentTypeEntry docType : elems.getEntries() ){
				if( docRef.equals(docType.getTitle().getPlainText()) )
					return docType;
			}
		}
		return null;
	}

	@Override
	protected DocumentTypeEntryShell createEntryShell(DocumentTypeEntry entry) {
		return new DocumentTypeEntryShell(entry);
	}

	@Override
	protected DocumentTypeEntry createEntry(String name, String description)
			throws IOException, ServiceException {
		return null; // not supported
	}

	@Override
	protected String print(DocumentTypeFeed feed) {
		return ApiHelper.print(feed);
	}
}
