package com.frevvo.forms.cli.shell;

import java.io.IOException;

import com.frevvo.forms.cli.ApiHelper;
import com.frevvo.forms.cli.core.FeedShell;
import com.frevvo.forms.client.ControlTypeEntry;
import com.frevvo.forms.client.ControlTypeFeed;
import com.google.gdata.util.ServiceException;

/**
 * Shell context for all commands related to control feeds
 */
public class ControlTypeFeedShell extends
		FeedShell<ControlTypeFeed, ControlTypeEntry, ControlTypeEntryShell> {
	public static final String PATH_ELEMENT = "controls";

	public ControlTypeFeedShell(ControlTypeFeed feed) {
		super(PATH_ELEMENT, feed, ControlTypeFeed.class);
	}

	@Override
	protected ControlTypeEntryShell createEntryShell(ControlTypeEntry entry) {
		return new ControlTypeEntryShell(entry);
	}

	@Override
	protected ControlTypeEntry createEntry(String name, String description)
			throws IOException, ServiceException {
		return null; // not supported
	}

	@Override
	protected String print(ControlTypeFeed feed) {
		return ApiHelper.print(feed);
	}
}
