package com.frevvo.forms.cli.shell;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

import asg.cliche.Command;

import com.frevvo.forms.cli.ApiHelper;
import com.frevvo.forms.cli.core.EntryShell;
import com.frevvo.forms.client.ApplicationEntry;
import com.frevvo.forms.client.FormTypeFeed;
import com.frevvo.forms.client.Helper;
import com.frevvo.forms.client.SchemaFeed;
import com.google.gdata.data.MediaContent;
import com.google.gdata.data.media.MediaSource;
import com.google.gdata.util.ServiceException;

/**
 * Shell context for all commands related to application entries
 */
public class ApplicationEntryShell extends EntryShell<ApplicationEntry> {
	public ApplicationEntryShell(ApplicationEntry entry) {
		super(entry.getTitle().getPlainText(), entry);
	}

	@Command(name = "forms", description = "LIST all forms (e.g. 'forms')")
	public String forms() throws IOException, ServiceException {

		ApplicationEntry app = getEntry();
		FormTypeFeed forms = app.getFormTypeFeed();

		return go(new FormTypeFeedShell(forms));
	}

	@Command(name = "flows", description = "LIST all flows (e.g. 'flows')")
	public String flows() throws IOException, ServiceException {

		ApplicationEntry app = getEntry();
		FormTypeFeed flows = app.getFlowTypeFeed();

		return go(new FormTypeFeedShell(flows));
	}

	@Command(name = "schemas", description = "LIST all schemas (e.g. 'schemas')")
	public String schemas() throws IOException, ServiceException {

		ApplicationEntry app = getEntry();
		SchemaFeed schemas = app.getSchemaFeed();

		return go(new SchemaFeedShell(schemas));
	}

	@Command(name = "down", description = "DOWNLOAD this application (e.g. 'down')")
	public String download() throws IOException, ServiceException {
		ApplicationEntry app = getEntry();

		String fileName = ApiHelper.getName(app);
		fileName = ApiHelper.nameToFileName(fileName);
		try {
			File file = File.createTempFile(fileName + "_", "_app.zip");
			FileOutputStream fos = new FileOutputStream(file);
			try {
				MediaContent mc = (MediaContent) app.getContent();
				MediaSource ms = getService().getMedia(mc);

				Helper.readStream(ms.getInputStream(), fos);

				return "Application downloaded to: " + file;
			} catch (Exception e) {
				return "Could not download application: " + e.getMessage();
			} finally {
				fos.close();
			}
		} catch (Exception e) {
			return "Could not download application: " + e.getMessage();
		}
	}

	@Override
	protected String print(ApplicationEntry entry) {
		return ApiHelper.print(getEntry());
	}
}