package com.frevvo.forms.cli.core;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

import asg.cliche.Command;
import asg.cliche.Param;

import com.frevvo.forms.cli.ApiHelper;
import com.google.gdata.client.Query;
import com.google.gdata.data.BaseEntry;
import com.google.gdata.data.BaseFeed;
import com.google.gdata.data.DateTime;
import com.google.gdata.data.Link;
import com.google.gdata.util.ServiceException;

public abstract class QueryShell<F extends BaseFeed<F, E>, E extends BaseEntry<E>, S extends EntryShell<E>, Q extends Query>
		extends FeedShell<F, E, S> {
	private Q query;

	public QueryShell(String pathElement, F feed, Class<F> feedCls, Q query) {
		super(pathElement, feed, feedCls);
		this.query = refreshQuery(feed, query);
	}

	@Command
	public String first() {
		try {
			F feed = getFeed();
			Link prevLink = feed.getNextLink();
			if (prevLink == null)
				return "This is already the first page!";
			ApiHelper.nextPage(getFeed(), getQuery());
			refreshFeed(getQuery());
			return print();
		} catch (Exception e) {
			return "Could not get next page";
		}
	}

	@Command
	public String next() {
		try {
			F feed = getFeed();
			Link prevLink = feed.getNextLink();
			if (prevLink == null)
				return "This is already the first page!";
			ApiHelper.nextPage(getFeed(), getQuery());
			refreshFeed(getQuery());
			return print();
		} catch (Exception e) {
			return "Could not get next page";
		}
	}

	@Command
	public String previous() {
		try {
			F feed = getFeed();
			Link prevLink = feed.getPreviousLink();
			if (prevLink == null)
				return "This is already the first page!";

			ApiHelper.previousPage(getFeed(), getQuery());
			refreshFeed(getQuery());
			feed = getService().getFeed(new URL(prevLink.getHref()),
					getFeedClass());
			setFeed(feed);
			return print();
		} catch (Exception e) {
			return "Could not get next page";
		}
	}

	@Command
	public String startIndex(@Param(name = "startIndex)") int startIndex) {
		try {
			Q query = getQuery();
			query.setStartIndex(startIndex);
			refreshFeed(query);
			return print();
		} catch (Exception e) {
			return "Could not get feed: " + e.getMessage();
		}
	}

	@Command
	public String maxResults(@Param(name = "maxResults") int maxResults) {
		try {
			Q query = getQuery();
			query.setMaxResults(maxResults);
			refreshFeed(query);
			return print();
		} catch (Exception e) {
			return "Could not get feed: " + e.getMessage();
		}
	}

	@Command
	public String author(String author) {
		try {
			Q query = getQuery();
			query.setAuthor(author);
			refreshFeed(query);
			return print();
		} catch (Exception e) {
			return "Could not get feed: " + e.getMessage();
		}
	}

	@Command
	public String publishedMin(String max) {
		try {
			Q query = getQuery();
			query.setPublishedMin(DateTime.parseDateTimeChoice(max));
			refreshFeed(query);
			return print();
		} catch (Exception e) {
			return "Could not get feed: " + e.getMessage();
		}
	}

	@Command
	public String publishedMax(String max) {
		try {
			Q query = getQuery();
			query.setPublishedMin(DateTime.parseDateTimeChoice(max));
			refreshFeed(query);
			return print();
		} catch (Exception e) {
			return "Could not get feed: " + e.getMessage();
		}
	}

	@Command
	public String updatedMin(String min) {
		try {
			Q query = getQuery();
			query.setUpdatedMax(DateTime.parseDateTimeChoice(min));
			refreshFeed(query);
			return print();
		} catch (Exception e) {
			return "Could not get feed: " + e.getMessage();
		}
	}

	@Command
	public String updatedMax(String max) {
		try {
			Q query = getQuery();
			query.setUpdatedMin(DateTime.parseDateTimeChoice(max));
			refreshFeed(query);
			return print();
		} catch (Exception e) {
			return "Could not get feed: " + e.getMessage();
		}
	}

	protected Q getQuery() {
		return query;
	}

	@Override
	protected List<String> getPathDetails() {
		List<String> details = new ArrayList<String>();
		details.add("page=" + ApiHelper.getCurrentPage(getFeed()));
		if (getQuery().getStartIndex() > 0)
			details.add("start=" + getQuery().getStartIndex());
		if (getQuery().getMaxResults() > 0)
			details.add("max=" + getQuery().getMaxResults());
		if (getQuery().getPublishedMin() != null)
			details.add("publishedMin=" + getQuery().getPublishedMin());
		if (getQuery().getPublishedMax() != null)
			details.add("publishedMax=" + getQuery().getPublishedMax());
		if (getQuery().getUpdatedMin() != null)
			details.add("updatedMin=" + getQuery().getUpdatedMin());
		if (getQuery().getUpdatedMax() != null)
			details.add("updatedMax=" + getQuery().getUpdatedMax());
		if (getQuery().getAuthor() != null)
			details.add("author=" + getQuery().getAuthor());
		return details;
	}

	protected F refreshFeed(Q query) throws IOException, ServiceException {
		try {
			F feed = getService().getFeed(query, getFeedClass());
			refreshQuery(feed, query);
			return setFeed(feed);
		} finally {
			cliGetShell().getPath().set(cliGetShell().getPath().size() - 1,
					getPathElement());
		}
	}

	protected Q refreshQuery(F feed, Q query) {
		query.setStartIndex(ApiHelper.getStartIndex(feed));
		query.setMaxResults(ApiHelper.getMaxResults(feed));
		return query;
	}
}