package com.frevvo.forms.cli.core;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;

import asg.cliche.CLIException;
import asg.cliche.Command;
import asg.cliche.Shell;
import asg.cliche.ShellDependent;
import asg.cliche.ShellFactory;
import asg.cliche.ShellManageable;

import com.frevvo.forms.cli.util.Util;
import com.google.gdata.data.Link;

public abstract class BaseShell implements ShellDependent, ShellManageable {
	private Shell theShell;
	private String pathElement;

	public BaseShell(String path) {
		this.pathElement = path == null ? "" : path;
	}

	public void cliSetShell(Shell theShell) {
		this.theShell = theShell;
	}

	public Shell cliGetShell() {
		return this.theShell;
	}

	public void cliEnterLoop() {
	}

	public void cliLeaveLoop() {
	}

	@Command
	public abstract String print();

	protected Link openLink(Link link) {
		if (link == null)
			return null;

		Util.openURL(link.getHref());

		return link;
	}

	protected String format(String pattern, Object... arguments) {
		return MessageFormat.format(pattern, arguments);
	}

	protected String getPathElement() {
		List<String> details = getPathDetails();
		if (details == null || details.size() == 0)
			return pathElement == null ? "" : pathElement;
		StringBuilder sb = new StringBuilder();
		for (int i = 0; i < details.size(); i++) {
			if (i > 0)
				sb.append(',');
			sb.append(details.get(i));
		}
		return String.format("%s", pathElement, sb.toString());
	}

	protected List<String> getPathDetails() {
		return null;
	}

	protected <S extends BaseShell> String go(S shell) throws IOException {
		Shell s = ShellFactory.createSubshell(shell.getPathElement(),
				cliGetShell(), null, shell);
		try {
			System.out.println("-----------------------------------------------------------------------------------------\n");
			s.processLine("print");
//			s.processLine("?list");
			System.out.println("-----------------------------------------------------------------------------------------");
		} catch (CLIException e) {
			// ignore
		}

		s.commandLoop();

		return null;
	}
}
