var upperCase = require('upper-case')
var sentenceCase = require('sentence-case')

/**
 * Title case a string.
 *
 * @param  {String} string
 * @param  {String} [locale]
 * @return {String}
 */
module.exports = function (str, locale) {
  return sentenceCase(str, locale).replace(/^.| ./g, function (m) {
    return upperCase(m, locale)
  })
}
