# arr-diff [![NPM version](https://badge.fury.io/js/arr-diff.svg)](http://badge.fury.io/js/arr-diff)  [![Build Status](https://travis-ci.org/jonschlinkert/arr-diff.svg)](https://travis-ci.org/jonschlinkert/arr-diff) 

> Returns an array with only the unique values from the first array, by excluding all values from additional arrays using strict equality for comparisons.

Why another array `difference` lib? I wanted the [fastest, correct implementation](./benchmark) I could find.

## Install with [npm](npmjs.org)

```bash
npm i arr-diff --save
```
### Install with [bower](https://github.com/bower/bower)

```bash
bower install arr-diff --save
```

## Usage

### [diff](index.js#L38)

Return the difference between the first array and additional arrays.

* `a` **{Array}**    
* `b` **{Array}**    
* `returns`: {Array}  

```js
var diff = require('{%= name %}');

var a = ['a', 'b', 'c', 'd'];
var b = ['b', 'c'];

console.log(diff(a, b))
//=> ['a', 'd']
```



## Run tests

```bash
npm test
```

## Author

**Jon Schlinkert**
 
+ [github/jonschlinkert](https://github.com/jonschlinkert)
+ [twitter/jonschlinkert](http://twitter.com/jonschlinkert) 


### Other javascript/node.js utils

Other projects that I maintain:

  - [arr-flatten](https://github.com/jonschlinkert/arr-flatten)
  - [arrayify-compact](https://github.com/jonschlinkert/arrayify-compact)
  - [compact-object](https://github.com/jonschlinkert/compact-object)
  - [delete](https://github.com/jonschlinkert/delete)
  - [for-in](https://github.com/jonschlinkert/for-in)
  - [for-own](https://github.com/jonschlinkert/for-own)
  - [has-any](https://github.com/jonschlinkert/has-any)
  - [has-value](https://github.com/jonschlinkert/has-value)
  - [is-number](https://github.com/jonschlinkert/is-number)
  - [is-plain-object](https://github.com/jonschlinkert/is-plain-object)
  - [mixin-deep](https://github.com/jonschlinkert/mixin-deep)
  - [mixin-object](https://github.com/jonschlinkert/mixin-object)
  - [object-length](https://github.com/jonschlinkert/object-length)
  - [omit-empty](https://github.com/jonschlinkert/omit-empty)
  - [reduce-object](https://github.com/jonschlinkert/reduce-object)


## License
Copyright (c) 2014 Jon Schlinkert  
Released under the MIT license

***

_This file was generated by [verb](https://github.com/assemble/verb) on December 28, 2014._
