"use strict";

exports.__esModule = true;
// istanbul ignore next

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var _state = require("./state");

var _location = require("./location");

// Start an AST node, attaching a start offset.

var pp = _state.Parser.prototype;

var Node = (function () {
  function Node(parser, pos, loc) {
    _classCallCheck(this, Node);

    this.type = "";
    this.start = pos;
    this.end = 0;

    if (parser) {
      if (parser.options.locations) {
        this.loc = new _location.SourceLocation(parser, loc);
      }

      if (parser.options.directSourceFile) {
        this.sourceFile = parser.options.directSourceFile;
      }

      if (parser.options.ranges) {
        this.range = [pos, 0];
      }
    }
  }

  Node.prototype.__clone = function __clone() {
    var node2 = new Node();
    for (var key in this) node2[key] = this[key];
    return node2;
  };

  return Node;
})();

exports.Node = Node;

pp.startNode = function () {
  return new Node(this, this.start, this.startLoc);
};

pp.startNodeAt = function (pos, loc) {
  return new Node(this, pos, loc);
};

function finishNodeAt(node, type, pos, loc) {
  node.type = type;
  node.end = pos;
  if (this.options.locations) node.loc.end = loc;
  if (this.options.ranges) node.range[1] = pos;
  return node;
}

// Finish an AST node, adding `type` and `end` properties.

pp.finishNode = function (node, type) {
  return finishNodeAt.call(this, node, type, this.lastTokEnd, this.lastTokEndLoc);
};

// Finish node at given position

pp.finishNodeAt = function (node, type, pos, loc) {
  return finishNodeAt.call(this, node, type, pos, loc);
};