"use strict";

exports.__esModule = true;
exports.parse = parse;
// istanbul ignore next

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var _state = require("./state");

var _options = require("./options");

require("./parseutil");

require("./statement");

require("./lval");

require("./expression");

require("./lookahead");

require("./tokentype");

require("./tokencontext");

var _pluginsFlow = require("./plugins/flow");

var _pluginsFlow2 = _interopRequireDefault(_pluginsFlow);

var _pluginsJsx = require("./plugins/jsx");

var _pluginsJsx2 = _interopRequireDefault(_pluginsJsx);

exports.Parser = _state.Parser;
exports.plugins = _state.plugins;
exports.defaultOptions = _options.defaultOptions;

var _location = require("./location");

exports.SourceLocation = _location.SourceLocation;
exports.getLineInfo = _location.getLineInfo;

var _node = require("./node");

exports.Node = _node.Node;

var _tokentype = require("./tokentype");

exports.TokenType = _tokentype.TokenType;
exports.tokTypes = _tokentype.types;

var _tokencontext = require("./tokencontext");

exports.TokContext = _tokencontext.TokContext;
exports.tokContexts = _tokencontext.types;

var _identifier = require("./identifier");

exports.isIdentifierChar = _identifier.isIdentifierChar;
exports.isIdentifierStart = _identifier.isIdentifierStart;

var _tokenize = require("./tokenize");

exports.Token = _tokenize.Token;

var _whitespace = require("./whitespace");

exports.isNewLine = _whitespace.isNewLine;
exports.lineBreak = _whitespace.lineBreak;
exports.lineBreakG = _whitespace.lineBreakG;

_state.plugins.flow = _pluginsFlow2["default"];
_state.plugins.jsx = _pluginsJsx2["default"];

function parse(input, options) {
  return new _state.Parser(_options.getOptions(options), input).parse();
}