<?php
/**
 * The template for displaying Search Results pages.
 *
 */

get_header(); ?>
	
	<div class="page-header">
	
		<div class="box">
		
			<div class="title">
				<h1 class="entry-title"><?php printf( __( 'Search Results for: %s', 'pxs' ), '<span>' . get_search_query() . '</span>' ); ?></h1>
			</div>
			
			<?php 
			if($smof_data['breadcrumb_pages']) { ?>
				<div class="breadcrumbs">
					<?php dimox_breadcrumbs(); ?>
				</div>
			<?php } ?>
		
		</div>
		
	</div>

	<section id="primary" class="content-area page">
		
		<?php 
			if($smof_data['layout_pages'] == 'sidebar-right') { ?>
				<main id="main" class="site-main" role="main">
		<?php } ?>
		
		<?php 
			if($smof_data['layout_pages'] == 'sidebar-left') { ?>
				<main id="main" class="site-main right" role="main">
		<?php } ?>
		
		<?php 
			if($smof_data['layout_pages'] == 'full-width') { ?>
				<main id="main" class="site-main fullwidth" role="main">
		<?php } ?>

		<?php if ( have_posts() ) : ?>

			<?php /* Start the Loop */ ?>
			<?php while ( have_posts() ) : the_post(); ?>

				<?php get_template_part( 'content', 'search' ); ?>

			<?php endwhile; ?>

			<?php pxs_content_nav( 'nav-below' ); ?>

		<?php else : ?>

			<?php get_template_part( 'no-results', 'search' ); ?>

		<?php endif; ?>

		</main><!-- #main -->
		
		<?php
			if($smof_data['layout_pages'] == 'sidebar-right') { ?>
				<div class="widgets right">
		<?php } ?>
		
		<?php
			if($smof_data['layout_pages'] == 'sidebar-left') { ?>
				<div class="widgets left">
		<?php } ?>

		<?php
			if($smof_data['layout_pages'] == 'full-width') { ?>
				<div class="widgets hide">
		<?php } ?>

		<?php get_sidebar(); ?>
		</div>
		
	</section><!-- #primary -->

<?php get_footer(); ?>