<?php
	ob_start(); //correction to error in logging in/out wp-admin -> Warning: Cannot modify header information - headers already sent by

/* Video Playlist Block */

class PXS_Video_Playlist_Block extends AQ_Block {
	
	//set and create block
	function __construct() {
		$block_options = array(
			'name' => 'Video Playlist',
			'size' => 'span12',
		);
		
		//create the block
		parent::__construct('pxs_video_playlist_block', $block_options);
	}
	
	function form($instance) {
	
		global $op_background;
		
		$defaults = array(
			'text' => '',
		);
		$instance = wp_parse_args($instance, $defaults);
		extract($instance);
		
		?>
		
		<div class="block-settings-title">
			<h4><?php  _e('Header', 'pxs'); ?></h4>
		</div>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('header1') ?>">
				<h4 class="label"><?php  _e('Title', 'pxs'); ?></h4>
				<input id="<?php echo $this->get_field_id('header1') ?>" class="input-full" type="text" value="<?php echo $header1 ?>" name="<?php echo $this->get_field_name('header1') ?>">
			</label>
		</p>

		<div class="block-settings-title">
			<h4><?php  _e('Video 1', 'pxs'); ?></h4>
		</div>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('title1') ?>">
				<h4 class="label"><?php  _e('Title', 'pxs'); ?></h4>
				<input id="<?php echo $this->get_field_id('title1') ?>" class="input-full" type="text" value="<?php echo $title1 ?>" name="<?php echo $this->get_field_name('title1') ?>">
			</label>
		</p>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('headline1') ?>">
				<h4 class="label"><?php  _e('Description', 'pxs'); ?></h4>
				<textarea id="<?php echo $this->get_field_id('headline1') ?>" class="textarea-full" name="<?php echo $this->get_field_name('headline1') ?>" rows="3"><?php echo $headline1 ?></textarea>
			</label>
		</p>

		<p class="description">
			<label for="<?php echo $this->get_field_id('module1_video') ?>">
				<h4 class="label"><?php  _e('Embed Code (iframe)', 'pxs'); ?></h4>
				<textarea id="<?php echo $this->get_field_id('module1_video') ?>" class="textarea-full" name="<?php echo $this->get_field_name('module1_video') ?>" rows="3"><?php echo $module1_video ?></textarea>
			</label>
		</p>				

		<div class="block-settings-title">
			<h4><?php  _e('Video 2', 'pxs'); ?></h4>
		</div>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('title2') ?>">
				<h4 class="label"><?php  _e('Title', 'pxs'); ?></h4>
				<input id="<?php echo $this->get_field_id('title2') ?>" class="input-full" type="text" value="<?php echo $title2 ?>" name="<?php echo $this->get_field_name('title2') ?>">
			</label>
		</p>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('headline2') ?>">
				<h4 class="label"><?php  _e('Description', 'pxs'); ?></h4>
				<textarea id="<?php echo $this->get_field_id('headline2') ?>" class="textarea-full" name="<?php echo $this->get_field_name('headline2') ?>" rows="3"><?php echo $headline2 ?></textarea>
			</label>
		</p>

		<p class="description">
			<label for="<?php echo $this->get_field_id('module2_video') ?>">
				<h4 class="label"><?php  _e('Embed Code (iframe)', 'pxs'); ?></h4>
				<textarea id="<?php echo $this->get_field_id('module2_video') ?>" class="textarea-full" name="<?php echo $this->get_field_name('module2_video') ?>" rows="3"><?php echo $module2_video ?></textarea>
			</label>
		</p>

		<div class="block-settings-title">
			<h4><?php  _e('Video 3', 'pxs'); ?></h4>
		</div>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('title3') ?>">
				<h4 class="label"><?php  _e('Title', 'pxs'); ?></h4>
				<input id="<?php echo $this->get_field_id('title3') ?>" class="input-full" type="text" value="<?php echo $title3 ?>" name="<?php echo $this->get_field_name('title3') ?>">
			</label>
		</p>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('headline3') ?>">
				<h4 class="label"><?php  _e('Description', 'pxs'); ?></h4>
				<textarea id="<?php echo $this->get_field_id('headlinee') ?>" class="textarea-full" name="<?php echo $this->get_field_name('headline3') ?>" rows="3"><?php echo $headline3 ?></textarea>
			</label>
		</p>

		<p class="description">
			<label for="<?php echo $this->get_field_id('module3_video') ?>">
				<h4 class="label"><?php  _e('Embed Code', 'pxs'); ?></h4>
				<textarea id="<?php echo $this->get_field_id('module3_video') ?>" class="textarea-full" name="<?php echo $this->get_field_name('module3_video') ?>" rows="3"><?php echo $module3_video ?></textarea>
			</label>
		</p>				

		<div class="block-settings-title">
			<h4><?php  _e('Video 4', 'pxs'); ?></h4>
		</div>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('title4') ?>">
				<h4 class="label"><?php  _e('Title', 'pxs'); ?></h4>
				<input id="<?php echo $this->get_field_id('title4') ?>" class="input-full" type="text" value="<?php echo $title4 ?>" name="<?php echo $this->get_field_name('title4') ?>">
			</label>
		</p>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('headline4') ?>">
				<h4 class="label"><?php  _e('Description', 'pxs'); ?></h4>
				<textarea id="<?php echo $this->get_field_id('headline4') ?>" class="textarea-full" name="<?php echo $this->get_field_name('headline4') ?>" rows="3"><?php echo $headline4 ?></textarea>
			</label>
		</p>

		<p class="description">
			<label for="<?php echo $this->get_field_id('module4_video') ?>">
				<h4 class="label"><?php  _e('Embed Code (iframe)', 'pxs'); ?></h4>
				<textarea id="<?php echo $this->get_field_id('module4_video') ?>" class="textarea-full" name="<?php echo $this->get_field_name('module4_video') ?>" rows="3"><?php echo $module4_video ?></textarea>
			</label>
		</p>
				
		<?php
	}
	
	function block($instance) {
		extract($instance);
		
		if ($section_name == ''){
			$section_name =  'video-playlist'. rand();
		}
		//$feature_rz = aq_resize($feature_img,850);
		
		$out = '';

		$out .= '<div id="'.$section_name.'" class="section video-playlist '.$bg.'" data-colornav="'.$anchor_color.'">';
		$out .= '<div style="width: 100%; text-align: center; margin: 20px;"><h1>'.$header1.'</h1></div>';

		$out .= '<div class="content">';
		$out .= '<div class="info">';
		$out .= '<div class="video2" id="video-main2">';
		$out .= htmlspecialchars_decode($module1_video); 
		$out .= '</div>';

		$out .= "</div>";

		$out .= '<div class="playlist">';

		$out .= '<div class="video-src2" onclick="changeVideo1a()">';
		$out .= '<img class="img2" id="img2-src1" src="wp-content/themes/socialvid/img/icon-pause.png"/>';
		$out .= '<h1>'.do_shortcode(htmlspecialchars_decode($title1)).'</h1>';
		$out .= '<p>'.do_shortcode(htmlspecialchars_decode($headline1)).'</p>';
		$out .= '</div>';
		$out .= '<div class="video-src2" onclick="changeVideo2a()">';
		$out .= '<img class="img2" id="img2-src2" src="wp-content/themes/socialvid/img/icon-play.png"/>';
		$out .= '<h1>'.do_shortcode(htmlspecialchars_decode($title2)).'</h1>';
		$out .= '<p>'.do_shortcode(htmlspecialchars_decode($headline2)).'</p>';
		$out .= '</div>';
		$out .= '<div class="video-src2" onclick="changeVideo3a()">';
		$out .= '<img class="img2" id="img2-src3" src="wp-content/themes/socialvid/img/icon-play.png"/>';
		$out .= '<h1>'.do_shortcode(htmlspecialchars_decode($title3)).'</h1>';
		$out .= '<p>'.do_shortcode(htmlspecialchars_decode($headline3)).'</p>';
		$out .= '</div>';
		$out .= '<div class="video-src2" onclick="changeVideo4a()">';
		$out .= '<img class="img2" id="img2-src4" src="wp-content/themes/socialvid/img/icon-play.png"/>';
		$out .= '<h1>'.do_shortcode(htmlspecialchars_decode($title4)).'</h1>';
		$out .= '<p>'.do_shortcode(htmlspecialchars_decode($headline4)).'</p>';
		$out .= '</div>';

		$out .= '</div>';

		$out .= "</div>";

		$out .= "</div>";

		$out .= '<script type="text/javascript" charset="utf-8">';
    	$out .= 'function changeVideo1a() {';
        $out .= 'var elems = document.getElementsByClassName("img2");';
		$out .= 'for (var i = 0; i < elems.length; i+= 1) {';
    	$out .= 'elems[i].src = "wp-content/themes/socialvid/img/icon-play.png";';
		$out .= '}';
        $out .= 'document.getElementById("img2-src1").src = "wp-content/themes/socialvid/img/icon-pause.png";';
        $out .= 'document.getElementById("video-main2").innerHTML = \'' .htmlspecialchars_decode($module1_video).'\';';
    	$out .= '}';
    	$out .= 'function changeVideo2a() {';
        $out .= 'var elems = document.getElementsByClassName("img2");';
		$out .= 'for (var i = 0; i < elems.length; i+= 1) {';
    	$out .= 'elems[i].src = "wp-content/themes/socialvid/img/icon-play.png";';
		$out .= '}';
        $out .= 'document.getElementById("img2-src2").src = "wp-content/themes/socialvid/img/icon-pause.png";';
        $out .= 'document.getElementById("video-main2").innerHTML = \'' .htmlspecialchars_decode($module2_video).'\';';
    	$out .= '}';
    	$out .= 'function changeVideo3a() {';
        $out .= 'var elems = document.getElementsByClassName("img2");';
		$out .= 'for (var i = 0; i < elems.length; i+= 1) {';
    	$out .= 'elems[i].src = "wp-content/themes/socialvid/img/icon-play.png";';
		$out .= '}';
        $out .= 'document.getElementById("img2-src3").src = "wp-content/themes/socialvid/img/icon-pause.png";';
        $out .= 'document.getElementById("video-main2").innerHTML = \'' .htmlspecialchars_decode($module3_video).'\';';
      	$out .= '}';
    	$out .= 'function changeVideo4a() {';
        $out .= 'var elems = document.getElementsByClassName("img2");';
		$out .= 'for (var i = 0; i < elems.length; i+= 1) {';
    	$out .= 'elems[i].src = "wp-content/themes/socialvid/img/icon-play.png";';
		$out .= '}';
        $out .= 'document.getElementById("img2-src4").src = "wp-content/themes/socialvid/img/icon-pause.png";';        
        $out .= 'document.getElementById("video-main2").innerHTML = \'' .htmlspecialchars_decode($module4_video).'\';';
    	$out .= '}';
		$out .= '</script>';
		echo $out;
	}
	
}

?>	