<?php 

/* =VIDEO BLOCK
-------------------------------------------------------------- */

class PXS_Video_Block extends AQ_Block {
	
	//set and create block
	function __construct() {
		$block_options = array(
			'name' => 'Video',
			'size' => 'span12'
		);
		
		//create the block
		parent::__construct('pxs_video_block', $block_options);
	}
	
	function form($instance) {
		global $video_type;
		
		$defaults = array(
			'width' => '640',
			'height' => '320'
		);
		$instance = wp_parse_args($instance, $defaults);
		extract($instance);
		
		?>
		<div class="block-settings-title"><i class="icon-facetime-video"></i><h3><?php  _e('Video', 'pxs'); ?></h3></div>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('video') ?>">
				<?php _e('Video Type', 'pxs') ?><br/>
				<?php echo aq_field_select('video', $block_id, $video_type, $video) ?>
			</label>
		</p>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('video_id') ?>">
				<?php _e('ID', 'pxs'); ?><br/>
				<?php echo aq_field_input('video_id', $block_id, $video_id) ?>
			</label>
		</p>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('width') ?>">
				<?php _e('Width', 'pxs'); ?><br/>
				<?php echo aq_field_input('width', $block_id, $width) ?>
			</label>
		</p>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('height') ?>">
				<?php _e('Height', 'pxs'); ?><br/>
				<?php echo aq_field_input('height', $block_id, $height) ?>
			</label>
		</p>
		
		<?php
	}
	
	function block($instance) {
		extract($instance);
		
		if ($section_name == ''){
			$section_name =  'video'. rand();
		}
		$out = '';
		
		if ($video == 'vimeo') {
	        $out .= '<div class="video" style="text-align:center;">';
	           $out .= '<iframe src="http://player.vimeo.com/video/' . $video_id . '?title=0&amp;byline=0&amp;portrait=0" width="'.$width.'px" height="' . $height . 'px" allowFullScreen></iframe>';
	        $out .= '</div>';
	    } 
	
	    if ($video == 'youtube') {
	        $out .= '<div class="video" style="text-align:center;">';
	            $out .= '<iframe src="http://www.youtube.com/embed/' . $video_id . '?rel=0" width="'.$width.'px"  height="' . $height . '" allowfullscreen></iframe>';
	        $out .= '</div>';
	    }
	    
	    echo $out;
		
	}
}

?>