<?php

/* Testimonial Block */

class PXS_Testimonial_Block extends AQ_Block {

	function __construct() {
		$block_options = array(
			'name' => 'Testimonials',
			'size' => 'span12',
		);

		//create the widget
		parent::__construct('pxs_testimonial_block', $block_options);

		//add ajax functions
		add_action('wp_ajax_aq_block_test_add_new', array($this, 'add_test_item'));

	}

	function form($instance) {
	
		global $op_background;

		$defaults = array(
			'title' => 'What Our Clients Say',
			'items' => array(
				1 => array(
					'title' => 'New Testimonial',
					'content' => '',
					'link' => '',
					'photo' => '',
				)
			)
		);

		$instance = wp_parse_args($instance, $defaults);
		extract($instance);

		?>
		
		<div class="block-settings-title">
			<h4><?php  _e('1. Add a testimonial', 'pxs'); ?></h4>
		</div>

		<div class="cf"></div>

		<div class="description cf">
			<ul id="aq-sortable-list-<?php echo $block_id ?>" class="aq-sortable-list" rel="<?php echo $block_id ?>">
				<?php
				$items = is_array($items) ? $items : $defaults['items'];
				$count = 1;
				foreach($items as $item) {	
					$this->item($item, $count);
					$count++;
				}
				?>
			</ul>
			<p></p>
			<a href="#" rel="test" class="aq-sortable-add-new button">Add New</a>
			<p></p>
		</div>
		
		<div class="block-settings-title">
			<h4><?php  _e('2. Section Settings', 'pxs'); ?></h4>
		</div>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('section_name') ?>">
				<h4 class="label"><?php  _e('Section Name eg. Intro', 'pxs'); ?></h4>
				<input id="<?php echo $this->get_field_id('section_name') ?>" class="input-full" type="text" value="<?php echo $section_name ?>" name="<?php echo $this->get_field_name('section_name') ?>">
			</label>
		</p>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('bg') ?>">
				<h4 class="label"><?php  _e('Select a background style', 'pxs'); ?></h4>
				<?php echo aq_field_select('bg', $block_id, $op_background, $bg) ?>
			</label>
		</p>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('anchor_color') ?>">
				<h4 class="label"><?php  _e('Anchor Color', 'pxs'); ?></h4>
				<input id="<?php echo $this->get_field_id('anchor_color') ?>" class="input-color-picker" type="text" value="<?php echo $anchor_color ?>" name="<?php echo $this->get_field_name('anchor_color') ?>">
			</label>
		</p>

		<?php
	}

	function item($item = array(), $count = 0) {

		?>
		<li id="sortable-item-<?php echo $count ?>" class="sortable-item" rel="<?php echo $count ?>">
			
			<div class="sortable-head cf">
				<div class="sortable-title">
					<strong><?php echo $item['title'] ?></strong>
				</div>
				<div class="sortable-handle">
					<a href="#">Open / Close</a>
				</div>
			</div>
			
			<div class="sortable-body">
				<div class="tab-desc description">
					<label for="<?php echo $this->get_field_id('items') ?>-<?php echo $count ?>-title">
						<h4 class="label"><?php  _e('Full Name', 'pxs'); ?></h4>
						<input type="text" id="<?php echo $this->get_field_id('items') ?>-<?php echo $count ?>-title" class="input-full" name="<?php echo $this->get_field_name('items') ?>[<?php echo $count ?>][title]" value="<?php echo $item['title'] ?>" />
					</label>
				</div>

				<div class="tab-desc description">
					<label for="<?php echo $this->get_field_id('items') ?>-<?php echo $count ?>-photo">
						<h4 class="label"><?php  _e('Photo (400px x 400px)', 'pxs'); ?></h4>
						<input type="text" id="<?php echo $this->get_field_id('items') ?>-<?php echo $count ?>-photo" class="input-full input-upload" value="<?php echo $item['photo'] ?>" name="<?php echo $this->get_field_name('items') ?>[<?php echo $count ?>][photo]">
						<a href="#" class="aq_upload_button button" rel="image">Upload</a><p></p>
					</label>
				</div>

				<div class="tab-desc description">
					<label for="<?php echo $this->get_field_id('items') ?>-<?php echo $count ?>-link">
						<h4 class="label"><?php  _e('Website', 'pxs'); ?></h4>
						<input type="text" id="<?php echo $this->get_field_id('items') ?>-<?php echo $count ?>-link" class="input-full" name="<?php echo $this->get_field_name('items') ?>[<?php echo $count ?>][link]" value="<?php echo $item['link'] ?>" />
					</label>
				</div>

				<div class="tab-desc description">
					<label for="<?php echo $this->get_field_id('items') ?>-<?php echo $count ?>-content">
						<h4 class="label"><?php  _e('Testimonial', 'pxs'); ?></h4>
						<textarea id="<?php echo $this->get_field_id('items') ?>-<?php echo $count ?>-content" class="textarea-full" name="<?php echo $this->get_field_name('items') ?>[<?php echo $count ?>][content]" rows="5"><?php echo $item['content'] ?></textarea>
					</label>
				</div>

				<p class="tab-desc description"><a href="#" class="sortable-delete">Delete</a></p>
			</div>
			
		</li>
		<?php
	}

	function block($instance) {
		extract($instance);
		
		if ($section_name == ''){
			$section_name =  'testimonial'. rand();
		}
		$out = '';
		
		$out .= '<div id="'.$section_name.'" class="section testimonials '.$bg.'" data-colornav="'.$anchor_color.'">';
		$out .= '<div class="content">';
		

			foreach( $items as $item ) {
				
				$image_rz = $item['photo'];
				$out .= '<blockquote>';
				$out .= '<div class="image aq_span4">';
				if ($image_rz != ''){
					$out .= '<i class="icon-quote-left"></i>';
				
					$out .= '<img src="' . $image_rz . '" alt="'.$item['content'].'" style="max-height:300px" />';
				}
				$out .= '</div>';
				
				$out .= '<div class="info aq_span8">';
				$out .= '<h2>"' . $item['content'] . '."</h2>';
				$out .= '<h3>' . $item['title'] . '</h3>';
				$out .= '<p>' . $item['link'] . '</p>';
				$out .= '</div>';
				$out .= '</blockquote>';
				
			}

		$out .= '</div>';	
		$out .= '</div>';

		echo $out;
		
		?>
		
		<script type="text/javascript">
			jQuery(document).ready(function ($) {
				$('blockquote').quovolver();
			});
		</script>
		
		<?php

	}

	/* AJAX add testimonial */
	function add_test_item() {
		$nonce = $_POST['security'];	
		if (! wp_verify_nonce($nonce, 'aqpb-settings-page-nonce') ) die('-1');

		$count = isset($_POST['count']) ? absint($_POST['count']) : false;
		$this->block_id = isset($_POST['block_id']) ? $_POST['block_id'] : 'aq-block-9999';

		//default key/value for the testimonial
		$item = array(
			'title' => 'New Testimonial',
			'content' => '',
			'link' => '',
			'photo' => '',
		);

		if($count) {
			$this->item($item, $count);
		} else {
			die(-1);
		}

		die();
	}

	function update($new_instance, $old_instance) {
		$new_instance = aq_recursive_sanitize($new_instance);
		return $new_instance;
	}
}