<?php 

/* =Team BLOCK
-------------------------------------------------------------- */

class PXS_Team_Block extends AQ_Block {
	
	//set and create block
	function __construct() {
		$block_options = array(
			'name' => 'Team',
			'size' => 'span4'
		);
		
		//create the block
		parent::__construct('pxs_team_block', $block_options);
	}
	
	function form($instance) {
		
		$defaults = array(
			'title' => 'Full Name',
			'content' => 'Enter a short description',
			'position' => 'Web Developer',
			'twitter' => '#',
			'facebook' => '#',
			'linkedin' => '#',
			'googleplus' => '#',
			'dribbble' => '#',
		);
		$instance = wp_parse_args($instance, $defaults);
		extract($instance);
		
		?>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('title') ?>">
				<?php _e('Full Name', 'pxs'); ?><br/>
				<?php echo aq_field_input('title', $block_id, $title) ?>
			</label>
		</p>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('position') ?>">
				<?php _e('Position', 'pxs'); ?><br/>
				<?php echo aq_field_input('position', $block_id, $position) ?>
			</label>
		</p>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('content') ?>">
				<?php _e('Description', 'pxs'); ?><br/>
				<?php echo aq_field_textarea('content', $block_id, $content) ?>
			</label>
		</p>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('photo') ?>">
				<?php _e('Upload a photo', 'pxs'); ?><br/>
				<?php echo aq_field_upload('photo', $block_id, $photo) ?>
			</label>
		</p>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('twitter') ?>">
				<?php _e('Twitter URL (optional)', 'pxs'); ?><br/>
				<?php echo aq_field_input('twitter', $block_id, $twitter) ?>
			</label>
		</p>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('facebook') ?>">
				<?php _e('Facebook URL (optional)', 'pxs'); ?><br/>
				<?php echo aq_field_input('facebook', $block_id, $facebook) ?>
			</label>
		</p>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('linkedin') ?>">
				<?php _e('Linkedin URL (optional)', 'pxs'); ?><br/>
				<?php echo aq_field_input('linkedin', $block_id, $linkedin) ?>
			</label>
		</p>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('googleplus') ?>">
				<?php _e('Google+ URL (optional)', 'pxs'); ?><br/>
				<?php echo aq_field_input('googleplus', $block_id, $googleplus) ?>
			</label>
		</p>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('dribbble') ?>">
				<?php _e('Dribbble URL (optional)', 'pxs'); ?><br/>
				<?php echo aq_field_input('dribbble', $block_id, $dribbble) ?>
			</label>
		</p>
		
		
		<?php
	}
	
	function block($instance) {
		extract($instance);
		
		$out = '';
		$out .= '<div class="team">';
			$out .= '<div class="photo">';
	    		$out .=  '<img src="' . $photo . '" alt="' . $title . ' ' . $position . '"/>';
	    	$out .= '</div>';
	    	$out .= '<div class="profile">';
	      	  $out .= '<h2>' . $title . '</h2>';
	      	  $out .= '<h5>' . $position . '</h5>';
	      	  $out .= '<p>' . $content . '</p>';
	        $out .= '</div>';
	        $out .= '<div class="social">';
	        	if ($twitter) $out .= '<a href="' . $twitter . '"><i class="icon-twitter"></i></a>';
	        	if ($facebook) $out .= '<a href="' . $facebook . '"><i class="icon-facebook"></i></a>';
	        	if ($linkedin) $out .= '<a href="' . $linkedin . '"><i class="icon-linkedin"></i></a>';
	        	if ($googleplus) $out .= '<a href="' . $googleplus . '"><i class="icon-google-plus"></i></a>';
	        	if ($dribbble) $out .= '<a href="' . $dribbble . '"><i class="icon-dribbble"></i></a>';
	        $out .= '</div>';
	    $out .= '</div>';
	    
	    echo $out;
		
	}
}

?>