<?php

/* Subscription Block */

class PXS_Subscription_Block extends AQ_Block {
	
	//set and create block
	function __construct() {
		$block_options = array(
			'name' => 'Subscription',
			'size' => 'span12',
		);
		
		//create the block
		parent::__construct('pxs_subscription_block', $block_options);
		add_action('wp_ajax_aq_block_ptable2_add_new', array($this, 'add_ptable2'));
	}
	
	function form($instance) {
	
		global $op_background;
		
		$defaults = array(
			'ptables2' => array(
				1 => array(
					'title'   => 'Table',
				)
			)
		);
		
		$instance = wp_parse_args($instance, $defaults);
		extract($instance);
		
		?>
		
		<div class="block-settings-title">
			<h4><?php  _e('1. Fill in the contents for this section', 'pxs'); ?></h4>
		</div>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('slogan') ?>">
				<h4 class="label"><?php  _e('Slogan', 'pxs'); ?></h4>
				<input id="<?php echo $this->get_field_id('slogan') ?>" class="input-full" type="text" value="<?php echo $slogan ?>" name="<?php echo $this->get_field_name('slogan') ?>">
			</label>
		</p>
		 <label for="<?php echo $this->get_field_id('default_img') ?>">
			<h4 class="label"><?php  _e('Upload Image', 'pxs'); ?></h4>
			<?php echo aq_field_upload('default_img', $block_id, $default_img) ?>
		</label>
		<div class="block-settings-title">
			<h4><?php  _e('Package #1', 'pxs'); ?></h4>
		</div>

		<p class="description">
			<label for="<?php echo $this->get_field_id('title_1') ?>">
				<h4 class="label"><?php  _e('Title', 'pxs'); ?></h4>
				<input id="<?php echo $this->get_field_id('title_1') ?>" class="input-full" type="text" value="<?php echo $title_1 ?>" name="<?php echo $this->get_field_name('title_1') ?>">
			</label>
			<label for="<?php echo $this->get_field_id('text_1') ?>">
				<h4 class="label"><?php  _e('Description', 'pxs'); ?></h4>
				<textarea id="<?php echo $this->get_field_id('text_1') ?>" class="textarea-full" name="<?php echo $this->get_field_name('text_1') ?>" rows="3"><?php echo $text_1 ?></textarea>
			</label>
			<label for="<?php echo $this->get_field_id('icon_1') ?>">
				<h4 class="label"><?php  _e('Icon', 'pxs'); ?></h4>
				<?php echo aq_field_input('icon_1', $block_id, $icon_1) ?>
			</label>
			<label for="<?php echo $this->get_field_id('link_1') ?>">
				<h4 class="label"><?php  _e('Link', 'pxs'); ?></h4>
				<input id="<?php echo $this->get_field_id('link_1') ?>" class="input-full" type="text" value="<?php echo $link_1 ?>" name="<?php echo $this->get_field_name('link_1') ?>">
			</label>
		</p>
		
		<div class="block-settings-title">
			<h4><?php  _e('Package #2', 'pxs'); ?></h4>
		</div>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('title_2') ?>">
				<h4 class="label"><?php  _e('Title', 'pxs'); ?></h4>
				<input id="<?php echo $this->get_field_id('title_2') ?>" class="input-full" type="text" value="<?php echo $title_2 ?>" name="<?php echo $this->get_field_name('title_2') ?>">
			</label>
			<label for="<?php echo $this->get_field_id('text_2') ?>">
				<h4 class="label"><?php  _e('Description', 'pxs'); ?></h4>
				<textarea id="<?php echo $this->get_field_id('text_2') ?>" class="textarea-full" name="<?php echo $this->get_field_name('text_2') ?>" rows="3"><?php echo $text_2 ?></textarea>
			</label>
			<label for="<?php echo $this->get_field_id('icon_2') ?>">
				<h4 class="label"><?php  _e('Icon', 'pxs'); ?></h4>
				<?php echo aq_field_input('icon_2', $block_id, $icon_2) ?>
			</label>
			<label for="<?php echo $this->get_field_id('link_2') ?>">
				<h4 class="label"><?php  _e('Link', 'pxs'); ?></h4>
				<input id="<?php echo $this->get_field_id('link_2') ?>" class="input-full" type="text" value="<?php echo $link_2 ?>" name="<?php echo $this->get_field_name('link_2') ?>">
			</label>
		</p>
		
		<div class="block-settings-title">
			<h4><?php  _e('Package #3', 'pxs'); ?></h4>
		</div>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('title_3') ?>">
				<h4 class="label"><?php  _e('Title', 'pxs'); ?></h4>
				<input id="<?php echo $this->get_field_id('title_3') ?>" class="input-full" type="text" value="<?php echo $title_3 ?>" name="<?php echo $this->get_field_name('title_3') ?>">
			</label>
			<label for="<?php echo $this->get_field_id('text_3') ?>">
				<h4 class="label"><?php  _e('Description', 'pxs'); ?></h4>
				<textarea id="<?php echo $this->get_field_id('text_3') ?>" class="textarea-full" name="<?php echo $this->get_field_name('text_3') ?>" rows="3"><?php echo $text_3 ?></textarea>
			</label>
			<label for="<?php echo $this->get_field_id('icon_3') ?>">
				<h4 class="label"><?php  _e('Icon', 'pxs'); ?></h4>
				<?php echo aq_field_input('icon_3', $block_id, $icon_3) ?>
			</label>
			<label for="<?php echo $this->get_field_id('link_3') ?>">
				<h4 class="label"><?php  _e('Link', 'pxs'); ?></h4>
				<input id="<?php echo $this->get_field_id('link_3') ?>" class="input-full" type="text" value="<?php echo $link_3 ?>" name="<?php echo $this->get_field_name('link_3') ?>">
			</label>
		</p>
		
		<div class="block-settings-title">
			<h4><?php  _e('Package #4', 'pxs'); ?></h4>
		</div>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('title_4') ?>">
				<h4 class="label"><?php  _e('Title', 'pxs'); ?></h4>
				<input id="<?php echo $this->get_field_id('title_4') ?>" class="input-full" type="text" value="<?php echo $title_4 ?>" name="<?php echo $this->get_field_name('title_4') ?>">
			</label>
			<label for="<?php echo $this->get_field_id('text_4') ?>">
				<h4 class="label"><?php  _e('Description', 'pxs'); ?></h4>
				<textarea id="<?php echo $this->get_field_id('text_4') ?>" class="textarea-full" name="<?php echo $this->get_field_name('text_4') ?>" rows="3"><?php echo $text_4 ?></textarea>
			</label>
			<label for="<?php echo $this->get_field_id('icon_4') ?>">
				<h4 class="label"><?php  _e('Icon', 'pxs'); ?></h4>
				<?php echo aq_field_input('icon_4', $block_id, $icon_4) ?>
			</label>
			<label for="<?php echo $this->get_field_id('link_4') ?>">
				<h4 class="label"><?php  _e('Link', 'pxs'); ?></h4>
				<input id="<?php echo $this->get_field_id('link_4') ?>" class="input-full" type="text" value="<?php echo $link_4 ?>" name="<?php echo $this->get_field_name('link_4') ?>">
			</label>
		</p>
		
		<div class="block-settings-title">
			<h4><?php  _e('3. Add a pricing table for each package', 'pxs'); ?></h4>
			<p>Note: Only four pricing tables are allowed. Each table will be assigned to a package automatically via the order below: </p>
		</div>
		
		<div class="description">
			<h4 class="label"><?php  _e('Add Bullet', 'pxs'); ?></h4>
			<ul id="sortable-list-<?php echo $block_id ?>" class="aq-sortable-list" rel="<?php echo $block_id ?>">
				<?php
				$ptables2 = is_array($ptables2) ? $ptables2 : $defaults['ptables2'];
				$count = 1;
				foreach ($ptables2 as $ptable2) {	
					$this->slide2($ptable2, $count);
					$count++;
				}
				?>
			</ul>
			<p></p>
			<a href="#" rel="ptable2" class="aq-sortable-add-new button">Add New</a>
			<p></p>
		</div>
		
		
		<div class="block-settings-title">
			<h4><?php  _e('4. Section Settings', 'pxs'); ?></h4>
		</div>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('section_name') ?>">
				<h4 class="label"><?php  _e('Section Name eg. Intro', 'pxs'); ?></h4>
				<input id="<?php echo $this->get_field_id('section_name') ?>" class="input-full" type="text" value="<?php echo $section_name ?>" name="<?php echo $this->get_field_name('section_name') ?>">
			</label>
		</p>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('bg') ?>">
				<h4 class="label"><?php  _e('Select a background style', 'pxs'); ?></h4>
				<?php echo aq_field_select('bg', $block_id, $op_background, $bg) ?>
			</label>
		</p>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('anchor_color') ?>">
				<h4 class="label"><?php  _e('Anchor Color', 'pxs'); ?></h4>
				<input id="<?php echo $this->get_field_id('anchor_color') ?>" class="input-color-picker" type="text" value="<?php echo $anchor_color ?>" name="<?php echo $this->get_field_name('anchor_color') ?>">
			</label>
		</p>
		
		<?php
	}
	
	function slide2($ptable2 = array(), $count = 0) {
		
		$defaults = array (
			'title'   => 'Table',
		);

		$ptable2 = wp_parse_args($ptable2, $defaults); 
		?>

		<li id="<?php echo $this->get_field_id('ptables2') ?>-sortable-item-<?php echo $count ?>" class="sortable-item" rel="<?php echo $count ?>">
			<div class="sortable-head cf">
				<div class="sortable-title">
					<strong><?php echo $ptable2['title'] ?></strong>
				</div>
				<div class="sortable-handle">
					<a href="#"><?php _e('Open / Close', 'pxs'); ?></a>
				</div>
			</div>
			
			<div class="sortable-body">
				<p class="description">
					<label for="<?php echo $this->get_field_id('ptables2') ?>-<?php echo $count ?>-ptlabel">
						<h4 class="label"><?php  _e('Label eg. 20% Discount', 'pxs'); ?></h4>
						<textarea id="<?php echo $this->get_field_id('ptables2') ?>-<?php echo $count ?>-ptlabel" class="textarea-full" name="<?php echo $this->get_field_name('ptables2') ?>[<?php echo $count ?>][ptlabel]" rows="1"><?php echo $ptable2['ptlabel'] ?></textarea>
					</label>
				</p>
				<p class="description">
					<label for="<?php echo $this->get_field_id('ptables2') ?>-<?php echo $count ?>-price">
						<h4 class="label"><?php  _e('Price', 'pxs'); ?></h4>
						<textarea id="<?php echo $this->get_field_id('ptables2') ?>-<?php echo $count ?>-price" class="textarea-full" name="<?php echo $this->get_field_name('ptables2') ?>[<?php echo $count ?>][price]" rows="1"><?php echo $ptable2['price'] ?></textarea>
					</label>
				</p>
				<p class="description">
					<label for="<?php echo $this->get_field_id('ptables2') ?>-<?php echo $count ?>-timeline">
						<h4 class="label"><?php  _e('Timeline eg. /month', 'pxs'); ?></h4>
						<textarea id="<?php echo $this->get_field_id('ptables2') ?>-<?php echo $count ?>-timeline" class="textarea-full" name="<?php echo $this->get_field_name('ptables2') ?>[<?php echo $count ?>][timeline]" rows="1"><?php echo $ptable2['timeline'] ?></textarea>
					</label>
				</p>
				<p class="description">
					<label for="<?php echo $this->get_field_id('ptables2') ?>-<?php echo $count ?>-bullet_1">
						<h4 class="label"><?php  _e('Bullet #1', 'pxs'); ?></h4>
						<textarea id="<?php echo $this->get_field_id('ptables2') ?>-<?php echo $count ?>-bullet_1" class="textarea-full" name="<?php echo $this->get_field_name('ptables2') ?>[<?php echo $count ?>][bullet_1]" rows="1"><?php echo $ptable2['bullet_1'] ?></textarea>
					</label>
				</p>
				<p class="description">
					<label for="<?php echo $this->get_field_id('ptables2') ?>-<?php echo $count ?>-bullet_2">
						<h4 class="label"><?php  _e('Bullet #2', 'pxs'); ?></h4>
						<textarea id="<?php echo $this->get_field_id('ptables2') ?>-<?php echo $count ?>-bullet_2" class="textarea-full" name="<?php echo $this->get_field_name('ptables2') ?>[<?php echo $count ?>][bullet_2]" rows="1"><?php echo $ptable2['bullet_2'] ?></textarea>
					</label>
				</p>
				<p class="description">
					<label for="<?php echo $this->get_field_id('ptables2') ?>-<?php echo $count ?>-bullet_3">
						<h4 class="label"><?php  _e('Bullet #3', 'pxs'); ?></h4>
						<textarea id="<?php echo $this->get_field_id('ptables2') ?>-<?php echo $count ?>-bullet_3" class="textarea-full" name="<?php echo $this->get_field_name('ptables2') ?>[<?php echo $count ?>][bullet_3]" rows="1"><?php echo $ptable2['bullet_3'] ?></textarea>
					</label>
				</p>
				<p class="description">
					<label for="<?php echo $this->get_field_id('ptables2') ?>-<?php echo $count ?>-bullet_4">
						<h4 class="label"><?php  _e('Bullet #4', 'pxs'); ?></h4>
						<textarea id="<?php echo $this->get_field_id('ptables2') ?>-<?php echo $count ?>-bullet_4" class="textarea-full" name="<?php echo $this->get_field_name('ptables2') ?>[<?php echo $count ?>][bullet_4]" rows="1"><?php echo $ptable2['bullet_4'] ?></textarea>
					</label>
				</p>
				<p class="description">
					<label for="<?php echo $this->get_field_id('ptables2') ?>-<?php echo $count ?>-bullet_5">
						<h4 class="label"><?php  _e('Bullet #5', 'pxs'); ?></h4>
						<textarea id="<?php echo $this->get_field_id('ptables2') ?>-<?php echo $count ?>-bullet_5" class="textarea-full" name="<?php echo $this->get_field_name('ptables2') ?>[<?php echo $count ?>][bullet_5]" rows="1"><?php echo $ptable2['bullet_5'] ?></textarea>
					</label>
				</p>
				<p class="description"><a href="#" class="sortable-delete"><?php _e('Delete', 'pxs'); ?></a></p>
			</div>
			
			
			
		</li>
	<?php }

	function add_ptable2() {
		$nonce = $_POST['security'];	
		if (!wp_verify_nonce($nonce, 'aqpb-settings-page-nonce') ) die('-1');
		
		$count = isset($_POST['count']) ? absint($_POST['count']) : false;
		$this->block_id = isset($_POST['block_id']) ? $_POST['block_id'] : 'aq-block-9999';
		
		$ptable2 = array(
			'title'   => 'Table',
		);
		
		if ($count) {
			$this->slide2($ptable2, $count);
		} else {
			die(-1);
		}
		
		die();
	}
	
	function block($instance) {
		extract($instance);
		if ($section_name == ''){
			$section_name =  'subscription'. rand();
		}
		?>
		
		<div id="<?php echo $section_name ?>" class="section subscription <?php echo $bg; ?>" data-colornav="<?php echo $anchor_color ?>">
			
			<div class="content">
			
			
				<div class="ptable aq_span5">
					<!--<img class="screen-default-ptable" src="<?php //echo get_template_directory_uri() ?>/img/preview/bg.png" alt="" />-->
                    <?php if ($default_img != ''){ ?>
                    <img class="screen-default-ptable" src="<?php echo $default_img ?>" alt="<?php echo do_shortcode(htmlspecialchars_decode($title_1)); ?>" style="height:auto; max-height: 550px;" />
                    <?php } 
			
					    $i = 1;
					    
						foreach ($ptables2 as $ptable2) {
						
							if($i == 1) {$package = $title_1;}
							if($i == 2) {$package = $title_2;}
							if($i == 3) {$package = $title_3;}
							if($i == 4) {$package = $title_4;}
							
							if ($i < 5){
								echo '<ul class="package-'.$i.'">';
								echo '<li class="title">'.$package.'</li>';
								echo '<li class="label">'.$ptable2['ptlabel'].'</li>';
								echo '<li class="price">$'.$ptable2['price'].' <span>'.$ptable2['timeline'].'</span></li>';
								echo '<li class="bullet">'.$ptable2['bullet_1'].'</li>';
								echo '<li class="bullet">'.$ptable2['bullet_2'].'</li>';
								echo '<li class="bullet">'.$ptable2['bullet_3'].'</li>';
								echo '<li class="bullet">'.$ptable2['bullet_4'].'</li>';
								echo '<li class="bullet">'.$ptable2['bullet_5'].'</li>';
								echo '</ul>';	
							}
							
							$i++;
							
						}
						
					?>
				</div>
			
				<div class="content aq_span7">
					
					<h1 class="slogan"><?php echo $slogan ?></h1>
                    
					<?php if($text_1 != ""){ ?>
					<div id="ptable-1" class="ptable-1 features aq_span5">
						<div class="icon">
							<i class="<?php echo $icon_1; ?>"></i>
						</div>
						
						<div class="info customlinks">
							<h2><?php echo do_shortcode(htmlspecialchars_decode($title_1)); ?></h2>
							<p><?php echo wpautop(do_shortcode(htmlspecialchars_decode($text_1))); ?></p>
							<a href="<?php echo do_shortcode(htmlspecialchars_decode($link_1)); ?>">Sign Up</a>
						</div>
					</div>
					<?php
					}
					
					if($text_2 != ""){
					?>
					<div id="ptable-2" class="ptable-2 features aq_span5">
						<div class="icon">
							<i class="<?php echo $icon_2; ?>"></i>
						</div>
						
						<div class="info customlinks">
							<h2><?php echo do_shortcode(htmlspecialchars_decode($title_2)); ?></h2>
							<p><?php echo wpautop(do_shortcode(htmlspecialchars_decode($text_2))); ?></p>
							<a href="<?php echo do_shortcode(htmlspecialchars_decode($link_2)); ?>">Sign Up</a>
						</div>
					</div>
					<?php
					}
					
					if($text_3 != ""){
					?>
					<div id="ptable-3" class="ptable-3 features aq_span5">
						<div class="icon">
							<i class="<?php echo $icon_3; ?>"></i>
						</div>
						
						<div class="info customlinks">
							<h2><?php echo do_shortcode(htmlspecialchars_decode($title_3)); ?></h2>
							<p><?php echo wpautop(do_shortcode(htmlspecialchars_decode($text_3))); ?></p>
							<a href="<?php echo do_shortcode(htmlspecialchars_decode($link_3)); ?>">Sign Up</a>
						</div>
					</div>
					<?php
					}
					
					if($text_4 != ""){
					?>
					<div id="ptable-4" class="ptable-4 features aq_span5">
						<div class="icon">
							<i class="<?php echo $icon_4; ?>"></i>
						</div>
						
						<div class="info customlinks">
							<h2><?php echo do_shortcode(htmlspecialchars_decode($title_4)); ?></h2>
							<p><?php echo wpautop(do_shortcode(htmlspecialchars_decode($text_4))); ?></p>
							<a href="<?php echo do_shortcode(htmlspecialchars_decode($link_4)); ?>">Sign Up</a>
						</div>
					</div>
					<?php
					}
					?>
				</div>
			
			</div>
		
		</div>
		
		<?php
		
	}
	
	function update($new_instance, $old_instance) {
		$new_instance = aq_recursive_sanitize($new_instance);
		return $new_instance;
	}
	
}

?>